/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.persistence.xml;

import java.util.List;
import oracle.dbtools.crest.model.design.AbstractView;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.relational.ColumnView;
import oracle.dbtools.crest.model.design.relational.TableView;
import oracle.dbtools.crest.model.persistence.XMLPersistenceManager;
import oracle.dbtools.crest.model.persistence.xml.AbstractWXMLDesignObject;
import oracle.dbtools.crest.util.string.StringUtilities;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class WXMLTableView
extends AbstractWXMLDesignObject {
    TableView view = null;

    public WXMLTableView(XMLPersistenceManager xMLPersistenceManager) {
        super(xMLPersistenceManager);
    }

    @Override
    public boolean canWrite(Object object) {
        boolean bl = object instanceof TableView;
        if (bl) {
            this.view = (TableView)object;
        }
        return bl;
    }

    @Override
    public String getRelativePath() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.view != null) {
            String string = this.view.getDesignPart().getAppView().getDesignName();
            stringBuffer.append(string).append('/').append("rel").append('/').append(this.view.getDesignPart().getPathIDString()).append('/');
        }
        stringBuffer.append(this.getConfiguration().get("tableViewPath"));
        return stringBuffer.toString();
    }

    @Override
    protected void appendDesignObjectInfo(Element element, DesignObject designObject) {
        if (designObject instanceof TableView) {
            String string;
            Object object2;
            TableView tableView = (TableView)designObject;
            Document document = element.getOwnerDocument();
            if (tableView.getBasedOnStructuredType() != null) {
                element.setAttribute("structuredType", StringUtilities.encodeAttributeValue(tableView.getBasedOnStructuredType().getObjectID()));
                if (tableView.getOidText() != null && !"".equalsIgnoreCase(tableView.getOidText())) {
                    element.setAttribute("oid_text", StringUtilities.encodeAttributeValue(tableView.getOidText()));
                }
            }
            element.setAttribute("allow_type_substitution", String.valueOf(tableView.isAllowTypeSubstitution()));
            Element element2 = document.createElement("containers");
            element.appendChild(element2);
            for (Object object2 : tableView.getUsedContainers()) {
                this.appendContainerInfo(document, element2, StringUtilities.encodeAttributeValue(((AbstractView.ContainerHolder)object2).getContainer().getObjectID()), StringUtilities.encodeAttributeValue(((AbstractView.ContainerHolder)object2).getAlias()));
            }
            object2 = "" + tableView.getUserDefined();
            Element element3 = document.createElement("userDefined");
            Text text = document.createTextNode(StringUtilities.encodeAttributeValue((String)object2));
            element3.appendChild(text);
            element.appendChild(element3);
            String string2 = tableView.getUserDefinedSQL();
            if (string2 != null) {
                element3 = document.createElement("userDefinedSQL");
                text = document.createTextNode(StringUtilities.encodeAttributeValue(string2));
                element3.appendChild(text);
                element.appendChild(element3);
            }
            if ((string = tableView.getWhere()) != null) {
                element3 = document.createElement("where");
                text = document.createTextNode(StringUtilities.encodeAttributeValue(string));
                element3.appendChild(text);
                element.appendChild(element3);
            }
            element3 = document.createElement("groupby");
            this.appendGroupBy(element, element3, tableView.getGroupByList());
            String string3 = tableView.getHaving();
            if (string3 != null) {
                element3 = document.createElement("having");
                text = document.createTextNode(StringUtilities.encodeAttributeValue(string3));
                element3.appendChild(text);
                element.appendChild(element3);
            }
            Element element4 = document.createElement("orderby");
            element.appendChild(element4);
            for (ContainedObject containedObject : tableView.getOrderByList()) {
                String string4 = StringUtilities.encodeAttributeValue(containedObject.getObjectID());
                String string5 = StringUtilities.encodeAttributeValue(containedObject.getName());
                String string6 = tableView.getSortOrder(string4);
                if (string6 == "") {
                    string6 = "ASC";
                }
                if (((ColumnView)containedObject).getTable() != null) {
                    this.appendOrderByInfo(document, element4, string4, string5, StringUtilities.encodeAttributeValue(((ColumnView)containedObject).getTable().getObjectID()), string6);
                    continue;
                }
                if (((ColumnView)containedObject).getView() != null) {
                    this.appendOrderByInfo(document, element4, string4, string5, StringUtilities.encodeAttributeValue(((ColumnView)containedObject).getView().getObjectID()), string6);
                    continue;
                }
                this.appendOrderByInfo(document, element4, string4, string5, StringUtilities.encodeAttributeValue(((ColumnView)containedObject).getContainer().getObjectID()), string6);
            }
            this.appendScriptInfo(element, "beforeDrop", tableView.getBeforeDrop());
            this.appendScriptInfo(element, "beforeCreate", tableView.getBeforeCreate());
            this.appendScriptInfo(element, "beforeAlter", tableView.getBeforeAlter());
            this.appendScriptInfo(element, "afterCreate", tableView.getAfterCreate());
            this.appendScriptInfo(element, "afterAlter", tableView.getAfterAlter());
            this.appendScriptInfo(element, "endOfScript", tableView.getEndOfScript());
        }
    }

    protected final Element appendOrderByInfo(Document document, Element element, String string, String string2, String string3, String string4) {
        Element element2 = document.createElement("columnview");
        element2.setAttribute("objectid", StringUtilities.encodeAttributeValue(string));
        element2.setAttribute("name", StringUtilities.encodeAttributeValue(string2));
        element2.setAttribute("cid", StringUtilities.encodeAttributeValue(string3));
        element2.setAttribute("sortorder", string4);
        element.appendChild(element2);
        return element2;
    }

    protected final Element appendContainerInfo(Document document, Element element, String string, String string2) {
        Element element2 = document.createElement("container");
        element2.setAttribute("alias", StringUtilities.encodeAttributeValue(string2));
        element2.setAttribute("cid", StringUtilities.encodeAttributeValue(string));
        element.appendChild(element2);
        return element2;
    }

    @Override
    protected void appendContainedObjectInfo(Element element, ContainedObject containedObject) {
        String string;
        String string2;
        String string3;
        Text text;
        Element element2;
        ColumnView columnView = (ColumnView)containedObject;
        Document document = element.getOwnerDocument();
        element.setAttribute("tableid", StringUtilities.encodeAttributeValue(columnView.getContainer().getObjectID()));
        element.setAttribute("reference", String.valueOf(columnView.isReference()));
        element.setAttribute("dttype", columnView.getStructuredType() != null ? StringUtilities.encodeAttributeValue(columnView.getStructuredType().getObjectID()) : "");
        this.appendScopeInfo(element, columnView);
        String string4 = columnView.getAlias();
        if (string4 != null) {
            element2 = document.createElement("alias");
            text = document.createTextNode(StringUtilities.encodeAttributeValue(string4));
            element2.appendChild(text);
            element.appendChild(element2);
        }
        if ((string3 = columnView.getTableAlias()) != null) {
            element2 = document.createElement("tableAlias");
            text = document.createTextNode(StringUtilities.encodeAttributeValue(string3));
            element2.appendChild(text);
            element.appendChild(element2);
        }
        if (columnView.getReferencedColumn() != null && (string2 = columnView.getReferencedColumn().getObjectID()) != null) {
            element2 = document.createElement("refcolumn");
            text = document.createTextNode(StringUtilities.encodeAttributeValue(string2));
            element2.appendChild(text);
            element.appendChild(element2);
        }
        if (columnView.getReferencedColumnView() != null && (string2 = columnView.getReferencedColumnView().getObjectID()) != null) {
            element2 = document.createElement("ref_column_view");
            text = document.createTextNode(StringUtilities.encodeAttributeValue(string2));
            element2.appendChild(text);
            element.appendChild(element2);
        }
        if (columnView.getTable() != null && (string2 = columnView.getTable().getObjectID()) != null) {
            element2 = document.createElement("table");
            text = document.createTextNode(StringUtilities.encodeAttributeValue(string2));
            element2.appendChild(text);
            element.appendChild(element2);
        }
        if (columnView.getView() != null && (string2 = columnView.getView().getObjectID()) != null) {
            element2 = document.createElement("view");
            text = document.createTextNode(StringUtilities.encodeAttributeValue(string2));
            element2.appendChild(text);
            element.appendChild(element2);
        }
        if ((string2 = columnView.getExpression()) != null) {
            element2 = document.createElement("expression");
            text = document.createTextNode(StringUtilities.encodeAttributeValue(string2));
            element2.appendChild(text);
            element.appendChild(element2);
        }
        if ((string = columnView.getDataType()) != null) {
            element2 = document.createElement("datatype");
            text = document.createTextNode(StringUtilities.encodeAttributeValue(string));
            element2.appendChild(text);
            element.appendChild(element2);
        }
    }

    private void appendGroupBy(Element element, Element element2, List list) {
        if (list.size() > 0) {
            for (ColumnView columnView : list) {
                if (columnView == null) continue;
                Element element3 = element.getOwnerDocument().createElement("cv_id");
                element3.setAttribute("value", columnView.getObjectID());
                element2.appendChild(element3);
            }
            element.appendChild(element2);
        }
    }
}

