/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.persistence.xml;

import java.io.Serializable;
import java.util.Iterator;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.datatypes.DataTypesDesign;
import oracle.dbtools.crest.model.design.logical.LogicalDesign;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.persistence.XMLPersistenceManager;
import oracle.dbtools.crest.model.persistence.xml.AbstractXMLWriter;
import oracle.dbtools.crest.model.placeholder.DesignPartViewPlaceHolder;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.util.string.StringUtilities;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class WXMLSubview
extends AbstractXMLWriter {
    public WXMLSubview(XMLPersistenceManager xMLPersistenceManager) {
        super(xMLPersistenceManager);
    }

    @Override
    public boolean canWrite(Object object) {
        return object instanceof DesignPartView;
    }

    @Override
    public String getRelativePath() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.getPersistenceManager().getAppView() != null) {
            String string = this.getPersistenceManager().getAppView().getDesignName();
            stringBuffer.append(string).append('/').append("subviews");
        }
        return stringBuffer.toString();
    }

    @Override
    public String getRelativePath(Object object) {
        if (object instanceof DesignPartView) {
            DesignPartView designPartView = (DesignPartView)object;
            DesignPart designPart = designPartView.getDesignPart();
            StringBuffer stringBuffer = new StringBuffer();
            if (this.getPersistenceManager().getAppView() != null) {
                String string = this.getPersistenceManager().getAppView().getDesignName();
                String string2 = designPart.getObjectID();
                String string3 = "";
                if (designPart instanceof RelationalDesign) {
                    string3 = "rel";
                    string2 = designPart.getPathIDString();
                } else if (designPart instanceof LogicalDesign) {
                    string3 = "logical";
                } else if (designPart instanceof DataTypesDesign) {
                    string3 = "datatypes";
                }
                stringBuffer.append(string).append('/').append(string3);
                if (designPart instanceof RelationalDesign) {
                    stringBuffer.append('/').append(StringUtilities.encodeAttributeValue(string2));
                }
                stringBuffer.append('/').append("subviews");
            }
            return stringBuffer.toString();
        }
        return this.getRelativePath();
    }

    @Override
    public String getFilenameFor(Object object) {
        if (object instanceof DesignPartView) {
            return ((DesignPartView)object).getDPVId();
        }
        return null;
    }

    @Override
    public Document writeDocument(Object object) {
        Document document = this.createDocument();
        if (object instanceof DesignPartView) {
            DesignPartView designPartView = (DesignPartView)object;
            Element element = document.getDocumentElement();
            DesignPartViewPlaceHolder designPartViewPlaceHolder = (DesignPartViewPlaceHolder)designPartView.getPlaceHolder();
            this.appendSubView(element, designPartViewPlaceHolder, designPartView);
        }
        return document;
    }

    public void appendExtSubViews(Element element, DesignPart designPart) {
        Serializable serializable;
        Document document = element.getOwnerDocument();
        Element element2 = document.createElement("ext_sub_views_collection");
        DesignPartViewPlaceHolder designPartViewPlaceHolder = designPart.getMainDPVPlaceHolder();
        if (!this.getPersistenceManager().isXML_FromDataBase() && designPartViewPlaceHolder != null) {
            boolean bl = this.getPersistenceManager().isCheckDirty() ? designPartViewPlaceHolder.isDirty() : true;
            if (bl) {
                DesignPartView designPartView = designPartViewPlaceHolder.getDesignPartView();
                this.write(designPartView);
                serializable = new StringBuffer();
                if (this.getPersistenceManager().getAppView() != null) {
                    ((StringBuffer)serializable).append(this.getPersistenceManager().getAppView().getCurrentDesign().getDesignPath()).append('/');
                }
                ((StringBuffer)serializable).append(this.getRelativePath(designPartView)).append('/').append(designPartView.getDPVId()).append(".dmd");
                designPartViewPlaceHolder.setFilePath(((StringBuffer)serializable).toString());
                designPartViewPlaceHolder.setDirty(false);
                designPartView.setDirty(false);
            }
        }
        this.appendSubViewElement(element2, designPartViewPlaceHolder);
        Iterator iterator = designPart.getDesignSubviews().iterator();
        while (iterator.hasNext()) {
            designPartViewPlaceHolder = (DesignPartViewPlaceHolder)iterator.next();
            if (!this.getPersistenceManager().isXML_FromDataBase() && designPartViewPlaceHolder != null) {
                boolean bl = this.getPersistenceManager().isCheckDirty() ? designPartViewPlaceHolder.isDirty() : true;
                if (bl) {
                    serializable = designPartViewPlaceHolder.getDesignPartView();
                    this.write(serializable);
                    StringBuffer stringBuffer = new StringBuffer();
                    if (this.getPersistenceManager().getAppView() != null) {
                        stringBuffer.append(this.getPersistenceManager().getAppView().getCurrentDesign().getDesignPath()).append('/');
                    }
                    stringBuffer.append(this.getRelativePath(serializable)).append('/').append(((DesignPartView)serializable).getDPVId()).append(".dmd");
                    designPartViewPlaceHolder.setFilePath(stringBuffer.toString());
                    designPartViewPlaceHolder.setDirty(false);
                    ((DesignPartView)serializable).setDirty(false);
                }
            }
            this.appendSubViewElement(element2, designPartViewPlaceHolder);
        }
        element.appendChild(element2);
    }

    protected Element appendObjectInfo(Document document, Element element, ModelIDObject modelIDObject, String string) {
        String string2;
        modelIDObject.setPersisted(true);
        Element element2 = document.createElement("object");
        element2.setAttribute("type", StringUtilities.encodeAttributeValue(string));
        element2.setAttribute("id", StringUtilities.encodeAttributeValue(modelIDObject.getObjectID()));
        if (!modelIDObject.hasOwnerDesignName() && modelIDObject.isWriteable()) {
            modelIDObject.setOwnerDesign();
        }
        Element element3 = document.createElement("name");
        Text text = document.createTextNode(StringUtilities.encodeAttributeValue(modelIDObject.getName()));
        element3.appendChild(text);
        element2.appendChild(element3);
        String string3 = modelIDObject.getComment();
        if (string3 != null) {
            element3 = document.createElement("comment");
            text = document.createTextNode(StringUtilities.encodeAttributeValue(string3));
            element3.appendChild(text);
            element2.appendChild(element3);
        }
        if ((string2 = modelIDObject.getNotes()) != null) {
            element3 = document.createElement("notes");
            text = document.createTextNode(StringUtilities.encodeAttributeValue(string2));
            element3.appendChild(text);
            element2.appendChild(element3);
        }
        this.appendChange(element2, modelIDObject.getCreation(), "created");
        this.appendChange(element2, modelIDObject.getChange(), "changed");
        String string4 = modelIDObject.getGeneratorID();
        if (!ModelIDObject.USER_GENERATED.equalsIgnoreCase(string4)) {
            element3 = document.createElement("generator");
            text = document.createTextNode(string4);
            element3.appendChild(text);
            element2.appendChild(element3);
        }
        element.appendChild(element2);
        StringBuffer stringBuffer = new StringBuffer();
        if (this.getPersistenceManager().getAppView() != null) {
            stringBuffer.append(this.getPersistenceManager().getAppView().getCurrentDesign().getDesignPath()).append('/');
        }
        stringBuffer.append(this.getRelativePath()).append('/').append(StringUtilities.encodeAttributeValue(modelIDObject.getObjectID())).append(".dmd");
        modelIDObject.setFilePath(stringBuffer.toString());
        return element2;
    }

    protected void appendSubViewElement(Element element, DesignPartViewPlaceHolder designPartViewPlaceHolder) {
        DesignPartView designPartView = designPartViewPlaceHolder.getDesignPartView();
        String string = "sub_view";
        if (designPartView == designPartView.getDesignPart().getMainView()) {
            string = "main_view";
        }
        Document document = element.getOwnerDocument();
        Element element2 = document.createElement("sub_view");
        element2.setAttribute("subview_name", StringUtilities.encodeAttributeValue(designPartView.getName()));
        element2.setAttribute("id", designPartView.getDPVId());
        element2.setAttribute("sv_type", string);
        element2.setAttribute("visible", designPartViewPlaceHolder.getVisible() ? "true" : "false");
        element2.setAttribute("rep_oid", designPartView.getRepositoryOID());
        element2.setAttribute("rep_ovid", designPartView.getRepositoryOVID());
        element2.setAttribute("is_checkedout", String.valueOf(designPartView.isCheckedOut()));
        element2.setAttribute("checkedout_by", designPartView.getCheckedOutBy());
        element.appendChild(element2);
    }
}

