/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.persistence.xml;

import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.RDBMSSiteSet;
import oracle.dbtools.crest.model.persistence.XMLPersistenceManager;
import oracle.dbtools.crest.model.persistence.xml.AbstractXMLWriter;
import oracle.dbtools.crest.util.string.StringUtilities;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class WXMLRDBMSSiteSet
extends AbstractXMLWriter {
    public WXMLRDBMSSiteSet(XMLPersistenceManager xMLPersistenceManager) {
        super(xMLPersistenceManager);
    }

    @Override
    public boolean canWrite(Object object) {
        return object instanceof RDBMSSiteSet;
    }

    @Override
    public String getFilenameFor(Object object) {
        StringBuffer stringBuffer = new StringBuffer();
        String string = this.getPersistenceManager().getAppView().getDesignName();
        stringBuffer.append(string).append("_RDBMSSites");
        return stringBuffer.toString();
    }

    @Override
    public String getRelativePath() {
        StringBuffer stringBuffer = new StringBuffer();
        String string = this.getPersistenceManager().getAppView().getDesignName();
        stringBuffer.append(string).append('/').append(this.getConfiguration().get("rdbmsSitePath"));
        return stringBuffer.toString();
    }

    @Override
    public Document writeDocument(Object object) {
        RDBMSSiteSet rDBMSSiteSet = (RDBMSSiteSet)object;
        Document document = this.createDocument();
        Element element = document.getDocumentElement();
        RDBMSSite[] rDBMSSiteArray = (RDBMSSite[])rDBMSSiteSet.toArray();
        for (int i = 0; i < rDBMSSiteArray.length; ++i) {
            if (rDBMSSiteSet.canSaveDefaults()) {
                this.appendSiteNode(element, rDBMSSiteArray[i]);
                continue;
            }
            if (rDBMSSiteArray[i].getIsDefault() && rDBMSSiteArray[i].getPathID() <= 9) continue;
            this.appendSiteNode(element, rDBMSSiteArray[i]);
        }
        return document;
    }

    public void appendSiteNode(Element element, RDBMSSite rDBMSSite) {
        Document document = element.getOwnerDocument();
        Element element2 = document.createElement("site");
        element2.setAttribute("name", StringUtilities.encodeAttributeValue(rDBMSSite.getLongName()));
        if (rDBMSSite.getType() != null) {
            element2.setAttribute("type", String.valueOf(rDBMSSite.getType().getType()));
        }
        element2.setAttribute("oid", StringUtilities.encodeAttributeValue(rDBMSSite.getObjectID()));
        element2.setAttribute("pathid", rDBMSSite.getPathIDString());
        element.appendChild(element2);
    }
}

