/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.persistence.xml;

import oracle.dbtools.crest.model.design.Note;
import oracle.dbtools.crest.model.design.datatypes.DataTypesDesign;
import oracle.dbtools.crest.model.design.logical.LogicalDesign;
import oracle.dbtools.crest.model.design.multidimensional.MultidimensionalDesign;
import oracle.dbtools.crest.model.design.process.DataFlowDesign;
import oracle.dbtools.crest.model.design.process.TransformationTask;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.persistence.XMLPersistenceManager;
import oracle.dbtools.crest.model.persistence.xml.AbstractWXMLDesignObject;
import oracle.dbtools.crest.util.string.StringUtilities;

public class WXMLNote
extends AbstractWXMLDesignObject {
    Note note = null;

    public WXMLNote(XMLPersistenceManager xMLPersistenceManager) {
        super(xMLPersistenceManager);
    }

    @Override
    public boolean canWrite(Object object) {
        boolean bl = object instanceof Note;
        if (bl) {
            this.note = (Note)object;
        }
        return bl;
    }

    @Override
    public String getRelativePath() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.note != null) {
            String string = this.note.getDesignPart().getAppView().getDesignName();
            String string2 = "";
            if (this.note.getDesignPart() instanceof LogicalDesign) {
                string2 = "logical";
            } else if (this.note.getDesignPart() instanceof RelationalDesign) {
                string2 = "rel/" + this.note.getDesignPart().getPathIDString();
            } else if (this.note.getDesignPart() instanceof DataFlowDesign) {
                string2 = "pm/dflows/" + StringUtilities.encodeAttributeValue(this.note.getDesignPart().getObjectID());
            } else if (this.note.getDesignPart() instanceof MultidimensionalDesign) {
                string2 = "multidimensional/" + StringUtilities.encodeAttributeValue(this.note.getDesignPart().getObjectID());
            } else if (this.note.getDesignPart() instanceof DataTypesDesign) {
                string2 = "datatypes";
            } else if (this.note.getDesignPart() instanceof TransformationTask) {
                string2 = "pm/tp/" + StringUtilities.encodeAttributeValue(((TransformationTask)this.note.getDesignPart()).getTransformationPackage().getObjectID()) + "/" + StringUtilities.encodeAttributeValue(this.note.getDesignPart().getObjectID());
            }
            stringBuffer.append(string).append('/').append(string2).append('/');
        }
        stringBuffer.append(this.getConfiguration().get("notePath"));
        return stringBuffer.toString();
    }
}

