/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.persistence.xml;

import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.logical.InheritanceRelation;
import oracle.dbtools.crest.model.persistence.XMLPersistenceManager;
import oracle.dbtools.crest.model.persistence.xml.AbstractWXMLDesignObject;
import oracle.dbtools.crest.util.string.StringUtilities;
import org.w3c.dom.Element;

public class WXMLInheritanceRelation
extends AbstractWXMLDesignObject {
    InheritanceRelation relation = null;

    public WXMLInheritanceRelation(XMLPersistenceManager xMLPersistenceManager) {
        super(xMLPersistenceManager);
    }

    @Override
    public boolean canWrite(Object object) {
        boolean bl;
        boolean bl2 = bl = object.getClass() == InheritanceRelation.class;
        if (bl) {
            this.relation = (InheritanceRelation)object;
        }
        return bl;
    }

    @Override
    public String getRelativePath() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.relation != null) {
            String string = this.relation.getDesignPart().getAppView().getDesignName();
            stringBuffer.append(string).append('/').append("logical").append('/');
        }
        stringBuffer.append(this.getConfiguration().get("inheritancePath"));
        return stringBuffer.toString();
    }

    @Override
    protected void appendDesignObjectInfo(Element element, DesignObject designObject) {
        if (designObject instanceof InheritanceRelation) {
            InheritanceRelation inheritanceRelation = (InheritanceRelation)designObject;
            this.appendConnectionInfo(element, StringUtilities.encodeAttributeValue(inheritanceRelation.getSourceEntity().getObjectID()), "source");
            this.appendConnectionInfo(element, StringUtilities.encodeAttributeValue(inheritanceRelation.getTargetEntity().getObjectID()), "target");
        }
    }

    private void appendConnectionInfo(Element element, String string, String string2) {
        Element element2 = element.getOwnerDocument().createElement("inheritance");
        element.appendChild(element2);
        element2.setAttribute("endpoint", string2);
        element2.setAttribute("entity", StringUtilities.encodeAttributeValue(string));
    }
}

