/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.persistence.xml;

import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.LogicalDatatype;
import oracle.dbtools.crest.model.design.logical.Attribute;
import oracle.dbtools.crest.model.design.logical.Entity;
import oracle.dbtools.crest.model.persistence.XMLPersistenceManager;
import oracle.dbtools.crest.model.persistence.xml.AbstractWXMLDesignObject;
import oracle.dbtools.crest.util.string.StringUtilities;
import org.w3c.dom.Element;

public class WXMLEntity
extends AbstractWXMLDesignObject {
    private Entity entity = null;

    public WXMLEntity(XMLPersistenceManager xMLPersistenceManager) {
        super(xMLPersistenceManager);
    }

    @Override
    public boolean canWrite(Object object) {
        boolean bl = object instanceof Entity;
        if (bl) {
            this.entity = (Entity)object;
        }
        return bl;
    }

    @Override
    public String getRelativePath() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.entity != null) {
            String string = this.entity.getDesignPart().getAppView().getDesignName();
            stringBuffer.append(string).append('/').append("logical").append('/');
        }
        stringBuffer.append(this.getConfiguration().get("entityPath"));
        return stringBuffer.toString();
    }

    @Override
    protected void appendDesignObjectInfo(Element element, DesignObject designObject) {
        if (designObject instanceof Entity) {
            String string;
            String string2;
            String string3;
            String string4;
            String string5;
            Entity entity = (Entity)designObject;
            element.setAttribute("entitytype", entity.getTypeID());
            String string6 = entity.getScope();
            if (string6 != null && !"".equalsIgnoreCase(string6)) {
                element.setAttribute("scope", StringUtilities.encodeAttributeValue(string6));
            }
            if (entity.getBasedOnStructuredType() != null) {
                element.setAttribute("structuredType", StringUtilities.encodeAttributeValue(entity.getBasedOnStructuredType().getObjectID()));
            }
            if ((string5 = entity.getPreferredAbbreviation()) != null && !"".equalsIgnoreCase(string5)) {
                element.setAttribute("pref_abbreviation", StringUtilities.encodeAttributeValue(string5));
            }
            if ((string4 = entity.getShortName()) != null && !"".equalsIgnoreCase(string4)) {
                element.setAttribute("short_name", StringUtilities.encodeAttributeValue(string4));
            }
            element.setAttribute("allow_type_substitution", String.valueOf(entity.isAllowTypeSubstitution()));
            element.setAttribute("strategy", entity.getFwdEngineeringStrategyName());
            String string7 = entity.getSynonym();
            if (string7 != null && !"".equalsIgnoreCase(string7)) {
                element.setAttribute("synonym", StringUtilities.encodeAttributeValue(string7));
            }
            if ((string3 = entity.getSynonymToDisplay()) != null && !"".equalsIgnoreCase(string3)) {
                element.setAttribute("synonym_to_display", StringUtilities.encodeAttributeValue(string3));
            }
            if ((string2 = entity.getOwner()) != null && !"".equalsIgnoreCase(string2)) {
                element.setAttribute("owner", StringUtilities.encodeAttributeValue(string2));
            }
            if ((string = entity.getSource()) != null && !"".equalsIgnoreCase(string)) {
                element.setAttribute("entsource", StringUtilities.encodeAttributeValue(string));
            }
            Element element2 = this.createElement(element, "parent");
            element.appendChild(element2);
            if (entity.hasHierarchicalParent()) {
                element2.setAttribute("inherits", VALUE_TRUE);
                element2.setAttribute("id", StringUtilities.encodeAttributeValue(entity.getHierarchicalParent().getObjectID()));
            } else {
                element2.setAttribute("inherits", VALUE_FALSE);
            }
            element.setAttribute("minVolumes", new Integer(entity.getMinVolumes()).toString());
            element.setAttribute("expectedVolumes", new Integer(entity.getExpectedVolumes()).toString());
            element.setAttribute("maxVolumes", new Integer(entity.getMaxVolumes()).toString());
            element.setAttribute("growthPercent", new Integer(entity.getGrowthPercent()).toString());
            element.setAttribute("growthType", entity.getGrowthType());
            element.setAttribute("normalForm", entity.getNormalForm());
            element.setAttribute("adequatelyNormalized", entity.getAdequatelyNormalized());
        }
    }

    @Override
    protected void appendContainedObjectInfo(Element element, ContainedObject containedObject) {
        Attribute attribute = (Attribute)containedObject;
        this.appendDataTypeInfo(element, attribute);
        this.appendReferenceInfo(element, attribute.isReference());
        this.appendLogicalTypeInfo(element, attribute.getLogicalDatatype());
        this.appendUseDomainInfo(element, attribute.getUse());
        this.appendSourceTypeInfo(element, attribute.getSourceType());
        this.appendFormulaDescInfo(element, attribute.getFormulaDesc());
        this.appendSubtypeSubstitutionInfo(element, attribute.isAllowSubtypeSubstitution());
        this.appendRestrictedSubstitutionInfo(element, attribute);
        this.appendScopeInfo(element, attribute);
        this.appendPreferredAbbreviationInfo(element, attribute.getPreferredAbbreviation());
        this.appendSource(element, attribute.getSource());
    }

    protected void appendLogicalTypeInfo(Element element, LogicalDatatype logicalDatatype) {
        if (logicalDatatype != null) {
            Element element2 = element.getOwnerDocument().createElement("logicaltype");
            element2.setAttribute("dttype", StringUtilities.encodeAttributeValue(logicalDatatype.getName()));
            element2.setAttribute("oid", StringUtilities.encodeAttributeValue(logicalDatatype.getObjectID()));
            element.appendChild(element2);
        }
    }

    protected void appendUseDomainInfo(Element element, short s) {
        Element element2 = element.getOwnerDocument().createElement("use");
        if (s == 0) {
            element2.setAttribute("value", "domain");
        } else if (s == 1) {
            element2.setAttribute("value", "logical type");
        } else if (s == 2) {
            element2.setAttribute("value", "distinct type");
        } else if (s == 3) {
            element2.setAttribute("value", "structured type");
        } else if (s == 4) {
            element2.setAttribute("value", "collection type");
        }
        element.appendChild(element2);
    }

    private void appendSourceTypeInfo(Element element, String string) {
        Element element2 = element.getOwnerDocument().createElement("sourcetype");
        element2.setAttribute("sort", string);
        element.appendChild(element2);
    }

    private void appendFormulaDescInfo(Element element, String string) {
        Element element2 = element.getOwnerDocument().createElement("formula");
        element2.setAttribute("desc", StringUtilities.encodeAttributeValue(string));
        element.appendChild(element2);
    }

    private void appendPreferredAbbreviationInfo(Element element, String string) {
        if (string != null && !"".equalsIgnoreCase(string)) {
            Element element2 = element.getOwnerDocument().createElement("pref_abbreviation");
            element2.setAttribute("abbreviation", StringUtilities.encodeAttributeValue(string));
            element.appendChild(element2);
        }
    }

    private void appendSource(Element element, String string) {
        Element element2 = element.getOwnerDocument().createElement("source");
        element2.setAttribute("value", StringUtilities.encodeAttributeValue(string));
        element.appendChild(element2);
    }
}

