/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.persistence.xml;

import java.util.HashMap;
import java.util.List;
import oracle.dbtools.crest.model.MDPreferences;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.design.AbstractView;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.ContainedObjectWithDomain;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.ContainerWithKeyObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.ColumnView;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.relational.TableView;
import oracle.dbtools.crest.model.persistence.XMLPersistenceManager;
import oracle.dbtools.crest.model.persistence.xml.AbstractRXMLDesignObject;
import oracle.dbtools.crest.util.string.StringUtilities;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class RXMLTableView
extends AbstractRXMLDesignObject {
    public RXMLTableView(XMLPersistenceManager xMLPersistenceManager) {
        super(xMLPersistenceManager);
    }

    @Override
    public String getRelativePath() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.getPersistenceManager().getAppView() != null) {
            String string = this.getPersistenceManager().getAppView().getDesignName();
            stringBuffer.append(string).append('/');
            if (this.isOldDesign()) {
                String string2 = this.getPersistenceManager().getAppView().getCurrentDesign().getRelationalDesign().getObjectID();
                stringBuffer.append("relational").append('/').append(string2).append('/');
            } else {
                String string3 = this.getPersistenceManager().getAppView().getCurrentDesign().getRelationalDesign().getPathIDString();
                stringBuffer.append("rel").append('/').append(string3).append('/');
            }
        }
        stringBuffer.append(this.getConfiguration().get("tableViewPath"));
        return stringBuffer.toString();
    }

    @Override
    public String getIdStartSequence() {
        return MDPreferences.getDefaultInstance().get("tableview id prefix");
    }

    @Override
    protected DesignObject instantiateDesignObject(String string, Design design, Element element) {
        return design.getRelationalDesign().getTableViewSet().createTableView(StringUtilities.decodeAttributeValue(string));
    }

    @Override
    protected void readObjectInfo(Element element, ModelIDObject modelIDObject, boolean bl) {
        if (modelIDObject instanceof TableView) {
            String string;
            Object object;
            Object object2;
            Object object3;
            Node node;
            Object object4;
            Object object5;
            TableView tableView = (TableView)modelIDObject;
            String string2 = element.getAttribute("structuredType");
            if (string2 != null) {
                object5 = (StructuredType)modelIDObject.getDesign().getDataTypesDesign().getStructuredTypeSet().getObjectByID(string2);
                tableView.setBasedOnStructuredType((StructuredType)object5);
                object4 = element.getAttribute("oid_text");
                if (object4 != null && !"".equalsIgnoreCase((String)object4)) {
                    tableView.setOidText(StringUtilities.decodeAttributeValue((String)object4));
                }
            }
            if ((object5 = element.getAttribute("allow_type_substitution")) != null) {
                tableView.setAllowTypeSubstitution(Boolean.valueOf((String)object5));
            }
            if ((object4 = RXMLTableView.getFirstChildByTagName(element, "userDefined")) != null && (node = object4.getFirstChild()) != null && (object3 = node.getNodeValue()) != null) {
                tableView.setUserDefined(Boolean.valueOf(StringUtilities.decodeAttributeValue((String)object3)));
            }
            if ((node = RXMLTableView.getFirstChildByTagName(element, "userDefinedSQL")) != null && (object3 = node.getFirstChild()) != null && (object2 = object3.getNodeValue()) != null) {
                tableView.setUserDefinedSQL(StringUtilities.decodeAttributeValue((String)object2));
            }
            if ((object3 = RXMLTableView.getFirstChildByTagName(element, "where")) != null && (object2 = object3.getFirstChild()) != null && (object = object2.getNodeValue()) != null) {
                tableView.setWhere(StringUtilities.decodeAttributeValue((String)object));
            }
            if ((object2 = RXMLTableView.getFirstChildByTagName(element, "having")) != null && (object = object2.getFirstChild()) != null && (string = object.getNodeValue()) != null) {
                tableView.setHaving(StringUtilities.decodeAttributeValue(string));
            }
            object = element.getElementsByTagName("container");
            int n = object.getLength();
            for (int i = 0; i < n; ++i) {
                Element element2 = (Element)object.item(i);
                String string3 = StringUtilities.decodeAttributeValue(element2.getAttribute("alias"));
                String string4 = StringUtilities.decodeAttributeValue(element2.getAttribute("cid"));
                if (string4 == null || string3 == null) continue;
                tableView.addToContainers(string4, string3);
            }
            this.recreateScript(element, tableView);
        }
    }

    @Override
    protected void readContainedObjectInfo(Element element, ContainerObject containerObject, ContainedObject containedObject, boolean bl) {
        String string;
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        Object object6;
        Object object7;
        Object object8;
        Node node;
        Object object9;
        Object object10;
        Object object11;
        ColumnView columnView = (ColumnView)containedObject;
        String string2 = element.getAttribute("tableid");
        if (string2 != null && (object11 = containerObject.getDesign().getDesignObject(string2)) != null) {
            columnView.setContainer((ContainerObject)object11);
        }
        object11 = element.getAttribute("reference");
        columnView.setReference(Boolean.valueOf((String)object11));
        String string3 = element.getAttribute("dttype");
        if (!"".equalsIgnoreCase(string3) && (object10 = (StructuredType)containerObject.getDesign().getDataTypesDesign().getStructuredTypeSet().getObjectByID(string3)) != null) {
            columnView.setStructuredType((StructuredType)object10);
        }
        if ((object10 = RXMLTableView.getFirstChildByTagName(element, "scope")) != null && (object9 = object10.getAttribute("objectid")) != null) {
            columnView.setScopeId((String)object9);
        }
        if ((object9 = RXMLTableView.getFirstChildByTagName(element, "name")) != null && (node = object9.getFirstChild()) != null && (object8 = node.getNodeValue()) != null) {
            columnView.setName(StringUtilities.decodeAttributeValue((String)object8));
        }
        if ((node = RXMLTableView.getFirstChildByTagName(element, "alias")) != null && (object8 = node.getFirstChild()) != null && (object7 = object8.getNodeValue()) != null) {
            columnView.setAlias(StringUtilities.decodeAttributeValue((String)object7));
        }
        if ((object8 = RXMLTableView.getFirstChildByTagName(element, "tableAlias")) != null && (object7 = object8.getFirstChild()) != null && (object6 = object7.getNodeValue()) != null) {
            columnView.setTableAlias(StringUtilities.decodeAttributeValue((String)object6));
        }
        if ((object7 = RXMLTableView.getFirstChildByTagName(element, "refcolumn")) != null && (object6 = object7.getFirstChild()) != null && (object5 = object6.getNodeValue()) != null) {
            object4 = (Column)containerObject.getDesign().getDesignObject((String)object5);
            columnView.setReferencedColumn((ContainedObjectWithDomain)object4);
        }
        if ((object6 = RXMLTableView.getFirstChildByTagName(element, "ref_column_view")) != null && (object5 = object6.getFirstChild()) != null && (object4 = object5.getNodeValue()) != null) {
            object3 = (ContainedObject)containerObject.getDesign().getDesignObject((String)object4);
            if (object3 != null) {
                columnView.setReferencedColumnView((ContainedObject)object3);
            }
            columnView.setReferencedColumnViewID((String)object4);
        }
        if ((object5 = RXMLTableView.getFirstChildByTagName(element, "table")) != null && (object4 = object5.getFirstChild()) != null && (object3 = object4.getNodeValue()) != null) {
            object2 = (Table)containerObject.getDesign().getDesignObject((String)object3);
            columnView.setTable((ContainerWithKeyObject)object2);
        }
        if ((object4 = RXMLTableView.getFirstChildByTagName(element, "view")) != null && (object3 = object4.getFirstChild()) != null && (object2 = object3.getNodeValue()) != null) {
            object = (TableView)containerObject.getDesign().getDesignObject((String)object2);
            columnView.setView((AbstractView)object);
        }
        if ((object3 = RXMLTableView.getFirstChildByTagName(element, "expression")) != null && (object2 = object3.getFirstChild()) != null && (object = object2.getNodeValue()) != null) {
            columnView.setExpression(StringUtilities.decodeAttributeValue((String)object));
        }
        if ((object2 = RXMLTableView.getFirstChildByTagName(element, "datatype")) != null && (object = object2.getFirstChild()) != null && (string = object.getNodeValue()) != null) {
            columnView.setDataType(StringUtilities.decodeAttributeValue(string));
        }
        if (!containerObject.contains(containedObject)) {
            containerObject.add(containedObject);
        }
    }

    @Override
    public Object recreateDesign(Document document, DesignPart designPart, boolean bl) {
        return null;
    }

    @Override
    public Object recreateObject(Element element, Design design, boolean bl) {
        TableView tableView = (TableView)super.recreateObject(element, design, bl);
        StringBuffer stringBuffer = new StringBuffer();
        if (this.getPersistenceManager().getAppView() != null) {
            stringBuffer.append(this.getPersistenceManager().getAppView().getCurrentDesign().getDesignPath()).append('/');
        }
        stringBuffer.append(this.getRelativePath()).append('/').append(StringUtilities.decodeAttributeValue(tableView.getObjectID())).append(".dmd");
        tableView.setFilePath(stringBuffer.toString());
        return tableView;
    }

    @Override
    protected void readGroupBy(Element element, String string, ContainerObject containerObject, List list) {
        TableView tableView = (TableView)containerObject;
        Element element2 = RXMLTableView.getFirstChildByTagName(element, string);
        if (element2 != null) {
            NodeList nodeList = element2.getElementsByTagName("cv_id");
            int n = nodeList.getLength();
            for (int i = 0; i < n; ++i) {
                Element element3 = (Element)nodeList.item(i);
                String string2 = element3.getAttribute("value");
                ColumnView columnView = tableView.getColumnByObjectID(string2);
                if (columnView == null || list.contains(columnView)) continue;
                list.add(columnView);
            }
        }
    }

    @Override
    protected void readOrderBy(Element element, ContainerObject containerObject) {
        TableView tableView = (TableView)containerObject;
        Element element2 = RXMLTableView.getFirstChildByTagName(element, "orderby");
        HashMap<String, String> hashMap = new HashMap<String, String>();
        NodeList nodeList = element2.getElementsByTagName("columnview");
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            ColumnView columnView2;
            Element element3 = (Element)nodeList.item(i);
            String string = StringUtilities.decodeAttributeValue(element3.getAttribute("objectid"));
            String string2 = element3.getAttribute("sortorder");
            String string3 = element3.getAttribute("cid");
            String string4 = StringUtilities.decodeAttributeValue(element3.getAttribute("name"));
            for (ColumnView columnView2 : tableView.getElementsCollection()) {
                if (!columnView2.getName().equalsIgnoreCase(string4)) continue;
                tableView.addToOrderBy(columnView2, string2);
                hashMap.put(string, string2);
                break;
            }
            if (tableView.getElementByName(string4) != null) continue;
            columnView2 = new ColumnView(tableView.getDesignPart());
            columnView2.setObjectID(string);
            columnView2.setName(string4);
            if ((Table)((RelationalDesign)tableView.getDesignPart()).getTableSet().getObjectByID(string3) != null) {
                columnView2.setTableAlias(((Table)((RelationalDesign)tableView.getDesignPart()).getTableSet().getObjectByID(string3)).getName());
            }
            tableView.addToOrderBy(columnView2, string2);
        }
    }

    @Override
    public boolean isReaderForClass(Class clazz) {
        return clazz == TableView.class;
    }
}

