/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.persistence.xml;

import java.util.ArrayList;
import java.util.Map;
import oracle.dbtools.crest.model.MDPreferences;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.Task;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.ContainerWithKeyObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.KeyObject;
import oracle.dbtools.crest.model.design.LogicalDatatype;
import oracle.dbtools.crest.model.design.constraint.TableLevelConstraint;
import oracle.dbtools.crest.model.design.datatypes.CollectionType;
import oracle.dbtools.crest.model.design.datatypes.DistinctType;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.SpatialColumnDefObject;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.persistence.XMLPersistenceManager;
import oracle.dbtools.crest.model.persistence.xml.AbstractRXMLDesignObject;
import oracle.dbtools.crest.util.string.StringUtilities;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class RXMLTable
extends AbstractRXMLDesignObject {
    private static float NFS = 2.4f;

    public RXMLTable(XMLPersistenceManager xMLPersistenceManager) {
        super(xMLPersistenceManager);
    }

    @Override
    public String getRelativePath() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.getPersistenceManager().getAppView() != null) {
            String string = this.getPersistenceManager().getAppView().getDesignName();
            stringBuffer.append(string).append('/');
            if (this.isOldDesign()) {
                String string2 = this.getPersistenceManager().getAppView().getCurrentDesign().getRelationalDesign().getObjectID();
                stringBuffer.append("relational").append('/').append(string2).append('/');
            } else {
                String string3 = this.getPersistenceManager().getAppView().getCurrentDesign().getRelationalDesign().getPathIDString();
                stringBuffer.append("rel").append('/').append(string3).append('/');
            }
        }
        stringBuffer.append(this.getConfiguration().get("tablePath"));
        return stringBuffer.toString();
    }

    @Override
    public String getIdStartSequence() {
        return MDPreferences.getDefaultInstance().get("table id prefix");
    }

    @Override
    protected DesignObject instantiateDesignObject(String string, Design design, Element element) {
        return design.getRelationalDesign().getTableSet().recreateTable(StringUtilities.decodeAttributeValue(string));
    }

    @Override
    protected ContainedObject instantiateContainedObject(String string, Design design, ContainerObject containerObject, Element element) {
        Table table = (Table)containerObject;
        String string2 = element.getAttribute("fk");
        if (string2 != null && Boolean.valueOf(string2).booleanValue()) {
            Object object;
            Column column = table.createTemporaryFKColumn(StringUtilities.decodeAttributeValue(string));
            Element element2 = RXMLTable.getFirstChildByTagName(element, "is_previous_column");
            if (element2 != null && (object = element2.getAttribute("value")) != null) {
                column.setPreviousColumn(Boolean.valueOf((String)object));
            }
            object = RXMLTable.getFirstChildByTagName(element, "associations");
            NodeList nodeList = object.getElementsByTagName("associated");
            int n = nodeList.getLength();
            for (int i = 0; i < n; ++i) {
                Element element3 = (Element)nodeList.item(i);
                column.addFKAssociation(element3.getAttribute("references"), element3.getAttribute("fkassid"));
            }
            return column;
        }
        return containerObject.createContainedObject(StringUtilities.decodeAttributeValue(string));
    }

    @Override
    public Object recreateObject(Element element, Design design, boolean bl) {
        Table table = (Table)super.recreateObject(element, design, bl);
        this.recreateTableLevelConstraints(element, table);
        this.recreateColumnGroups(element, table);
        if (design.getLoadedVersion() < NFS) {
            this.recreateFKAssociations(element, table, design);
        }
        this.recreateScript(element, table);
        this.recreateSpatialTableInfo(element, table);
        String string = element.getAttribute("oid_is_pk");
        if (string != null && "true".equalsIgnoreCase(string)) {
            table.setOidIsPK(true);
        }
        this.recreateOidPKColumns(element, table);
        StringBuffer stringBuffer = new StringBuffer();
        if (this.getPersistenceManager().getAppView() != null) {
            stringBuffer.append(this.getPersistenceManager().getAppView().getCurrentDesign().getDesignPath()).append('/');
        }
        stringBuffer.append(this.getRelativePath()).append('/').append(StringUtilities.decodeAttributeValue(table.getObjectID())).append(".dmd");
        table.setFilePath(stringBuffer.toString());
        return table;
    }

    private void recreateOidPKColumns(Element element, Table table) {
        Map map = this.getProperties(element, "oid_pk_columns");
        Object[] objectArray = map.keySet().toArray();
        for (int i = 0; i < objectArray.length; ++i) {
            String string = (String)map.get(objectArray[i]);
            ContainedObject containedObject = table.getElementByID(string);
            if (containedObject == null) continue;
            table.getOidPKColumns().add(containedObject);
        }
    }

    private void recreateSpatialTableInfo(Element element, Table table) {
        NodeList nodeList = element.getElementsByTagName("spatial_table");
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            Element element2 = (Element)nodeList.item(i);
            table.setSpatialTable(Boolean.valueOf(element2.getAttribute("value")));
            NodeList nodeList2 = element2.getElementsByTagName("spatial_definition");
            int n2 = nodeList2.getLength();
            for (int j = 0; j < n2; ++j) {
                Object object;
                Object object2;
                Element element3 = (Element)nodeList2.item(j);
                SpatialColumnDefObject spatialColumnDefObject = new SpatialColumnDefObject(table);
                spatialColumnDefObject.setName(element3.getAttribute(StringUtilities.decodeAttributeValue("name")));
                table.addSpatialDefinition(spatialColumnDefObject);
                Element element4 = RXMLTable.getFirstChildByTagName(element3, "spatial_index");
                if (element4 != null && (object2 = (Index)table.getKeyObject((String)(object = element4.getAttribute("id")))) != null) {
                    ((Index)object2).setSpatialIndex(true);
                    spatialColumnDefObject.setSpatialIndex((Index)object2);
                    ((Index)object2).setSpatialColumnDefiniton(spatialColumnDefObject);
                    ((Index)object2).setLayerType(element4.getAttribute("layer_gtype"));
                    ((Index)object2).setGeodetic(element4.getAttribute("geodetic"));
                    ((Index)object2).setDimensionsNumber(Integer.parseInt(element4.getAttribute("sdo_indx_dims")));
                }
                if ((element4 = RXMLTable.getFirstChildByTagName(element3, "spatial_srid")) != null) {
                    spatialColumnDefObject.setSystemID(element4.getAttribute(StringUtilities.decodeAttributeValue("value")));
                }
                if ((element4 = RXMLTable.getFirstChildByTagName(element3, "spatial_function")) != null) {
                    boolean bl = Boolean.valueOf(element4.getAttribute("value"));
                    if (bl && (element4 = RXMLTable.getFirstChildByTagName(element3, "spatial_func_expression")) != null) {
                        object2 = element4.getAttribute("value");
                        spatialColumnDefObject.setFuncExpression((String)object2);
                    }
                    spatialColumnDefObject.setFunction(bl);
                }
                if ((element4 = RXMLTable.getFirstChildByTagName(element3, "spatial_column")) != null) {
                    object = element4.getAttribute("id");
                    object2 = (Column)table.getColumnSet().getObjectByID((String)object);
                    spatialColumnDefObject.setSpatialColumn((Column)object2);
                }
                if ((element4 = RXMLTable.getFirstChildByTagName(element3, "spatial_table_dimensions")) == null) continue;
                object = element4.getElementsByTagName("spatial_table_dimension");
                int n3 = object.getLength();
                for (int k = 0; k < n3; ++k) {
                    Element element5 = (Element)object.item(k);
                    SpatialColumnDefObject.TableDimension tableDimension = spatialColumnDefObject.new SpatialColumnDefObject.TableDimension();
                    tableDimension.setName(element5.getAttribute(StringUtilities.decodeAttributeValue("name")));
                    tableDimension.setLowBoundary(element5.getAttribute(StringUtilities.decodeAttributeValue("low_boundary")));
                    tableDimension.setUpperBoundary(element5.getAttribute(StringUtilities.decodeAttributeValue("upper_boundary")));
                    tableDimension.setTolerance(element5.getAttribute(StringUtilities.decodeAttributeValue("tolerance")));
                }
            }
        }
    }

    @Override
    protected void readObjectInfo(Element element, ModelIDObject modelIDObject, boolean bl) {
        if (modelIDObject instanceof Table) {
            String string;
            String string2;
            String string3;
            String string4;
            String string5;
            String string6;
            String string7;
            Object object;
            String string8;
            String string9;
            Table table = (Table)modelIDObject;
            String string10 = element.getAttribute("entitytype");
            if (table.getDesign().getLoadedVersion() < 2.2f) {
                if (table.getDesign().getDLSettings().getClassificationTypeByName(string10) != null) {
                    table.setTypeID(table.getDesign().getDLSettings().getClassificationTypeByName(string10).getTypeID());
                } else {
                    table.setTypeID("");
                }
            } else if (table.getDesign().getDLSettings().getClassificationTypeByID(string10) != null) {
                table.setTypeID(table.getDesign().getDLSettings().getClassificationTypeByID(string10).getTypeID());
            } else {
                table.setTypeID("");
            }
            String string11 = element.getAttribute("scope");
            if (string11 != null) {
                table.setScope(StringUtilities.decodeAttributeValue(string11));
            }
            if ((string9 = element.getAttribute("splittedTableID")) != null) {
                table.setSplittedTableID(string9);
            }
            if ((string8 = element.getAttribute("structuredType")) != null) {
                object = (StructuredType)modelIDObject.getDesign().getDataTypesDesign().getStructuredTypeSet().getObjectByID(string8);
                table.setBasedOnStructuredType((StructuredType)object);
            }
            if ((object = element.getAttribute("allow_type_substitution")) != null) {
                table.setAllowTypeSubstitution(Boolean.valueOf((String)object));
            }
            if ((string7 = element.getAttribute("minVolumes")) != null) {
                table.setMinVolumes(string7);
            }
            if ((string6 = element.getAttribute("expectedVolumes")) != null) {
                table.setExpectedVolumes(string6);
            }
            if ((string5 = element.getAttribute("maxVolumes")) != null) {
                table.setMaxVolumes(string5);
            }
            if ((string4 = element.getAttribute("growthPercent")) != null) {
                table.setGrowthPercent(string4);
            }
            if ((string3 = element.getAttribute("growthType")) != null) {
                table.setGrowthType(string3);
            }
            if ((string2 = element.getAttribute("abbreviation")) != null) {
                table.setAbbreviation(StringUtilities.encodeAttributeValue(string2));
            }
            if ((string = element.getAttribute("normalForm")) != null) {
                table.setNormalForm(string);
            }
        }
    }

    @Override
    protected void readContainedObjectInfo(Element element, ContainedObject containedObject, boolean bl) {
        Element element2;
        Object object;
        String string;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        Object object6;
        Object object7;
        Object object8;
        Object object9;
        Object object10;
        Object object11;
        Object object12;
        Object object13;
        Column column = (Column)containedObject;
        Element element3 = RXMLTable.getFirstChildByTagName(element, "use");
        if (element3 != null) {
            object13 = element3.getAttribute("value");
            if (object13 != null) {
                if (((String)object13).equalsIgnoreCase("domain")) {
                    column.setUse((short)0);
                } else if (((String)object13).equalsIgnoreCase("logical type")) {
                    column.setUse((short)1);
                } else if (((String)object13).equalsIgnoreCase("distinct type")) {
                    column.setUse((short)2);
                } else if (((String)object13).equalsIgnoreCase("structured type")) {
                    column.setUse((short)3);
                } else if (((String)object13).equalsIgnoreCase("collection type")) {
                    column.setUse((short)4);
                }
            }
        } else {
            element3 = RXMLTable.getFirstChildByTagName(element, "usedomain");
            if (element3 != null && (object13 = element3.getAttribute("value")) != null) {
                if (Boolean.valueOf((String)object13).booleanValue()) {
                    column.setUse((short)0);
                } else {
                    column.setUse((short)1);
                }
            }
        }
        object13 = RXMLTable.getFirstChildByTagName(element, "reference");
        if (object13 != null && (object12 = object13.getAttribute("value")) != null) {
            column.setReference(Boolean.valueOf((String)object12));
        }
        if ((object12 = RXMLTable.getFirstChildByTagName(element, "logicaltype")) != null) {
            object11 = object12.getAttribute("dttype");
            object10 = object12.getAttribute("oid");
            if (object11 != null || object10 != null) {
                object9 = LogicalDatatype.getLogicalDatatype(containedObject.getDesign(), (String)object11, (String)object10);
                column.setLogicalDatatype((LogicalDatatype)object9);
            }
        }
        if ((object11 = RXMLTable.getFirstChildByTagName(element, "datatype")) != null) {
            object10 = object11.getAttribute("dttype");
            object9 = object11.getAttribute("typename");
            if (object10 != null && ((String)object10).equalsIgnoreCase("distinct")) {
                column.setDistinctType((DistinctType)containedObject.getDesign().getDataTypesDesign().getDistinctTypeSet().getObjectByID((String)object9));
            } else if (object10 != null && ((String)object10).equalsIgnoreCase("structured")) {
                column.setStructuredType((StructuredType)containedObject.getDesign().getDataTypesDesign().getStructuredTypeSet().getObjectByID((String)object9));
            } else if (object10 != null && ((String)object10).equalsIgnoreCase("collection")) {
                column.setCollectionType((CollectionType)containedObject.getDesign().getDataTypesDesign().getCollectionTypeSet().getObjectByID((String)object9));
            } else {
                object8 = object11.getAttribute("size");
                if (object8 != null && !((String)object8).equalsIgnoreCase("")) {
                    column.setDataTypeParameter("size", (String)object8);
                }
                if ((object7 = object11.getAttribute("precision")) != null && !((String)object7).equalsIgnoreCase("")) {
                    column.setDataTypeParameter("precision", (String)object7);
                }
                if ((object6 = object11.getAttribute("scale")) != null && !((String)object6).equalsIgnoreCase("")) {
                    column.setDataTypeParameter("scale", (String)object6);
                }
            }
        }
        if ((object10 = RXMLTable.getFirstChildByTagName(element, "abbreviation")) != null && (object9 = object10.getTextContent()) != null) {
            column.setAbbreviation((String)object9);
        }
        if ((object9 = RXMLTable.getFirstChildByTagName(element, "sourcetype")) != null && (object8 = object9.getAttribute("sort")) != null) {
            column.setSourceType((String)object8);
        }
        if ((object8 = RXMLTable.getFirstChildByTagName(element, "computed")) != null && (object7 = object8.getAttribute("value")) != null) {
            column.setComputed((boolean)Boolean.valueOf((String)object7));
        }
        if ((object7 = RXMLTable.getFirstChildByTagName(element, "formula")) != null && (object6 = object7.getAttribute("desc")) != null) {
            column.setFormulaDesc(StringUtilities.decodeAttributeValue((String)object6));
        }
        if ((object6 = RXMLTable.getFirstChildByTagName(element, "subtypeSubstitution")) != null && (object5 = object6.getAttribute("value")) != null) {
            column.setAllowSubtypeSubstitution(Boolean.valueOf((String)object5));
        }
        if ((object5 = RXMLTable.getFirstChildByTagName(element, "restricted_substitution")) != null && (object4 = object5.getAttribute("value")) != null) {
            column.setRestrictedTypeSubstitution(Boolean.valueOf((String)object4));
            if (column.isRestrictedTypeSubstitution()) {
                object3 = this.getProperties((Element)object5, "permitted_types");
                object2 = object3.keySet().toArray();
                for (int i = 0; i < ((Object[])object2).length; ++i) {
                    string = (String)object3.get(object2[i]);
                    object = (StructuredType)column.getDesign().getDesignObject(string);
                    if (object == null) continue;
                    column.getPermittedSubTypes().add(object);
                }
            }
        }
        if ((object4 = RXMLTable.getFirstChildByTagName(element, "scope")) != null && (object3 = object4.getAttribute("objectid")) != null) {
            column.setScopeId((String)object3);
        }
        if ((object3 = RXMLTable.getFirstChildByTagName(element, "ui_defaults")) != null) {
            column.setDefaultLabel(StringUtilities.decodeAttributeValue(object3.getAttribute("label")));
            column.setDefaultFormatMask(StringUtilities.decodeAttributeValue(object3.getAttribute("formatMask")));
            object2 = object3.getAttribute("formDisplayWidth");
            column.setDefaultFormDisplayWidth(StringUtilities.isNotEmpty((String)object2) ? Integer.valueOf(Integer.parseInt((String)object2)) : null);
            String string2 = object3.getAttribute("formMaximumWidth");
            column.setDefaultFormMaximumWidth(StringUtilities.isNotEmpty(string2) ? Integer.valueOf(Integer.parseInt(string2)) : null);
            string = object3.getAttribute("formHeight");
            column.setDefaultFormHeight(StringUtilities.isNotEmpty(string) ? Integer.valueOf(Integer.parseInt(string)) : null);
            column.setDefaultHelpText(StringUtilities.decodeAttributeValue(object3.getAttribute("helpText")));
            column.setDefaultReadOnly(Boolean.parseBoolean(object3.getAttribute("readOnly")));
            column.setDefaultDisplayedOnReports(Boolean.parseBoolean(object3.getAttribute("displayedOnReports")));
            column.setDefaultDisplayedOnForms(Boolean.parseBoolean(object3.getAttribute("displayedOnForms")));
            column.setDefaultDisplayAs(object3.getAttribute("displayAs"));
        }
        if ((object2 = RXMLTable.getFirstChildByTagName(element, "security")) != null) {
            String string3 = object2.getAttribute("containsPII");
            if (StringUtilities.isNotEmpty(string3)) {
                column.setContainsPII(Boolean.valueOf(string3));
            }
            if (StringUtilities.isNotEmpty(string = object2.getAttribute("containsSensitiveInformation"))) {
                column.setContainsSensitiveInformation(Boolean.valueOf(string));
            }
            if (StringUtilities.isNotEmpty((String)(object = object2.getAttribute("maskData")))) {
                column.setMaskData(Boolean.valueOf((String)object));
            }
        }
        if ((element2 = RXMLTable.getFirstChildByTagName(element, "auto_increment")) != null) {
            column.setAutoIncrementColumn(Boolean.parseBoolean(object3.getAttribute("auto_increment_column")));
            column.setIdentityColumn(Boolean.parseBoolean(object3.getAttribute("identity_column")));
            column.setAutoIncrementGenerateAlways(Boolean.parseBoolean(object3.getAttribute("generate_always")));
            string = object3.getAttribute("start_with");
            if (StringUtilities.isNotEmpty(string)) {
                column.setAutoIncrementStartWith(string);
            }
            if (StringUtilities.isNotEmpty(string = object3.getAttribute("increment_by"))) {
                column.setAutoIncrementIncrementBy(Integer.parseInt(string));
            }
            if (StringUtilities.isNotEmpty(string = object3.getAttribute("min_value"))) {
                column.setAutoIncrementMinValue(string);
            }
            if (StringUtilities.isNotEmpty(string = object3.getAttribute("max_value"))) {
                column.setAutoIncrementMaxValue(string);
            }
            column.setAutoIncrementCycle(Boolean.parseBoolean(object3.getAttribute("cycle")));
            column.setAutoIncrementDisableCache(Boolean.parseBoolean(object3.getAttribute("disable_cache")));
            string = object3.getAttribute("cache");
            if (StringUtilities.isNotEmpty(string)) {
                column.setAutoIncrementCache(Integer.parseInt(string));
            }
            column.setAutoIncrementOrder(Boolean.parseBoolean(object3.getAttribute("order")));
            column.setAutoIncrementSequenceName(object3.getAttribute("sequence_name"));
            column.setAutoIncrementTriggerName(object3.getAttribute("trigger_name"));
            column.setAutoIncrementGenerateTrigger(Boolean.parseBoolean(object3.getAttribute("generate_trigger")));
        }
    }

    protected void recreateFKAssociations(Element element, Table table, Design design) {
        NodeList nodeList = element.getElementsByTagName("foreignkey");
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            Object object;
            Object object2;
            Object object3;
            Object object4;
            Element element2 = (Element)nodeList.item(i);
            String string = element2.getAttribute("tableid");
            String string2 = element2.getAttribute("references");
            String string3 = element2.getAttribute("oid");
            String string4 = element2.getAttribute("localindexid");
            String string5 = element2.getAttribute("delrule");
            String string6 = element2.getAttribute("mandatory");
            String string7 = element2.getAttribute("transferable");
            String string8 = "";
            Element element3 = RXMLTable.getFirstChildByTagName(element2, "comment");
            if (element3 != null && (object4 = element3.getFirstChild()) != null && (object3 = object4.getNodeValue()) != null) {
                string8 = StringUtilities.decodeAttributeValue((String)object3);
            }
            object4 = "";
            object3 = RXMLTable.getFirstChildByTagName(element2, "notes");
            if (object3 != null && (object2 = object3.getFirstChild()) != null && (object = object2.getNodeValue()) != null) {
                object4 = StringUtilities.decodeAttributeValue((String)object);
            }
            object2 = element2.getAttribute("name");
            object = (Table)design.getDesignObject(string);
            if (object != null) {
                Index index = (Index)((ContainerWithKeyObject)object).getKeyObject(string2);
                FKIndexAssociation fKIndexAssociation = table.recreateFK(index, string3, string4, string5, (String)object2, string8, (String)object4);
                if (string6 != null && "true".equalsIgnoreCase(string6)) {
                    fKIndexAssociation.setMandatory(true);
                } else if ("".equals(string6)) {
                    fKIndexAssociation.resetMandatoryUsingColumns();
                } else {
                    fKIndexAssociation.setMandatory(false);
                }
                if (string7 != null && ("true".equalsIgnoreCase(string7) || "".equals(string7))) {
                    fKIndexAssociation.setTransferable(true);
                } else {
                    fKIndexAssociation.setTransferable(false);
                }
                fKIndexAssociation.resetEdgeParams();
                continue;
            }
            table.recreateFK(string, string2, string3, string4, string5, (String)object2, string8, (String)object4, string6, string7);
            this.getPersistenceManager().addTask(new ResolveFKTask(table));
        }
    }

    private void recreateTableLevelConstraints(Element element, Table table) {
        NodeList nodeList = element.getElementsByTagName("tableconstraint");
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            Element element2 = (Element)nodeList.item(i);
            String string = element2.getAttribute("name");
            string = StringUtilities.decodeAttributeValue(string);
            String string2 = StringUtilities.decodeAttributeValue(element2.getAttribute("rule"));
            String string3 = element2.getAttribute("oid");
            TableLevelConstraint tableLevelConstraint = table.createCheckConstraint(string, string2);
            table.addCheckConstraint(tableLevelConstraint);
            if (string3 == null || "".equals(string3)) continue;
            tableLevelConstraint.setID(string3);
        }
    }

    @Override
    public Object recreateDesign(Document document, DesignPart designPart, boolean bl) {
        return null;
    }

    @Override
    public boolean isReaderForClass(Class clazz) {
        return clazz == Table.class;
    }

    @Override
    protected void readKeyObjectInfo(Element element, KeyObject keyObject, boolean bl) {
        if (keyObject instanceof Index) {
            Index index = (Index)keyObject;
            String string = element.getAttribute("id_of_recovered_integrity_index");
            if (string != null && !"".equals(string)) {
                index.setIdOfRecoveredIntegrityIndex(string);
            }
        }
    }

    private void recreateColumnGroups(Element element, Table table) {
        NodeList nodeList = element.getElementsByTagName("column_group");
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            Element element2 = (Element)nodeList.item(i);
            String string = element2.getAttribute(StringUtilities.decodeAttributeValue("name"));
            String string2 = element2.getAttribute("note");
            Table table2 = table;
            table2.getClass();
            Table.ColumnGroup columnGroup = table2.new Table.ColumnGroup(string);
            NodeList nodeList2 = element2.getChildNodes();
            ArrayList<String> arrayList = new ArrayList<String>();
            int n2 = nodeList2.getLength();
            for (int j = 0; j < n2; ++j) {
                Node node = nodeList2.item(j);
                if (!(node instanceof Element)) continue;
                Element element3 = (Element)node;
                arrayList.add(element3.getAttribute("objectid"));
            }
            columnGroup.getColumns().clear();
            columnGroup.getColumns().addAll(arrayList);
            columnGroup.setName(string);
            columnGroup.setNote(string2);
            table.addColumnGroup(columnGroup);
        }
    }

    private class ResolveFKTask
    implements Task {
        Table table;

        ResolveFKTask(Table table) {
            this.table = table;
        }

        @Override
        public boolean execute() {
            this.table.attemptRecreateFK();
            return !this.table.hasPendingFKAssociationRecreations();
        }
    }
}

