/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.persistence.xml;

import java.io.InputStream;
import java.text.MessageFormat;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.datatypes.DataTypesDesign;
import oracle.dbtools.crest.model.design.logical.LogicalDesign;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.persistence.XMLPersistenceManager;
import oracle.dbtools.crest.model.persistence.xml.AbstractXMLReader;
import oracle.dbtools.crest.model.placeholder.DesignPartViewPlaceHolder;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.dbtools.crest.util.string.StringUtilities;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class RXMLSubview
extends AbstractXMLReader {
    private static final Logger LOGGER = new Logger(RXMLSubview.class);

    public RXMLSubview(XMLPersistenceManager xMLPersistenceManager) {
        super(xMLPersistenceManager);
    }

    @Override
    public Object recreateDesign(Document document, DesignPart designPart, boolean bl) {
        return null;
    }

    @Override
    public String getRelativePath() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.getPersistenceManager().getAppView() != null) {
            String string = this.getPersistenceManager().getAppView().getDesignName();
            stringBuffer.append(string).append('/').append("subviews");
        }
        return stringBuffer.toString();
    }

    @Override
    public String getRelativePath(Object object) {
        if (object instanceof DesignPart) {
            DesignPart designPart = (DesignPart)object;
            StringBuffer stringBuffer = new StringBuffer();
            if (this.getPersistenceManager().getAppView() != null) {
                String string = StringUtilities.decodeAttributeValue(this.getPersistenceManager().getAppView().getDesignName());
                String string2 = StringUtilities.decodeAttributeValue(designPart.getObjectID());
                String string3 = "";
                if (designPart instanceof RelationalDesign) {
                    if (this.isOldDesign()) {
                        string3 = "relational";
                    } else {
                        string2 = designPart.getPathIDString();
                        string3 = "rel";
                    }
                } else if (designPart instanceof LogicalDesign) {
                    string3 = "logical";
                } else if (designPart instanceof DataTypesDesign) {
                    string3 = "datatypes";
                }
                stringBuffer.append(string).append('/').append(string3);
                if (designPart instanceof RelationalDesign) {
                    stringBuffer.append('/').append(string2);
                }
                stringBuffer.append('/').append("subviews");
            }
            return stringBuffer.toString();
        }
        return this.getRelativePath();
    }

    public Object recreateObject(Object object, DesignPart designPart, boolean bl) {
        InputStream inputStream = this.getInputStreamFor(designPart, object);
        if (inputStream != null) {
            try {
                Design design = designPart != null ? designPart.getDesign() : null;
                Document document = RXMLSubview.parse(inputStream, this.getFilename(object), design);
                return this.recreateObject(document, designPart, bl);
            }
            catch (Throwable throwable) {
                Design.openFailed();
                LOGGER.error("RXMLSubview - Error recreating object from XML: " + object + " \n" + throwable.toString());
                return null;
            }
        }
        return null;
    }

    public InputStream getInputStreamFor(DesignPart designPart, Object object) {
        String string = this.getRelativePath(designPart);
        InputStream inputStream = this.getPersistenceManager().getInputStreamFor(string, this.getFilename(object));
        if (inputStream == null) {
            LOGGER.error("Data inputstream is null (path: " + string + " name: " + this.getFilename(object) + ")");
        }
        return inputStream;
    }

    public Object recreateObject(Document document, DesignPart designPart, boolean bl) {
        try {
            Element element = document.getDocumentElement();
            return this.recreateObject(element, designPart, bl);
        }
        catch (NullPointerException nullPointerException) {
            return null;
        }
    }

    public Object recreateObject(Element element, DesignPart designPart, boolean bl) {
        DesignPartViewPlaceHolder designPartViewPlaceHolder;
        String string;
        DesignPartView designPartView;
        Element element2 = RXMLSubview.getFirstChildByTagName(element, "sub_view");
        String string2 = element2.getAttribute("subview_name");
        String string3 = element2.getAttribute("id");
        String string4 = element2.getAttribute("generator");
        String string5 = element2.getAttribute("sv_type");
        if ("main_view".equalsIgnoreCase(string5)) {
            designPartView = designPart.getMainView();
            designPart.getMainDPVPlaceHolder().setDesignPartView(designPartView);
        } else {
            designPartView = designPart.createDesignPartSubView();
        }
        designPartView.setName(StringUtilities.decodeAttributeValue(string2));
        this.readDisplayProperties(element2, designPartView);
        designPartView.setVisible(false);
        String string6 = element2.getAttribute("visible");
        if (string3 != null && !"".equalsIgnoreCase(string3) && !"null".equalsIgnoreCase(string3)) {
            designPartView.setDPVId(string3);
        }
        if (string4 != null && !"".equalsIgnoreCase(string4) && !"null".equalsIgnoreCase(string4)) {
            designPartView.setGeneratorId(string4);
        }
        if (!"".equalsIgnoreCase(string = element2.getAttribute("rep_oid")) && !"null".equalsIgnoreCase(string)) {
            designPartView.setRepositoryOID(string);
        }
        if (!"".equalsIgnoreCase(string = element2.getAttribute("rep_ovid")) && !"null".equalsIgnoreCase(string)) {
            designPartView.setRepositoryOVID(string);
        }
        if (!"".equalsIgnoreCase(string = element2.getAttribute("is_checkedout"))) {
            designPartView.setCheckedOut(Boolean.valueOf(string));
        }
        string = element2.getAttribute("checkedout_by");
        designPartView.setCheckedOutBy(string);
        this.readMainDisplay(element2, designPartView);
        int n = designPartView.getTabbedPane().indexOfComponent(designPartView);
        if (n < 0) {
            designPartView.getTabbedPane().setName(designPartView.getName());
            designPartView.getTabbedPane().add(designPartView);
        }
        this.readSubordinateDisplays(element2, designPartView);
        designPartView.setMustBeVisible(string6.equalsIgnoreCase("true"));
        String string7 = element2.getAttribute("comment");
        ((DesignPartViewPlaceHolder)designPartView.getPlaceHolder()).setComment(StringUtilities.decodeAttributeValue(string7));
        String string8 = element2.getAttribute("notes");
        ((DesignPartViewPlaceHolder)designPartView.getPlaceHolder()).setNotes(StringUtilities.decodeAttributeValue(string8));
        designPartView.getTabbedPane().setSelectedComponent(designPartView);
        designPartView.getWorkSpace().updateSettings();
        if (designPartView.isMasterDPV() && (designPartViewPlaceHolder = (DesignPartViewPlaceHolder)designPartView.getPlaceHolder()) != null) {
            StringBuffer stringBuffer = new StringBuffer();
            if (this.getPersistenceManager().getAppView() != null) {
                stringBuffer.append(this.getPersistenceManager().getAppView().getCurrentDesign().getDesignPath()).append('/');
            }
            stringBuffer.append(this.getRelativePath(designPart)).append('/').append(designPartView.getDPVId()).append(".dmd");
            designPartViewPlaceHolder.setFilePath(stringBuffer.toString());
        }
        return designPartView;
    }

    @Override
    public Object recreateObject(Document document, Design design, boolean bl) {
        return null;
    }

    public void readExtSubViews(Element element, DesignPart designPart) {
        ApplicationView.log(MessageFormat.format(Messages.getString("RXMLSubview.ReadSubViewsFor"), designPart.getName()));
        Element element2 = RXMLSubview.getFirstChildByTagName(element, "ext_sub_views_collection");
        if (element2 != null) {
            NodeList nodeList = element2.getElementsByTagName("sub_view");
            int n = nodeList.getLength();
            for (int i = 0; i < n; ++i) {
                String string;
                Object object;
                Element element3 = (Element)nodeList.item(i);
                if (element3.getParentNode() != element2 || !((object = this.recreateObject((Object)(string = element3.getAttribute("id")), designPart, false)) instanceof DesignPartView)) continue;
                DesignPartView designPartView = (DesignPartView)object;
                designPartView.setVisible(false);
                String string2 = element3.getAttribute("visible");
                designPartView.setMustBeVisible(string2.equalsIgnoreCase("true"));
                designPartView.setDirty(false);
            }
        }
    }
}

