/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.persistence.xml;

import java.awt.Color;
import java.awt.Rectangle;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.MultiShapedDesignObject;
import oracle.dbtools.crest.model.TypeSubstitution;
import oracle.dbtools.crest.model.businessinfo.BIDocument;
import oracle.dbtools.crest.model.businessinfo.BIResponsibleParty;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.DiagramView;
import oracle.dbtools.crest.model.design.Label;
import oracle.dbtools.crest.model.design.Note;
import oracle.dbtools.crest.model.design.relational.FKArc;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.relational.TableSet;
import oracle.dbtools.crest.model.design.relational.TableView;
import oracle.dbtools.crest.model.design.relational.TableViewSet;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.persistence.XMLPersistenceManager;
import oracle.dbtools.crest.model.persistence.xml.AbstractXMLReader;
import oracle.dbtools.crest.model.persistence.xml.RXMLSubview;
import oracle.dbtools.crest.model.placeholder.DesignPartViewPlaceHolder;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.ContainerView;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.TVConnector;
import oracle.dbtools.crest.swingui.TVDiagramView;
import oracle.dbtools.crest.swingui.TVNote;
import oracle.dbtools.crest.swingui.TVTypeSubstitution;
import oracle.dbtools.crest.swingui.TopView;
import oracle.dbtools.crest.swingui.diagram.graph.DiagramConstants;
import oracle.dbtools.crest.swingui.relational.DPVRelationalSubView;
import oracle.dbtools.crest.swingui.relational.TVFKRelation;
import oracle.dbtools.crest.swingui.relational.TVTable;
import oracle.dbtools.crest.swingui.relational.TVView;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.dbtools.crest.util.string.StringUtilities;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class RXMLRelationalDesign
extends AbstractXMLReader {
    private static Logger LOGGER;
    private boolean xmlFromDB = false;
    private static float NFS;
    private float loadedVersion = NFS;

    public RXMLRelationalDesign(XMLPersistenceManager xMLPersistenceManager) {
        super(xMLPersistenceManager);
    }

    @Override
    public Object recreateDesign(Document document, DesignPart designPart, boolean bl) {
        int n;
        Object object;
        Object object2;
        Object[] objectArray;
        this.loadedVersion = designPart.getDesign().getLoadedVersion();
        this.xmlFromDB = this.getPersistenceManager().isXML_FromDataBase();
        Element element = document.getDocumentElement();
        String string = element.getAttribute("id");
        if (!"".equalsIgnoreCase(string)) {
            designPart.setObjectID(StringUtilities.decodeAttributeValue(string));
        }
        String string2 = element.getAttribute("defaultRDBMSSite");
        RDBMSSite rDBMSSite = designPart.getDesign().getRDBMSSiteSet().getByObjectID(string2);
        if (rDBMSSite != null) {
            designPart.getDesign().setSelectedRDBMSSite(rDBMSSite);
        }
        DesignPartView designPartView = null;
        if (this.loadedVersion < NFS) {
            designPartView = designPart.getMainView();
            this.readDisplayProperties(element, designPartView);
            designPartView.getWorkSpace().updateSettings();
            int n2 = designPartView.getTabbedPane().indexOfComponent(designPartView);
            if (n2 < 0) {
                designPartView.getTabbedPane().setName(designPartView.getName());
                designPartView.getTabbedPane().add(designPartView);
            }
        }
        NodeList nodeList = RXMLRelationalDesign.getFirstChildByTagName(element, "ref").getElementsByTagName("objectid");
        int n3 = nodeList.getLength();
        for (int i = 0; i < n3; ++i) {
            objectArray = (Object[])nodeList.item(i);
            String string3 = objectArray.getAttribute("role");
            object2 = objectArray.getAttribute("oid");
            object = objectArray.getAttribute("marked_generate");
            boolean bl2 = "contains".equalsIgnoreCase(string3) && bl;
            DesignObject designObject = null;
            designObject = !this.xmlFromDB ? (DesignObject)this.getPersistenceManager().read(object2, designPart.getDesign(), bl2) : designPart.getDesign().getDesignObject((String)object2);
            if (designObject != null) {
                if (object != null) {
                    if ("true".equalsIgnoreCase((String)object) || "".equalsIgnoreCase((String)object)) {
                        designObject.setMarkedGenerate(true);
                    } else {
                        designObject.setMarkedGenerate(false);
                    }
                } else {
                    designObject.setMarkedGenerate(true);
                }
                designObject.setTemporaryWriteable(true);
                if (!designObject.belongsToDesign(designPart.getDesign())) {
                    designObject.setReadOnly(true);
                }
                if (this.loadedVersion < NFS) {
                    this.readGraphicalInfo((Element)objectArray, designObject);
                }
                designObject.setTemporaryWriteable(false);
                continue;
            }
            LOGGER.error("Read object returns null - " + (String)object2);
        }
        Map map = this.getProperties(element, "documents");
        objectArray = map.keySet().toArray();
        for (n = 0; n < objectArray.length; ++n) {
            object2 = (String)map.get(objectArray[n]);
            object = designPart.getDesign().getDesignObject((String)object2);
            if (object == null) continue;
            designPart.addDocument((BIDocument)object);
        }
        map = this.getProperties(element, "parties");
        objectArray = map.keySet().toArray();
        for (n = 0; n < objectArray.length; ++n) {
            object2 = (String)map.get(objectArray[n]);
            object = designPart.getDesign().getDesignObject((String)object2);
            if (object == null) continue;
            designPart.addResponsibleParty((BIResponsibleParty)object);
        }
        this.reconnectColumnPlaceholders((RelationalDesign)designPart);
        this.getPersistenceManager().runTasks();
        if (this.loadedVersion < NFS) {
            this.readViewSynonyms(element, (RelationalDesign)designPart);
            this.readFKtoSynonyms(element, (RelationalDesign)designPart);
        }
        this.readTypeSubstitutions(element, (RelationalDesign)designPart);
        if (!this.xmlFromDB && !(this.loadedVersion < NFS)) {
            RXMLSubview rXMLSubview = this.getPersistenceManager().getDesignPartViewReader();
            rXMLSubview.readExtSubViews(element, designPart);
        }
        if (this.loadedVersion < NFS) {
            this.readSubordinateDisplays(element, designPartView);
            designPartView.getTabbedPane().setSelectedComponent(designPartView);
            this.readSubordinateDisplays(element, designPart.getMainView());
            this.readPhysicalSubViews(element, (RelationalDesign)designPart);
            this.readDiagramViews(element, designPart);
        }
        this.readIndAndFKeysMarkGenerate(element, (RelationalDesign)designPart);
        this.readNamingOptions(element, designPart);
        ((RelationalDesign)designPart).showFkeysInSubviews();
        Iterator iterator = ((RelationalDesign)designPart).getFKIndexAssociationSet().iterator();
        while (iterator.hasNext()) {
            object2 = (FKIndexAssociation)iterator.next();
            ((FKIndexAssociation)object2).resetEdgeParams();
        }
        designPart.setLoaded(true);
        designPart.getAppView().getXMLTransformationManager().loadExistingPhysicalModels((RelationalDesign)designPart);
        return designPart;
    }

    @Override
    protected Map getProperties(Element element, String string) {
        TreeMap<String, String> treeMap = new TreeMap<String, String>();
        Element element2 = RXMLRelationalDesign.getFirstChildByTagName(element, string);
        if (element2 != null) {
            NodeList nodeList = element2.getElementsByTagName("parameter");
            int n = nodeList.getLength();
            for (int i = 0; i < n; ++i) {
                Element element3 = (Element)nodeList.item(i);
                treeMap.put(element3.getAttribute("name"), element3.getAttribute("value"));
            }
        }
        return treeMap;
    }

    private void readPhysicalSubViews(Element element, RelationalDesign relationalDesign) {
        ApplicationView.log(Messages.getString("RXMLRelationalDesign.ReadPhysicalSubViews"));
        if (relationalDesign.getAppView() != null) {
            TableSet tableSet = relationalDesign.getTableSet();
            TableViewSet tableViewSet = relationalDesign.getTableViewSet();
            Element element2 = RXMLRelationalDesign.getFirstChildByTagName(element, "physical_sub_views_collection");
            if (element2 != null) {
                NodeList nodeList = element2.getElementsByTagName("physical_sub_view");
                int n = nodeList.getLength();
                for (int i = 0; i < n; ++i) {
                    Object object;
                    Object object2;
                    String string;
                    Object object3;
                    Object object4;
                    String string2;
                    Object object5;
                    String string3;
                    Element element3 = (Element)nodeList.item(i);
                    String string4 = element3.getAttribute("subview_name");
                    String string5 = element3.getAttribute("id");
                    String string6 = element3.getAttribute("generator");
                    DesignPartView designPartView = relationalDesign.createDesignPartSubView();
                    this.readDisplayProperties(element3, designPartView);
                    designPartView.setName(StringUtilities.decodeAttributeValue(string4));
                    designPartView.setVisible(false);
                    if (string5 != null && !"".equalsIgnoreCase(string5) && !"null".equalsIgnoreCase(string5)) {
                        designPartView.setDPVId(string5);
                    }
                    if (string6 != null && !"".equalsIgnoreCase(string6) && !"null".equalsIgnoreCase(string6)) {
                        designPartView.setGeneratorId(string6);
                    }
                    String string7 = element3.getAttribute("visible");
                    NodeList nodeList2 = element3.getElementsByTagName("objectid");
                    int n2 = nodeList2.getLength();
                    for (int j = 0; j < n2; ++j) {
                        String string8;
                        String string9;
                        Object object6;
                        int n3;
                        Object object7;
                        int n4;
                        Element element4 = (Element)nodeList2.item(j);
                        if (element4.getParentNode() != element3) continue;
                        string3 = element4.getAttribute("type");
                        object5 = element4.getAttribute("oid");
                        string2 = element4.getAttribute("tv_generator_id");
                        if (string3.equalsIgnoreCase("Table")) {
                            object4 = (Table)tableSet.getObjectByID((String)object5);
                            object3 = (TVTable)((TVTable)((MultiShapedDesignObject)object4).getTopView()).createViewSynonim(designPartView);
                            string = element4.getAttribute("viewid");
                            ((TopView)object3).setViewID(string);
                            if (string2 != null && !"".equalsIgnoreCase(string2) && !"null".equalsIgnoreCase(string2)) {
                                ((TopView)object3).setGeneratorID(string2);
                            }
                            this.readGraphicalInfo(element4, (TopView)object3);
                        }
                        if (string3.equalsIgnoreCase("VIEW")) {
                            object4 = (TableView)tableViewSet.getObjectByID((String)object5);
                            object3 = (TVView)((TVView)((MultiShapedDesignObject)object4).getTopView()).createViewSynonim(designPartView);
                            string = element4.getAttribute("viewid");
                            ((TopView)object3).setViewID(string);
                            if (string2 != null && !"".equalsIgnoreCase(string2) && !"null".equalsIgnoreCase(string2)) {
                                ((TopView)object3).setGeneratorID(string2);
                            }
                            this.readGraphicalInfo(element4, (TopView)object3);
                        }
                        if (string3.equalsIgnoreCase("FKArc") && (object4 = (FKArc)relationalDesign.getDesign().getDesignObject((String)object5)) != null) {
                            object3 = designPartView.createTopViewFor((DesignObject)object4);
                            string = element4.getAttribute("viewid");
                            object2 = element4.getAttribute("tv_generator_id");
                            ((TopView)object3).setViewID(string);
                            if (object2 != null && !"".equalsIgnoreCase((String)object2) && !"null".equalsIgnoreCase((String)object2)) {
                                ((TopView)object3).setGeneratorID((String)object2);
                            }
                            this.readGraphicalInfo(element4, (TopView)object3);
                        }
                        if (string3.equalsIgnoreCase("Note")) {
                            object4 = (Note)this.getPersistenceManager().read(object5, relationalDesign.getDesign(), true);
                            object3 = (TVNote)((TVNote)((MultiShapedDesignObject)object4).getTopView()).createViewSynonim(designPartView);
                            ((TVNote)((MultiShapedDesignObject)object4).getTopView()).remove(false);
                            string = element4.getAttribute("viewid");
                            ((TopView)object3).setViewID(string);
                            this.readGraphicalInfo(element4, (TopView)object3);
                        }
                        if (string3.equalsIgnoreCase("FKIndexAssociation") && (object4 = (FKIndexAssociation)relationalDesign.getFKIndexAssociationSet().getObjectByID((String)object5)) != null) {
                            object3 = element4.getAttribute("viewid_source");
                            string = element4.getAttribute("viewid_target");
                            if (!((String)object3).equals("null")) {
                                ((FKIndexAssociation)object4).setSourceTVTable((TVTable)((FKIndexAssociation)object4).getRemoteTable().getTopViewByID(designPartView, (String)object3));
                            }
                            if (!string.equals("null")) {
                                ((FKIndexAssociation)object4).setTargetTVTable((TVTable)((FKIndexAssociation)object4).getContainerWithKeyObject().getTopViewByID(designPartView, string));
                            }
                            if ((object2 = RXMLRelationalDesign.getFirstChildByTagName(element4, "points")) != null) {
                                object = object2.getElementsByTagName("point");
                                n4 = object.getLength();
                                object7 = (TVFKRelation)((FKIndexAssociation)object4).getViewFor(designPartView);
                                for (n3 = 0; n3 < n4; ++n3) {
                                    object6 = (Element)object.item(n3);
                                    string9 = object6.getAttribute("x_coordinate");
                                    string8 = object6.getAttribute("y_coordinate");
                                    ((TVConnector)object7).getEdgePoints().add(DiagramConstants.createPoint(Double.parseDouble(string9), Double.parseDouble(string8)));
                                }
                            }
                            if ((object = RXMLRelationalDesign.getFirstChildByTagName(element4, "labels")) != null) {
                                TVFKRelation tVFKRelation = (TVFKRelation)((FKIndexAssociation)object4).getViewFor(designPartView);
                                object7 = RXMLRelationalDesign.getFirstChildByTagName((Element)object, "main_label");
                                if (object7 != null) {
                                    String string10 = object7.getAttribute("x_coordinate");
                                    object6 = object7.getAttribute("y_coordinate");
                                    string9 = object7.getAttribute("width");
                                    string8 = object7.getAttribute("height");
                                    if (string10 != null && !"".equals(string10)) {
                                        if (string9 == null || "".equalsIgnoreCase(string9)) {
                                            string9 = "-1";
                                        }
                                        if (string8 == null || "".equalsIgnoreCase(string8)) {
                                            string8 = "-1";
                                        }
                                        tVFKRelation.setLabelBounds(new Rectangle((int)Double.parseDouble(string10), (int)Double.parseDouble((String)object6), (int)Double.parseDouble(string9), (int)Double.parseDouble(string8)));
                                        Label label = tVFKRelation.getTempCenterLabel();
                                        if (label != null) {
                                            this.readColorInfo((Element)object7, label);
                                            this.readFontsInfo((Element)object7, label);
                                        }
                                    }
                                }
                            }
                        }
                        if (!string3.equalsIgnoreCase("TypeSubstitution")) continue;
                        object4 = (TypeSubstitution)relationalDesign.getTypeSubstitutionSet().getObjectByID((String)object5);
                        object3 = element4.getAttribute("view_id_child");
                        string = element4.getAttribute("view_id_parent");
                        if (!((String)object3).equals("null")) {
                            ((TypeSubstitution)object4).setChildCV((ContainerView)((TypeSubstitution)object4).getChildContainerObject().getTopViewByID(designPartView, (String)object3));
                        }
                        if (!string.equals("null")) {
                            ((TypeSubstitution)object4).setParentCV((ContainerView)((TypeSubstitution)object4).getParentContainerObject().getTopViewByID(designPartView, string));
                        }
                        if ((object2 = RXMLRelationalDesign.getFirstChildByTagName(element4, "points")) == null) continue;
                        object = object2.getElementsByTagName("point");
                        n4 = object.getLength();
                        object7 = (TVTypeSubstitution)((TypeSubstitution)object4).getViewFor(designPartView);
                        for (n3 = 0; n3 < n4; ++n3) {
                            object6 = (Element)object.item(n3);
                            string9 = object6.getAttribute("x_coordinate");
                            string8 = object6.getAttribute("y_coordinate");
                            ((TVConnector)object7).getEdgePoints().add(DiagramConstants.createPoint(Double.parseDouble(string9), Double.parseDouble(string8)));
                        }
                    }
                    NodeList nodeList3 = element3.getElementsByTagName("diagram_view");
                    int n5 = nodeList3.getLength();
                    for (int j = 0; j < n5; ++j) {
                        object5 = (Element)nodeList3.item(j);
                        string2 = object5.getAttribute("objectid");
                        object4 = object5.getAttribute("dpv_id");
                        object3 = object5.getAttribute("dpv_name");
                        string = object5.getAttribute("composite");
                        object2 = relationalDesign.recreateDiagramView(string2);
                        ((DiagramView)object2).setDpvID((String)object4);
                        ((DiagramView)object2).setDpvName((String)object3);
                        ((DiagramView)object2).setCompositeView(Boolean.valueOf(string));
                        relationalDesign.getDesign().addDiagramView((DiagramView)object2);
                        object = (TVDiagramView)designPartView.createTopViewFor((DesignObject)object2);
                        relationalDesign.getMainView().removeViewFor((DesignObject)object2);
                        TopView topView = ((MultiShapedDesignObject)object2).getFirstViewForDPV(relationalDesign.getMainView());
                        if (topView != null) {
                            ((MultiShapedDesignObject)object2).removeTopView(topView, true);
                        }
                        this.readGraphicalInfo((Element)object5, (TopView)object);
                    }
                    designPartView.setMustBeVisible(string7.equalsIgnoreCase("true"));
                    string3 = element3.getAttribute("comment");
                    ((DesignPartViewPlaceHolder)((DPVRelationalSubView)designPartView).getPlaceHolder()).setComment(StringUtilities.decodeAttributeValue(string3));
                    object5 = element3.getAttribute("notes");
                    ((DesignPartViewPlaceHolder)designPartView.getPlaceHolder()).setNotes(StringUtilities.decodeAttributeValue((String)object5));
                    designPartView.getTabbedPane().setName(designPartView.getName());
                    designPartView.getWorkSpace().updateSettings();
                    this.readSubordinateDisplays(element3, designPartView);
                    designPartView.getTabbedPane().setSelectedComponent(designPartView);
                }
            }
        }
    }

    private void readFKtoSynonyms(Element element, RelationalDesign relationalDesign) {
        ApplicationView.log(Messages.getString("RXMLRelationalDesign.ReadForeignKeysToSynonyms"));
        if (relationalDesign.getAppView() != null) {
            DesignPartView designPartView = relationalDesign.getMainView();
            Element element2 = RXMLRelationalDesign.getFirstChildByTagName(element, "view_fkeys");
            if (element2 != null) {
                NodeList nodeList = element2.getElementsByTagName("objectid");
                int n = nodeList.getLength();
                for (int i = 0; i < n; ++i) {
                    Object object;
                    Object object2;
                    String string;
                    Object object3;
                    Object object4;
                    Element element3;
                    Object object5;
                    Element element4 = (Element)nodeList.item(i);
                    String string2 = element4.getAttribute("oid");
                    FKIndexAssociation fKIndexAssociation = (FKIndexAssociation)relationalDesign.getFKIndexAssociationSet().getObjectByID(string2);
                    if (fKIndexAssociation == null) continue;
                    String string3 = element4.getAttribute("viewid_source");
                    String string4 = element4.getAttribute("viewid_target");
                    if (!string3.equals("null") && (object5 = (TVTable)fKIndexAssociation.getRemoteTable().getTopViewByID(designPartView, string3)) != null) {
                        fKIndexAssociation.setSourceTVTable((TVTable)object5);
                    }
                    if (!string4.equals("null") && (object5 = (TVTable)fKIndexAssociation.getContainerWithKeyObject().getTopViewByID(designPartView, string4)) != null) {
                        fKIndexAssociation.setTargetTVTable((TVTable)object5);
                    }
                    object5 = RXMLRelationalDesign.getFirstChildByTagName(element4, "points");
                    NodeList nodeList2 = object5.getElementsByTagName("point");
                    int n2 = nodeList2.getLength();
                    TVFKRelation tVFKRelation = (TVFKRelation)fKIndexAssociation.getTopView();
                    for (int j = 0; j < n2; ++j) {
                        element3 = (Element)nodeList2.item(j);
                        object4 = element3.getAttribute("x_coordinate");
                        object3 = element3.getAttribute("y_coordinate");
                        tVFKRelation.getEdgePoints().add(DiagramConstants.createPoint(Double.parseDouble((String)object4), Double.parseDouble((String)object3)));
                    }
                    Element element5 = RXMLRelationalDesign.getFirstChildByTagName(element4, "labels");
                    if (element5 != null && (element3 = RXMLRelationalDesign.getFirstChildByTagName(element5, "main_label")) != null) {
                        object4 = element3.getAttribute("x_coordinate");
                        object3 = element3.getAttribute("y_coordinate");
                        String string5 = element3.getAttribute("width");
                        string = element3.getAttribute("height");
                        if (object4 != null && !"".equals(object4)) {
                            if (string5 == null || "".equalsIgnoreCase(string5)) {
                                string5 = "-1";
                            }
                            if (string == null || "".equalsIgnoreCase(string)) {
                                string = "-1";
                            }
                            tVFKRelation.setLabelBounds(new Rectangle((int)Double.parseDouble((String)object4), (int)Double.parseDouble((String)object3), (int)Double.parseDouble(string5), (int)Double.parseDouble(string)));
                            object2 = tVFKRelation.getTempCenterLabel();
                            if (object2 != null) {
                                this.readColorInfo(element3, (DesignObject)object2);
                                this.readFontsInfo(element3, (DesignObject)object2);
                            }
                        }
                    }
                    if ((element3 = RXMLRelationalDesign.getFirstChildByTagName(element4, "graphical")) == null) continue;
                    object4 = element3.getElementsByTagName("parameter");
                    object3 = new HashMap();
                    int n3 = object4.getLength();
                    for (int j = 0; j < n3; ++j) {
                        object2 = (Element)object4.item(j);
                        object3.put(object2.getAttribute("name"), object2.getAttribute("value"));
                    }
                    string = (String)object3.get("use_default_color");
                    boolean bl = true;
                    if (string != null) {
                        bl = Boolean.valueOf(string);
                    }
                    tVFKRelation.setUseDefaultColor(bl);
                    if (bl) continue;
                    String string6 = (String)object3.get("color");
                    if (string6 != null && !"null".equalsIgnoreCase(string6)) {
                        object = new Color(Integer.parseInt(string6));
                        tVFKRelation.setBackgroundColor((Color)object);
                    }
                    if ((object = (String)object3.get("width")) == null || "null".equalsIgnoreCase((String)object)) continue;
                    int n4 = Integer.parseInt((String)object);
                    tVFKRelation.setLineWidth(n4);
                }
            }
        }
    }

    private void readIndAndFKeysMarkGenerate(Element element, RelationalDesign relationalDesign) {
        Element element2;
        ApplicationView.log(Messages.getString("RXMLRelationalDesign.ReadMarkgenerateForIndexesAndFKeys"));
        if (relationalDesign.getAppView() != null && (element2 = RXMLRelationalDesign.getFirstChildByTagName(element, "marked_generate_for_indexes")) != null) {
            NodeList nodeList = element2.getElementsByTagName("objectid");
            int n = nodeList.getLength();
            for (int i = 0; i < n; ++i) {
                Element element3 = (Element)nodeList.item(i);
                String string = element3.getAttribute("oid");
                Index index = (Index)relationalDesign.getGlobalIndexSet().getObjectByID(string);
                String string2 = element3.getAttribute("marked_generate");
                if (index == null || string2 == null) continue;
                if ("true".equalsIgnoreCase(string2)) {
                    index.setMarkedGenerate(true);
                    continue;
                }
                index.setMarkedGenerate(false);
            }
        }
    }

    private void readTypeSubstitutions(Element element, RelationalDesign relationalDesign) {
        ApplicationView.log(Messages.getString("RXMLRelationalDesign.ReadTypeSubstitutions"));
        if (relationalDesign.getAppView() != null) {
            DesignPartView designPartView = relationalDesign.getMainView();
            Element element2 = RXMLRelationalDesign.getFirstChildByTagName(element, "type_substitutions");
            if (element2 != null) {
                NodeList nodeList = element2.getElementsByTagName("objectid");
                int n = nodeList.getLength();
                for (int i = 0; i < n; ++i) {
                    Object object;
                    Object object2;
                    Object object3;
                    Element element3 = (Element)nodeList.item(i);
                    String string = element3.getAttribute("oid");
                    String string2 = element3.getAttribute("child_id");
                    ContainerObject containerObject = null;
                    ContainerObject containerObject2 = null;
                    if (string2 == null) {
                        string2 = "null";
                    } else {
                        containerObject2 = (ContainerObject)relationalDesign.getDesign().getDesignObject(string2);
                    }
                    String string3 = element3.getAttribute("parent_id");
                    if (string3 == null) {
                        string3 = "null";
                    } else {
                        containerObject = (ContainerObject)relationalDesign.getDesign().getDesignObject(string3);
                    }
                    if (containerObject == null || containerObject2 == null) continue;
                    TypeSubstitution typeSubstitution = (TypeSubstitution)relationalDesign.getDesign().getDesignObject(string);
                    if (typeSubstitution == null) {
                        typeSubstitution = relationalDesign.createTypeSubstitution(string);
                    }
                    String string4 = element3.getAttribute("view_id_child");
                    String string5 = element3.getAttribute("view_id_parent");
                    if (!string4.equals("null")) {
                        typeSubstitution.setChildCV((ContainerView)containerObject2.getTopViewByID(designPartView, string4));
                    }
                    if (!string5.equals("null")) {
                        typeSubstitution.setParentCV((ContainerView)containerObject.getTopViewByID(designPartView, string5));
                    }
                    if (!(this.loadedVersion < NFS)) continue;
                    Element element4 = RXMLRelationalDesign.getFirstChildByTagName(element3, "points");
                    NodeList nodeList2 = element4.getElementsByTagName("point");
                    int n2 = nodeList2.getLength();
                    TVTypeSubstitution tVTypeSubstitution = (TVTypeSubstitution)typeSubstitution.getTopView();
                    for (int j = 0; j < n2; ++j) {
                        object3 = (Element)nodeList2.item(j);
                        object2 = object3.getAttribute("x_coordinate");
                        String string6 = object3.getAttribute("y_coordinate");
                        tVTypeSubstitution.getEdgePoints().add(DiagramConstants.createPoint(Double.parseDouble((String)object2), Double.parseDouble(string6)));
                    }
                    Element element5 = RXMLRelationalDesign.getFirstChildByTagName(element3, "graphical");
                    if (element5 == null) continue;
                    object3 = element5.getElementsByTagName("parameter");
                    object2 = new HashMap();
                    int n3 = object3.getLength();
                    for (int j = 0; j < n3; ++j) {
                        Element element6 = (Element)object3.item(j);
                        object2.put(element6.getAttribute("name"), element6.getAttribute("value"));
                    }
                    String string7 = (String)object2.get("use_default_color");
                    boolean bl = true;
                    if (string7 != null) {
                        bl = Boolean.valueOf(string7);
                    }
                    tVTypeSubstitution.setUseDefaultColor(bl);
                    if (bl) continue;
                    String string8 = (String)object2.get("color");
                    if (string8 != null && !"null".equalsIgnoreCase(string8)) {
                        object = new Color(Integer.parseInt(string8));
                        tVTypeSubstitution.setBackgroundColor((Color)object);
                    }
                    if ((object = (String)object2.get("width")) == null || "null".equalsIgnoreCase((String)object)) continue;
                    int n4 = Integer.parseInt((String)object);
                    tVTypeSubstitution.setLineWidth(n4);
                }
            }
        }
    }

    private void readViewSynonyms(Element element, RelationalDesign relationalDesign) {
        ApplicationView.log(Messages.getString("RXMLRelationalDesign.ReadViewsSynonyms"));
        if (relationalDesign.getAppView() != null) {
            DesignPartView designPartView = relationalDesign.getMainView();
            Element element2 = RXMLRelationalDesign.getFirstChildByTagName(element, "view_synonyms");
            if (element2 != null) {
                NodeList nodeList = element2.getElementsByTagName("objectid");
                int n = nodeList.getLength();
                for (int i = 0; i < n; ++i) {
                    ContainerView containerView;
                    DesignObject designObject;
                    Element element3 = (Element)nodeList.item(i);
                    String string = element3.getAttribute("oid");
                    String string2 = element3.getAttribute("viewid");
                    String string3 = element3.getAttribute("tv_generator_id");
                    String string4 = element3.getAttribute("type");
                    if (string4.equalsIgnoreCase("Table")) {
                        designObject = relationalDesign.getTableSet().getObjectByID(string);
                        containerView = (TVTable)designObject.getTopView().createViewSynonim(designPartView);
                        containerView.setViewID(string2);
                        if (string3 != null && !"".equalsIgnoreCase(string3) && !"null".equalsIgnoreCase(string3)) {
                            containerView.setGeneratorID(string3);
                        }
                        this.readGraphicalInfo(element3, containerView);
                    }
                    if (!string4.equalsIgnoreCase("VIEW")) continue;
                    designObject = relationalDesign.getTableViewSet().getObjectByID(string);
                    containerView = (TVView)designObject.getTopView().createViewSynonim(designPartView);
                    containerView.setViewID(string2);
                    if (string3 != null && !"".equalsIgnoreCase(string3) && !"null".equalsIgnoreCase(string3)) {
                        containerView.setGeneratorID(string3);
                    }
                    this.readGraphicalInfo(element3, containerView);
                }
            }
        }
    }

    public void readGraphicalInfo(Element element, TopView topView) {
        DesignObject designObject = topView.getModel();
        ApplicationView applicationView = designObject.getDesign().getAppView();
        if (applicationView != null) {
            NodeList nodeList = element.getElementsByTagName("graphical");
            HashMap<String, String> hashMap = null;
            int n = nodeList.getLength();
            for (int i = 0; i < n; ++i) {
                Element element2 = (Element)nodeList.item(i);
                hashMap = new HashMap<String, String>();
                NodeList nodeList2 = element2.getElementsByTagName("parameter");
                int n2 = nodeList2.getLength();
                for (int j = 0; j < n2; ++j) {
                    Element element3 = (Element)nodeList2.item(j);
                    hashMap.put(element3.getAttribute("name"), element3.getAttribute("value"));
                }
                applicationView.setGraphicalPropsFor(topView, hashMap);
            }
        }
    }

    private void reconnectColumnPlaceholders(RelationalDesign relationalDesign) {
        Iterator iterator = relationalDesign.getTableSet().iterator();
        while (iterator.hasNext()) {
            Table table = (Table)iterator.next();
            if (table.reconnectFKColumns()) {
                ApplicationView.log(Messages.getString("RXMLRelationalDesign.ReconnectColumnsInTable") + table);
                continue;
            }
            ApplicationView.log(Messages.getString("RXMLRelationalDesign.CanNotReconnectColumnsInTable") + table);
        }
    }

    public void readGraphicalInfo(Element element, DesignObject designObject) {
        if (designObject == null || designObject.getDesign() == null) {
            LOGGER.error("readGraphicalInfo: DesignObject = null or design = null");
            return;
        }
        ApplicationView applicationView = designObject.getDesign().getAppView();
        if (applicationView != null) {
            NodeList nodeList = element.getElementsByTagName("graphical");
            HashMap<String, String> hashMap = null;
            int n = nodeList.getLength();
            for (int i = 0; i < n; ++i) {
                Element element2 = (Element)nodeList.item(i);
                hashMap = new HashMap<String, String>();
                NodeList nodeList2 = element2.getElementsByTagName("parameter");
                int n2 = nodeList2.getLength();
                for (int j = 0; j < n2; ++j) {
                    Element element3 = (Element)nodeList2.item(j);
                    hashMap.put(element3.getAttribute("name"), element3.getAttribute("value"));
                }
                applicationView.setGraphicalPropsFor(designObject, hashMap);
            }
        }
    }

    @Override
    public Object recreateObject(Document document, Design design, boolean bl) {
        return null;
    }

    @Override
    public String getRelativePath() {
        if (this.getPersistenceManager().getAppView() != null) {
            String string = this.getPersistenceManager().getAppView().getDesignName();
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(string).append('/');
            if (this.isOldDesign()) {
                stringBuffer.append("relational");
            } else {
                stringBuffer.append("rel");
            }
            return stringBuffer.toString();
        }
        return "rel";
    }

    static {
        NFS = 2.4f;
        LOGGER = new Logger(RXMLRelationalDesign.class);
    }
}

