/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.persistence.xml;

import oracle.dbtools.crest.model.MDPreferences;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.logical.Entity;
import oracle.dbtools.crest.model.design.logical.InheritanceRelation;
import oracle.dbtools.crest.model.persistence.XMLPersistenceManager;
import oracle.dbtools.crest.model.persistence.xml.AbstractRXMLDesignObject;
import oracle.dbtools.crest.util.string.StringUtilities;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class RXMLInheritanceRelation
extends AbstractRXMLDesignObject {
    public RXMLInheritanceRelation(XMLPersistenceManager xMLPersistenceManager) {
        super(xMLPersistenceManager);
    }

    @Override
    protected DesignObject instantiateDesignObject(String string, Design design, Element element) {
        return design.getLogicalDesign().recreateInheritanceRelation(StringUtilities.decodeAttributeValue(string));
    }

    @Override
    public String getIdStartSequence() {
        return MDPreferences.getDefaultInstance().get("inheritance id prefix");
    }

    @Override
    public Object recreateDesign(Document document, DesignPart designPart, boolean bl) {
        return null;
    }

    @Override
    public String getRelativePath() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.getPersistenceManager().getAppView() != null) {
            String string = this.getPersistenceManager().getAppView().getDesignName();
            stringBuffer.append(string).append('/').append("logical").append('/');
        }
        stringBuffer.append(this.getConfiguration().get("inheritancePath"));
        return stringBuffer.toString();
    }

    @Override
    protected void readObjectInfo(Element element, ModelIDObject modelIDObject, boolean bl) {
        if (modelIDObject instanceof InheritanceRelation) {
            Design design = modelIDObject.getDesign();
            InheritanceRelation inheritanceRelation = (InheritanceRelation)modelIDObject;
            NodeList nodeList = element.getElementsByTagName("inheritance");
            int n = nodeList.getLength();
            Entity entity = null;
            Entity entity2 = null;
            for (int i = 0; i < n; ++i) {
                Element element2 = (Element)nodeList.item(i);
                String string = element2.getAttribute("entity");
                Entity entity3 = (Entity)design.getDesignObject(string);
                if ("source".equals(element2.getAttribute("endpoint"))) {
                    entity = entity3;
                    continue;
                }
                if (!"target".equals(element2.getAttribute("endpoint")) || entity3 == null) continue;
                inheritanceRelation.setTargetEntity(entity3);
                inheritanceRelation.setTargetTV(inheritanceRelation.getTargetTVEntity());
                entity2 = entity3;
            }
            if (entity != null && entity2 != null) {
                entity2.setHierarchicalParent(entity, inheritanceRelation);
            }
        }
    }

    @Override
    public Object recreateObject(Element element, Design design, boolean bl) {
        InheritanceRelation inheritanceRelation = (InheritanceRelation)super.recreateObject(element, design, bl);
        StringBuffer stringBuffer = new StringBuffer();
        if (this.getPersistenceManager().getAppView() != null) {
            stringBuffer.append(this.getPersistenceManager().getAppView().getCurrentDesign().getDesignPath()).append('/');
        }
        stringBuffer.append(this.getRelativePath()).append('/').append(StringUtilities.decodeAttributeValue(inheritanceRelation.getObjectID())).append(".dmd");
        inheritanceRelation.setFilePath(stringBuffer.toString());
        return inheritanceRelation;
    }

    @Override
    public boolean isReaderForClass(Class clazz) {
        return clazz == InheritanceRelation.class;
    }
}

