/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.persistence.xml;

import java.util.Map;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.relational.FKArc;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.persistence.XMLPersistenceManager;
import oracle.dbtools.crest.model.persistence.xml.AbstractRXMLDesignObject;
import oracle.dbtools.crest.util.string.StringUtilities;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class RXMLFKArc
extends AbstractRXMLDesignObject {
    public RXMLFKArc(XMLPersistenceManager xMLPersistenceManager) {
        super(xMLPersistenceManager);
    }

    @Override
    protected DesignObject instantiateDesignObject(String string, Design design, Element element) {
        return design.getRelationalDesign().getArcSet().createArc(StringUtilities.decodeAttributeValue(string));
    }

    @Override
    public Object recreateObject(Element element, Design design, boolean bl) {
        Object object;
        FKArc fKArc = (FKArc)super.recreateObject(element, design, bl);
        String string = element.getAttribute("table");
        if (string != null && !"".equalsIgnoreCase(string) && (object = (Table)design.getDesignObject(string)) != null) {
            ((Table)object).addArc(fKArc);
            Map map = this.getProperties(element, "fkeys");
            Object[] objectArray = map.keySet().toArray();
            for (int i = 0; i < objectArray.length; ++i) {
                Object object2 = objectArray[i];
                String string2 = (String)map.get(object2);
                if (string2 == null) continue;
                fKArc.addFKid(string2);
            }
        }
        if ((object = element.getAttribute("mandatory")) != null && "true".equalsIgnoreCase((String)object)) {
            fKArc.setMandatory(true);
        } else {
            fKArc.setMandatory(false);
        }
        return fKArc;
    }

    @Override
    public Object recreateDesign(Document document, DesignPart designPart, boolean bl) {
        return null;
    }

    @Override
    public String getRelativePath() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.getPersistenceManager().getAppView() != null) {
            String string = this.getPersistenceManager().getAppView().getDesignName();
            stringBuffer.append(string).append('/');
            if (this.isOldDesign()) {
                String string2 = this.getPersistenceManager().getAppView().getCurrentDesign().getRelationalDesign().getObjectID();
                stringBuffer.append("relational").append('/').append(StringUtilities.decodeAttributeValue(string2)).append('/');
            } else {
                String string3 = this.getPersistenceManager().getAppView().getCurrentDesign().getRelationalDesign().getPathIDString();
                stringBuffer.append("rel").append('/').append(string3).append('/');
            }
        }
        stringBuffer.append(this.getConfiguration().get("arcPath"));
        return stringBuffer.toString();
    }

    @Override
    public boolean isReaderForClass(Class clazz) {
        return clazz == FKArc.class;
    }
}

