/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.persistence.xml;

import java.util.HashMap;
import java.util.List;
import java.util.StringTokenizer;
import oracle.dbtools.crest.model.MDPreferences;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.design.AbstractView;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.ContainedObjectWithDomain;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;
import oracle.dbtools.crest.model.design.logical.Attribute;
import oracle.dbtools.crest.model.design.logical.AttributeView;
import oracle.dbtools.crest.model.design.logical.Entity;
import oracle.dbtools.crest.model.design.logical.EntityView;
import oracle.dbtools.crest.model.design.logical.LogicalDesign;
import oracle.dbtools.crest.model.persistence.XMLPersistenceManager;
import oracle.dbtools.crest.model.persistence.xml.AbstractRXMLDesignObject;
import oracle.dbtools.crest.util.string.StringUtilities;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class RXMLEntityView
extends AbstractRXMLDesignObject {
    public RXMLEntityView(XMLPersistenceManager xMLPersistenceManager) {
        super(xMLPersistenceManager);
    }

    @Override
    public String getRelativePath() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.getPersistenceManager().getAppView() != null) {
            String string = this.getPersistenceManager().getAppView().getDesignName();
            stringBuffer.append(string).append('/').append("logical").append('/');
        }
        stringBuffer.append(this.getConfiguration().get("tableViewPath"));
        return stringBuffer.toString();
    }

    @Override
    public String getIdStartSequence() {
        return MDPreferences.getDefaultInstance().get("tableview id prefix");
    }

    @Override
    protected DesignObject instantiateDesignObject(String string, Design design, Element element) {
        return design.getLogicalDesign().getEntityViewSet().createEntityView(StringUtilities.decodeAttributeValue(string));
    }

    @Override
    protected void readObjectInfo(Element element, ModelIDObject modelIDObject, boolean bl) {
        if (modelIDObject instanceof EntityView) {
            String string;
            Object object;
            Object object2;
            Object object3;
            Node node;
            Element element2;
            Object object4;
            String string2;
            EntityView entityView = (EntityView)modelIDObject;
            String string3 = element.getAttribute("viewtype");
            if (string3 != null) {
                entityView.setViewType(string3);
            }
            if ((string2 = element.getAttribute("structuredType")) != null) {
                object4 = (StructuredType)modelIDObject.getDesign().getDataTypesDesign().getStructuredTypeSet().getObjectByID(string2);
                entityView.setBasedOnStructuredType((StructuredType)object4);
            }
            if ((object4 = element.getAttribute("allow_type_substitution")) != null) {
                entityView.setAllowTypeSubstitution(Boolean.valueOf((String)object4));
            }
            if ((element2 = RXMLEntityView.getFirstChildByTagName(element, "userDefined")) != null && (node = element2.getFirstChild()) != null && (object3 = node.getNodeValue()) != null) {
                entityView.setUserDefined(Boolean.valueOf(StringUtilities.decodeAttributeValue((String)object3)));
            }
            if ((node = RXMLEntityView.getFirstChildByTagName(element, "userDefinedSQL")) != null && (object3 = node.getFirstChild()) != null && (object2 = object3.getNodeValue()) != null) {
                entityView.setUserDefinedSQL(StringUtilities.decodeAttributeValue((String)object2));
            }
            if ((object3 = RXMLEntityView.getFirstChildByTagName(element, "where")) != null && (object2 = object3.getFirstChild()) != null && (object = object2.getNodeValue()) != null) {
                entityView.setWhere(StringUtilities.decodeAttributeValue((String)object));
            }
            if ((object2 = RXMLEntityView.getFirstChildByTagName(element, "having")) != null && (object = object2.getFirstChild()) != null && (string = object.getNodeValue()) != null) {
                entityView.setHaving(StringUtilities.decodeAttributeValue(string));
            }
            object = element.getElementsByTagName("container");
            int n = object.getLength();
            for (int i = 0; i < n; ++i) {
                Element element3 = (Element)object.item(i);
                String string4 = element3.getAttribute("alias");
                String string5 = element3.getAttribute("cid");
                if (string5 == null || string4 == null) continue;
                entityView.addToContainers(StringUtilities.decodeAttributeValue(string5), StringUtilities.decodeAttributeValue(string4));
            }
        }
    }

    @Override
    protected void readContainedObjectInfo(Element element, ContainerObject containerObject, ContainedObject containedObject, boolean bl) {
        String string;
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        Object object6;
        Node node;
        Object object7;
        Object object8;
        Object object9;
        AttributeView attributeView = (AttributeView)containedObject;
        String string2 = element.getAttribute("tableid");
        if (string2 != null && (object9 = containerObject.getDesign().getDesignObject(string2)) != null) {
            attributeView.setContainer((ContainerObject)object9);
        }
        object9 = element.getAttribute("reference");
        attributeView.setReference(Boolean.valueOf((String)object9));
        String string3 = element.getAttribute("dttype");
        if (!"".equalsIgnoreCase(string3) && (object8 = (StructuredType)containerObject.getDesign().getDataTypesDesign().getStructuredTypeSet().getObjectByID(string3)) != null) {
            attributeView.setStructuredType((StructuredType)object8);
        }
        if ((object8 = RXMLEntityView.getFirstChildByTagName(element, "scope")) != null && (object7 = object8.getAttribute("objectid")) != null) {
            attributeView.setScopeId((String)object7);
        }
        if ((object7 = RXMLEntityView.getFirstChildByTagName(element, "alias")) != null && (node = object7.getFirstChild()) != null && (object6 = node.getNodeValue()) != null) {
            attributeView.setAlias(StringUtilities.decodeAttributeValue((String)object6));
        }
        if ((node = RXMLEntityView.getFirstChildByTagName(element, "tableAlias")) != null && (object6 = node.getFirstChild()) != null && (object5 = object6.getNodeValue()) != null) {
            attributeView.setTableAlias(StringUtilities.decodeAttributeValue((String)object5));
        }
        if ((object6 = RXMLEntityView.getFirstChildByTagName(element, "refcolumn")) != null && (object5 = object6.getFirstChild()) != null && (object4 = object5.getNodeValue()) != null) {
            object3 = (Attribute)containerObject.getDesign().getDesignObject((String)object4);
            attributeView.setReferencedColumn((ContainedObjectWithDomain)object3);
        }
        if ((object5 = RXMLEntityView.getFirstChildByTagName(element, "table")) != null && (object4 = object5.getFirstChild()) != null && (object3 = object4.getNodeValue()) != null) {
            object2 = (Entity)containerObject.getDesign().getDesignObject((String)object3);
            attributeView.setEntity((Entity)object2);
        }
        if ((object4 = RXMLEntityView.getFirstChildByTagName(element, "view")) != null && (object3 = object4.getFirstChild()) != null && (object2 = object3.getNodeValue()) != null) {
            object = (EntityView)containerObject.getDesign().getDesignObject((String)object2);
            attributeView.setView((AbstractView)object);
        }
        if ((object3 = RXMLEntityView.getFirstChildByTagName(element, "expression")) != null && (object2 = object3.getFirstChild()) != null && (object = object2.getNodeValue()) != null) {
            attributeView.setExpression(StringUtilities.decodeAttributeValue((String)object));
        }
        if ((object2 = RXMLEntityView.getFirstChildByTagName(element, "datatype")) != null && (object = object2.getFirstChild()) != null && (string = object.getNodeValue()) != null) {
            attributeView.setDataType(StringUtilities.decodeAttributeValue(string));
        }
        if (!containerObject.contains(containedObject)) {
            containerObject.add(containedObject);
        }
    }

    @Override
    public Object recreateDesign(Document document, DesignPart designPart, boolean bl) {
        return null;
    }

    @Override
    public Object recreateObject(Element element, Design design, boolean bl) {
        Object object;
        EntityView entityView = (EntityView)super.recreateObject(element, design, bl);
        if (entityView.getGroupBy().length() > 0) {
            object = new StringTokenizer(entityView.getGroupBy(), ",");
            while (((StringTokenizer)object).hasMoreTokens()) {
                String string = ((StringTokenizer)object).nextToken().trim();
                AttributeView attributeView = entityView.getAttributeViewByLongName(string);
                if (attributeView == null) continue;
                entityView.addGroupByList(attributeView);
            }
        }
        object = new StringBuffer();
        if (this.getPersistenceManager().getAppView() != null) {
            ((StringBuffer)object).append(this.getPersistenceManager().getAppView().getCurrentDesign().getDesignPath()).append('/');
        }
        ((StringBuffer)object).append(this.getRelativePath()).append('/').append(StringUtilities.decodeAttributeValue(entityView.getObjectID())).append(".dmd");
        entityView.setFilePath(((StringBuffer)object).toString());
        return entityView;
    }

    @Override
    protected void readGroupBy(Element element, String string, ContainerObject containerObject, List list) {
        EntityView entityView = (EntityView)containerObject;
        Element element2 = RXMLEntityView.getFirstChildByTagName(element, string);
        if (element2 != null) {
            NodeList nodeList = element2.getElementsByTagName("cv_id");
            int n = nodeList.getLength();
            for (int i = 0; i < n; ++i) {
                Element element3 = (Element)nodeList.item(i);
                String string2 = element3.getAttribute("value");
                AttributeView attributeView = entityView.getAttributeByObjectID(string2);
                if (list.contains(attributeView)) continue;
                list.add(attributeView);
            }
        }
    }

    @Override
    protected void readOrderBy(Element element, ContainerObject containerObject) {
        EntityView entityView = (EntityView)containerObject;
        Element element2 = RXMLEntityView.getFirstChildByTagName(element, "orderby");
        HashMap<String, String> hashMap = new HashMap<String, String>();
        NodeList nodeList = element2.getElementsByTagName("columnview");
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            AttributeView attributeView2;
            Element element3 = (Element)nodeList.item(i);
            String string = element3.getAttribute("objectid");
            String string2 = element3.getAttribute("sortorder");
            String string3 = element3.getAttribute("cid");
            String string4 = element3.getAttribute("name");
            for (AttributeView attributeView2 : entityView.getElementsCollection()) {
                if (!attributeView2.getName().equalsIgnoreCase(string4)) continue;
                entityView.addToOrderBy(attributeView2, string2);
                hashMap.put(string, string2);
            }
            if (entityView.getElementByName(string4) != null) continue;
            attributeView2 = new AttributeView(entityView.getDesignPart());
            attributeView2.setObjectID(StringUtilities.decodeAttributeValue(string));
            attributeView2.setName(string4);
            if ((Entity)((LogicalDesign)entityView.getDesignPart()).getEntitySet().getObjectByID(string3) != null) {
                attributeView2.setTableAlias(((Entity)((LogicalDesign)entityView.getDesignPart()).getEntitySet().getObjectByID(string3)).getName());
            }
            entityView.addToOrderBy(attributeView2, string2);
        }
    }

    @Override
    public boolean isReaderForClass(Class clazz) {
        return clazz == EntityView.class;
    }
}

