/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.persistence.xml;

import oracle.dbtools.crest.model.MDPreferences;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.Task;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.LogicalDatatype;
import oracle.dbtools.crest.model.design.datatypes.CollectionType;
import oracle.dbtools.crest.model.design.datatypes.DistinctType;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;
import oracle.dbtools.crest.model.design.logical.Attribute;
import oracle.dbtools.crest.model.design.logical.Entity;
import oracle.dbtools.crest.model.persistence.XMLPersistenceManager;
import oracle.dbtools.crest.model.persistence.xml.AbstractRXMLDesignObject;
import oracle.dbtools.crest.util.string.StringUtilities;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class RXMLEntity
extends AbstractRXMLDesignObject {
    public RXMLEntity(XMLPersistenceManager xMLPersistenceManager) {
        super(xMLPersistenceManager);
    }

    @Override
    public String getRelativePath() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.getPersistenceManager().getAppView() != null) {
            String string = this.getPersistenceManager().getAppView().getDesignName();
            stringBuffer.append(string).append('/').append("logical").append('/');
        }
        stringBuffer.append(this.getConfiguration().get("entityPath"));
        return stringBuffer.toString();
    }

    @Override
    protected DesignObject instantiateDesignObject(String string, Design design, Element element) {
        return design.getLogicalDesign().recreateEntity(StringUtilities.decodeAttributeValue(string));
    }

    @Override
    protected void readObjectInfo(Element element, ModelIDObject modelIDObject, boolean bl) {
        if (modelIDObject instanceof Entity) {
            String string;
            String string2;
            Object object;
            String string3;
            String string4;
            String string5;
            String string6;
            String string7;
            String string8;
            String string9;
            String string10;
            String string11;
            String string12;
            String string13;
            String string14;
            String string15;
            Entity entity = (Entity)modelIDObject;
            String string16 = element.getAttribute("strategy");
            if (string16 != null) {
                entity.setFwdEngineeringStrategyName(string16);
            }
            if ((string15 = element.getAttribute("owner")) != null && !"".equalsIgnoreCase(string15)) {
                entity.setOwner(StringUtilities.decodeAttributeValue(string15));
            }
            if ((string14 = element.getAttribute("synonym")) != null && !"".equalsIgnoreCase(string14)) {
                entity.setSynonym(StringUtilities.decodeAttributeValue(string14));
            }
            if ((string13 = element.getAttribute("synonym_to_display")) != null && !"".equalsIgnoreCase(string13)) {
                entity.setSynonymToDisplay(StringUtilities.decodeAttributeValue(string13));
            }
            if ((string12 = element.getAttribute("entsource")) != null && !"".equalsIgnoreCase(string12)) {
                entity.setSource(StringUtilities.decodeAttributeValue(string12));
            }
            if ((string11 = element.getAttribute("minVolumes")) != null) {
                entity.setMinVolumes(string11);
            }
            if ((string10 = element.getAttribute("expectedVolumes")) != null) {
                entity.setExpectedVolumes(string10);
            }
            if ((string9 = element.getAttribute("maxVolumes")) != null) {
                entity.setMaxVolumes(string9);
            }
            if ((string8 = element.getAttribute("growthPercent")) != null) {
                entity.setGrowthPercent(string8);
            }
            if ((string7 = element.getAttribute("growthType")) != null) {
                entity.setGrowthType(string7);
            }
            if ((string6 = element.getAttribute("normalForm")) != null) {
                entity.setNormalForm(string6);
            }
            if ((string5 = element.getAttribute("entitytype")) != null) {
                if (ContainerObject.TYPE_CONSOLIDATED.equalsIgnoreCase(string5)) {
                    entity.setTypeID(entity.getDesign().getDLSettings().getClassificationTypeByName(ContainerObject.TYPE_SUMMARY).getTypeID());
                } else if (entity.getDesign().getLoadedVersion() < 2.2f) {
                    if (entity.getDesign().getDLSettings().getClassificationTypeByName(string5) != null) {
                        entity.setTypeID(entity.getDesign().getDLSettings().getClassificationTypeByName(string5).getTypeID());
                    } else {
                        entity.setTypeID("");
                    }
                } else if (entity.getDesign().getDLSettings().getClassificationTypeByID(string5) != null) {
                    entity.setTypeID(entity.getDesign().getDLSettings().getClassificationTypeByID(string5).getTypeID());
                } else {
                    entity.setTypeID("");
                }
            }
            if ((string4 = element.getAttribute("scope")) != null && !"".equalsIgnoreCase(string4)) {
                entity.setScope(StringUtilities.decodeAttributeValue(string4));
            }
            if ((string3 = element.getAttribute("structuredType")) != null) {
                object = (StructuredType)modelIDObject.getDesign().getDataTypesDesign().getStructuredTypeSet().getObjectByID(string3);
                entity.setBasedOnStructuredType((StructuredType)object);
            }
            if ((object = element.getAttribute("pref_abbreviation")) != null && !"".equalsIgnoreCase((String)object)) {
                entity.setPreferredAbbreviation(StringUtilities.decodeAttributeValue((String)object));
            }
            if ((string2 = element.getAttribute("short_name")) != null && !"".equalsIgnoreCase(string2)) {
                entity.setShortName(StringUtilities.decodeAttributeValue(string2));
            }
            if ((string = element.getAttribute("allow_type_substitution")) != null) {
                entity.setAllowTypeSubstitution(Boolean.valueOf(string));
            }
            if (entity.getLoadedVersion() < 1.0f) {
                NodeList nodeList = element.getElementsByTagName("parent");
                int n = nodeList.getLength();
                for (int i = 0; i < n; ++i) {
                    Element element2 = (Element)nodeList.item(i);
                    if (!VALUE_TRUE.equals(element2.getAttribute("inherits"))) continue;
                    String string17 = element2.getAttribute("id");
                    ConnectHierarchicalParentTask connectHierarchicalParentTask = new ConnectHierarchicalParentTask(entity, string17);
                    this.getPersistenceManager().addTask(connectHierarchicalParentTask);
                }
            }
        }
    }

    @Override
    public String getIdStartSequence() {
        return MDPreferences.getDefaultInstance().get("entity id prefix");
    }

    @Override
    protected void readContainedObjectInfo(Element element, ContainedObject containedObject, boolean bl) {
        Object[] objectArray;
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        Object object6;
        Object object7;
        Object object8;
        Object object9;
        Object object10;
        Attribute attribute = (Attribute)containedObject;
        Element element2 = RXMLEntity.getFirstChildByTagName(element, "use");
        if (element2 != null) {
            object10 = element2.getAttribute("value");
            if (object10 != null) {
                if (((String)object10).equalsIgnoreCase("domain")) {
                    attribute.setUse((short)0);
                } else if (((String)object10).equalsIgnoreCase("logical type")) {
                    attribute.setUse((short)1);
                } else if (((String)object10).equalsIgnoreCase("distinct type")) {
                    attribute.setUse((short)2);
                } else if (((String)object10).equalsIgnoreCase("structured type")) {
                    attribute.setUse((short)3);
                } else if (((String)object10).equalsIgnoreCase("collection type")) {
                    attribute.setUse((short)4);
                }
            }
        } else {
            element2 = RXMLEntity.getFirstChildByTagName(element, "usedomain");
            if (element2 != null && (object10 = element2.getAttribute("value")) != null) {
                if (Boolean.valueOf((String)object10).booleanValue()) {
                    attribute.setUse((short)0);
                } else {
                    attribute.setUse((short)1);
                }
            }
        }
        object10 = RXMLEntity.getFirstChildByTagName(element, "logicaltype");
        if (object10 != null) {
            object9 = object10.getAttribute("dttype");
            object8 = object10.getAttribute("oid");
            if (object9 != null || object8 != null) {
                object7 = LogicalDatatype.getLogicalDatatype(containedObject.getDesign(), (String)object9, (String)object8);
                attribute.setLogicalDatatype((LogicalDatatype)object7);
            }
        }
        if ((object9 = RXMLEntity.getFirstChildByTagName(element, "datatype")) != null) {
            object8 = object9.getAttribute("dttype");
            object7 = object9.getAttribute("typename");
            if (object8 != null && ((String)object8).equalsIgnoreCase("distinct")) {
                attribute.setDistinctType((DistinctType)containedObject.getDesign().getDataTypesDesign().getDistinctTypeSet().getObjectByID((String)object7));
            } else if (object8 != null && ((String)object8).equalsIgnoreCase("structured")) {
                attribute.setStructuredType((StructuredType)containedObject.getDesign().getDataTypesDesign().getStructuredTypeSet().getObjectByID((String)object7));
            } else if (object8 != null && ((String)object8).equalsIgnoreCase("collection")) {
                attribute.setCollectionType((CollectionType)containedObject.getDesign().getDataTypesDesign().getCollectionTypeSet().getObjectByID((String)object7));
            } else {
                object6 = object9.getAttribute("size");
                if (object6 != null && !((String)object6).equalsIgnoreCase("")) {
                    attribute.setDataTypeParameter("size", (String)object6);
                }
                if ((object5 = object9.getAttribute("precision")) != null && !((String)object5).equalsIgnoreCase("")) {
                    attribute.setDataTypeParameter("precision", (String)object5);
                }
                if ((object4 = object9.getAttribute("scale")) != null && !((String)object4).equalsIgnoreCase("")) {
                    attribute.setDataTypeParameter("scale", (String)object4);
                }
            }
        }
        if ((object8 = RXMLEntity.getFirstChildByTagName(element, "reference")) != null && (object7 = object8.getAttribute("value")) != null) {
            attribute.setReference(Boolean.valueOf((String)object7));
        }
        if ((object7 = RXMLEntity.getFirstChildByTagName(element, "sourcetype")) != null && (object6 = object7.getAttribute("sort")) != null) {
            attribute.setSourceType((String)object6);
        }
        if ((object6 = RXMLEntity.getFirstChildByTagName(element, "formula")) != null && (object5 = object6.getAttribute("desc")) != null) {
            attribute.setFormulaDesc(StringUtilities.decodeAttributeValue((String)object5));
        }
        if ((object5 = RXMLEntity.getFirstChildByTagName(element, "pref_abbreviation")) != null && (object4 = object5.getAttribute("abbreviation")) != null) {
            attribute.setPreferredAbbreviation(StringUtilities.decodeAttributeValue((String)object4));
        }
        if ((object4 = RXMLEntity.getFirstChildByTagName(element, "subtypeSubstitution")) != null && (object3 = object4.getAttribute("value")) != null) {
            attribute.setAllowSubtypeSubstitution(Boolean.valueOf((String)object3));
        }
        if ((object3 = RXMLEntity.getFirstChildByTagName(element, "restricted_substitution")) != null && (object2 = object3.getAttribute("value")) != null) {
            attribute.setRestrictedTypeSubstitution(Boolean.valueOf((String)object2));
            if (attribute.isRestrictedTypeSubstitution()) {
                object = this.getProperties((Element)object3, "permitted_types");
                objectArray = object.keySet().toArray();
                for (int i = 0; i < objectArray.length; ++i) {
                    String string = (String)object.get(objectArray[i]);
                    StructuredType structuredType = (StructuredType)attribute.getDesign().getDesignObject(string);
                    if (structuredType == null) continue;
                    attribute.getPermittedSubTypes().add(structuredType);
                }
            }
        }
        if ((object2 = RXMLEntity.getFirstChildByTagName(element, "scope")) != null && (object = object2.getAttribute("objectid")) != null) {
            attribute.setScopeId((String)object);
        }
        if ((object = RXMLEntity.getFirstChildByTagName(element, "source")) != null && (objectArray = object.getAttribute("value")) != null) {
            attribute.setSource((String)objectArray);
        }
    }

    @Override
    public Object recreateDesign(Document document, DesignPart designPart, boolean bl) {
        return null;
    }

    @Override
    public Object recreateObject(Element element, Design design, boolean bl) {
        Entity entity = (Entity)super.recreateObject(element, design, bl);
        StringBuffer stringBuffer = new StringBuffer();
        if (this.getPersistenceManager().getAppView() != null) {
            stringBuffer.append(this.getPersistenceManager().getAppView().getCurrentDesign().getDesignPath()).append('/');
        }
        stringBuffer.append(this.getRelativePath()).append('/').append(StringUtilities.decodeAttributeValue(entity.getObjectID())).append(".dmd");
        entity.setFilePath(stringBuffer.toString());
        return entity;
    }

    @Override
    public boolean isReaderForClass(Class clazz) {
        return clazz == Entity.class;
    }

    public static class ConnectHierarchicalParentTask
    implements Task {
        private Entity child;
        private String parentId;

        ConnectHierarchicalParentTask(Entity entity, String string) {
            if (entity == null) {
                throw new IllegalArgumentException(Messages.getString("RXMLEntity.ChildEntityCanNotBeNull"));
            }
            if (string == null) {
                throw new IllegalArgumentException(Messages.getString("RXMLEntity.ParentIdCanNotBeNull"));
            }
            this.child = entity;
            this.parentId = string;
        }

        @Override
        public boolean execute() {
            if (this.child != null && this.parentId != null) {
                Entity entity = (Entity)this.child.getDesign().getDesignObject(this.parentId);
                if (entity != null) {
                    this.child.setHierarchicalParent(entity);
                    this.child = null;
                    this.parentId = null;
                    return true;
                }
                return false;
            }
            return true;
        }
    }
}

