/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.persistence.xml;

import java.util.Iterator;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.persistence.XMLPersistenceManager;
import oracle.dbtools.crest.model.persistence.xml.AbstractXMLReader;
import oracle.dbtools.crest.model.persistence.xml.RXMLDomain;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class RXMLDomainFile
extends AbstractXMLReader {
    private RXMLDomain delegate;
    private boolean isSystem;

    public RXMLDomainFile(XMLPersistenceManager xMLPersistenceManager) {
        super(xMLPersistenceManager);
        this.delegate = new RXMLDomain(xMLPersistenceManager);
    }

    @Override
    public String getRelativePath(Object object) {
        this.isSystem = object instanceof String && "defaultdomains".equalsIgnoreCase(String.valueOf(object));
        return this.getRelativePath();
    }

    @Override
    public String getRelativePath() {
        if (!this.isSystem) {
            StringBuffer stringBuffer = new StringBuffer();
            String string = this.getPersistenceManager().getAppView().getDesignName();
            stringBuffer.append(string).append('/').append(this.getConfiguration().get("domainPath"));
            return stringBuffer.toString();
        }
        return this.getConfiguration().get("typesPath");
    }

    @Override
    protected void handleNoFile(Design design) {
        design.getDomainSet().removeAll();
    }

    @Override
    public Object recreateObject(Document document, Design design, boolean bl) {
        Element element = document.getDocumentElement();
        String string = element.getTagName();
        if (string.equals("domain")) {
            NodeList nodeList = document.getDocumentElement().getElementsByTagName("object");
            int n = nodeList.getLength();
            Element element2 = null;
            for (int i = 0; i < n; ++i) {
                element2 = (Element)nodeList.item(i);
                if (!"Domain".equals(element2.getAttribute("type"))) continue;
                this.delegate.recreateObject(element2, design, bl);
            }
        } else {
            String string2 = element.getAttribute("fileName");
            if (string2 != null && !"".equals(string2)) {
                this.getPersistenceManager().getAppView().getXMLTransformationManager().loadDomains(design, string2, document);
            }
        }
        return design.getDomainSet();
    }

    public static void checkAndSetIDGenerator(Design design) {
        Iterator iterator = design.getDomainSet().iterator();
        long l = 0L;
        long l2 = 0L;
        while (iterator.hasNext()) {
            ModelIDObject modelIDObject = (ModelIDObject)iterator.next();
            String string = modelIDObject.getObjectID();
            if (string.indexOf(64) <= -1 || (l2 = DesignPart.getCounter(string)) <= l) continue;
            l = l2;
        }
        long l3 = design.getAppView().getIDGenerator().getStartCounter();
        long l4 = design.getAppView().getIDGenerator().getLastIDIndex();
        if (l > l4) {
            design.getAppView().getIDGenerator().setCounter(l - l3 + 1L);
        }
    }

    @Override
    public Object recreateDesign(Document document, DesignPart designPart, boolean bl) {
        return null;
    }
}

