/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.persistence.xml;

import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.design.Constraint;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.Domain;
import oracle.dbtools.crest.model.design.LogicalDatatype;
import oracle.dbtools.crest.model.design.constraint.AVT;
import oracle.dbtools.crest.model.design.constraint.CheckConstraint;
import oracle.dbtools.crest.model.design.constraint.ConstraintEnumeration;
import oracle.dbtools.crest.model.persistence.XMLPersistenceManager;
import oracle.dbtools.crest.model.persistence.xml.AbstractRXMLDesignObject;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.dbtools.crest.util.string.StringUtilities;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class RXMLDomain
extends AbstractRXMLDesignObject {
    private static final Logger LOGGER = new Logger(RXMLDomain.class);

    public RXMLDomain(XMLPersistenceManager xMLPersistenceManager) {
        super(xMLPersistenceManager);
    }

    @Override
    public boolean canRead(Object object) {
        if (object instanceof Element) {
            String string = RXMLDomain.decodeAttributeValue(((Element)object).getAttribute("type"));
            return "Domain".equals(string);
        }
        return false;
    }

    @Override
    public Object recreateObject(Element element, Design design, boolean bl) {
        String string = RXMLDomain.decodeAttributeValue(element.getAttribute("id"));
        Domain domain = (Domain)design.getDesignObject(string);
        if (domain == null) {
            domain = (Domain)this.instantiateDesignObject(string, design, null);
        }
        this.readBasicObjectInfo(element, domain, bl);
        this.readObjectInfo(element, domain, bl);
        this.readAVT(element, domain);
        this.readConstraint(element, domain);
        Element element2 = RXMLDomain.getFirstChildByTagName(element, "logicaltype");
        String string2 = RXMLDomain.decodeAttributeValue(element2.getAttribute("oid"));
        String string3 = RXMLDomain.decodeAttributeValue(element2.getAttribute("name"));
        LogicalDatatype logicalDatatype = LogicalDatatype.getLogicalDatatype(design, string3, string2);
        this.readDataTypeParameters(element, domain);
        domain.setLogicalDatatype(logicalDatatype);
        String string4 = RXMLDomain.decodeAttributeValue(element.getAttribute("file"));
        if (string4 != null && !"".equals(string4)) {
            domain.setFileName(string4);
        }
        return domain;
    }

    @Override
    protected void readObjectInfo(Element element, ModelIDObject modelIDObject, boolean bl) {
        if (modelIDObject instanceof Domain) {
            String string;
            Domain domain = (Domain)modelIDObject;
            String string2 = element.getAttribute("synonym");
            if (string2 != null) {
                domain.setSynonym(StringUtilities.decodeAttributeValue(string2));
            }
            if ((string = element.getAttribute("dimension")) != null) {
                domain.setDimension(StringUtilities.decodeAttributeValue(string));
            }
        }
    }

    protected void readDataTypeParameters(Element element, Domain domain) {
        Element element2 = RXMLDomain.getFirstChildByTagName(element, "parameters");
        if (element2 != null) {
            NodeList nodeList = element.getElementsByTagName("parameter");
            int n = nodeList.getLength();
            for (int i = 0; i < n; ++i) {
                Element element3 = (Element)nodeList.item(i);
                domain.setDataTypeParameter(element3.getAttribute("name"), StringUtilities.decodeAttributeValue(element3.getAttribute("value")));
            }
        }
    }

    public Object recreateObject(Document document, Design design) {
        throw new RuntimeException("RXMLDomain.recreateObject(Document, Design) should never be called");
    }

    @Override
    public String getRelativePath() {
        return this.getConfiguration().get("typesPath");
    }

    @Override
    protected DesignObject instantiateDesignObject(String string, Design design, Element element) {
        return design.getDomainSet().createDomain(StringUtilities.decodeAttributeValue(string));
    }

    protected void readConstraint(Element element, Domain domain) {
        NodeList nodeList = element.getElementsByTagName("constraint");
        if (nodeList.getLength() > 0) {
            Element element2 = (Element)nodeList.item(0);
            String string = RXMLDomain.decodeAttributeValue(element2.getAttribute("type"));
            Constraint constraint = domain.getDesign().getConstraintSet().createConstraint(string);
            this.readConstraintInfo(element2, constraint);
            this.readPropertiesListLocateRoot(element2, constraint);
            if (string.equalsIgnoreCase("check constraint")) {
                this.readPropertiesListLocateRoot(element2, constraint);
                domain.setCheck((CheckConstraint)constraint);
            } else if (string.equalsIgnoreCase("enumerated String")) {
                this.readConstraintEnumerationList(element2, (ConstraintEnumeration)constraint);
                domain.setValueList((ConstraintEnumeration)constraint);
            }
            if (nodeList.getLength() > 1) {
                element2 = (Element)nodeList.item(1);
                string = RXMLDomain.decodeAttributeValue(element2.getAttribute("type"));
                constraint = domain.getDesign().getConstraintSet().createConstraint(string);
                this.readConstraintInfo(element2, constraint);
                this.readPropertiesListLocateRoot(element2, constraint);
                if (string.equalsIgnoreCase("check constraint")) {
                    domain.setCheck((CheckConstraint)constraint);
                } else if (string.equalsIgnoreCase("enumerated String")) {
                    this.readConstraintEnumerationList(element2, (ConstraintEnumeration)constraint);
                    domain.setValueList((ConstraintEnumeration)constraint);
                }
            }
        }
    }

    private void readConstraintEnumerationList(Element element, ConstraintEnumeration constraintEnumeration) {
        NodeList nodeList = element.getElementsByTagName("properties");
        if (nodeList.getLength() > 0) {
            this.readConstraintEnumeration((Element)nodeList.item(0), constraintEnumeration);
        }
    }

    private void readConstraintEnumeration(Element element, ConstraintEnumeration constraintEnumeration) {
        NodeList nodeList = element.getElementsByTagName("parameter");
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            Element element2 = (Element)nodeList.item(i);
            String string = RXMLDomain.decodeAttributeValue(element2.getAttribute("value"));
            String string2 = RXMLDomain.decodeAttributeValue(element2.getAttribute("desc"));
            constraintEnumeration.add(string, string2);
        }
    }

    @Override
    protected void readConstraintInfo(Element element, Constraint constraint) {
        try {
            Element element2 = RXMLDomain.getFirstChildByTagName(element, "name");
            if (element2 != null && element2.getFirstChild() != null) {
                String string = element2.getFirstChild().getNodeValue();
                constraint.setName(string);
            }
        }
        catch (Exception exception) {
            LOGGER.warn(exception.getMessage(), exception);
        }
    }

    protected void readAVT(Element element, Domain domain) {
        NodeList nodeList;
        int n;
        String string = element.getAttribute("avt_sort_order");
        if (!"".equalsIgnoreCase(string)) {
            try {
                int n2 = Integer.parseInt(string);
                domain.setAVTSortOrder(n2);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if ((n = (nodeList = element.getElementsByTagName("avt")).getLength()) > 0) {
            for (int i = 0; i < n; ++i) {
                String string2;
                Element element2 = (Element)nodeList.item(i);
                AVT aVT = null;
                Element element3 = RXMLDomain.getFirstChildByTagName(element2, "beginvalue");
                if (element3 != null && element3.getFirstChild() != null && (string2 = element3.getFirstChild().getNodeValue()) != null) {
                    aVT = new AVT(StringUtilities.decodeAttributeValue(string2), "", "");
                }
                if ((element3 = RXMLDomain.getFirstChildByTagName(element2, "endvalue")) != null && element3.getFirstChild() != null && (string2 = element3.getFirstChild().getNodeValue()) != null) {
                    if (aVT != null) {
                        aVT.setEndValue(StringUtilities.decodeAttributeValue(string2));
                    } else {
                        aVT = new AVT("", StringUtilities.decodeAttributeValue(string2), "");
                    }
                }
                if ((element3 = RXMLDomain.getFirstChildByTagName(element2, "description")) != null && element3.getFirstChild() != null && (string2 = element3.getFirstChild().getNodeValue()) != null) {
                    if (aVT != null) {
                        aVT.setDescription(StringUtilities.decodeAttributeValue(string2));
                    } else {
                        aVT = new AVT("", "", StringUtilities.decodeAttributeValue(string2));
                    }
                }
                if (aVT == null) continue;
                domain.addAVT(aVT);
            }
        }
    }

    @Override
    public Object recreateDesign(Document document, DesignPart designPart, boolean bl) {
        return null;
    }

    @Override
    public boolean isReaderForClass(Class clazz) {
        return clazz == Domain.class;
    }
}

