/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.persistence.xml;

import java.util.Map;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.logical.Arc;
import oracle.dbtools.crest.model.design.logical.Entity;
import oracle.dbtools.crest.model.design.logical.Relation;
import oracle.dbtools.crest.model.persistence.XMLPersistenceManager;
import oracle.dbtools.crest.model.persistence.xml.AbstractRXMLDesignObject;
import oracle.dbtools.crest.util.string.StringUtilities;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class RXMLArc
extends AbstractRXMLDesignObject {
    public RXMLArc(XMLPersistenceManager xMLPersistenceManager) {
        super(xMLPersistenceManager);
    }

    @Override
    protected DesignObject instantiateDesignObject(String string, Design design, Element element) {
        return design.getLogicalDesign().getArcSet().createArc(StringUtilities.decodeAttributeValue(string));
    }

    @Override
    public Object recreateObject(Element element, Design design, boolean bl) {
        Entity entity;
        Arc arc = (Arc)super.recreateObject(element, design, bl);
        String string = element.getAttribute("entity");
        if (string != null && !"".equalsIgnoreCase(string) && (entity = (Entity)design.getDesignObject(string)) != null) {
            entity.addArc(arc);
            Map map = this.getProperties(element, "relations");
            Object[] objectArray = map.keySet().toArray();
            for (int i = 0; i < objectArray.length; ++i) {
                Object object = objectArray[i];
                String string2 = (String)map.get(object);
                Relation relation = (Relation)design.getDesignObject(string2);
                if (relation == null) continue;
                arc.addRelation(relation);
            }
        }
        return arc;
    }

    @Override
    public Object recreateDesign(Document document, DesignPart designPart, boolean bl) {
        return null;
    }

    @Override
    public String getRelativePath() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.getPersistenceManager().getAppView() != null) {
            String string = this.getPersistenceManager().getAppView().getDesignName();
            stringBuffer.append(string).append('/').append("logical").append('/');
        }
        stringBuffer.append(this.getConfiguration().get("arcPath"));
        return stringBuffer.toString();
    }

    @Override
    public boolean isReaderForClass(Class clazz) {
        return clazz == Arc.class;
    }
}

