/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.persistence.xml;

import java.awt.Color;
import java.awt.Font;
import java.awt.Rectangle;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import oracle.dbtools.crest.model.MDUserFactory;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.MultiShapedDesignObject;
import oracle.dbtools.crest.model.NamingOptionsHolder;
import oracle.dbtools.crest.model.ObjectChange;
import oracle.dbtools.crest.model.design.ConnectionInterface;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.DiagramView;
import oracle.dbtools.crest.model.design.EditableFonts;
import oracle.dbtools.crest.model.design.FontObject;
import oracle.dbtools.crest.model.design.Note;
import oracle.dbtools.crest.model.design.datatypes.AbstractDTObject;
import oracle.dbtools.crest.model.design.datatypes.DTInheritance;
import oracle.dbtools.crest.model.design.datatypes.DTReference;
import oracle.dbtools.crest.model.design.datatypes.DTRelation;
import oracle.dbtools.crest.model.design.datatypes.DataTypesDesign;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;
import oracle.dbtools.crest.model.design.datatypes.TypeElement;
import oracle.dbtools.crest.model.persistence.XMLPersistenceManager;
import oracle.dbtools.crest.model.persistence.xml.AbstractXMLHandler;
import oracle.dbtools.crest.model.placeholder.PlaceHolder;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.ProgressDialog;
import oracle.dbtools.crest.swingui.TVConnector;
import oracle.dbtools.crest.swingui.TVDiagramView;
import oracle.dbtools.crest.swingui.TVNote;
import oracle.dbtools.crest.swingui.TopView;
import oracle.dbtools.crest.swingui.diagram.graph.DiagramConstants;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.dbtools.crest.util.string.StringUtilities;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public abstract class AbstractXMLReader
extends AbstractXMLHandler {
    private AbstractXMLReader successor;
    private static final Logger LOGGER = new Logger(AbstractXMLReader.class);

    public AbstractXMLReader(XMLPersistenceManager xMLPersistenceManager) {
        super(xMLPersistenceManager);
    }

    @Override
    public final boolean canWrite(Object object) {
        return false;
    }

    @Override
    public boolean canRead(String string) {
        return this.getPersistenceManager().exists(this.getRelativePath(string), string);
    }

    public abstract Object recreateObject(Document var1, Design var2, boolean var3);

    public abstract Object recreateDesign(Document var1, DesignPart var2, boolean var3);

    public Object recreateObject(Document document, Design design, ProgressDialog progressDialog) {
        return null;
    }

    public final Object handleRecreateObject(Object object, Design design, boolean bl) {
        design.getAppView().setCurrentDesign(design);
        AbstractXMLReader abstractXMLReader = this.getReaderFor(object);
        if (abstractXMLReader != null) {
            return abstractXMLReader.recreateObject(object, design, bl);
        }
        return null;
    }

    public final Object handleRecreateObject(Object object, Design design, ProgressDialog progressDialog) {
        design.getAppView().setCurrentDesign(design);
        AbstractXMLReader abstractXMLReader = this.getReaderFor(object);
        if (abstractXMLReader != null) {
            return abstractXMLReader.recreateObject(object, design, progressDialog);
        }
        return null;
    }

    public final Object handleRecreateDesign(Object object, DesignPart designPart, boolean bl) {
        AbstractXMLReader abstractXMLReader;
        if (designPart != null) {
            designPart.getAppView().setCurrentDesign(designPart.getDesign());
        }
        if ((abstractXMLReader = this.getReaderFor(object)) != null) {
            return abstractXMLReader.recreateDesign(object, designPart, bl);
        }
        return null;
    }

    public Object recreateObject(Object object, Design design, boolean bl) {
        design.getAppView().setCurrentDesign(design);
        InputStream inputStream = this.getInputStreamFor(object);
        if (inputStream != null) {
            try {
                Document document = AbstractXMLReader.parse(inputStream, this.getFilename(object), design);
                return this.recreateObject(document, design, bl);
            }
            catch (Throwable throwable) {
                Design.openFailed();
                LOGGER.error("Error recreating object from XML: " + object + " \n" + throwable.toString());
                return null;
            }
        }
        this.handleNoFile(design);
        return null;
    }

    protected void handleNoFile(Design design) {
    }

    public Object recreateObject(Object object, Design design, ProgressDialog progressDialog) {
        design.getAppView().setCurrentDesign(design);
        InputStream inputStream = this.getInputStreamFor(object);
        if (inputStream != null) {
            try {
                Document document = AbstractXMLReader.parse(inputStream, this.getFilename(object), design);
                return this.recreateObject(document, design, progressDialog);
            }
            catch (Throwable throwable) {
                Design.openFailed();
                LOGGER.error("Error recreating object from XML: " + object);
                return null;
            }
        }
        return null;
    }

    public Object recreateDesign(Object object, DesignPart designPart, boolean bl) {
        InputStream inputStream;
        if (designPart != null) {
            designPart.getAppView().setCurrentDesign(designPart.getDesign());
        }
        if ((inputStream = this.getInputStreamFor(object)) != null) {
            try {
                Design design = designPart != null ? designPart.getDesign() : null;
                Document document = AbstractXMLReader.parse(inputStream, this.getFilename(object), design);
                boolean bl2 = false;
                return this.recreateDesign(document, designPart, bl2);
            }
            catch (Throwable throwable) {
                Design.openFailed();
                LOGGER.error("Error recreating Design from XML: " + object + "\n" + throwable.toString());
                return null;
            }
        }
        return null;
    }

    public InputStream getInputStreamFor(Object object) {
        String string = this.getRelativePath(object);
        InputStream inputStream = this.getPersistenceManager().getInputStreamFor(string, this.getFilename(object));
        if (inputStream == null && !"defaultdomains".equals(object)) {
            LOGGER.error("Data inputstream is null (path: " + string + " name: " + this.getFilename(object) + ")");
        }
        return inputStream;
    }

    public static Document parse(InputStream inputStream, String string, Design design) {
        if (inputStream == null) {
            LOGGER.error("InputStream is null, Can not parse XML for: " + string);
        } else {
            try {
                InputStreamReader inputStreamReader = design != null && design.getLoadedVersion() <= 2.2f ? new InputStreamReader(inputStream) : new InputStreamReader(inputStream, "UTF-8");
                InputSource inputSource = new InputSource(inputStreamReader);
                Document document = DOCUMENT_BUILDER.parse(inputSource);
                inputStreamReader.close();
                return document;
            }
            catch (Exception exception) {
                Design.openFailed();
                LOGGER.error("problem parsing document for:" + string + "\n AbstractXMLReader.parse: ", exception);
            }
        }
        return null;
    }

    public void setSuccessor(AbstractXMLReader abstractXMLReader) {
        this.successor = abstractXMLReader;
    }

    public AbstractXMLReader getSuccessor() {
        return this.successor;
    }

    public AbstractXMLReader getLast() {
        if (this.getSuccessor() == null) {
            return this;
        }
        return this.getSuccessor().getLast();
    }

    public AbstractXMLReader getReaderFor(Object object) {
        if (this.canRead(object)) {
            return this;
        }
        AbstractXMLReader abstractXMLReader = this.getSuccessor();
        if (abstractXMLReader != null) {
            return abstractXMLReader.getReaderFor(object);
        }
        String string = String.valueOf(object);
        if (string.equals("")) {
            string = object.getClass().getName();
        }
        if (!"defaultdomains".equals(object)) {
            LOGGER.error("No reader for: " + string);
        }
        return null;
    }

    public AbstractXMLReader getReaderFor(Class clazz) {
        if (this.isReaderForClass(clazz)) {
            return this;
        }
        AbstractXMLReader abstractXMLReader = this.getSuccessor();
        if (abstractXMLReader != null) {
            return abstractXMLReader.getReaderFor(clazz);
        }
        String string = String.valueOf(clazz);
        if (string.equals("")) {
            string = clazz.getName();
        }
        LOGGER.error("No reader for: " + string);
        return null;
    }

    public String getIdStartSequence() {
        return "";
    }

    protected Map getProperties(Element element, String string) {
        TreeMap<String, String> treeMap = new TreeMap<String, String>();
        Element element2 = AbstractXMLReader.getFirstChildByTagName(element, string);
        if (element2 != null) {
            NodeList nodeList = element2.getElementsByTagName("parameter");
            int n = nodeList.getLength();
            for (int i = 0; i < n; ++i) {
                Element element3 = (Element)nodeList.item(i);
                treeMap.put(element3.getAttribute("name"), AbstractXMLReader.decodeAttributeValue(element3.getAttribute("value")));
            }
        }
        return treeMap;
    }

    protected void readSubViews(Element element, DesignPart designPart) {
        ApplicationView.log(MessageFormat.format(Messages.getString("AbstractXMLReader.ReadSubViewsFor"), designPart.getName()));
        Element element2 = AbstractXMLReader.getFirstChildByTagName(element, "sub_views_collection");
        if (element2 != null) {
            NodeList nodeList = element2.getElementsByTagName("sub_view");
            int n = nodeList.getLength();
            for (int i = 0; i < n; ++i) {
                Element element3 = (Element)nodeList.item(i);
                if (element3.getParentNode() != element2) continue;
                String string = element3.getAttribute("subview_name");
                String string2 = element3.getAttribute("id");
                String string3 = element3.getAttribute("generator");
                DesignPartView designPartView = designPart.createDesignPartSubView();
                designPartView.setName(StringUtilities.decodeAttributeValue(string));
                this.readDisplayProperties(element3, designPartView);
                designPartView.setVisible(false);
                String string4 = element3.getAttribute("visible");
                if (string2 != null && !"".equalsIgnoreCase(string2) && !"null".equalsIgnoreCase(string2)) {
                    designPartView.setDPVId(string2);
                }
                if (string3 != null && !"".equalsIgnoreCase(string3) && !"null".equalsIgnoreCase(string3)) {
                    designPartView.setGeneratorId(string3);
                }
                this.readMainDisplay(element3, designPartView);
                this.readSubordinateDisplays(element3, designPartView);
                designPartView.setMustBeVisible(string4.equalsIgnoreCase("true"));
                String string5 = element3.getAttribute("comment");
                designPartView.getPlaceHolder().setComment(StringUtilities.decodeAttributeValue(string5));
                String string6 = element3.getAttribute("notes");
                designPartView.getPlaceHolder().setNotes(StringUtilities.decodeAttributeValue(string6));
                designPartView.getTabbedPane().setName(designPartView.getName());
                designPartView.getWorkSpace().updateSettings();
                designPartView.getTabbedPane().setSelectedComponent(designPartView);
            }
        }
    }

    protected void readSubordinateDisplays(Element element, DesignPartView designPartView) {
        ApplicationView.log(MessageFormat.format(Messages.getString("AbstractXMLReader.ReadSubordinateDispalysFor"), designPartView.getName()));
        Element element2 = AbstractXMLReader.getFirstChildByTagName(element, "subordinate_displays");
        if (element2 != null) {
            NodeList nodeList = element2.getElementsByTagName("subordinate_display");
            int n = nodeList.getLength();
            for (int i = 0; i < n; ++i) {
                Element element3 = (Element)nodeList.item(i);
                if (element3.getParentNode() != element2) continue;
                String string = element3.getAttribute("name");
                String string2 = element3.getAttribute("objectid");
                DesignPartView designPartView2 = designPartView.addSubordinateView();
                designPartView2.setName(StringUtilities.decodeAttributeValue(string));
                if (string2 != null && !"".equalsIgnoreCase(string2) && !"null".equalsIgnoreCase(string2)) {
                    designPartView2.setDPVId(string2);
                }
                this.readSubordinateDisplay(element3, designPartView2, false);
                this.readDisplayProperties(element3, designPartView2);
                designPartView2.getWorkSpace().updateSettings();
            }
        }
        this.readDisplayProperties(element, designPartView);
    }

    protected void readMainDisplay(Element element, DesignPartView designPartView) {
        ApplicationView.log(MessageFormat.format(Messages.getString("AbstractXMLReader.ReadMainDispalyFor"), designPartView.getName()));
        Element element2 = AbstractXMLReader.getFirstChildByTagName(element, "main_display");
        if (element2 != null) {
            this.readSubordinateDisplay(element2, designPartView, true);
            this.readDisplayProperties(element2, designPartView);
            designPartView.getWorkSpace().updateSettings();
        }
    }

    protected void readSubordinateDisplay(Element element, DesignPartView designPartView, boolean bl) {
        Object object;
        Object object2;
        String string;
        String string2;
        Object object3;
        Object object4;
        Object object52;
        ApplicationView.log(MessageFormat.format(Messages.getString("AbstractXMLReader.ReadDisplay"), designPartView.getName()));
        NodeList nodeList = element.getElementsByTagName("objectid");
        Design design = designPartView.getDesignPart().getDesign();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            object52 = (Element)nodeList.item(i);
            object4 = object52.getAttribute("viewid_source");
            if (object4 != null && !"".equals(object4)) {
                arrayList.add(object52);
                continue;
            }
            String string3 = StringUtilities.decodeAttributeValue(object52.getAttribute("oid"));
            String string4 = StringUtilities.decodeAttributeValue(object52.getAttribute("viewid"));
            object3 = StringUtilities.decodeAttributeValue(object52.getAttribute("tv_generator_id"));
            string2 = StringUtilities.decodeAttributeValue(object52.getAttribute("type"));
            string = object52.getAttribute("viewnumber");
            int n2 = 0;
            if (!"".equalsIgnoreCase(string)) {
                try {
                    n2 = Integer.parseInt(string);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (bl && string2.equalsIgnoreCase("Note")) {
                object2 = null;
                object2 = !this.getPersistenceManager().isXML_FromDataBase() ? (Note)this.getPersistenceManager().read((Object)string3, design.getDesign(), true) : (Note)design.getDesignObject(string3);
                if (object2 != null && !designPartView.isMainDiagram()) {
                    ((TVNote)((MultiShapedDesignObject)object2).getTopView()).remove(false);
                }
            }
            if ((object = design.getDesignObject(string3)) == null) continue;
            object2 = ((DesignObject)object).getTopViewByID(designPartView, string4, n2);
            if (object2 == null) {
                object2 = designPartView.createTopViewFor((DesignObject)object);
            }
            if (object2 == null) continue;
            ((TopView)object2).setViewID(string4);
            if (object3 != null && !"".equalsIgnoreCase((String)object3) && !"null".equalsIgnoreCase((String)object3)) {
                ((TopView)object2).setGeneratorID((String)object3);
            }
            this.readGraphInfo((Element)object52, (TopView)object2);
        }
        for (Object object52 : arrayList) {
            this.readTVConnector((Element)object52, designPartView);
        }
        object52 = designPartView.getDesignPart();
        object4 = element.getElementsByTagName("diagram_view");
        int n3 = object4.getLength();
        for (int i = 0; i < n3; ++i) {
            object3 = (Element)object4.item(i);
            string2 = StringUtilities.decodeAttributeValue(object3.getAttribute("objectid"));
            string = StringUtilities.decodeAttributeValue(object3.getAttribute("dpv_id"));
            String string5 = StringUtilities.decodeAttributeValue(object3.getAttribute("dpv_name"));
            object = object3.getAttribute("composite");
            object2 = ((DesignPart)object52).recreateDiagramView(string2);
            ((DiagramView)object2).setDpvID(string);
            ((DiagramView)object2).setDpvName(string5);
            ((DiagramView)object2).setCompositeView(Boolean.valueOf((String)object));
            TVDiagramView tVDiagramView = ((DesignPart)object52).getMainView() == designPartView ? (TVDiagramView)((MultiShapedDesignObject)object2).getFirstViewForDPV(designPartView) : (TVDiagramView)designPartView.createTopViewFor((DesignObject)object2);
            this.readGraphInfo((Element)object3, tVDiagramView);
        }
    }

    protected void readGraphInfo(Element element, TopView topView) {
        DesignObject designObject = topView.getModel();
        ApplicationView applicationView = designObject.getDesign().getAppView();
        if (applicationView != null) {
            NodeList nodeList = element.getElementsByTagName("graphical");
            HashMap<String, String> hashMap = null;
            int n = nodeList.getLength();
            for (int i = 0; i < n; ++i) {
                Element element2 = (Element)nodeList.item(i);
                hashMap = new HashMap<String, String>();
                NodeList nodeList2 = element2.getElementsByTagName("parameter");
                int n2 = nodeList2.getLength();
                for (int j = 0; j < n2; ++j) {
                    Element element3 = (Element)nodeList2.item(j);
                    hashMap.put(element3.getAttribute("name"), element3.getAttribute("value"));
                }
                applicationView.setGraphicalPropsFor(topView, hashMap);
            }
        }
    }

    private void readTVConnector(Element element, DesignPartView designPartView) {
        Object object;
        Object object2;
        Object object3;
        String string;
        Object object4;
        DesignObject designObject;
        Design design = designPartView.getDesignPart().getDesign();
        DesignPart designPart = designPartView.getDesignPart();
        String string2 = element.getAttribute("oid");
        if (designPart instanceof DataTypesDesign && designPart.getMainView() == designPartView && (designObject = ((String)(object4 = StringUtilities.decodeAttributeValue(element.getAttribute("type")))).equalsIgnoreCase("DTInheritance") ? ((DataTypesDesign)designPart).createDTInheritance() : ((DataTypesDesign)designPart).createDTReference()) != null) {
            if (designObject instanceof DTReference) {
                string = element.getAttribute("stelement");
                if (!string.equals("null") && (object3 = (TypeElement)((DataTypesDesign)designPart).getTypeElementSet().getObjectByID(string)) != null) {
                    ((DTReference)designObject).setTypeElement((TypeElement)object3);
                    ((TypeElement)object3).setReferenceRelation((DTReference)designObject);
                }
            } else if (designObject instanceof DTInheritance && (string = element.getAttribute("target")) != null && !string.equals("null") && (object3 = (StructuredType)design.getDesign().getDesignObject(string)) != null) {
                ((StructuredType)object3).setInheritanceRelation((DTInheritance)designObject);
            }
            string = element.getAttribute("source");
            object3 = element.getAttribute("target");
            if (!string.equals("null") && !((String)object3).equals("null")) {
                object2 = (AbstractDTObject)design.getDesign().getDesignObject(string);
                object = (AbstractDTObject)design.getDesign().getDesignObject((String)object3);
                if (object2 != null && object != null) {
                    ((DTRelation)designObject).setSourceDTObject((AbstractDTObject)object2);
                    ((DTRelation)designObject).setTargetDTObject((AbstractDTObject)object);
                }
            }
            designObject.setObjectID(string2);
            design.getDesign().addDesignObject(designObject);
        }
        if ((designObject = design.getDesignObject(string2)) != null && designObject instanceof ConnectionInterface && (object4 = (ConnectionInterface)((Object)designObject)) != null) {
            string = element.getAttribute("viewid_source");
            object3 = element.getAttribute("viewid_target");
            if (!string.equals("null") && (object2 = object4.getSourceObject().getTopViewByID(designPartView, string)) != null) {
                object4.setSourceTopView((TopView)object2);
            }
            if (!((String)object3).equals("null") && (object2 = object4.getTargetObject().getTopViewByID(designPartView, (String)object3)) != null) {
                object4.setTargetTopView((TopView)object2);
            }
            object2 = AbstractXMLReader.getFirstChildByTagName(element, "points");
            object = object2.getElementsByTagName("point");
            int n = object.getLength();
            object4.getSourceTopView(designPartView);
            object4.getTargetTopView(designPartView);
            TVConnector tVConnector = (TVConnector)object4.getViewFor(designPartView);
            if (tVConnector != null) {
                Object object5;
                Object object6;
                Object object7;
                Element element2;
                for (int i = 0; i < n; ++i) {
                    element2 = (Element)object.item(i);
                    object7 = element2.getAttribute("x_coordinate");
                    object6 = element2.getAttribute("y_coordinate");
                    tVConnector.getEdgePoints().add(DiagramConstants.createPoint(Double.parseDouble((String)object7), Double.parseDouble((String)object6)));
                }
                Element element3 = AbstractXMLReader.getFirstChildByTagName(element, "labels");
                if (element3 != null) {
                    String string3;
                    String string4;
                    element2 = AbstractXMLReader.getFirstChildByTagName(element3, "source");
                    if (element2 != null) {
                        object7 = element2.getAttribute("x_coordinate");
                        object6 = element2.getAttribute("y_coordinate");
                        string4 = element2.getAttribute("width");
                        string3 = element2.getAttribute("height");
                        if (string4 == null || "".equalsIgnoreCase(string4)) {
                            string4 = "-1";
                        }
                        if (string3 == null || "".equalsIgnoreCase(string3)) {
                            string3 = "-1";
                        }
                        tVConnector.setSourceLabelBounds(new Rectangle((int)Double.parseDouble((String)object7), (int)Double.parseDouble((String)object6), (int)Double.parseDouble(string4), (int)Double.parseDouble(string3)));
                        object5 = tVConnector.getTempSourceLabel();
                        if (object5 != null) {
                            this.readColorInfo(element2, (DesignObject)object5);
                            this.readFontsInfo(element2, (DesignObject)object5);
                        }
                    }
                    if ((element2 = AbstractXMLReader.getFirstChildByTagName(element3, "target")) != null) {
                        object7 = element2.getAttribute("x_coordinate");
                        object6 = element2.getAttribute("y_coordinate");
                        string4 = element2.getAttribute("width");
                        string3 = element2.getAttribute("height");
                        if (string4 == null || "".equalsIgnoreCase(string4)) {
                            string4 = "-1";
                        }
                        if (string3 == null || "".equalsIgnoreCase(string3)) {
                            string3 = "-1";
                        }
                        tVConnector.setTargetLabelBounds(new Rectangle((int)Double.parseDouble((String)object7), (int)Double.parseDouble((String)object6), (int)Double.parseDouble(string4), (int)Double.parseDouble(string3)));
                        object5 = tVConnector.getTempTargetLabel();
                        if (object5 != null) {
                            this.readColorInfo(element2, (DesignObject)object5);
                            this.readFontsInfo(element2, (DesignObject)object5);
                        }
                    }
                    if ((element2 = AbstractXMLReader.getFirstChildByTagName(element3, "main_label")) != null) {
                        object7 = element2.getAttribute("x_coordinate");
                        object6 = element2.getAttribute("y_coordinate");
                        string4 = element2.getAttribute("width");
                        string3 = element2.getAttribute("height");
                        if (object7 != null && !"".equals(object7)) {
                            if (string4 == null || "".equalsIgnoreCase(string4)) {
                                string4 = "-1";
                            }
                            if (string3 == null || "".equalsIgnoreCase(string3)) {
                                string3 = "-1";
                            }
                            tVConnector.setLabelBounds(new Rectangle((int)Double.parseDouble((String)object7), (int)Double.parseDouble((String)object6), (int)Double.parseDouble(string4), (int)Double.parseDouble(string3)));
                            object5 = tVConnector.getTempCenterLabel();
                            if (object5 != null) {
                                this.readColorInfo(element2, (DesignObject)object5);
                                this.readFontsInfo(element2, (DesignObject)object5);
                            }
                        }
                    }
                }
                if ((element2 = AbstractXMLReader.getFirstChildByTagName(element, "graphical")) != null) {
                    object7 = element2.getElementsByTagName("parameter");
                    object6 = new HashMap();
                    int n2 = object7.getLength();
                    for (int i = 0; i < n2; ++i) {
                        object5 = (Element)object7.item(i);
                        object6.put(object5.getAttribute("name"), object5.getAttribute("value"));
                    }
                    String string5 = (String)object6.get("use_default_color");
                    boolean bl = true;
                    if (string5 != null) {
                        bl = Boolean.valueOf(string5);
                    }
                    tVConnector.setUseDefaultColor(bl);
                    if (!bl) {
                        Object object8;
                        String string6 = (String)object6.get("color");
                        if (string6 != null && !"null".equalsIgnoreCase(string6)) {
                            object8 = new Color(Integer.parseInt(string6));
                            tVConnector.setBackgroundColor((Color)object8);
                        }
                        if ((object8 = (String)object6.get("width")) != null && !"null".equalsIgnoreCase((String)object8)) {
                            int n3 = Integer.parseInt((String)object8);
                            tVConnector.setLineWidth(n3);
                        }
                    }
                }
            }
        }
    }

    protected void readDisplayProperties(Element element, DesignPartView designPartView) {
        PlaceHolder placeHolder;
        String string;
        String string2;
        String string3;
        String string4;
        String string5;
        String string6;
        String string7;
        String string8 = element.getAttribute("notation");
        if (string8 != null && !"".equals(string8)) {
            designPartView.setNotation(Integer.decode(string8));
        }
        if ((string7 = element.getAttribute("auto_route")) != null && !"".equals(string7)) {
            designPartView.setAutoRoute(Boolean.valueOf(string7));
        }
        if ((string6 = element.getAttribute("box_in_box")) != null && !"".equals(string6)) {
            designPartView.setBoxInBox(Boolean.valueOf(string6));
        }
        if ((string5 = element.getAttribute("show_all_details")) != null && !"".equals(string5)) {
            designPartView.setShowAllDetails(Boolean.valueOf(string5));
        }
        if ((string4 = element.getAttribute("show_names_only")) != null && !"".equals(string4)) {
            designPartView.setShowNamesOnly(Boolean.valueOf(string4));
        }
        if ((string3 = element.getAttribute("show_elements")) != null && !"".equals(string3)) {
            designPartView.setShowElements(Boolean.valueOf(string3));
        }
        if ((string2 = element.getAttribute("show_datatype")) != null && !"".equals(string2)) {
            designPartView.setShowDatatype(Boolean.valueOf(string2));
        }
        if ((string = element.getAttribute("show_keys")) != null && !"".equals(string)) {
            designPartView.setShowKeys(Boolean.valueOf(string));
        }
        if ((placeHolder = designPartView.getPlaceHolder()) != null) {
            String string9 = element.getAttribute("comment");
            placeHolder.setComment(StringUtilities.decodeAttributeValue(string9));
            String string10 = element.getAttribute("notes");
            placeHolder.setNotes(StringUtilities.decodeAttributeValue(string10));
            this.updateCreateChange(element, placeHolder);
        }
    }

    public void readDiagramViews(Element element, DesignPart designPart) {
        Element element2 = AbstractXMLReader.getFirstChildByTagName(element, "diagram_views");
        if (element2 != null) {
            NodeList nodeList = element2.getElementsByTagName("diagram_view");
            int n = nodeList.getLength();
            for (int i = 0; i < n; ++i) {
                Element element3 = (Element)nodeList.item(i);
                String string = element3.getAttribute("objectid");
                String string2 = element3.getAttribute("dpv_id");
                String string3 = element3.getAttribute("dpv_name");
                String string4 = element3.getAttribute("composite");
                DiagramView diagramView = designPart.recreateDiagramView(string);
                diagramView.setDpvID(string2);
                diagramView.setDpvName(string3);
                diagramView.setCompositeView(Boolean.valueOf(string4));
                designPart.getDesign().addDiagramView(diagramView);
                TopView topView = diagramView.getFirstViewForDPV(designPart.getMainView());
                if (topView == null) continue;
                this.readGraphInfo(element3, topView);
            }
        }
    }

    public void readDiagramViews(Element element, DesignPartView designPartView) {
        DesignPart designPart = designPartView.getDesignPart();
        Element element2 = AbstractXMLReader.getFirstChildByTagName(element, "diagram_views");
        if (element2 != null) {
            NodeList nodeList = element2.getElementsByTagName("diagram_view");
            int n = nodeList.getLength();
            for (int i = 0; i < n; ++i) {
                Element element3 = (Element)nodeList.item(i);
                String string = StringUtilities.decodeAttributeValue(element3.getAttribute("objectid"));
                String string2 = StringUtilities.decodeAttributeValue(element3.getAttribute("dpv_id"));
                String string3 = StringUtilities.decodeAttributeValue(element3.getAttribute("dpv_name"));
                String string4 = element3.getAttribute("composite");
                DiagramView diagramView = designPart.recreateDiagramView(string);
                diagramView.setDpvID(string2);
                diagramView.setDpvName(string3);
                diagramView.setCompositeView(Boolean.valueOf(string4));
                TopView topView = diagramView.getFirstViewForDPV(designPartView);
                if (topView == null) continue;
                this.readGraphInfo(element3, topView);
            }
        }
    }

    public void readNamingOptions(Element element, DesignPart designPart) {
        Element element2 = AbstractXMLReader.getFirstChildByTagName(element, "naming_options");
        if (element2 != null) {
            NodeList nodeList = element2.getElementsByTagName("naming_option");
            int n = nodeList.getLength();
            for (int i = 0; i < n; ++i) {
                Element element3 = (Element)nodeList.item(i);
                String string = element3.getAttribute("class_name");
                String string2 = element3.getAttribute("max_name_length");
                String string3 = element3.getAttribute("case_type");
                String string4 = element3.getAttribute("valid_characters");
                String string5 = element3.getAttribute("all_valid");
                NamingOptionsHolder namingOptionsHolder = designPart.getNamingOptionsHolderFor(string);
                namingOptionsHolder.setMaxNameLength(Integer.valueOf(string2));
                namingOptionsHolder.setCaseType(Integer.valueOf(string3));
                namingOptionsHolder.setValidChars(string4);
                namingOptionsHolder.setIsValid(Boolean.valueOf(string5));
            }
        }
    }

    protected void readColorInfo(Element element, DesignObject designObject) {
        Object object;
        String string;
        String string2 = element.getAttribute("use_default_color");
        if (string2 != null && !"".equals(string2) && !"null".equalsIgnoreCase(string2)) {
            designObject.setUseDefaultColor(Boolean.valueOf(string2));
        }
        if ((string = element.getAttribute("background_color")) != null && !"".equals(string) && !"null".equalsIgnoreCase(string)) {
            object = new Color(Integer.parseInt(string));
            designObject.setBackgroundColor((Color)object);
        }
        if ((object = element.getAttribute("foreground_color")) != null && !"".equals(object) && !"null".equalsIgnoreCase((String)object)) {
            Color color = new Color(Integer.parseInt((String)object));
            designObject.setForegroundColor(color);
        }
    }

    protected void readFontsInfo(Element element, DesignObject designObject) {
        if (designObject instanceof EditableFonts) {
            EditableFonts editableFonts = (EditableFonts)((Object)designObject);
            Element element2 = AbstractXMLReader.getFirstChildByTagName(element, "fonts");
            if (element2 != null) {
                NodeList nodeList = element2.getElementsByTagName("font_object");
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    Object object;
                    Element element3 = (Element)nodeList.item(i);
                    TreeMap<String, String> treeMap = new TreeMap<String, String>();
                    NodeList nodeList2 = element3.getElementsByTagName("parameter");
                    int n = nodeList2.getLength();
                    for (int j = 0; j < n; ++j) {
                        object = (Element)nodeList2.item(j);
                        treeMap.put(object.getAttribute("name"), object.getAttribute("value"));
                    }
                    String string = (String)treeMap.get("fo_type");
                    object = (String)treeMap.get("font_name");
                    String string2 = (String)treeMap.get("font_style");
                    String string3 = (String)treeMap.get("font_size");
                    String string4 = (String)treeMap.get("font_color");
                    Font font = new Font((String)object, Integer.parseInt(string2), Integer.parseInt(string3));
                    FontObject fontObject = new FontObject(string, font, new Color(Integer.parseInt(string4)));
                    FontObject fontObject2 = editableFonts.getFontObject(string);
                    if (fontObject2 != null) {
                        int n2 = editableFonts.getEditableFonts().indexOf(fontObject2);
                        editableFonts.getEditableFonts().remove(fontObject2);
                        editableFonts.getEditableFonts().add(n2, fontObject);
                        continue;
                    }
                    editableFonts.getEditableFonts().add(fontObject);
                }
            }
        }
    }

    public boolean isReaderForClass(Class clazz) {
        return false;
    }

    protected void updateCreateChange(Element element, ModelIDObject modelIDObject) {
        NodeList nodeList = element.getElementsByTagName("alter");
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            Element element2 = (Element)nodeList.item(i);
            if (!element2.getParentNode().equals(element)) continue;
            String string = element2.getAttribute("type");
            this.readChange(element2, modelIDObject, string);
        }
    }

    protected void readChange(Element element, ModelIDObject modelIDObject, String string) {
        ObjectChange objectChange = null;
        if ("created".equals(string)) {
            objectChange = modelIDObject.getCreation();
        } else if ("changed".equals(string)) {
            objectChange = modelIDObject.getChange();
        } else {
            return;
        }
        Element element2 = AbstractXMLReader.getFirstChildByTagName(element, "user");
        objectChange.setUser(MDUserFactory.getInstance().getUser(element2.getFirstChild().getNodeValue()));
        Element element3 = AbstractXMLReader.getFirstChildByTagName(element, "timestamp");
        objectChange.setTimeString(element3.getFirstChild().getNodeValue());
    }

    protected boolean isOldDesign() {
        if (this.getPersistenceManager().getAppView() != null) {
            return this.getPersistenceManager().getAppView().getCurrentDesign().getLoadedVersion() < 3.2f;
        }
        return false;
    }
}

