/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.persistence.xml;

import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Map;
import java.util.StringTokenizer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import oracle.dbtools.crest.model.MDConfiguration;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.persistence.XMLPersistenceManager;
import oracle.dbtools.crest.model.persistence.xml.XMLConstants;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.dbtools.crest.util.propertymap.PropertyMap;
import oracle.dbtools.crest.util.propertymap.wrapperpool.PMWPoolMap;
import oracle.dbtools.crest.util.string.StringUtilities;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public abstract class AbstractXMLHandler
implements XMLConstants {
    public static final String NULL_STR = "null";
    public static final DocumentBuilder DOCUMENT_BUILDER;
    private static final Logger LOGGER;
    public static final String DOC_VERSION = "2.0";
    public static final String NEWLINE;
    private XMLPersistenceManager persistenceMgr;

    public AbstractXMLHandler(XMLPersistenceManager xMLPersistenceManager) {
        this.persistenceMgr = xMLPersistenceManager;
    }

    public abstract String getRelativePath();

    public String getRelativePath(Object object) {
        return this.getRelativePath();
    }

    public String getFilename(Object object) {
        return String.valueOf(object);
    }

    public abstract boolean canWrite(Object var1);

    public boolean canRead(Object object) {
        if (object instanceof String) {
            return this.canRead((String)object);
        }
        return false;
    }

    public abstract boolean canRead(String var1);

    protected MDConfiguration getConfiguration() {
        return MDConfiguration.getDefaultInstance();
    }

    public XMLPersistenceManager getPersistenceManager() {
        return this.persistenceMgr;
    }

    protected Document createDocument() {
        return this.createDocument("metadatadoc");
    }

    protected Document createDocument(String string) {
        Document document = null;
        try {
            document = DOCUMENT_BUILDER.newDocument();
            Element element = document.getDocumentElement();
            element = document.createElement(string);
            element.setAttribute("version", this.getVersion());
            document.appendChild(element);
        }
        catch (Exception exception) {
            LOGGER.error("problem creating document. AbstractXMLHandler.createDocument(): ", exception);
        }
        return document;
    }

    public final PMWPoolMap getPMWPoolMap() {
        return this.getPersistenceManager().getPMWPoolMap();
    }

    public static Element getFirstChildByTagName(Element element, String string) {
        NodeList nodeList = element.getChildNodes();
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            Node node = nodeList.item(i);
            if (node.getNodeType() != 1 || !((Element)node).getTagName().equals(string)) continue;
            return (Element)node;
        }
        return null;
    }

    protected void appendComment(Element element, String string) {
        this.appendComment(element, string, 0);
    }

    protected void appendComment(Element element, String string, int n) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(NEWLINE);
        for (int i = 0; i < n; ++i) {
            stringBuffer.append('\t');
        }
        stringBuffer.append("<!-- ").append(string).append(" -->");
        stringBuffer.append(NEWLINE);
        Text text = element.getOwnerDocument().createTextNode(stringBuffer.toString());
        element.appendChild(text);
    }

    protected void showStatusMessage(String string) {
        this.getPersistenceManager().showStatusMessage(string);
    }

    protected String getVersion() {
        return DOC_VERSION;
    }

    public void prettyPrint(Document document, PrintWriter printWriter) {
        Element element = document.getDocumentElement();
        this.print(element, 0, printWriter);
        printWriter.println();
        printWriter.flush();
    }

    public void prettyPrint(Document document) {
        PrintWriter printWriter = new PrintWriter(System.out);
        this.prettyPrint(document, printWriter);
    }

    public String prettyPrint(Document document, StringBuffer stringBuffer) {
        Element element = document.getDocumentElement();
        this.print(element, 0, stringBuffer);
        return stringBuffer.toString();
    }

    public void prettyPrint(Document document, OutputStream outputStream) {
        PrintWriter printWriter = new PrintWriter(outputStream);
        this.prettyPrint(document, printWriter);
    }

    protected void print(Element element, int n, StringBuffer stringBuffer) {
        boolean bl;
        if (n == 0) {
            stringBuffer.append(MDConfiguration.getDefaultInstance().get("xml.documenttype"));
            stringBuffer.append(NEWLINE);
        } else {
            this.printlvl(n, stringBuffer);
        }
        stringBuffer.append('<');
        stringBuffer.append(element.getTagName());
        NamedNodeMap namedNodeMap = element.getAttributes();
        int n2 = namedNodeMap.getLength();
        for (int i = 0; namedNodeMap != null && i < n2; ++i) {
            stringBuffer.append(' ');
            stringBuffer.append(namedNodeMap.item(i).getNodeName());
            stringBuffer.append("=\"");
            stringBuffer.append(namedNodeMap.item(i).getNodeValue());
            stringBuffer.append('\"');
        }
        NodeList nodeList = element.getChildNodes();
        int n3 = 0;
        boolean bl2 = bl = nodeList != null && 0 < nodeList.getLength();
        if (bl) {
            stringBuffer.append('>');
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                if (node instanceof Element) {
                    ++n3;
                    this.print((Element)node, n + 1, stringBuffer);
                    continue;
                }
                this.print(node, n + 1, stringBuffer);
            }
        }
        if (n3 > 0) {
            this.printlvl(n, stringBuffer);
        }
        if (bl) {
            stringBuffer.append("</");
            stringBuffer.append(element.getTagName());
            stringBuffer.append('>');
        } else {
            stringBuffer.append(" />");
        }
    }

    protected void print(Element element, int n, PrintWriter printWriter) {
        boolean bl;
        this.printlvl(n, printWriter);
        printWriter.print('<');
        printWriter.print(element.getTagName());
        NamedNodeMap namedNodeMap = element.getAttributes();
        int n2 = namedNodeMap.getLength();
        for (int i = 0; namedNodeMap != null && i < n2; ++i) {
            printWriter.print(' ');
            printWriter.print(namedNodeMap.item(i).getNodeName());
            printWriter.print("=\"");
            printWriter.print(namedNodeMap.item(i).getNodeValue());
            printWriter.print('\"');
        }
        NodeList nodeList = element.getChildNodes();
        int n3 = 0;
        boolean bl2 = bl = nodeList != null && 0 < nodeList.getLength();
        if (bl) {
            printWriter.print('>');
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                if (node instanceof Element) {
                    ++n3;
                    this.print((Element)node, n + 1, printWriter);
                    continue;
                }
                this.print(node, n + 1, printWriter);
            }
        }
        if (n3 > 0) {
            this.printlvl(n, printWriter);
        }
        if (bl) {
            printWriter.print("</");
            printWriter.print(element.getTagName());
            printWriter.print('>');
        } else {
            printWriter.print(" />");
        }
        printWriter.flush();
    }

    protected void printlvl(int n, PrintWriter printWriter) {
        printWriter.println();
        for (int i = 0; i < n; ++i) {
            printWriter.print('\t');
        }
    }

    protected void printlvl(int n, StringBuffer stringBuffer) {
        stringBuffer.append(NEWLINE);
        for (int i = 0; i < n; ++i) {
            stringBuffer.append('\t');
        }
    }

    protected void print(Node node, int n, PrintWriter printWriter) {
        printWriter.print(node);
    }

    protected void print(Node node, int n, StringBuffer stringBuffer) {
        stringBuffer.append(node.getNodeValue());
    }

    protected void print(Node node, PrintWriter printWriter) {
        this.print(node, 0, printWriter);
    }

    protected void appendProperties(Element element, String string, Map map) {
        Element element2 = element.getOwnerDocument().createElement(string);
        Object[] objectArray = map.keySet().toArray();
        for (int i = 0; i < objectArray.length; ++i) {
            String string2 = (String)objectArray[i];
            String string3 = (String)map.get(string2);
            if (string2.equalsIgnoreCase("object.property.auto.DialogVisible")) continue;
            Element element3 = element.getOwnerDocument().createElement("parameter");
            element2.appendChild(element3);
            this.appendProperty(element3, string2, string3);
        }
        element.appendChild(element2);
    }

    protected void appendProperty(Element element, String string, String string2) {
        element.setAttribute("name", string);
        element.setAttribute("value", AbstractXMLHandler.encodeAttributeValue(string2));
    }

    protected void readPropertiesListLocateRoot(Element element, PropertyMap propertyMap) {
        NodeList nodeList = element.getElementsByTagName("properties");
        if (nodeList.getLength() > 0) {
            this.readPropertiesList((Element)nodeList.item(0), propertyMap);
        }
    }

    protected void readPropertiesList(Element element, PropertyMap propertyMap) {
        NodeList nodeList = element.getElementsByTagName("parameter");
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            Element element2 = (Element)nodeList.item(i);
            this.doReadPropertyFromParameterElement(element2, propertyMap);
        }
    }

    protected void readPropertiesList(Element element, PropertyMap propertyMap, StorageObject storageObject) {
        if (element != null) {
            NodeList nodeList = element.getElementsByTagName("parameter");
            int n = nodeList.getLength();
            for (int i = 0; i < n; ++i) {
                Element element2 = (Element)nodeList.item(i);
                this.doReadPropertyFromParameterElement(element2, propertyMap, storageObject);
            }
        }
    }

    private void doReadPropertyFromParameterElement(Element element, PropertyMap propertyMap) {
        String string = element.getAttribute("name");
        if (!string.equalsIgnoreCase("object.property.auto.ReadOnly")) {
            String string2 = element.getAttribute("value");
            propertyMap.setProperty(string, AbstractXMLHandler.decodeAttributeValue(string2));
        }
    }

    private void doReadPropertyFromParameterElement(Element element, PropertyMap propertyMap, StorageObject storageObject) {
        StorageDesign storageDesign = storageObject.getStorageDesign();
        String string = element.getAttribute("name");
        if (!string.equalsIgnoreCase("object.property.auto.ReadOnly")) {
            String string2 = element.getAttribute("value");
            string2 = this.replaceIDsInValue(string2, storageDesign);
            propertyMap.setProperty(string, AbstractXMLHandler.decodeAttributeValue(string2));
        }
    }

    private String replaceIDsInValue(String string, StorageDesign storageDesign) {
        if (string != null) {
            ModelIDObject modelIDObject;
            String string2 = "";
            Map map = storageDesign.getCorrespondenceMap();
            if (string.indexOf(44) > 0 && map != null) {
                boolean bl = true;
                StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
                while (stringTokenizer.hasMoreTokens()) {
                    String string3 = stringTokenizer.nextToken();
                    String string4 = string3.trim();
                    ModelIDObject modelIDObject2 = (ModelIDObject)map.get(string4);
                    if (modelIDObject2 != null && !string4.equals(modelIDObject2.getObjectID())) {
                        string3 = modelIDObject2.getObjectID();
                    }
                    if (bl) {
                        string2 = string3;
                        bl = false;
                        continue;
                    }
                    string2 = string2 + "," + string3;
                }
                return string2;
            }
            if (map != null && (modelIDObject = (ModelIDObject)map.get(string)) != null) {
                String string5 = modelIDObject.getObjectID();
                return string5;
            }
        }
        return string;
    }

    public static String encodeAttributeValue(String string) {
        return StringUtilities.encodeAttributeValue(string);
    }

    public static String decodeAttributeValue(String string) {
        return StringUtilities.decodeAttributeValue(string);
    }

    static {
        LOGGER = new Logger(AbstractXMLHandler.class);
        DocumentBuilder documentBuilder = null;
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilder = documentBuilderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            LOGGER.error("Can not instantiate XML parser in AbstractXMLHandler (DOCUMENT_BUILDER) " + parserConfigurationException);
        }
        DOCUMENT_BUILDER = documentBuilder;
        NEWLINE = System.getProperty("line.separator");
    }
}

