/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.persistence.xml;

import java.text.MessageFormat;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.datatype.MDDataType;
import oracle.dbtools.crest.model.design.Constraint;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.ContainedObjectWithDomain;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.ContainerWithKeyObject;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.Domain;
import oracle.dbtools.crest.model.design.KeyObject;
import oracle.dbtools.crest.model.design.Measurement;
import oracle.dbtools.crest.model.design.constraint.AVT;
import oracle.dbtools.crest.model.design.constraint.ConstraintEnumeration;
import oracle.dbtools.crest.model.design.datatypes.CollectionType;
import oracle.dbtools.crest.model.design.datatypes.DistinctType;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;
import oracle.dbtools.crest.model.design.logical.Arc;
import oracle.dbtools.crest.model.design.logical.CandidateKey;
import oracle.dbtools.crest.model.design.logical.LogicalDesign;
import oracle.dbtools.crest.model.design.multidimensional.AbstractMDObject;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.persistence.XMLPersistenceManager;
import oracle.dbtools.crest.model.persistence.xml.AbstractWXMLModelIDObject;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.TopView;
import oracle.dbtools.crest.util.string.StringUtilities;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public abstract class AbstractWXMLDesignObject
extends AbstractWXMLModelIDObject {
    public AbstractWXMLDesignObject(XMLPersistenceManager xMLPersistenceManager) {
        super(xMLPersistenceManager);
    }

    @Override
    public Document writeDocument(Object object) {
        DesignObject designObject = (DesignObject)object;
        if (object instanceof ModelObject) {
            ApplicationView.log(MessageFormat.format(Messages.getString("AbstractWXMLDesignObject.Writing"), ((ModelObject)object).getName()));
        }
        Document document = this.createDocument();
        Element element = document.getDocumentElement();
        Element element2 = this.appendDesignObjectInfo(document, element, designObject);
        this.appendDocumentsInfo(document, element2, designObject);
        this.appendPartiesInfo(document, element2, designObject);
        this.appendChangeRequestsInfo(document, element2, designObject);
        List list = designObject.getMeasurements();
        Element element3 = document.createElement("measurements");
        element2.appendChild(element3);
        for (int i = 0; i < list.size(); ++i) {
            this.appendMeasurementInfo(document, element3, (Measurement)list.get(i));
        }
        if (designObject instanceof ContainerObject) {
            ContainedObject[] containedObjectArray = ((ContainerObject)designObject).getElements();
            Element element4 = document.createElement("contained");
            element2.appendChild(element4);
            for (int i = 0; i < containedObjectArray.length; ++i) {
                this.appendContainedObjectInfo(document, element4, containedObjectArray[i]);
            }
            if (designObject instanceof ContainerWithKeyObject) {
                Element element5 = document.createElement("key");
                element2.appendChild(element5);
                KeyObject[] keyObjectArray = ((ContainerWithKeyObject)designObject).getKeys();
                for (int i = 0; i < keyObjectArray.length; ++i) {
                    this.appendKeyObjectInfo(document, element5, keyObjectArray[i]);
                }
            }
        }
        this.appendContainedElements(document, element, designObject);
        return document;
    }

    private void appendChangeRequestsInfo(Document document, Element element, DesignObject designObject) {
        this.appendObjects(element, designObject.getRequests().toArray(), "changerequests");
    }

    private void appendDocumentsInfo(Document document, Element element, DesignObject designObject) {
        this.appendObjects(element, designObject.getDocuments().toArray(), "documents");
    }

    private void appendPartiesInfo(Document document, Element element, DesignObject designObject) {
        this.appendObjects(element, designObject.getResponsibleParties().toArray(), "parties");
    }

    protected void appendDesignObjectInfo(Element element, DesignObject designObject) {
    }

    protected void appendContainedElements(Document document, Element element, DesignObject designObject) {
    }

    protected Element appendDesignObjectInfo(Document document, Element element, DesignObject designObject) {
        return this.appendDesignObjectInfo(document, element, designObject, designObject.getObjectTypeName());
    }

    protected Element appendDesignObjectInfo(Document document, Element element, DesignObject designObject, String string) {
        Element element2;
        Element element3 = this.appendObjectInfo(document, element, designObject, string);
        TopView topView = designObject.getFirstViewForDPV(designObject.getDesignPart().getMainView());
        boolean bl = topView != null && topView.getCellView() != null;
        element3.setAttribute("visible_in_main_view", String.valueOf(bl));
        if (designObject.getImportedId() != null && !"".equalsIgnoreCase(designObject.getImportedId())) {
            element3.setAttribute("imported_id", designObject.getImportedId());
        }
        this.appendDesignObjectInfo(element3, designObject);
        this.appendDesignObjectColor(element3, designObject);
        this.appendOracleNames(element3, designObject);
        if (!(designObject instanceof Arc)) {
            element2 = this.createElement(element3, "engineering");
            if (designObject.getDesignPart() instanceof LogicalDesign) {
                Map map = designObject.getEngineerTo();
                Object[] objectArray = map.keySet().toArray();
                for (int i = 0; i < objectArray.length; ++i) {
                    String string2 = (String)objectArray[i];
                    Object v = map.get(string2);
                    Element element4 = this.createElement(element2, "relational_design");
                    element4.setAttribute("id", string2);
                    element4.setAttribute("should", String.valueOf(v));
                }
            } else {
                element2.setAttribute("should", designObject.getShouldEngineer() ? VALUE_TRUE : VALUE_FALSE);
            }
        }
        element2 = this.createElement(element3, "des_obj_version");
        element2.setAttribute("version", String.valueOf(designObject.getVersion()));
        this.appendDesignObjectFonts(element3, designObject);
        return element3;
    }

    private void appendOracleNames(Element element, DesignObject designObject) {
        if (designObject instanceof AbstractMDObject) {
            AbstractMDObject abstractMDObject = (AbstractMDObject)designObject;
            TreeMap<String, String> treeMap = new TreeMap<String, String>();
            treeMap.put("oracle_short_name", abstractMDObject.getOracleShortName());
            treeMap.put("oracle_long_name", abstractMDObject.getOracleLongName());
            treeMap.put("oracle_plural_name", abstractMDObject.getOraclePluralName());
            treeMap.put("name_in_oracle_aw", abstractMDObject.getNameInOracleAW());
            this.appendProperties(element, "oracle_names", treeMap);
        }
    }

    protected final Element appendContainedObjectInfo(Document document, Element element, ContainedObject containedObject) {
        Object object;
        String string;
        Element element2 = this.appendDesignObjectInfo(document, element, containedObject);
        element.appendChild(element2);
        element2.setAttribute("unique", String.valueOf(containedObject.isUnique()));
        element2.setAttribute("allownull", String.valueOf(containedObject.getNullsAllowed()));
        String string2 = containedObject.getConstraintName();
        if (string2 != null && !"".equalsIgnoreCase(string2)) {
            element2.setAttribute("constraint_name", StringUtilities.encodeAttributeValue(string2));
        }
        element2.setAttribute("usedomainconstraints", String.valueOf(containedObject.getUseDomainConstraints()));
        element2.setAttribute("is_oid", String.valueOf(containedObject.isOid()));
        element2.setAttribute("structured_attribute_id", String.valueOf(containedObject.getStructAttributeID()));
        if (!containedObject.getUseDomainConstraints()) {
            this.appendConstraint(element2, containedObject.getCheck());
            this.appendConstraint(element2, containedObject.getValueList());
            this.appendAVT(element2, containedObject);
        }
        if ((string = containedObject.getSynonym()) != null && !"".equalsIgnoreCase(string)) {
            element2.setAttribute("synonym", StringUtilities.encodeAttributeValue(String.valueOf(containedObject.getSynonym())));
        }
        element2.setAttribute("fk", String.valueOf(containedObject.isFKElement()));
        if (containedObject.isFKElement() && (object = containedObject.getDelegateElement()) != null) {
            element2.setAttribute("references", ((ModelIDObject)object).getObjectID());
        }
        if (containedObject instanceof ContainedObjectWithDomain) {
            this.appendContainedObjectWithDomainInfo(document, element2, (ContainedObjectWithDomain)containedObject);
        }
        this.appendContainedObjectInfo(element2, containedObject);
        this.appendDocumentsInfo(document, element2, containedObject);
        this.appendPartiesInfo(document, element2, containedObject);
        this.appendChangeRequestsInfo(document, element2, containedObject);
        object = containedObject.getMeasurements();
        Element element3 = document.createElement("measurements");
        element2.appendChild(element3);
        for (int i = 0; i < object.size(); ++i) {
            this.appendMeasurementInfo(document, element3, (Measurement)object.get(i));
        }
        return element2;
    }

    private Element appendMeasurementInfo(Document document, Element element, Measurement measurement) {
        Element element2 = this.appendDesignObjectInfo(document, element, measurement);
        element.appendChild(element2);
        Element element3 = document.createElement("value");
        Text text = document.createTextNode("" + measurement.getValue());
        element3.appendChild(text);
        element2.appendChild(element3);
        element3 = document.createElement("unit");
        text = document.createTextNode(measurement.getUnit());
        element3.appendChild(text);
        element2.appendChild(element3);
        element3 = document.createElement("sort");
        text = document.createTextNode(measurement.getType());
        element3.appendChild(text);
        element2.appendChild(element3);
        element3 = document.createElement("creationTime");
        text = document.createTextNode(measurement.getCreationDate());
        element3.appendChild(text);
        element2.appendChild(element3);
        element3 = document.createElement("effectiveTime");
        text = document.createTextNode(measurement.getEffectiveDate());
        element3.appendChild(text);
        element2.appendChild(element3);
        return element2;
    }

    protected void appendConstraint(Element element, Constraint constraint) {
        if (constraint != null) {
            Element element2 = this.createElement(element, "constraint");
            element2.setAttribute("type", constraint.getType());
            this.appendConstraintInfo(element2, constraint);
            if (constraint instanceof ConstraintEnumeration) {
                this.appendConstraintEnumeration(element2, (ConstraintEnumeration)constraint);
            }
        }
    }

    private void appendConstraintEnumeration(Element element, ConstraintEnumeration constraintEnumeration) {
        Element element2 = element.getOwnerDocument().createElement("properties");
        Iterator iterator = constraintEnumeration.getPropertyNames();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            String string2 = constraintEnumeration.getProperty(string);
            if (string.equalsIgnoreCase("object.property.auto.DialogVisible")) continue;
            Element element3 = element.getOwnerDocument().createElement("parameter");
            element2.appendChild(element3);
            this.appendProperty(element3, string, string2);
            String string3 = "";
            if (constraintEnumeration.getValuesDescriptionMap().containsKey(string2)) {
                string3 = (String)constraintEnumeration.getValuesDescriptionMap().get(string2);
            }
            element3.setAttribute("desc", AbstractWXMLDesignObject.encodeAttributeValue(string3));
        }
        element.appendChild(element2);
    }

    protected void appendConstraintInfo(Element element, Constraint constraint) {
    }

    protected void appendAVT(Element element, ContainedObject containedObject) {
        element.setAttribute("avt_sort_order", String.valueOf(containedObject.getAVTSortOrder()));
        Set set = containedObject.getAVTs();
        Iterator iterator = set.iterator();
        if (iterator.hasNext()) {
            while (iterator.hasNext()) {
                AVT aVT = (AVT)iterator.next();
                Element element2 = this.createElement(element, "avt");
                Element element3 = element2.getOwnerDocument().createElement("beginvalue");
                Text text = element2.getOwnerDocument().createTextNode(StringUtilities.encodeAttributeValue(aVT.getBeginValue()));
                element3.appendChild(text);
                element2.appendChild(element3);
                element3 = element2.getOwnerDocument().createElement("endvalue");
                text = element2.getOwnerDocument().createTextNode(StringUtilities.encodeAttributeValue(aVT.getEndValue()));
                element3.appendChild(text);
                element2.appendChild(element3);
                element3 = element2.getOwnerDocument().createElement("description");
                text = element2.getOwnerDocument().createTextNode(StringUtilities.encodeAttributeValue(aVT.getDescription()));
                element3.appendChild(text);
                element2.appendChild(element3);
            }
        } else {
            Element element4 = this.createElement(element, "avt");
            Element element5 = element4.getOwnerDocument().createElement("beginvalue");
            Text text = element4.getOwnerDocument().createTextNode("");
            element5.appendChild(text);
            element4.appendChild(element5);
            element5 = element4.getOwnerDocument().createElement("endvalue");
            text = element4.getOwnerDocument().createTextNode("");
            element5.appendChild(text);
            element4.appendChild(element5);
            element5 = element4.getOwnerDocument().createElement("description");
            text = element4.getOwnerDocument().createTextNode("");
            element5.appendChild(text);
            element4.appendChild(element5);
        }
    }

    protected void appendContainedObjectInfo(Element element, ContainedObject containedObject) {
    }

    protected final void appendContainedObjectWithDomainInfo(Document document, Element element, ContainedObjectWithDomain containedObjectWithDomain) {
        Domain domain = containedObjectWithDomain.getDomain();
        if (domain != null) {
            Element element2 = document.createElement("domain");
            element2.setAttribute("oid", domain.getObjectID());
            element2.setAttribute("file", domain.getFileName());
            this.appendContainedObjectWithDomainInfo(element, containedObjectWithDomain);
            element.appendChild(element2);
        }
    }

    protected void appendContainedObjectWithDomainInfo(Element element, ContainedObjectWithDomain containedObjectWithDomain) {
    }

    protected final Element appendKeyObjectInfo(Document document, Element element, KeyObject keyObject) {
        Element element2 = this.appendDesignObjectInfo(document, element, keyObject);
        element2.setAttribute("pk", String.valueOf(keyObject.isPK()));
        if (keyObject instanceof CandidateKey) {
            element2.setAttribute("keystate", ((CandidateKey)keyObject).getKeyState());
            element2.setAttribute("synonym", StringUtilities.encodeAttributeValue(((CandidateKey)keyObject).getSynonym()));
        } else if (keyObject instanceof Index) {
            element2.setAttribute("indexstate", ((Index)keyObject).getIndexState());
            this.appendFunctional(document, element2, ((Index)keyObject).getIndexExpression());
        }
        element.appendChild(element2);
        this.appendKeyObjectInfo(element2, keyObject);
        ContainedObject[] containedObjectArray = keyObject.getElements();
        for (int i = 0; i < containedObjectArray.length; ++i) {
            this.appendKeyElementInfo(document, element2, containedObjectArray[i], keyObject);
        }
        this.appendDocumentsInfo(document, element2, keyObject);
        this.appendPartiesInfo(document, element2, keyObject);
        this.appendChangeRequestsInfo(document, element2, keyObject);
        List list = keyObject.getMeasurements();
        Element element3 = document.createElement("measurements");
        element2.appendChild(element3);
        for (int i = 0; i < list.size(); ++i) {
            this.appendMeasurementInfo(document, element3, (Measurement)list.get(i));
        }
        return element2;
    }

    private void appendFunctional(Document document, Element element, Object object) {
        Element element2 = document.createElement("functional");
        element2.appendChild(document.createTextNode(object.toString()));
        element.appendChild(element2);
    }

    protected void appendKeyObjectInfo(Element element, KeyObject keyObject) {
    }

    protected final Element appendKeyElementInfo(Document document, Element element, ContainedObject containedObject, KeyObject keyObject) {
        Element element2 = document.createElement("contains");
        element2.setAttribute("type", containedObject.getObjectTypeName());
        if (keyObject instanceof Index && !keyObject.isFK()) {
            Index index = (Index)keyObject;
            element2.setAttribute("sortorder", index.getColumnSortOrder(containedObject));
        }
        element2.appendChild(document.createTextNode(containedObject.getObjectID()));
        element.appendChild(element2);
        this.appendKeyElementInfo(element2, containedObject);
        return element2;
    }

    protected void appendKeyElementInfo(Element element, ContainedObject containedObject) {
    }

    public void appendDataTypeInfo(Element element, ContainedObjectWithDomain containedObjectWithDomain) {
        Element element2 = element.getOwnerDocument().createElement("datatype");
        if (containedObjectWithDomain.getDataType() instanceof MDDataType) {
            MDDataType mDDataType = (MDDataType)containedObjectWithDomain.getDataType();
            if (mDDataType.isImplicitSized()) {
                element2.setAttribute("dttype", "builtin");
            } else if (mDDataType.isFixedLength()) {
                element2.setAttribute("dttype", "fixed");
                element2.setAttribute("size", String.valueOf(containedObjectWithDomain.getSize()));
            } else if (mDDataType.isVarSized()) {
                element2.setAttribute("dttype", "var");
                element2.setAttribute("size", String.valueOf(containedObjectWithDomain.getSize()));
            } else if (mDDataType.isPacked()) {
                element2.setAttribute("dttype", "packed");
                element2.setAttribute("precision", String.valueOf(containedObjectWithDomain.getPrecision()));
                element2.setAttribute("scale", String.valueOf(containedObjectWithDomain.getScale()));
            }
            element2.setAttribute("typename", mDDataType.getName());
        } else if (containedObjectWithDomain.getDataType() instanceof DistinctType) {
            element2.setAttribute("dttype", "distinct");
            element2.setAttribute("typename", ((DistinctType)containedObjectWithDomain.getDataType()).getObjectID());
        } else if (containedObjectWithDomain.getDataType() instanceof StructuredType) {
            element2.setAttribute("dttype", "structured");
            element2.setAttribute("typename", ((StructuredType)containedObjectWithDomain.getDataType()).getObjectID());
        } else if (containedObjectWithDomain.getDataType() instanceof CollectionType) {
            element2.setAttribute("dttype", "collection");
            element2.setAttribute("typename", ((CollectionType)containedObjectWithDomain.getDataType()).getObjectID());
        }
        element.appendChild(element2);
    }

    public void appendScopeInfo(Element element, ContainedObject containedObject) {
        if (containedObject.getScopeId() != null) {
            Element element2 = element.getOwnerDocument().createElement("scope");
            element2.setAttribute("objectid", containedObject.getScopeId());
            element.appendChild(element2);
        }
    }

    protected void appendReferenceInfo(Element element, boolean bl) {
        Element element2 = element.getOwnerDocument().createElement("reference");
        element2.setAttribute("value", String.valueOf(bl));
        element.appendChild(element2);
    }

    protected void appendSubtypeSubstitutionInfo(Element element, boolean bl) {
        Element element2 = element.getOwnerDocument().createElement("subtypeSubstitution");
        element2.setAttribute("value", String.valueOf(bl));
        element.appendChild(element2);
    }

    @Override
    public String getFilenameFor(Object object) {
        return ((DesignObject)object).getObjectID();
    }

    protected void appendObjects(Element element, Object[] objectArray, String string) {
        TreeMap<String, String> treeMap = new TreeMap<String, String>();
        for (int i = 0; i < objectArray.length; ++i) {
            DesignObject designObject = (DesignObject)objectArray[i];
            treeMap.put(String.valueOf(i + 1), designObject.getObjectID());
        }
        this.appendProperties(element, string, treeMap);
    }

    protected void appendScriptInfo(Element element, String string, String string2) {
        Element element2 = element.getOwnerDocument().createElement(string);
        element2.setAttribute("value", StringUtilities.encodeAttributeValue(string2));
        element.appendChild(element2);
    }

    protected void appendRestrictedSubstitutionInfo(Element element, ContainedObjectWithDomain containedObjectWithDomain) {
        Element element2 = element.getOwnerDocument().createElement("restricted_substitution");
        element2.setAttribute("value", String.valueOf(containedObjectWithDomain.isRestrictedTypeSubstitution()));
        if (containedObjectWithDomain.isRestrictedTypeSubstitution() && containedObjectWithDomain.getPermittedSubTypes().size() > 0) {
            this.appendObjects(element2, containedObjectWithDomain.getPermittedSubTypes().toArray(), "permitted_types");
        }
        element.appendChild(element2);
    }
}

