/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.persistence.xml;

import java.util.List;
import java.util.Map;
import oracle.dbtools.crest.model.ChangeRequest;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.businessinfo.BIDocument;
import oracle.dbtools.crest.model.businessinfo.BIResponsibleParty;
import oracle.dbtools.crest.model.design.AbstractView;
import oracle.dbtools.crest.model.design.Constraint;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.ContainedObjectWithDomain;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.ContainerWithKeyObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.Domain;
import oracle.dbtools.crest.model.design.KeyObject;
import oracle.dbtools.crest.model.design.Measurement;
import oracle.dbtools.crest.model.design.constraint.AVT;
import oracle.dbtools.crest.model.design.constraint.CheckConstraint;
import oracle.dbtools.crest.model.design.constraint.ConstraintEnumeration;
import oracle.dbtools.crest.model.design.logical.CandidateKey;
import oracle.dbtools.crest.model.design.logical.EntityView;
import oracle.dbtools.crest.model.design.logical.LogicalDesign;
import oracle.dbtools.crest.model.design.multidimensional.AbstractMDObject;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.TableView;
import oracle.dbtools.crest.model.persistence.XMLPersistenceManager;
import oracle.dbtools.crest.model.persistence.xml.AbstractRXMLModelIDObject;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.dbtools.crest.util.string.StringUtilities;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class AbstractRXMLDesignObject
extends AbstractRXMLModelIDObject {
    private static final Logger LOGGER = new Logger(AbstractRXMLDesignObject.class);

    public AbstractRXMLDesignObject(XMLPersistenceManager xMLPersistenceManager) {
        super(xMLPersistenceManager);
    }

    protected abstract DesignObject instantiateDesignObject(String var1, Design var2, Element var3);

    protected ContainedObject instantiateContainedObject(String string, Design design, ContainerObject containerObject, Element element) {
        return containerObject.createContainedObject(string);
    }

    protected KeyObject instantiateKeyObject(String string, ContainerWithKeyObject containerWithKeyObject) {
        return containerWithKeyObject.createKeyObject(string);
    }

    @Override
    public Object recreateObject(Document document, Design design, boolean bl) {
        try {
            Element element = AbstractRXMLDesignObject.getFirstChildByTagName(document.getDocumentElement(), "object");
            return this.recreateObject(element, design, bl);
        }
        catch (NullPointerException nullPointerException) {
            return null;
        }
    }

    public Object recreateObject(Element element, Design design, boolean bl) {
        Object object;
        DesignObject designObject;
        String string;
        int n;
        String string2;
        String string3 = element.getAttribute("id");
        DesignObject designObject2 = design.getDesignObject(string3);
        if (designObject2 == null) {
            designObject2 = this.instantiateDesignObject(string3, design, element);
        }
        if ((string2 = element.getAttribute("imported_id")) != null && !"".equalsIgnoreCase(string2)) {
            designObject2.setImportedId(string2);
        }
        this.readBasicObjectInfo(element, designObject2, bl);
        if (!(designObject2 instanceof TableView) && !(designObject2 instanceof EntityView)) {
            this.readObjectInfo(element, designObject2, bl);
        }
        this.readColorInfo(element, designObject2);
        Map map = this.getProperties(element, "documents");
        Object[] objectArray = map.keySet().toArray();
        for (n = 0; n < objectArray.length; ++n) {
            string = (String)map.get(objectArray[n]);
            designObject = design.getDesignObject(string);
            if (designObject == null) continue;
            designObject2.addDocument((BIDocument)designObject);
        }
        map = this.getProperties(element, "parties");
        objectArray = map.keySet().toArray();
        for (n = 0; n < objectArray.length; ++n) {
            string = (String)map.get(objectArray[n]);
            designObject = design.getDesignObject(string);
            if (designObject == null) continue;
            designObject2.addResponsibleParty((BIResponsibleParty)designObject);
        }
        map = this.getProperties(element, "changerequests");
        objectArray = map.keySet().toArray();
        for (n = 0; n < objectArray.length; ++n) {
            string = (String)map.get(objectArray[n]);
            designObject = design.getDesignObject(string);
            if (designObject == null) continue;
            designObject2.addRequest((ChangeRequest)designObject);
        }
        if (AbstractRXMLDesignObject.getFirstChildByTagName(element, "measurements") != null) {
            NodeList nodeList = AbstractRXMLDesignObject.getFirstChildByTagName(element, "measurements").getElementsByTagName("object");
            int n2 = nodeList.getLength();
            for (int i = 0; i < n2; ++i) {
                Element element2 = (Element)nodeList.item(i);
                String string4 = element2.getAttribute("id");
                object = (Measurement)design.getDesignObject(string4);
                if (object != null) continue;
                object = this.instantiateMeasurement(element2.getAttribute("id"), design, designObject2, element2);
                this.readMeasurementInfo(element2, (Measurement)object, bl, design, designObject2);
            }
        }
        if (designObject2 instanceof AbstractMDObject) {
            AbstractMDObject abstractMDObject = (AbstractMDObject)designObject2;
            Map map2 = this.getProperties(element, "oracle_names");
            String string5 = (String)map2.get("oracle_short_name");
            if (string5 != null) {
                abstractMDObject.setOracleShortName(string5);
            }
            if ((string5 = (String)map2.get("oracle_long_name")) != null) {
                abstractMDObject.setOracleLongName(string5);
            }
            if ((string5 = (String)map2.get("oracle_plural_name")) != null) {
                abstractMDObject.setOraclePluralName(string5);
            }
            if ((string5 = (String)map2.get("name_in_oracle_aw")) != null) {
                abstractMDObject.setNameInOracleAW(string5);
            }
        }
        this.readFontsInfo(element, designObject2);
        if (designObject2 instanceof ContainerObject) {
            ContainerObject containerObject = (ContainerObject)designObject2;
            Element element3 = AbstractRXMLDesignObject.getFirstChildByTagName(element, "contained");
            if (element3 != null) {
                Object object2;
                Object object3;
                NodeList nodeList = element3.getElementsByTagName("object");
                int n3 = nodeList.getLength();
                for (int i = 0; i < n3; ++i) {
                    object = (Element)nodeList.item(i);
                    String string6 = object.getAttribute("type");
                    if ("Measurement".equalsIgnoreCase(string6)) continue;
                    object3 = object.getAttribute("id");
                    object2 = (ContainedObject)design.getDesignObject((String)object3);
                    if (object2 == null) {
                        object2 = this.instantiateContainedObject((String)object3, design, containerObject, (Element)object);
                    }
                    if (object2 == null) continue;
                    this.readBasicContainedObjectInfo((Element)object, (ContainedObject)object2, bl, design, containerObject);
                    this.readContainedObjectInfo((Element)object, (ContainedObject)object2, bl);
                    this.readContainedObjectInfo((Element)object, containerObject, (ContainedObject)object2, bl);
                }
                if (containerObject instanceof TableView) {
                    this.readGroupBy(element, "groupby", containerObject, ((AbstractView)containerObject).getGroupByList());
                    this.readOrderBy(element, containerObject);
                } else if (containerObject instanceof EntityView) {
                    this.readGroupBy(element, "groupby", containerObject, ((AbstractView)containerObject).getGroupByList());
                    this.readOrderBy(element, containerObject);
                }
                if (designObject2 instanceof ContainerWithKeyObject) {
                    KeyObject keyObject;
                    ContainerWithKeyObject containerWithKeyObject = (ContainerWithKeyObject)designObject2;
                    object = AbstractRXMLDesignObject.getFirstChildByTagName(element, "key").getElementsByTagName("object");
                    n3 = object.getLength();
                    for (int i = 0; i < n3; ++i) {
                        object3 = (Element)object.item(i);
                        object2 = object3.getAttribute("type");
                        if ("Measurement".equalsIgnoreCase((String)object2)) continue;
                        String string7 = object3.getAttribute("id");
                        KeyObject keyObject2 = (KeyObject)design.getDesignObject(string7);
                        if (keyObject2 == null) {
                            keyObject2 = this.instantiateKeyObject(string7, containerWithKeyObject);
                        }
                        this.readBasicKeyObjectInfo((Element)object3, keyObject2, bl);
                        this.readKeyObjectInfo((Element)object3, keyObject2, bl);
                    }
                    if (containerWithKeyObject.isBST() && (keyObject = containerWithKeyObject.getPK()) != null && keyObject.getElementsCollection().size() == 1 && ((ContainedObject)(object3 = keyObject.getElement(0))).isOid()) {
                        keyObject.setOidKey(true);
                    }
                }
            }
        }
        return designObject2;
    }

    private void readMeasurementInfo(Element element, Measurement measurement, boolean bl, Design design, DesignObject designObject) {
        String string;
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Node node;
        this.readBasicObjectInfo(element, measurement, bl);
        Element element2 = AbstractRXMLDesignObject.getFirstChildByTagName(element, "value");
        if (element2 != null && (node = element2.getFirstChild()) != null && (object4 = node.getNodeValue()) != null) {
            measurement.setValue(StringUtilities.decodeAttributeValue((String)object4));
        }
        if ((node = AbstractRXMLDesignObject.getFirstChildByTagName(element, "unit")) != null && (object4 = node.getFirstChild()) != null && (object3 = object4.getNodeValue()) != null) {
            measurement.setUnit(StringUtilities.decodeAttributeValue((String)object3));
        }
        if ((object4 = AbstractRXMLDesignObject.getFirstChildByTagName(element, "sort")) != null && (object3 = object4.getFirstChild()) != null && (object2 = object3.getNodeValue()) != null) {
            measurement.setType(StringUtilities.decodeAttributeValue((String)object2));
        }
        if ((object3 = AbstractRXMLDesignObject.getFirstChildByTagName(element, "creationTime")) != null && (object2 = object3.getFirstChild()) != null && (object = object2.getNodeValue()) != null) {
            measurement.setCreationDate(StringUtilities.decodeAttributeValue((String)object));
        }
        if ((object2 = AbstractRXMLDesignObject.getFirstChildByTagName(element, "effectiveTime")) != null && (object = object2.getFirstChild()) != null && (string = object.getNodeValue()) != null) {
            measurement.setEffectiveDate(StringUtilities.decodeAttributeValue(string));
        }
    }

    private Measurement instantiateMeasurement(String string, Design design, DesignObject designObject, Element element) {
        Measurement measurement = new Measurement(designObject.getDesignPart());
        measurement.setObjectID(string);
        measurement.setDesign(designObject.getDesign());
        measurement.setObject(designObject);
        designObject.addMeasurement(measurement);
        return measurement;
    }

    protected void readContainedObjectInfo(Element element, ContainedObject containedObject, boolean bl) {
    }

    protected void readContainedObjectInfo(Element element, ContainerObject containerObject, ContainedObject containedObject, boolean bl) {
    }

    protected void readBasicContainedObjectInfo(Element element, ContainedObject containedObject, boolean bl, Design design, ContainerObject containerObject) {
        DesignObject designObject;
        String string;
        int n;
        boolean bl2;
        this.readBasicObjectInfo(element, containedObject, bl);
        String string2 = element.getAttribute("unique");
        if (string2 != null) {
            containedObject.setUnique(Boolean.valueOf(string2));
        }
        if ((string2 = element.getAttribute("allownull")) != null) {
            bl2 = Boolean.valueOf(string2);
            containedObject.setNullsAllowed(bl2);
        }
        if ((string2 = element.getAttribute("constraint_name")) != null) {
            containedObject.setConstraintName(StringUtilities.decodeAttributeValue(string2));
        }
        if ((string2 = element.getAttribute("usedomainconstraints")) != null) {
            bl2 = Boolean.valueOf(string2);
            containedObject.setUseDomainConstraints(bl2);
        }
        if ((string2 = element.getAttribute("is_oid")) != null) {
            bl2 = Boolean.valueOf(string2);
            containedObject.setOid(bl2);
        }
        if ((string2 = element.getAttribute("structured_attribute_id")) != null) {
            containedObject.setStructAttributeID(string2);
        }
        if ((string2 = element.getAttribute("synonym")) != null) {
            containedObject.setSynonym(StringUtilities.decodeAttributeValue(String.valueOf(string2)));
        }
        if (!containedObject.getUseDomainConstraints()) {
            this.readConstraint(element, containedObject);
            this.readAVT(element, containedObject);
        }
        if ((string2 = element.getAttribute("fk")) != null && Boolean.valueOf(string2).booleanValue()) {
            String string3 = element.getAttribute("references");
            containedObject.setReferedAttribute(string3);
            if (containerObject.getReferIDMap() != null) {
                containerObject.getReferIDMap().put(string3, containedObject.getObjectID());
            }
            design.getFKMap().put(containedObject.getObjectID(), containedObject.getName());
        }
        if (containedObject instanceof ContainedObjectWithDomain) {
            this.readBasicContainedObjectWithDomainInfo(element, (ContainedObjectWithDomain)containedObject, bl);
        }
        Map map = this.getProperties(element, "documents");
        Object[] objectArray = map.keySet().toArray();
        for (n = 0; n < objectArray.length; ++n) {
            string = (String)map.get(objectArray[n]);
            designObject = design.getDesignObject(string);
            if (designObject == null) continue;
            containedObject.addDocument((BIDocument)designObject);
        }
        map = this.getProperties(element, "parties");
        objectArray = map.keySet().toArray();
        for (n = 0; n < objectArray.length; ++n) {
            string = (String)map.get(objectArray[n]);
            designObject = design.getDesignObject(string);
            if (designObject == null) continue;
            containedObject.addResponsibleParty((BIResponsibleParty)designObject);
        }
        map = this.getProperties(element, "changerequests");
        objectArray = map.keySet().toArray();
        for (n = 0; n < objectArray.length; ++n) {
            string = (String)map.get(objectArray[n]);
            designObject = design.getDesignObject(string);
            if (designObject == null) continue;
            containedObject.addRequest((ChangeRequest)designObject);
        }
        if (AbstractRXMLDesignObject.getFirstChildByTagName(element, "measurements") != null) {
            NodeList nodeList = AbstractRXMLDesignObject.getFirstChildByTagName(element, "measurements").getElementsByTagName("object");
            int n2 = nodeList.getLength();
            for (int i = 0; i < n2; ++i) {
                Element element2 = (Element)nodeList.item(i);
                String string4 = element2.getAttribute("id");
                Measurement measurement = (Measurement)design.getDesignObject(string4);
                if (measurement != null) continue;
                measurement = this.instantiateMeasurement(element2.getAttribute("id"), design, containedObject, element2);
                this.readMeasurementInfo(element2, measurement, bl, design, containedObject);
            }
        }
    }

    protected void readConstraint(Element element, ContainedObject containedObject) {
        NodeList nodeList = element.getElementsByTagName("constraint");
        if (nodeList.getLength() > 0) {
            Element element2 = (Element)nodeList.item(0);
            String string = element2.getAttribute("type");
            Constraint constraint = containedObject.getDesign().getConstraintSet().createConstraint(string);
            this.readConstraintInfo(element2, constraint);
            this.readPropertiesListLocateRoot(element2, constraint);
            if (string.equalsIgnoreCase("check constraint")) {
                this.readPropertiesListLocateRoot(element2, constraint);
                containedObject.setCheck((CheckConstraint)constraint);
            } else if (string.equalsIgnoreCase("enumerated String")) {
                this.readConstraintEnumerationList(element2, (ConstraintEnumeration)constraint);
                containedObject.setValueList((ConstraintEnumeration)constraint);
            }
            if (nodeList.getLength() > 1) {
                element2 = (Element)nodeList.item(1);
                string = element2.getAttribute("type");
                constraint = containedObject.getDesign().getConstraintSet().createConstraint(string);
                this.readConstraintInfo(element2, constraint);
                this.readPropertiesListLocateRoot(element2, constraint);
                if (string.equalsIgnoreCase("check constraint")) {
                    containedObject.setCheck((CheckConstraint)constraint);
                } else if (string.equalsIgnoreCase("enumerated String")) {
                    this.readConstraintEnumerationList(element2, (ConstraintEnumeration)constraint);
                    containedObject.setValueList((ConstraintEnumeration)constraint);
                }
            }
        }
    }

    private void readConstraintEnumerationList(Element element, ConstraintEnumeration constraintEnumeration) {
        NodeList nodeList = element.getElementsByTagName("properties");
        if (nodeList.getLength() > 0) {
            this.readConstraintEnumeration((Element)nodeList.item(0), constraintEnumeration);
        }
    }

    private void readConstraintEnumeration(Element element, ConstraintEnumeration constraintEnumeration) {
        NodeList nodeList = element.getElementsByTagName("parameter");
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            Element element2 = (Element)nodeList.item(i);
            String string = element2.getAttribute("value");
            String string2 = element2.getAttribute("desc");
            constraintEnumeration.add(string, string2);
        }
    }

    protected void readConstraintInfo(Element element, Constraint constraint) {
        try {
            Element element2 = AbstractRXMLDesignObject.getFirstChildByTagName(element, "name");
            if (element2 != null && element2.getFirstChild() != null) {
                String string = element2.getFirstChild().getNodeValue();
                constraint.setName(string);
            }
        }
        catch (Exception exception) {
            LOGGER.warn(exception.getMessage(), exception);
        }
    }

    protected void readAVT(Element element, ContainedObject containedObject) {
        NodeList nodeList;
        int n;
        String string = element.getAttribute("avt_sort_order");
        if (!"".equalsIgnoreCase(string)) {
            try {
                int n2 = Integer.parseInt(string);
                containedObject.setAVTSortOrder(n2);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if ((n = (nodeList = element.getElementsByTagName("avt")).getLength()) > 0) {
            for (int i = 0; i < n; ++i) {
                String string2;
                Element element2 = (Element)nodeList.item(i);
                AVT aVT = null;
                Element element3 = AbstractRXMLDesignObject.getFirstChildByTagName(element2, "beginvalue");
                if (element3 != null && element3.getFirstChild() != null && (string2 = element3.getFirstChild().getNodeValue()) != null) {
                    aVT = new AVT(StringUtilities.decodeAttributeValue(string2), "", "");
                }
                if ((element3 = AbstractRXMLDesignObject.getFirstChildByTagName(element2, "endvalue")) != null && element3.getFirstChild() != null && (string2 = element3.getFirstChild().getNodeValue()) != null) {
                    if (aVT != null) {
                        aVT.setEndValue(StringUtilities.decodeAttributeValue(string2));
                    } else {
                        aVT = new AVT("", StringUtilities.decodeAttributeValue(string2), "");
                    }
                }
                if ((element3 = AbstractRXMLDesignObject.getFirstChildByTagName(element2, "description")) != null && element3.getFirstChild() != null && (string2 = element3.getFirstChild().getNodeValue()) != null) {
                    if (aVT != null) {
                        aVT.setDescription(StringUtilities.decodeAttributeValue(string2));
                    } else {
                        aVT = new AVT("", "", StringUtilities.decodeAttributeValue(string2));
                    }
                }
                if (aVT == null) continue;
                containedObject.addAVT(aVT);
            }
        }
    }

    protected final void readBasicContainedObjectWithDomainInfo(Element element, ContainedObjectWithDomain containedObjectWithDomain, boolean bl) {
        Element element2 = AbstractRXMLDesignObject.getFirstChildByTagName(element, "domain");
        if (element2 != null) {
            String string = element2.getAttribute("oid");
            String string2 = element2.getAttribute("file");
            if (string2 != null && string != null) {
                Domain domain = containedObjectWithDomain.getDesign().getLoadDomain(string, string2);
                containedObjectWithDomain.setDomain(domain);
            }
        }
    }

    protected void readKeyObjectInfo(Element element, KeyObject keyObject, boolean bl) {
    }

    protected void readBasicKeyObjectInfo(Element element, KeyObject keyObject, boolean bl) {
        Object object;
        int n;
        Object object2;
        Object[] objectArray;
        Object object3;
        Object object4;
        this.readBasicObjectInfo(element, keyObject, bl);
        ContainerObject containerObject = keyObject.getTopLevelContainer();
        NodeList nodeList = element.getElementsByTagName("contains");
        int n2 = nodeList.getLength();
        for (int i = 0; i < n2; ++i) {
            object4 = (Element)nodeList.item(i);
            object3 = object4.getFirstChild().getNodeValue();
            objectArray = containerObject.getElementByID((String)object3);
            if (objectArray == null) continue;
            keyObject.add((ContainedObject)objectArray);
            if (!(keyObject instanceof Index)) continue;
            String string = object4.getAttribute("sortorder");
            object2 = (Index)keyObject;
            ((Index)object2).setColumnSortOrder(objectArray, string.length() > 0 ? string : "ASC");
        }
        String string = "";
        if (AbstractRXMLDesignObject.getFirstChildByTagName(element, "functional") != null && AbstractRXMLDesignObject.getFirstChildByTagName(element, "functional").getFirstChild() != null) {
            string = AbstractRXMLDesignObject.getFirstChildByTagName(element, "functional").getFirstChild().getNodeValue();
        }
        if (Boolean.valueOf(element.getAttribute("pk")).booleanValue()) {
            keyObject.makePK();
        }
        if (keyObject instanceof CandidateKey) {
            ((CandidateKey)keyObject).setKeyState(element.getAttribute("keystate"));
            ((CandidateKey)keyObject).setSynonym(StringUtilities.decodeAttributeValue(element.getAttribute("synonym")));
        } else if (keyObject instanceof Index) {
            ((Index)keyObject).setIndexState(element.getAttribute("indexstate"));
            ((Index)keyObject).setIndexExpression(string);
        }
        object4 = keyObject.getDesign();
        object3 = this.getProperties(element, "documents");
        objectArray = object3.keySet().toArray();
        for (n = 0; n < objectArray.length; ++n) {
            object2 = (String)object3.get(objectArray[n]);
            object = ((Design)object4).getDesignObject((String)object2);
            if (object == null) continue;
            keyObject.addDocument((BIDocument)object);
        }
        object3 = this.getProperties(element, "parties");
        objectArray = object3.keySet().toArray();
        for (n = 0; n < objectArray.length; ++n) {
            object2 = (String)object3.get(objectArray[n]);
            object = ((Design)object4).getDesignObject((String)object2);
            if (object == null) continue;
            keyObject.addResponsibleParty((BIResponsibleParty)object);
        }
        object3 = this.getProperties(element, "changerequests");
        objectArray = object3.keySet().toArray();
        for (n = 0; n < objectArray.length; ++n) {
            object2 = (String)object3.get(objectArray[n]);
            object = ((Design)object4).getDesignObject((String)object2);
            if (object == null) continue;
            keyObject.addRequest((ChangeRequest)object);
        }
        if (AbstractRXMLDesignObject.getFirstChildByTagName(element, "measurements") != null) {
            NodeList nodeList2 = AbstractRXMLDesignObject.getFirstChildByTagName(element, "measurements").getElementsByTagName("object");
            n2 = nodeList2.getLength();
            for (int i = 0; i < n2; ++i) {
                object = (Element)nodeList2.item(i);
                String string2 = object.getAttribute("id");
                Measurement measurement = (Measurement)((Design)object4).getDesignObject(string2);
                if (measurement != null) continue;
                measurement = this.instantiateMeasurement(object.getAttribute("id"), (Design)object4, keyObject, (Element)object);
                this.readMeasurementInfo((Element)object, measurement, bl, (Design)object4, keyObject);
            }
        }
    }

    @Override
    protected void readBasicObjectInfo(Element element, ModelIDObject modelIDObject, boolean bl) {
        super.readBasicObjectInfo(element, modelIDObject, bl);
        NodeList nodeList = element.getElementsByTagName("engineering");
        if (nodeList.getLength() > 0) {
            Element element2 = (Element)nodeList.item(0);
            if (((DesignObject)modelIDObject).getDesignPart() instanceof LogicalDesign) {
                NodeList nodeList2 = element2.getElementsByTagName("relational_design");
                for (int i = 0; i < nodeList2.getLength(); ++i) {
                    Element element3 = (Element)nodeList2.item(i);
                    String string = element3.getAttribute("id");
                    boolean bl2 = Boolean.valueOf(element3.getAttribute("should"));
                    ((DesignObject)modelIDObject).setEngineerTo(string, bl2);
                }
            } else {
                String string = element2.getAttribute("should");
                if (string != null && string.equals(VALUE_TRUE)) {
                    modelIDObject.setShouldEngineer(true);
                } else {
                    modelIDObject.setShouldEngineer(false);
                }
            }
        }
    }

    protected void recreateScript(Element element, ContainerObject containerObject) {
        containerObject.setBeforeDrop(this.getElementValue(element, "beforeDrop"));
        containerObject.setBeforeCreate(this.getElementValue(element, "beforeCreate"));
        containerObject.setBeforeAlter(this.getElementValue(element, "beforeAlter"));
        containerObject.setAfterCreate(this.getElementValue(element, "afterCreate"));
        containerObject.setAfterAlter(this.getElementValue(element, "afterAlter"));
        containerObject.setEndOfScript(this.getElementValue(element, "endOfScript"));
        containerObject.setShouldGenerateScript(this.getElementBooleanValue(element, "include_in_ddl", false));
    }

    private String getElementValue(Element element, String string) {
        return this.getElementRawValue(element, string, "");
    }

    private boolean getElementBooleanValue(Element element, String string, boolean bl) {
        return Boolean.parseBoolean(this.getElementRawValue(element, string, String.valueOf(bl)));
    }

    private String getElementRawValue(Element element, String string, String string2) {
        Element element2;
        String string3 = string2;
        NodeList nodeList = element.getElementsByTagName(string);
        if (nodeList.getLength() > 0 && (element2 = (Element)nodeList.item(0)) != null) {
            string3 = element2.getAttribute("value");
            string3 = StringUtilities.decodeAttributeValue(string3);
        }
        return string3;
    }

    protected void readOrderBy(Element element, ContainerObject containerObject) {
    }

    protected void readGroupBy(Element element, String string, ContainerObject containerObject, List list) {
    }
}

