/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.persistence.db.oracle;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import oracle.dbtools.crest.model.ChangeRequest;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.businessinfo.BIContact;
import oracle.dbtools.crest.model.businessinfo.BIDocument;
import oracle.dbtools.crest.model.businessinfo.BIEmail;
import oracle.dbtools.crest.model.businessinfo.BILocation;
import oracle.dbtools.crest.model.businessinfo.BIPhone;
import oracle.dbtools.crest.model.businessinfo.BIResourceLocator;
import oracle.dbtools.crest.model.businessinfo.BIResponsibleParty;
import oracle.dbtools.crest.model.design.AbstractLevelDomains;
import oracle.dbtools.crest.model.design.ConnectionInterface;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.Domain;
import oracle.dbtools.crest.model.design.LogicalDatatypeSet;
import oracle.dbtools.crest.model.design.Note;
import oracle.dbtools.crest.model.design.datatypes.CollectionType;
import oracle.dbtools.crest.model.design.datatypes.DistinctType;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;
import oracle.dbtools.crest.model.design.multidimensional.AbstractMDObject;
import oracle.dbtools.crest.model.design.multidimensional.FactEntitiesJoin;
import oracle.dbtools.crest.model.design.process.AbstractProcessObject;
import oracle.dbtools.crest.model.design.process.TransformationPackage;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.storage.RDBMSSiteSet;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.persistence.ObjectTypes;
import oracle.dbtools.crest.model.persistence.db.AbstractRepositoryManager;
import oracle.dbtools.crest.model.persistence.db.RepDeleteDescr;
import oracle.dbtools.crest.model.persistence.db.RepositoryObject;
import oracle.dbtools.crest.model.persistence.db.oracle.AbstractDBWriter;
import oracle.dbtools.crest.model.persistence.db.oracle.DB_COntainerObjWriter;
import oracle.dbtools.crest.model.persistence.db.oracle.DB_ConnectorObjWriter;
import oracle.dbtools.crest.model.persistence.db.oracle.DB_DomainObjWriter;
import oracle.dbtools.crest.model.persistence.db.oracle.DB_LogicalTypesObjWriter;
import oracle.dbtools.crest.model.persistence.db.oracle.DB_PhysObjWriter;
import oracle.dbtools.crest.model.persistence.db.oracle.DB_RDBMSSitesObjWriter;
import oracle.dbtools.crest.model.persistence.db.oracle.DB_XMappingWriter;
import oracle.dbtools.crest.model.persistence.db.oracle.OracleRepositoryManager;
import oracle.dbtools.crest.model.placeholder.DesignPartViewPlaceHolder;
import oracle.dbtools.crest.model.xtdmapping.ExtendedMap;
import oracle.dbtools.crest.model.xtdmapping.XtdMapping;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.util.GUID;
import oracle.dbtools.crest.util.TimeLog;
import oracle.jdbc.OraclePreparedStatement;
import oracle.sql.BLOB;

public class WriteManager {
    private OracleRepositoryManager repositoryManager;
    private Map writers = new TreeMap();
    private DB_COntainerObjWriter coWriter;
    private DB_ConnectorObjWriter connectorWriter;
    private DB_DomainObjWriter dmWriter;
    private DB_LogicalTypesObjWriter ldtWriter;
    private DB_RDBMSSitesObjWriter rdbmsWriter;
    private List rollbackList = new ArrayList();
    private List dirtyList = new ArrayList();
    private DB_XMappingWriter xmappingWriter;
    private DB_PhysObjWriter physObjWriter;

    public WriteManager(OracleRepositoryManager oracleRepositoryManager) {
        this.repositoryManager = oracleRepositoryManager;
        this.initWriters();
    }

    private void initWriters() {
        this.coWriter = new DB_COntainerObjWriter(this.repositoryManager);
        this.connectorWriter = new DB_ConnectorObjWriter(this.repositoryManager);
        this.dmWriter = new DB_DomainObjWriter(this.repositoryManager);
        this.ldtWriter = new DB_LogicalTypesObjWriter(this.repositoryManager);
        this.xmappingWriter = new DB_XMappingWriter(this.repositoryManager);
        this.physObjWriter = new DB_PhysObjWriter(this.repositoryManager);
        this.rdbmsWriter = new DB_RDBMSSitesObjWriter(this.repositoryManager);
    }

    public OracleRepositoryManager getRepositoryManager() {
        return this.repositoryManager;
    }

    public void writeDesignPart(DesignPart designPart) {
        boolean bl = false;
        try {
            boolean bl2 = false;
            if (designPart.getRepositoryOID() == null) {
                this.writePackageRecord(designPart.getObjectTypeName(), designPart);
                bl2 = true;
            }
            List list = (List)designPart.getStorableDesignObjects();
            list = this.getObjectsToStore(list, bl2);
            List list2 = this.getNewObjects(list);
            if (list.size() > 0) {
                this.writeObjects(list, designPart);
                this.writePackageMembers(designPart.getRepositoryOID(), designPart.getRepositoryOVID(), list2);
            }
            this.writeSubviews(designPart, bl2);
            if (!bl2 && designPart.isCheckedOutByMe() && designPart.isDirty()) {
                this.updatePackageRecord(designPart.getObjectTypeName(), designPart);
            }
            if (designPart.isCheckedOutByMe()) {
                this.removeDeleted(designPart.getObjectsToDeleteFromRepository(), designPart.getRepositoryOVID(), false);
            }
            designPart.createRepositoryMap();
            if (designPart instanceof RelationalDesign) {
                this.writePhysicalModels((RelationalDesign)designPart);
            }
        }
        catch (SQLException sQLException) {
            bl = true;
        }
        catch (RuntimeException runtimeException) {
            bl = true;
        }
        if (!bl) {
            designPart.setDirty(false);
        }
    }

    public void writePhysicalModels(RelationalDesign relationalDesign) throws SQLException {
        StorageDesign[] storageDesignArray = relationalDesign.getStorageDesignFactory().getOpenStorageDesigns();
        ArrayList<StorageDesign> arrayList = new ArrayList<StorageDesign>();
        for (int i = 0; i < storageDesignArray.length; ++i) {
            if (!storageDesignArray[i].isOpen()) continue;
            this.writePhysicalModel(storageDesignArray[i]);
            arrayList.add(storageDesignArray[i]);
        }
        if (arrayList.size() > 0) {
            this.writePackageMembers(relationalDesign.getRepositoryOID(), relationalDesign.getRepositoryOVID(), arrayList);
        }
    }

    public void writePhysicalModel(StorageDesign storageDesign) {
        TimeLog.log();
        System.out.println("Save SD to DB start " + System.currentTimeMillis());
        boolean bl = false;
        try {
            boolean bl2 = false;
            if (storageDesign.getRepositoryOID() == null) {
                this.writePhysModelRecord(storageDesign);
                bl2 = true;
            }
            List list = storageDesign.getStorableObjects();
            list = this.getObjectsToStore(list, bl2);
            List list2 = this.getNewObjects(list);
            if (list.size() > 0) {
                this.writeObjects(list, "");
                this.writePackageMembers(storageDesign.getRepositoryOID(), storageDesign.getRepositoryOVID(), list2);
            }
            if (!bl2 && storageDesign.isCheckedOutByMe() && storageDesign.isDirty()) {
                this.updatePackageRecord(storageDesign.getObjectTypeName(), storageDesign);
            }
            this.removeDeleted(storageDesign.getObjectsToDeleteFromRepository(), storageDesign.getRepositoryOVID(), true);
            storageDesign.createRepositoryMap();
        }
        catch (SQLException sQLException) {
            bl = true;
        }
        catch (RuntimeException runtimeException) {
            bl = true;
        }
        if (!bl) {
            storageDesign.setDirty(false);
        }
        TimeLog.log();
        System.out.println("Save SD to DB end " + System.currentTimeMillis());
    }

    public void writeDomains(AbstractLevelDomains abstractLevelDomains) {
        boolean bl = false;
        try {
            List list = abstractLevelDomains.getDomains();
            list = this.getPackageMembersToStore(list);
            List list2 = this.getNewObjects(list);
            if (list.size() > 0) {
                this.writeObjects(list, "");
                this.writePackageMembers(abstractLevelDomains.getRepositoryOID(), abstractLevelDomains.getRepositoryOVID(), list2);
            }
            this.removeDeleted(abstractLevelDomains.getObjectsToDeleteFromRepository(), abstractLevelDomains.getRepositoryOVID(), false);
            abstractLevelDomains.createRepositoryMap();
        }
        catch (SQLException sQLException) {
            bl = true;
        }
        catch (RuntimeException runtimeException) {
            bl = true;
        }
        if (!bl) {
            abstractLevelDomains.setDirty(false);
        }
    }

    private List getObjectsToStore(List list, boolean bl) {
        ArrayList<RepositoryObject> arrayList = new ArrayList<RepositoryObject>();
        for (RepositoryObject repositoryObject : list) {
            if (AbstractRepositoryManager.INITIAL_WRITE_TODB || bl) {
                arrayList.add(repositoryObject);
                continue;
            }
            if (repositoryObject.getRepositoryOID() == null) {
                if (repositoryObject instanceof DesignObject) {
                    if (!((DesignObject)repositoryObject).getDesignPart().isCheckedOutByMe()) continue;
                    arrayList.add(repositoryObject);
                    continue;
                }
                if (!(repositoryObject instanceof StorageObject)) continue;
                arrayList.add(repositoryObject);
                continue;
            }
            if (!repositoryObject.isDirty() || !repositoryObject.isCheckedOutByMe()) continue;
            arrayList.add(repositoryObject);
        }
        return arrayList;
    }

    private List getPackageMembersToStore(List list) {
        ArrayList<ModelIDObject> arrayList = new ArrayList<ModelIDObject>();
        for (ModelIDObject modelIDObject : list) {
            if (AbstractRepositoryManager.INITIAL_WRITE_TODB) {
                arrayList.add(modelIDObject);
                continue;
            }
            if (modelIDObject.getRepositoryOID() == null) {
                arrayList.add(modelIDObject);
                continue;
            }
            if (!modelIDObject.isDirty() || !modelIDObject.isCheckedOutByMe()) continue;
            arrayList.add(modelIDObject);
        }
        return arrayList;
    }

    private List getNewObjects(List list) {
        ArrayList<RepositoryObject> arrayList = new ArrayList<RepositoryObject>();
        for (RepositoryObject repositoryObject : list) {
            if (repositoryObject.getRepositoryOID() != null) continue;
            arrayList.add(repositoryObject);
        }
        return arrayList;
    }

    public void writeXMap(ExtendedMap extendedMap) {
        boolean bl = false;
        try {
            boolean bl2 = false;
            if (extendedMap.getRepositoryOID() == null) {
                this.writeXMapPackageRecord(extendedMap);
                bl2 = true;
            }
            List list = extendedMap.getAllMappings();
            list = this.getObjectsToStore(list, bl2);
            List list2 = this.getNewObjects(list);
            if (list.size() > 0) {
                this.writeObjects(list, ObjectTypes.XMAPPING);
                this.writePackageMembers(extendedMap.getRepositoryOID(), extendedMap.getRepositoryOVID(), list2);
            }
        }
        catch (SQLException sQLException) {
            bl = true;
        }
        catch (RuntimeException runtimeException) {
            bl = true;
        }
        if (!bl) {
            // empty if block
        }
    }

    public void writeObject(RepositoryObject repositoryObject) {
        if (repositoryObject instanceof Design) {
            if (repositoryObject.getRepositoryOID() == null) {
                throw new RuntimeException("Design should be saved using writeDesign(Design design) of OracleRepositoryManager");
            }
            this.getRepositoryManager().writeDesign((Design)repositoryObject);
            repositoryObject.setDirty(false);
            return;
        }
        if (repositoryObject instanceof DesignPartView || repositoryObject instanceof DesignPart) {
            String string = this.getRepositoryManager().getObjectType(repositoryObject);
            if (repositoryObject.getRepositoryOID() == null) {
                DesignPart designPart;
                if (repositoryObject instanceof DesignPartView) {
                    if (((DesignPartView)repositoryObject).getDesignPart().isCheckedOutByMe()) {
                        try {
                            this.writePackageRecord(string, repositoryObject);
                            repositoryObject.setDirty(false);
                        }
                        catch (SQLException sQLException) {}
                    }
                } else if (repositoryObject instanceof DesignPart && (designPart = (DesignPart)repositoryObject).getDesign().isCheckedOutByMe()) {
                    this.writeDesignPart(designPart);
                }
            } else if (repositoryObject instanceof DesignPart) {
                DesignPart designPart = (DesignPart)repositoryObject;
                this.writeDesignPart(designPart);
            } else if (repositoryObject.isCheckedOutByMe() && repositoryObject.isDirty()) {
                try {
                    this.updatePackageRecord(string, repositoryObject);
                    repositoryObject.setDirty(false);
                }
                catch (SQLException sQLException) {}
            }
        } else if (repositoryObject instanceof RDBMSSiteSet || repositoryObject instanceof LogicalDatatypeSet) {
            String string = this.getRepositoryManager().getObjectType(repositoryObject);
            if (repositoryObject.getRepositoryOID() == null) {
                if (repositoryObject.isCheckedOutByMe()) {
                    try {
                        this.writePackageRecord(string, repositoryObject);
                        repositoryObject.setDirty(false);
                    }
                    catch (SQLException sQLException) {}
                }
            } else if (repositoryObject.isCheckedOutByMe() && repositoryObject.isDirty()) {
                try {
                    this.updatePackageRecord(string, repositoryObject);
                    repositoryObject.setDirty(false);
                }
                catch (SQLException sQLException) {}
            }
        } else if (repositoryObject instanceof StorageDesign) {
            this.writePhysicalModel((StorageDesign)repositoryObject);
        } else {
            AbstractDBWriter abstractDBWriter = this.getWriterFor(repositoryObject);
            if (abstractDBWriter != null) {
                abstractDBWriter.writeObject(repositoryObject);
            }
        }
    }

    private void writeTransformationPackage(TransformationPackage transformationPackage) throws SQLException {
        boolean bl = false;
        if (transformationPackage.getRepositoryOID() == null) {
            this.writePackageRecord(transformationPackage.getObjectTypeName(), transformationPackage);
            bl = true;
        }
        Iterator iterator = transformationPackage.getTransformationTaskSet().iterator();
        ArrayList<DesignPart> arrayList = new ArrayList<DesignPart>();
        while (iterator.hasNext()) {
            DesignPart designPart = (DesignPart)iterator.next();
            if (designPart.getRepositoryOID() == null) {
                arrayList.add(designPart);
            }
            this.writeDesignPart(designPart);
        }
        if (arrayList.size() > 0) {
            this.writePackageMembers(transformationPackage.getRepositoryOID(), transformationPackage.getRepositoryOVID(), arrayList);
        }
        if (!bl && transformationPackage.isCheckedOutByMe() && transformationPackage.isDirty()) {
            this.updatePackageRecord(transformationPackage.getObjectTypeName(), transformationPackage);
        }
    }

    public void writeObjects(List list, String string) throws SQLException {
        if (list.size() > 0) {
            Object e = list.get(0);
            if (e instanceof TransformationPackage) {
                this.writeTransformationPackage((TransformationPackage)e);
            } else {
                AbstractDBWriter abstractDBWriter = this.getWriterFor(e);
                if (abstractDBWriter != null) {
                    abstractDBWriter.writeObjects(list);
                }
            }
        }
    }

    public void writeObjects(List list, DesignPart designPart) throws SQLException {
        Object object;
        Object object22;
        TreeMap<Object, ArrayList<Object>> treeMap = new TreeMap<Object, ArrayList<Object>>();
        for (Object object22 : list) {
            object = this.getRepositoryManager().getObjectType(object22);
            ArrayList<Object> arrayList = (ArrayList<Object>)treeMap.get(object);
            if (arrayList == null) {
                arrayList = new ArrayList<Object>();
                treeMap.put(object, arrayList);
            }
            arrayList.add(object22);
        }
        Iterator iterator = designPart.getTypeOrder().iterator();
        while (iterator.hasNext()) {
            object22 = (String)iterator.next();
            object = (List)treeMap.get(object22);
            if (object == null || object.size() <= 0) continue;
            this.writeObjects((List)object, (String)object22);
            treeMap.remove(object22);
        }
        while (iterator.hasNext()) {
            object22 = (String)iterator.next();
            object = (List)treeMap.get(object22);
            if (object == null || object.size() <= 0) continue;
            this.writeObjects((List)object, (String)object22);
            treeMap.remove(object22);
        }
    }

    private AbstractDBWriter getWriterFor(Object object) {
        DB_COntainerObjWriter dB_COntainerObjWriter;
        String string = ObjectTypes.getObjectType(object);
        if (!ObjectTypes.UNKNOWN.equals(string) && (dB_COntainerObjWriter = (DB_COntainerObjWriter)this.writers.get(string)) == null) {
            if (object instanceof ContainerObject || object instanceof StructuredType || object instanceof CollectionType || object instanceof DistinctType || object instanceof FactEntitiesJoin || (object instanceof AbstractMDObject || object instanceof AbstractProcessObject) && !(object instanceof ConnectionInterface) || object instanceof BIEmail || object instanceof BILocation || object instanceof BIPhone || object instanceof BIResourceLocator || object instanceof BIContact || object instanceof BIResponsibleParty || object instanceof BIDocument || object instanceof Note || object instanceof ChangeRequest) {
                return this.coWriter;
            }
            if (object instanceof LogicalDatatypeSet) {
                return this.ldtWriter;
            }
            if (object instanceof RDBMSSiteSet) {
                return this.rdbmsWriter;
            }
            if (object instanceof Domain) {
                return this.dmWriter;
            }
            if (object instanceof ConnectionInterface) {
                return this.connectorWriter;
            }
            if (object instanceof XtdMapping) {
                return this.xmappingWriter;
            }
            if (object instanceof StorageObject) {
                return this.physObjWriter;
            }
        }
        return null;
    }

    public void writePackageRecord(String string, RepositoryObject repositoryObject) throws SQLException {
        String string2 = this.getRepositoryManager().getXML(repositoryObject);
        String string3 = "null";
        OraclePreparedStatement oraclePreparedStatement = null;
        try {
            String string4;
            String string5;
            String string6;
            boolean bl = false;
            string3 = repositoryObject.getName();
            Connection connection = this.getRepositoryManager().getConnection();
            String string7 = OracleRepositoryManager.T_PACKAGES;
            String string8 = repositoryObject.getRepositoryOID();
            if (string8 == null) {
                string8 = new GUID().toString();
                bl = true;
            }
            if ((string6 = repositoryObject.getRepositoryOVID()) == null) {
                string6 = new GUID().toString();
            }
            if (repositoryObject instanceof Design) {
                string5 = ((Design)repositoryObject).getComment();
                string4 = "insert into " + string7 + " ( name,type, OID, OVID, created_by,date_created,short_description,v_sequence,xml_content) values ('" + string3 + "' ,'" + string + "','" + string8 + "', '" + string6 + "', user, sysdate,'" + string5 + "',1,? )";
            } else {
                string4 = "insert into " + string7 + " ( name,type, OID, OVID, created_by,date_created,v_sequence,xml_content) values ('" + string3 + "' ,'" + string + "','" + string8 + "', '" + string6 + "', user, sysdate,1,? )";
            }
            oraclePreparedStatement = (OraclePreparedStatement)connection.prepareStatement(string4);
            string5 = AbstractDBWriter.getBLOB(string2, connection);
            oraclePreparedStatement.setObject(1, (Object)string5);
            int n = oraclePreparedStatement.executeUpdate();
            if (n == 1) {
                this.assignRepositoryIDs(repositoryObject, string8, string6);
                boolean bl2 = repositoryObject instanceof StorageObject;
                WriteManager.registerObject(string8, string6, connection, bl2);
                if (bl && repositoryObject instanceof DesignPartView) {
                    repositoryObject.setCheckedOut(false);
                    repositoryObject.setCheckedOutByMe(false);
                }
                this.clearDirtyFlag(repositoryObject);
            }
        }
        catch (SQLException sQLException) {
            throw sQLException;
        }
        finally {
            if (oraclePreparedStatement != null) {
                oraclePreparedStatement.close();
            }
        }
    }

    public void writePhysModelRecord(StorageDesign storageDesign) throws SQLException {
        String string = this.getRepositoryManager().getXML(storageDesign);
        String string2 = "null";
        OraclePreparedStatement oraclePreparedStatement = null;
        try {
            String string3;
            boolean bl = false;
            string2 = storageDesign.getName();
            Connection connection = this.getRepositoryManager().getConnection();
            String string4 = OracleRepositoryManager.T_PHYSMODELS;
            String string5 = storageDesign.getRepositoryOID();
            if (string5 == null) {
                string5 = new GUID().toString();
                bl = true;
            }
            if ((string3 = storageDesign.getRepositoryOVID()) == null) {
                string3 = new GUID().toString();
            }
            String string6 = storageDesign.getPhysicalDesign().getRepositoryOID();
            String string7 = storageDesign.getRDBMSSite().getObjectID();
            String string8 = String.valueOf(storageDesign.getRDBMSSite().getType().getType());
            String string9 = "insert into " + string4 + " ( name, Reational_Model, DB_Site, DB_Type, OID, OVID, created_by,date_created,v_sequence,xml_content) values ('" + string2 + "' ,'" + string6 + "','" + string7 + "','" + string8 + "','" + string5 + "', '" + string3 + "', user, sysdate,1,? )";
            oraclePreparedStatement = (OraclePreparedStatement)connection.prepareStatement(string9);
            BLOB bLOB = AbstractDBWriter.getBLOB(string, connection);
            oraclePreparedStatement.setObject(1, (Object)bLOB);
            int n = oraclePreparedStatement.executeUpdate();
            if (n == 1) {
                this.assignRepositoryIDs(storageDesign, string5, string3);
                WriteManager.registerObject(string5, string3, connection, true);
                this.clearDirtyFlag(storageDesign);
            }
        }
        catch (SQLException sQLException) {
            throw sQLException;
        }
        finally {
            if (oraclePreparedStatement != null) {
                oraclePreparedStatement.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeXMapPackageRecord(ExtendedMap extendedMap) throws SQLException {
        Object var2_2 = null;
        String string = "ExtendedMap";
        OraclePreparedStatement oraclePreparedStatement = null;
        try {
            String string2;
            boolean bl = false;
            Connection connection = this.getRepositoryManager().getConnection();
            String string3 = OracleRepositoryManager.T_PACKAGES;
            String string4 = extendedMap.getRepositoryOID();
            if (string4 == null) {
                string4 = new GUID().toString();
                bl = true;
            }
            if ((string2 = extendedMap.getRepositoryOVID()) == null) {
                string2 = new GUID().toString();
            }
            String string5 = "insert into " + string3 + " ( name,type, OID, OVID, created_by,date_created,v_sequence,xml_content) values ('" + string + "' ,'" + extendedMap.getName() + "','" + string4 + "', '" + string2 + "', user, sysdate,1,? )";
            oraclePreparedStatement = (OraclePreparedStatement)connection.prepareStatement(string5);
            Object var11_12 = null;
            oraclePreparedStatement.setObject(1, var11_12);
            int n = oraclePreparedStatement.executeUpdate();
            if (n == 1) {
                if (extendedMap.getRepositoryOID() == null) {
                    extendedMap.setRepositoryOID(string4);
                    extendedMap.setRepositoryOVID(string2);
                }
                WriteManager.registerObject(string4, string2, connection, false);
            }
        }
        catch (SQLException sQLException) {
        }
        finally {
            if (oraclePreparedStatement != null) {
                oraclePreparedStatement.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updatePackageRecord(String string, RepositoryObject repositoryObject) throws SQLException {
        String string2 = this.getRepositoryManager().getXML(repositoryObject);
        String string3 = "null";
        OraclePreparedStatement oraclePreparedStatement = null;
        try {
            String string4;
            String string5;
            string3 = repositoryObject.getName();
            Connection connection = this.getRepositoryManager().getConnection();
            String string6 = OracleRepositoryManager.T_PACKAGES;
            if (repositoryObject instanceof StorageDesign) {
                string6 = OracleRepositoryManager.T_PHYSMODELS;
            }
            if ((string5 = repositoryObject.getRepositoryOID()) == null) {
                string5 = new GUID().toString();
            }
            if ((string4 = repositoryObject.getRepositoryOVID()) == null) {
                string4 = new GUID().toString();
            }
            String string7 = "update " + string6 + " set name = ?, changed_by = user, date_changed = sysdate, xml_content = ? " + " where ovid = ?";
            oraclePreparedStatement = (OraclePreparedStatement)connection.prepareStatement(string7);
            BLOB bLOB = AbstractDBWriter.getBLOB(string2, connection);
            oraclePreparedStatement.setString(1, string3);
            oraclePreparedStatement.setObject(2, (Object)bLOB);
            oraclePreparedStatement.setString(3, string4);
            int n = oraclePreparedStatement.executeUpdate();
            if (n > 0) {
                repositoryObject.setDirty(false);
            }
        }
        finally {
            if (oraclePreparedStatement != null) {
                oraclePreparedStatement.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updatePackageRecords(String string, List list) throws SQLException {
        String string2 = "null";
        Statement statement = null;
        try {
            for (RepositoryObject repositoryObject : list) {
                Object object;
                String string3;
                String string4 = this.getRepositoryManager().getXML(repositoryObject);
                string2 = repositoryObject.getName();
                Connection connection = this.getRepositoryManager().getConnection();
                String string5 = OracleRepositoryManager.T_PACKAGES;
                String string6 = repositoryObject.getRepositoryOID();
                if (string6 == null) {
                    string6 = new GUID().toString();
                }
                if ((string3 = repositoryObject.getRepositoryOVID()) == null) {
                    string3 = new GUID().toString();
                }
                if (statement == null) {
                    object = "update " + string5 + " set name = ?, changed_by = user, date_changed = sysdate, xml_content = ? " + " where ovid = ?";
                    statement = connection.prepareStatement((String)object);
                }
                object = AbstractDBWriter.getBLOB(string4, connection);
                statement.setString(1, string2);
                statement.setObject(2, object);
                statement.setString(3, string3);
                int n = statement.executeUpdate();
                if (n <= 0) continue;
                repositoryObject.setDirty(false);
            }
        }
        finally {
            if (statement != null) {
                statement.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writePackageRecords(String string, List list) throws SQLException {
        String string2 = "null";
        Statement statement = null;
        try {
            for (RepositoryObject repositoryObject : list) {
                Object object;
                String string3;
                String string4 = this.getRepositoryManager().getXML(repositoryObject);
                string2 = repositoryObject.getName();
                Connection connection = this.getRepositoryManager().getConnection();
                String string5 = OracleRepositoryManager.T_PACKAGES;
                String string6 = repositoryObject.getRepositoryOID();
                if (string6 == null) {
                    string6 = new GUID().toString();
                }
                if ((string3 = repositoryObject.getRepositoryOVID()) == null) {
                    string3 = new GUID().toString();
                }
                if (statement == null) {
                    object = "insert into " + string5 + " ( name,type, OID, OVID, created_by,date_created,v_sequence,xml_content) values (? ,'" + string + "',?, ?, user, sysdate,1,? )";
                    statement = connection.prepareStatement((String)object);
                }
                object = AbstractDBWriter.getBLOB(string4, connection);
                statement.setString(1, string2);
                statement.setString(2, string6);
                statement.setString(3, string3);
                statement.setObject(4, object);
                int n = statement.executeUpdate();
                if (n != 1) continue;
                this.assignRepositoryIDs(repositoryObject, string6, string3);
                WriteManager.registerObject(string6, string3, connection, false);
                this.clearDirtyFlag(repositoryObject);
            }
        }
        finally {
            if (statement != null) {
                statement.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writePackageMembers(String string, String string2, List list) throws SQLException {
        if (list.size() > 0) {
            Connection connection = this.getRepositoryManager().getConnection();
            Statement statement = null;
            try {
                Object e = list.get(0);
                String string3 = OracleRepositoryManager.T_PACKAGE_MEMBERS;
                if (e instanceof StorageObject) {
                    string3 = OracleRepositoryManager.T_PHYSMODELS_MEMBERS;
                }
                String string4 = "insert into " + string3 + " ( type, OID, created_by,date_created,OWNERSHIP_FLAG,parent_oid,parent_ovid) values (?,?,user, sysdate,'Y','" + string + "','" + string2 + "' )";
                statement = (OraclePreparedStatement)connection.prepareStatement(string4);
                for (RepositoryObject repositoryObject : list) {
                    String string5 = repositoryObject.getRepositoryOID();
                    String string6 = repositoryObject.getRepositoryOVID();
                    if (string5 == null || string6 == null) {
                        throw new RuntimeException("Object " + repositoryObject.getName() + "should be saved before added to package");
                    }
                    statement.setString(1, this.getRepositoryManager().getObjectType(repositoryObject));
                    statement.setString(2, string5);
                    int n = statement.executeUpdate();
                    if (n != 1) continue;
                }
            }
            finally {
                if (statement != null) {
                    statement.close();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerObject(String string, String string2, Connection connection, boolean bl) throws SQLException {
        Statement statement = null;
        String string3 = OracleRepositoryManager.T_OBJECT_REGISTER;
        if (bl) {
            string3 = OracleRepositoryManager.T_PM_OBJECT_REGISTER;
        }
        try {
            String string4 = "insert into " + string3 + " (oid,last_version) values('" + string + "','" + string2 + "')";
            statement = connection.createStatement();
            statement.executeUpdate(string4);
        }
        finally {
            if (statement != null) {
                statement.close();
            }
        }
    }

    public static void registerObject(String string, String string2, PreparedStatement preparedStatement) throws SQLException {
        preparedStatement.setString(1, string);
        preparedStatement.setString(2, string2);
        preparedStatement.executeUpdate();
    }

    public static PreparedStatement prepareRegisterStatement(Connection connection, boolean bl) throws SQLException {
        PreparedStatement preparedStatement = null;
        String string = OracleRepositoryManager.T_OBJECT_REGISTER;
        if (bl) {
            string = OracleRepositoryManager.T_PM_OBJECT_REGISTER;
        }
        String string2 = "insert into " + string + " (oid,last_version) values(?,?)";
        preparedStatement = connection.prepareStatement(string2);
        return preparedStatement;
    }

    private void writeSubviews(DesignPart designPart, boolean bl) {
        ArrayList<DesignPartView> arrayList = new ArrayList<DesignPartView>();
        ArrayList<DesignPartView> arrayList2 = new ArrayList<DesignPartView>();
        DesignPartView designPartView = designPart.getMainView();
        String string = null;
        if (designPartView != null) {
            string = designPartView.getRepositoryOID();
        }
        try {
            if (designPartView != null && designPartView.isStorable() && (string == null || AbstractRepositoryManager.INITIAL_WRITE_TODB)) {
                if (designPart.isCheckedOutByMe() || AbstractRepositoryManager.INITIAL_WRITE_TODB || bl) {
                    this.writePackageRecord("MainView", designPartView);
                    arrayList.add(designPartView);
                    this.writePackageMembers(designPart.getRepositoryOID(), designPart.getRepositoryOVID(), arrayList);
                    arrayList.clear();
                }
            } else if (designPartView != null && designPartView.isStorable() && designPartView.isCheckedOutByMe() && designPartView.isDirty()) {
                this.updatePackageRecord("MainView", designPartView);
            }
            Iterator iterator = designPart.getDesignSubviews().iterator();
            while (iterator.hasNext()) {
                DesignPartViewPlaceHolder designPartViewPlaceHolder = (DesignPartViewPlaceHolder)iterator.next();
                designPartView = designPartViewPlaceHolder.getDesignPartView();
                if (!designPartView.isStorable()) continue;
                string = designPartView.getRepositoryOID();
                if (string == null || AbstractRepositoryManager.INITIAL_WRITE_TODB) {
                    if (!designPart.isCheckedOutByMe() && !AbstractRepositoryManager.INITIAL_WRITE_TODB && !bl) continue;
                    arrayList.add(designPartView);
                    continue;
                }
                if (!designPartView.isCheckedOutByMe() || !designPartViewPlaceHolder.isDirty()) continue;
                arrayList2.add(designPartView);
            }
            if (arrayList.size() > 0) {
                this.writePackageRecords("SubView", arrayList);
                this.writePackageMembers(designPart.getRepositoryOID(), designPart.getRepositoryOVID(), arrayList);
            }
            if (arrayList2.size() > 0) {
                this.updatePackageRecords("SubView", arrayList2);
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public void writeRepSet(RepositoryObject repositoryObject) {
        String string = repositoryObject.getRepositoryOID();
        try {
            if (string == null || AbstractRepositoryManager.INITIAL_WRITE_TODB) {
                if (repositoryObject.isCheckedOutByMe() || AbstractRepositoryManager.INITIAL_WRITE_TODB) {
                    this.writePackageRecord(repositoryObject.getName(), repositoryObject);
                }
            } else if (repositoryObject.isCheckedOutByMe() && repositoryObject.isDirty()) {
                this.updatePackageRecord(repositoryObject.getName(), repositoryObject);
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeDeleted(List list, String string, boolean bl) throws SQLException {
        int n = 0;
        if (list.size() > 0 && string != null) {
            Statement statement = null;
            try {
                Object object2;
                Connection connection = this.getRepositoryManager().getConnection();
                String string2 = OracleRepositoryManager.T_PACKAGE_MEMBERS;
                if (bl) {
                    string2 = OracleRepositoryManager.T_PHYSMODELS_MEMBERS;
                }
                String string3 = "(";
                boolean bl2 = true;
                for (Object object2 : list) {
                    if (bl2) {
                        bl2 = false;
                        string3 = string3 + "'" + ((RepDeleteDescr)object2).repOID + "'";
                        continue;
                    }
                    string3 = string3 + ",'" + ((RepDeleteDescr)object2).repOID + "'";
                }
                string3 = string3 + ")";
                object2 = "delete from " + string2 + " where parent_ovid = '" + string + "' and oid in " + string3;
                statement = connection.createStatement();
                n = statement.executeUpdate((String)object2);
            }
            finally {
                if (statement != null) {
                    statement.close();
                }
            }
        }
    }

    public void assignRepositoryIDs(RepositoryObject repositoryObject, String string, String string2) {
        if (repositoryObject.getRepositoryOID() == null) {
            repositoryObject.setRepositoryOID(string);
            repositoryObject.setRepositoryOVID(string2);
            this.rollbackList.add(repositoryObject);
        }
    }

    public void rollbackIDs() {
        for (RepositoryObject repositoryObject : this.rollbackList) {
            repositoryObject.setRepositoryOID(null);
            repositoryObject.setRepositoryOVID(null);
        }
        this.rollbackList.clear();
    }

    public void clearDirtyFlag(RepositoryObject repositoryObject) {
        if (repositoryObject.isDirty()) {
            repositoryObject.setDirty(false);
            this.dirtyList.add(repositoryObject);
        }
    }

    public void rollbackDirtyFlag() {
        for (RepositoryObject repositoryObject : this.dirtyList) {
            repositoryObject.setDirty(true);
        }
        this.dirtyList.clear();
    }

    public List writeChangeRequests(Design design) throws SQLException {
        List list = new ArrayList();
        List list2 = new ArrayList();
        design.getChangeRequestSet().addAllElementsTo(list2);
        list2 = this.getObjectsToStore(list2, false);
        list = this.getNewObjects(list2);
        this.writeObjects(list2, "ChangeRequest");
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateDLSettingsRecord(Design design, String string) throws SQLException {
        String string2 = string;
        OraclePreparedStatement oraclePreparedStatement = null;
        try {
            Connection connection = this.getRepositoryManager().getConnection();
            String string3 = OracleRepositoryManager.T_DL_SETTINGS;
            String string4 = design.getRepositoryOID();
            if (string4 != null) {
                String string5 = design.getRepositoryOVID();
                String string6 = "update " + string3 + " set changed_by = user, date_changed = sysdate, xml_content = ? " + " where Design_ovid = ?";
                oraclePreparedStatement = (OraclePreparedStatement)connection.prepareStatement(string6);
                BLOB bLOB = AbstractDBWriter.getBLOB(string2, connection);
                oraclePreparedStatement.setObject(1, (Object)bLOB);
                oraclePreparedStatement.setString(2, string5);
                int n = oraclePreparedStatement.executeUpdate();
                if (n > 0) {
                    // empty if block
                }
            }
        }
        finally {
            if (oraclePreparedStatement != null) {
                oraclePreparedStatement.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void createDLSettingsRecord(Design design, String string) throws SQLException {
        String string2 = string;
        OraclePreparedStatement oraclePreparedStatement = null;
        try {
            Connection connection = this.getRepositoryManager().getConnection();
            String string3 = OracleRepositoryManager.T_DL_SETTINGS;
            String string4 = design.getRepositoryOID();
            if (string4 != null) {
                String string5 = design.getRepositoryOVID();
                String string6 = "insert into " + string3 + " (type, Design_OID, Design_OVID,created_by,date_created,v_sequence,xml_content)  values('Design','" + string4 + "', '" + string5 + "', user, sysdate,1,? )";
                oraclePreparedStatement = (OraclePreparedStatement)connection.prepareStatement(string6);
                BLOB bLOB = AbstractDBWriter.getBLOB(string2, connection);
                oraclePreparedStatement.setObject(1, (Object)bLOB);
                int n = oraclePreparedStatement.executeUpdate();
                if (n > 0) {
                    // empty if block
                }
            }
        }
        finally {
            if (oraclePreparedStatement != null) {
                oraclePreparedStatement.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean existsDLSettings(String string) throws SQLException {
        Connection connection = this.getRepositoryManager().getConnection();
        Statement statement = null;
        ResultSet resultSet = null;
        boolean bl = false;
        try {
            String string2 = OracleRepositoryManager.T_DL_SETTINGS;
            String string3 = "select 1 from " + string2 + " where Design_ovid = '" + string + "'";
            statement = connection.createStatement();
            resultSet = statement.executeQuery(string3);
            if (resultSet.next()) {
                resultSet.getString(1);
                bl = true;
            }
        }
        finally {
            if (resultSet != null) {
                resultSet.close();
            }
            if (statement != null) {
                statement.close();
            }
        }
        return bl;
    }

    public void writeDLSettings(Design design, String string) {
        String string2 = design.getRepositoryOVID();
        try {
            if (string2 != null) {
                if (this.existsDLSettings(string2)) {
                    this.updateDLSettingsRecord(design, string);
                } else {
                    this.createDLSettingsRecord(design, string);
                }
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }
}

