/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.persistence.db.oracle;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.InflaterInputStream;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.design.AbstractLevelDomains;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.Domain;
import oracle.dbtools.crest.model.design.multidimensional.MultidimensionalDesign;
import oracle.dbtools.crest.model.design.process.DataFlowDesign;
import oracle.dbtools.crest.model.design.process.ProcessModel;
import oracle.dbtools.crest.model.design.process.TransformationPackage;
import oracle.dbtools.crest.model.design.process.TransformationTask;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.persistence.ObjectTypes;
import oracle.dbtools.crest.model.persistence.db.AbstractRepositoryManager;
import oracle.dbtools.crest.model.persistence.db.RepositoryObject;
import oracle.dbtools.crest.model.persistence.db.oracle.OracleRepositoryManager;
import oracle.dbtools.crest.model.persistence.xml.AbstractXMLHandler;
import oracle.dbtools.crest.model.persistence.xml.AbstractXMLReader;
import oracle.dbtools.crest.model.persistence.xml.RXMLSubview;
import oracle.dbtools.crest.model.persistence.xml.storage.AbstractRXMLStorageDesign;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.ProgressDialog;
import oracle.dbtools.crest.util.TimeLog;
import oracle.sql.BLOB;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ReadManager {
    private OracleRepositoryManager repositoryManager;
    private String[] dpOrder = new String[]{"Business Information", "Data Types", "LogicalDesign", "RelationalModel", "Process Model", "TransformationPackage", "Data Flow Diagram"};
    int count = 0;

    public ReadManager(OracleRepositoryManager oracleRepositoryManager) {
        this.repositoryManager = oracleRepositoryManager;
    }

    public OracleRepositoryManager getRepositoryManager() {
        return this.repositoryManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readDesignPartObjects(DesignPart designPart, String string, String string2) throws SQLException {
        List list = new ArrayList<String>();
        Connection connection = this.getRepositoryManager().getConnection();
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            String string3 = "select distinct m.type from " + OracleRepositoryManager.T_PACKAGE_MEMBERS + " m where parent_OVID = '" + string2 + "'";
            statement = connection.createStatement();
            resultSet = statement.executeQuery(string3);
            while (resultSet.next()) {
                String string4 = resultSet.getString(1);
                list.add(string4);
            }
        }
        finally {
            if (resultSet != null) {
                resultSet.close();
            }
            if (statement != null) {
                statement.close();
            }
        }
        list = designPart.getOrderedTypes(list);
        for (String string4 : list) {
            this.readDesignPartObjects(designPart, string, string2, string4);
        }
    }

    public void readChangerequests(Design design) throws SQLException {
        String string = design.getRepositoryOID();
        String string2 = design.getRepositoryOVID();
        if (string != null && string2 != null) {
            this.readDesignPartObjects(null, string, string2, "ChangeRequest");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readDesignPartObjects(DesignPart designPart, String string, String string2, String string3) throws SQLException {
        AbstractXMLReader abstractXMLReader = this.getRepositoryManager().getXMReader(string3);
        int n = 0;
        if (abstractXMLReader != null) {
            String string4 = this.getRepositoryManager().getUser();
            String string5 = this.getRepositoryManager().getTableName(string3);
            Connection connection = this.getRepositoryManager().getConnection();
            Statement statement = null;
            ResultSet resultSet = null;
            try {
                String string6 = "select m.type,m.oid,d.ovid, r.check_out_version, r.checkout_by,d.xml_content from " + OracleRepositoryManager.T_PACKAGE_MEMBERS + " m, " + OracleRepositoryManager.T_OBJECT_REGISTER + " r, " + string5 + " d where m.type = '" + string3 + "' and m.parent_OVID = '" + string2 + "'  and m.oid = r.oid and r.last_version = d.ovid and (r.check_out_version is null or  r.check_out_version is not null and r.checkout_by <> user)";
                string6 = string6 + " union all " + "select m.type,m.oid,d.ovid, r.check_out_version, r.checkout_by,d.xml_content from " + OracleRepositoryManager.T_PACKAGE_MEMBERS + " m, " + OracleRepositoryManager.T_OBJECT_REGISTER + " r, " + string5 + " d where m.type = '" + string3 + "' and  m.parent_OVID = '" + string2 + "'  and m.oid = r.oid and r.check_out_version = d.ovid and r.check_out_version is not null and r.checkout_by = user";
                statement = connection.createStatement();
                resultSet = statement.executeQuery(string6);
                while (resultSet.next()) {
                    String string7 = resultSet.getString(1);
                    String string8 = resultSet.getString(2);
                    String string9 = resultSet.getString(3);
                    String string10 = resultSet.getString(4);
                    String string11 = resultSet.getString(5);
                    BLOB bLOB = (BLOB)resultSet.getBlob(6);
                    String string12 = null;
                    ++n;
                    try {
                        Object object;
                        if (bLOB != null) {
                            string12 = ReadManager.getString(bLOB);
                        }
                        Object object2 = null;
                        if (string12 != null) {
                            if ("TransformationPackage".equalsIgnoreCase(string3)) {
                                object2 = this.readTransformationPackage(designPart.getDesign(), string8, string9, string12);
                            } else {
                                object = OracleRepositoryManager.getDocument(string12);
                                if (designPart != null && string3.equalsIgnoreCase("Note")) {
                                    String string13 = this.getAttributeForObject((Document)object, "id");
                                    designPart.recreateNote(string13);
                                }
                                object2 = abstractXMLReader instanceof RXMLSubview && (string3.equalsIgnoreCase(ObjectTypes.SUBVIEW) || string3.equalsIgnoreCase(ObjectTypes.MAINVIEW)) ? ((RXMLSubview)abstractXMLReader).recreateObject((Document)object, designPart, false) : abstractXMLReader.recreateObject((Document)object, this.getRepositoryManager().getDesign(), false);
                            }
                        }
                        if (object2 != null && object2 instanceof RepositoryObject) {
                            object = (RepositoryObject)object2;
                            object.setRepositoryOID(string8);
                            object.setRepositoryOVID(string9);
                            if (string10 != null) {
                                object.setCheckedOut(true);
                            } else {
                                object.setCheckedOut(false);
                            }
                            if (string11 == null) {
                                string11 = "";
                            }
                            object.setCheckedOutBy(string11);
                            if (object.isCheckedOut() && string4 != null && string4.equalsIgnoreCase(string11)) {
                                object.setCheckedOutByMe(true);
                            } else {
                                object.setCheckedOutByMe(false);
                            }
                            object.setDirty(false);
                        }
                        if (!(object2 instanceof DesignPartView)) continue;
                        object = (DesignPartView)object2;
                        ((DesignPartView)object).setCheckedOutByMe(((DesignPartView)object).isCheckedOutByMe());
                        ((DesignPartView)object2).getPlaceHolder().setDirty(false);
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                }
            }
            finally {
                if (resultSet != null) {
                    resultSet.close();
                }
                if (statement != null) {
                    statement.close();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readTransformationTasks(TransformationPackage transformationPackage, Design design, String string, String string2) throws SQLException {
        String string3 = "TransformationTask";
        AbstractXMLReader abstractXMLReader = design.getAppView().getPersistenceManager().getTransformationTaskReader();
        int n = 0;
        if (abstractXMLReader != null) {
            String string4 = this.getRepositoryManager().getUser();
            String string5 = OracleRepositoryManager.T_PACKAGES;
            Connection connection = this.getRepositoryManager().getConnection();
            Statement statement = null;
            ResultSet resultSet = null;
            try {
                String string6 = "select m.type,m.oid,d.ovid, r.check_out_version, r.checkout_by,d.xml_content from " + OracleRepositoryManager.T_PACKAGE_MEMBERS + " m, " + OracleRepositoryManager.T_OBJECT_REGISTER + " r, " + string5 + " d where m.type = '" + string3 + "' and m.parent_OVID = '" + string2 + "'  and m.oid = r.oid and r.last_version = d.ovid and (r.check_out_version is null or  r.check_out_version is not null and r.checkout_by <> user)";
                string6 = string6 + " union all " + "select m.type,m.oid,d.ovid, r.check_out_version, r.checkout_by,d.xml_content from " + OracleRepositoryManager.T_PACKAGE_MEMBERS + " m, " + OracleRepositoryManager.T_OBJECT_REGISTER + " r, " + string5 + " d where m.type = '" + string3 + "' and  m.parent_OVID = '" + string2 + "'  and m.oid = r.oid and r.check_out_version = d.ovid and r.check_out_version is not null and r.checkout_by = user";
                statement = connection.createStatement();
                resultSet = statement.executeQuery(string6);
                while (resultSet.next()) {
                    String string7 = resultSet.getString(1);
                    String string8 = resultSet.getString(2);
                    String string9 = resultSet.getString(3);
                    String string10 = resultSet.getString(4);
                    String string11 = resultSet.getString(5);
                    BLOB bLOB = (BLOB)resultSet.getBlob(6);
                    String string12 = null;
                    ++n;
                    if (bLOB != null) {
                        try {
                            string12 = ReadManager.getString(bLOB);
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    Document document = OracleRepositoryManager.getDocument(string12);
                    String string13 = this.getAttributeForDesign(document, "id");
                    TransformationTask transformationTask = transformationPackage.createTransformationTask(string13);
                    this.readDesignPartObjects(transformationTask, string8, string9);
                    if ((transformationTask = (TransformationTask)abstractXMLReader.recreateDesign(document, (DesignPart)transformationTask, false)) == null || !(transformationTask instanceof RepositoryObject)) continue;
                    TransformationTask transformationTask2 = transformationTask;
                    transformationTask2.setRepositoryOID(string8);
                    transformationTask2.setRepositoryOVID(string9);
                    if (string10 != null) {
                        transformationTask2.setCheckedOut(true);
                    } else {
                        transformationTask2.setCheckedOut(false);
                    }
                    if (string11 == null) {
                        string11 = "";
                    }
                    transformationTask2.setCheckedOutBy(string11);
                    if (transformationTask2.isCheckedOut() && string4 != null && string4.equalsIgnoreCase(string11)) {
                        transformationTask2.setCheckedOutByMe(true);
                    } else {
                        transformationTask2.setCheckedOutByMe(false);
                    }
                    transformationTask2.setDirty(false);
                    transformationTask.getMainView().setDirty(false);
                }
            }
            finally {
                if (resultSet != null) {
                    resultSet.close();
                }
                if (statement != null) {
                    statement.close();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readRepSet(RepositoryObject repositoryObject) throws SQLException {
        String string = repositoryObject.getName();
        AbstractXMLReader abstractXMLReader = this.getRepositoryManager().getXMReader(string);
        int n = 0;
        if (abstractXMLReader != null) {
            String string2 = this.getRepositoryManager().getUser();
            Connection connection = this.getRepositoryManager().getConnection();
            Statement statement = null;
            ResultSet resultSet = null;
            try {
                String string3 = "select m.type, m.oid, m.ovid, r.check_out_version, r.checkout_by, m.xml_content from " + OracleRepositoryManager.T_PACKAGES + " m, " + OracleRepositoryManager.T_OBJECT_REGISTER + " r where m.type = '" + string + "' and m.oid = r.oid and r.last_version = m.ovid and (r.check_out_version is null or  r.check_out_version is not null and r.checkout_by <> user)";
                string3 = string3 + " union all " + "select m.type, m.oid, m.ovid, r.check_out_version, r.checkout_by, m.xml_content from " + OracleRepositoryManager.T_PACKAGES + " m, " + OracleRepositoryManager.T_OBJECT_REGISTER + " r where m.type = '" + string + "' and m.oid = r.oid and r.check_out_version = m.ovid and r.check_out_version is not null and r.checkout_by = user";
                statement = connection.createStatement();
                resultSet = statement.executeQuery(string3);
                while (resultSet.next()) {
                    String string4 = resultSet.getString(2);
                    String string5 = resultSet.getString(3);
                    String string6 = resultSet.getString(4);
                    String string7 = resultSet.getString(5);
                    BLOB bLOB = (BLOB)resultSet.getBlob(6);
                    String string8 = null;
                    ++n;
                    if (bLOB != null) {
                        try {
                            string8 = ReadManager.getString(bLOB);
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    Document document = OracleRepositoryManager.getDocument(string8);
                    Object object = null;
                    object = abstractXMLReader.recreateObject(document, this.getRepositoryManager().getDesign(), false);
                    if (object != null && object instanceof RepositoryObject) {
                        RepositoryObject repositoryObject2 = (RepositoryObject)object;
                        repositoryObject2.setRepositoryOID(string4);
                        repositoryObject2.setRepositoryOVID(string5);
                        if (string6 != null) {
                            repositoryObject2.setCheckedOut(true);
                        } else {
                            repositoryObject2.setCheckedOut(false);
                        }
                        if (string7 == null) {
                            string7 = "";
                        }
                        repositoryObject2.setCheckedOutBy(string7);
                        if (repositoryObject2.isCheckedOut() && string2 != null && string2.equalsIgnoreCase(string7)) {
                            repositoryObject2.setCheckedOutByMe(true);
                        } else {
                            repositoryObject2.setCheckedOutByMe(false);
                        }
                    }
                    if (object == null || !(object instanceof RepositoryObject)) continue;
                    ((RepositoryObject)object).setDirty(false);
                }
            }
            finally {
                if (resultSet != null) {
                    resultSet.close();
                }
                if (statement != null) {
                    statement.close();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readStorageObjects(StorageDesign storageDesign, String string, String string2) throws SQLException {
        AbstractXMLReader abstractXMLReader = storageDesign.getAppView().getPersistenceManager().getReaderFor(storageDesign);
        if (abstractXMLReader != null && abstractXMLReader instanceof AbstractRXMLStorageDesign) {
            String string3 = this.getRepositoryManager().getUser();
            String string4 = OracleRepositoryManager.T_PHYSICAL_OBJECTS;
            Connection connection = this.getRepositoryManager().getConnection();
            Statement statement = null;
            ResultSet resultSet = null;
            try {
                String string5 = "select m.type,m.oid,d.ovid, r.check_out_version, r.checkout_by,d.xml_content from " + OracleRepositoryManager.T_PHYSMODELS_MEMBERS + " m, " + OracleRepositoryManager.T_PM_OBJECT_REGISTER + " r, " + string4 + " d where m.type ='" + string2 + "' and m.parent_OVID = '" + string + "'  and m.oid = r.oid and r.last_version = d.ovid and (r.check_out_version is null or  r.check_out_version is not null and r.checkout_by <> user)";
                string5 = string5 + " union all " + "select m.type,m.oid,d.ovid, r.check_out_version, r.checkout_by,d.xml_content from " + OracleRepositoryManager.T_PHYSMODELS_MEMBERS + " m, " + OracleRepositoryManager.T_PM_OBJECT_REGISTER + " r, " + string4 + " d where m.type ='" + string2 + "' and m.parent_OVID = '" + string + "'  and m.oid = r.oid and r.check_out_version = d.ovid and r.check_out_version is not null and r.checkout_by = user";
                statement = connection.createStatement();
                resultSet = statement.executeQuery(string5);
                while (resultSet.next()) {
                    String string6 = resultSet.getString(1);
                    String string7 = resultSet.getString(2);
                    String string8 = resultSet.getString(3);
                    String string9 = resultSet.getString(4);
                    String string10 = resultSet.getString(5);
                    BLOB bLOB = (BLOB)resultSet.getBlob(6);
                    String string11 = null;
                    if (bLOB != null) {
                        try {
                            string11 = ReadManager.getString(bLOB);
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    Document document = OracleRepositoryManager.getDocument(string11);
                    StorageObject storageObject = null;
                    storageObject = ((AbstractRXMLStorageDesign)abstractXMLReader).recreateStorageObject(document, string6, storageDesign, true);
                    ++this.count;
                    if (storageObject == null || !(storageObject instanceof RepositoryObject)) continue;
                    RepositoryObject repositoryObject = storageObject;
                    repositoryObject.setRepositoryOID(string7);
                    repositoryObject.setRepositoryOVID(string8);
                    if (string9 != null) {
                        repositoryObject.setCheckedOut(true);
                    } else {
                        repositoryObject.setCheckedOut(false);
                    }
                    if (string10 == null) {
                        string10 = "";
                    }
                    repositoryObject.setCheckedOutBy(string10);
                    if (repositoryObject.isCheckedOut() && string3 != null && string3.equalsIgnoreCase(string10)) {
                        repositoryObject.setCheckedOutByMe(true);
                    } else {
                        repositoryObject.setCheckedOutByMe(false);
                    }
                    repositoryObject.setDirty(false);
                }
            }
            finally {
                if (resultSet != null) {
                    resultSet.close();
                }
                if (statement != null) {
                    statement.close();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readDomains(Design design, AbstractLevelDomains abstractLevelDomains) throws SQLException {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        String string = OracleRepositoryManager.T_DOMAINS;
        Connection connection = this.getRepositoryManager().getConnection();
        Statement statement = null;
        ResultSet resultSet = null;
        String string2 = abstractLevelDomains.getRepositoryOVID();
        String string3 = "Domain";
        try {
            Domain domain;
            String string4 = this.getRepositoryManager().getUser();
            String string5 = "select m.type,m.oid,d.ovid, r.check_out_version, r.checkout_by,d.xml_content from " + OracleRepositoryManager.T_PACKAGE_MEMBERS + " m, " + OracleRepositoryManager.T_OBJECT_REGISTER + " r, " + string + " d where m.type = '" + string3 + "' and m.parent_OVID = '" + string2 + "'  and m.oid = r.oid and r.last_version = d.ovid and (r.check_out_version is null or  r.check_out_version is not null and r.checkout_by <> user)";
            string5 = string5 + " union all " + "select m.type,m.oid,d.ovid, r.check_out_version, r.checkout_by,d.xml_content from " + OracleRepositoryManager.T_PACKAGE_MEMBERS + " m, " + OracleRepositoryManager.T_OBJECT_REGISTER + " r, " + string + " d where m.type = '" + string3 + "' and  m.parent_OVID = '" + string2 + "'  and m.oid = r.oid and r.check_out_version = d.ovid and r.check_out_version is not null and r.checkout_by = user";
            statement = connection.createStatement();
            resultSet = statement.executeQuery(string5);
            while (resultSet.next()) {
                ObjectDescr objectDescr = new ObjectDescr();
                arrayList.add(objectDescr);
                objectDescr.type = resultSet.getString(1);
                objectDescr.oid = resultSet.getString(2);
                objectDescr.ovid = resultSet.getString(3);
                Object object = resultSet.getString(4);
                objectDescr.checkOutBy = resultSet.getString(5);
                domain = (BLOB)resultSet.getBlob(6);
                if (objectDescr.checkOutBy == null) {
                    objectDescr.checkOutBy = "";
                }
                objectDescr.checkedOut = object != null;
                if (domain == null) continue;
                try {
                    objectDescr.xmldata = ReadManager.getString((BLOB)domain);
                }
                catch (IOException iOException) {}
            }
            abstractLevelDomains.clearDomains();
            for (Object object : arrayList) {
                domain = this.createDomain(design, abstractLevelDomains, ((ObjectDescr)object).type, ((ObjectDescr)object).oid, ((ObjectDescr)object).ovid, ((ObjectDescr)object).xmldata);
                if (domain == null) continue;
                domain.setCheckedOut(((ObjectDescr)object).checkedOut);
                domain.setCheckedOutBy(((ObjectDescr)object).checkOutBy);
                if (domain.isCheckedOut() && string4 != null && string4.equalsIgnoreCase(((ObjectDescr)object).checkOutBy)) {
                    domain.setCheckedOutByMe(true);
                } else {
                    domain.setCheckedOutByMe(false);
                }
                domain.setDirty(false);
            }
            design.getDomainSet().sort();
        }
        finally {
            if (resultSet != null) {
                resultSet.close();
            }
            if (statement != null) {
                statement.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readXMapObjects(String string, String string2) throws SQLException {
        String string3 = ObjectTypes.XMAPPING;
        AbstractXMLReader abstractXMLReader = this.getRepositoryManager().getXMReader(string3);
        int n = 0;
        boolean bl = false;
        if (abstractXMLReader != null) {
            String string4 = this.getRepositoryManager().getUser();
            String string5 = this.getRepositoryManager().getTableName(string3);
            Connection connection = this.getRepositoryManager().getConnection();
            Statement statement = null;
            ResultSet resultSet = null;
            try {
                String string6 = "select m.type,m.oid,d.ovid, r.check_out_version, r.checkout_by,d.xml_content from " + OracleRepositoryManager.T_PACKAGE_MEMBERS + " m, " + OracleRepositoryManager.T_OBJECT_REGISTER + " r, " + string5 + " d where m.type = '" + string3 + "' and m.parent_OVID = '" + string2 + "'  and m.oid = r.oid and r.last_version = d.ovid and (r.check_out_version is null or  r.check_out_version is not null and r.checkout_by <> user)";
                string6 = string6 + " union all " + "select m.type,m.oid,d.ovid, r.check_out_version, r.checkout_by,d.xml_content from " + OracleRepositoryManager.T_PACKAGE_MEMBERS + " m, " + OracleRepositoryManager.T_OBJECT_REGISTER + " r, " + string5 + " d where m.type = '" + string3 + "' and  m.parent_OVID = '" + string2 + "'  and m.oid = r.oid and r.check_out_version = d.ovid and r.check_out_version is not null and r.checkout_by = user";
                statement = connection.createStatement();
                resultSet = statement.executeQuery(string6);
                while (resultSet.next()) {
                    Document document;
                    Object object;
                    String string7 = resultSet.getString(1);
                    String string8 = resultSet.getString(2);
                    String string9 = resultSet.getString(3);
                    String string10 = resultSet.getString(4);
                    String string11 = resultSet.getString(5);
                    BLOB bLOB = (BLOB)resultSet.getBlob(6);
                    String string12 = null;
                    ++n;
                    if (bLOB != null) {
                        try {
                            string12 = ReadManager.getString(bLOB);
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    if ((object = abstractXMLReader.recreateObject(document = OracleRepositoryManager.getDocument(string12), this.getRepositoryManager().getDesign(), false)) != null && object instanceof RepositoryObject) {
                        RepositoryObject repositoryObject = (RepositoryObject)object;
                        repositoryObject.setRepositoryOID(string8);
                        repositoryObject.setRepositoryOVID(string9);
                        if (string10 != null) {
                            repositoryObject.setCheckedOut(true);
                        } else {
                            repositoryObject.setCheckedOut(false);
                        }
                        if (string11 == null) {
                            string11 = "";
                        }
                        repositoryObject.setCheckedOutBy(string11);
                        if (repositoryObject.isCheckedOut() && string4 != null && string4.equalsIgnoreCase(string11)) {
                            repositoryObject.setCheckedOutByMe(true);
                        } else {
                            repositoryObject.setCheckedOutByMe(false);
                        }
                    }
                    if (object == null || !(object instanceof RepositoryObject)) continue;
                    ((RepositoryObject)object).setDirty(false);
                }
            }
            finally {
                if (resultSet != null) {
                    resultSet.close();
                }
                if (statement != null) {
                    statement.close();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readDesignParts(Design design, String string, String string2, ProgressDialog progressDialog) throws SQLException {
        List<ObjectDescr> list = new ArrayList();
        ArrayList<ObjectDescr> arrayList = new ArrayList<ObjectDescr>();
        String string3 = OracleRepositoryManager.T_PACKAGE_MEMBERS;
        Connection connection = this.getRepositoryManager().getConnection();
        Statement statement = null;
        ResultSet resultSet = null;
        ObjectDescr objectDescr = null;
        try {
            Object object;
            Object object2;
            String string4 = this.getRepositoryManager().getUser();
            String string5 = design.getDLDomains().getType();
            String string6 = "select m.type,p.name,m.oid,p.ovid,r.check_out_version,r.checkout_by,p.xml_content from " + string3 + " m, " + OracleRepositoryManager.T_OBJECT_REGISTER + " r, " + OracleRepositoryManager.T_PACKAGES + " p where m.type != '" + string5 + "' and parent_OVID = '" + string2 + "'  and m.oid = r.oid and p.ovid = r.last_version and (r.check_out_version is null or  r.check_out_version is not null and r.checkout_by <> user)";
            string6 = string6 + " union all " + "select m.type,p.name,m.oid,p.ovid,r.check_out_version,r.checkout_by,p.xml_content from " + string3 + " m, " + OracleRepositoryManager.T_OBJECT_REGISTER + " r, " + OracleRepositoryManager.T_PACKAGES + " p where parent_OVID = '" + string2 + "'  and m.oid = r.oid and p.ovid = r.check_out_version and r.check_out_version is not null and r.checkout_by = user";
            statement = connection.createStatement();
            resultSet = statement.executeQuery(string6);
            int n = 10;
            while (resultSet.next()) {
                String string7 = resultSet.getString(1);
                ObjectDescr objectDescr2 = new ObjectDescr();
                if ("ExtendedMap".equalsIgnoreCase(string7)) {
                    objectDescr = objectDescr2;
                } else if ("Data Flow Diagram".equalsIgnoreCase(string7)) {
                    arrayList.add(objectDescr2);
                } else {
                    list.add(objectDescr2);
                }
                objectDescr2.type = string7;
                objectDescr2.name = resultSet.getString(2);
                objectDescr2.oid = resultSet.getString(3);
                objectDescr2.ovid = resultSet.getString(4);
                object2 = resultSet.getString(5);
                objectDescr2.checkOutBy = resultSet.getString(6);
                if (objectDescr2.checkOutBy == null) {
                    objectDescr2.checkOutBy = "";
                }
                object = (BLOB)resultSet.getBlob(7);
                if (object2 != null) {
                    objectDescr2.checkedOut = true;
                }
                if (object == null) continue;
                try {
                    objectDescr2.xmldata = ReadManager.getString((BLOB)object);
                }
                catch (IOException iOException) {}
            }
            list = this.reorderDP_Descriptors(list);
            for (ObjectDescr objectDescr2 : list) {
                progressDialog.setNote("Reading Model: " + objectDescr2.name);
                progressDialog.setProgress(n);
                if (!"TransformationPackage".equalsIgnoreCase(objectDescr2.type)) {
                    object2 = this.createDesignPart(design, objectDescr2.name, objectDescr2.type, objectDescr2.oid, objectDescr2.ovid, objectDescr2.xmldata, arrayList);
                    if (object2 != null) {
                        if (objectDescr2.checkedOut) {
                            ((ModelIDObject)object2).setCheckedOut(true);
                        }
                        ((DesignPart)object2).setDirty(false);
                        ((DesignPart)object2).setLoaded(true);
                        ((ModelIDObject)object2).setCheckedOutBy(objectDescr2.checkOutBy);
                        if (((ModelIDObject)object2).isCheckedOut() && string4 != null && string4.equalsIgnoreCase(objectDescr2.checkOutBy)) {
                            ((DesignPart)object2).setCheckedOutByMe(true);
                        }
                        ((DesignPart)object2).sortCollections();
                        if (((DesignPart)object2).getMainView() != null) {
                            ((DesignPart)object2).getMainView().setDirty(false);
                        }
                    }
                    if ("LogicalDesign".equalsIgnoreCase(objectDescr2.type)) {
                        object = design.getRelationalDesign();
                        ((DesignPart)object).setIsDeleting(true);
                        design.removeRelationalDesign((RelationalDesign)object);
                    }
                }
                n += 10;
            }
            if (objectDescr != null) {
                this.readXMapObjects(objectDescr.oid, objectDescr.ovid);
            }
        }
        finally {
            if (resultSet != null) {
                resultSet.close();
            }
            if (statement != null) {
                statement.close();
            }
        }
    }

    private TransformationPackage readTransformationPackage(Design design, String string, String string2, String string3) throws SQLException {
        Document document = OracleRepositoryManager.getDocument(string3);
        String string4 = this.getAttributeForObject(document, "id");
        TransformationPackage transformationPackage = design.getProcessModel().createTransformationPackage(string4);
        design.getProcessModel().setTransformationPackage(transformationPackage);
        transformationPackage.setRepositoryOID(string);
        transformationPackage.setRepositoryOVID(string2);
        this.readTransformationTasks(transformationPackage, design, string, string2);
        AbstractXMLReader abstractXMLReader = this.getRepositoryManager().getXMReader("TransformationPackage");
        if (abstractXMLReader != null) {
            transformationPackage = (TransformationPackage)abstractXMLReader.recreateObject(document, this.getRepositoryManager().getDesign(), false);
            transformationPackage.setDirty(false);
        }
        return transformationPackage;
    }

    public static String getString(BLOB bLOB) throws SQLException, IOException {
        int n;
        int n2 = bLOB.getBufferSize();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(n2);
        InflaterInputStream inflaterInputStream = new InflaterInputStream(bLOB.getBinaryStream());
        byte[] byArray = new byte[n2];
        int n3 = 0;
        while ((n = inflaterInputStream.read(byArray)) != -1) {
            byteArrayOutputStream.write(byArray, 0, n);
            n3 += n;
        }
        byte[] byArray2 = byteArrayOutputStream.toByteArray();
        inflaterInputStream.close();
        byteArrayOutputStream.close();
        String string = new String(byArray2, 0, n3, "UTF-8");
        return string;
    }

    private DesignPart createDesignPart(Design design, String string, String string2, String string3, String string4, String string5, List list) {
        Document document = OracleRepositoryManager.getDocument(string5);
        DesignPart designPart = this.createDesignPart(string2, string, design, document, list);
        if (designPart != null) {
            if (designPart instanceof ProcessModel) {
                this.createDataFlowDesigns(design, list);
            }
            designPart.setRepositoryOID(string3);
            designPart.setRepositoryOVID(string4);
            try {
                this.readDesignPartObjects(designPart, string3, string4);
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            AbstractXMLReader abstractXMLReader = this.getRepositoryManager().getDesign().getAppView().getPersistenceManager().getDesignPartReader(designPart);
            if (abstractXMLReader != null) {
                abstractXMLReader.recreateDesign(document, designPart, false);
            }
            designPart.checkAndSetIDGenerator();
            designPart.createRepositoryMap();
            designPart.setLoaded(true);
            designPart.setDirty(false);
            if (designPart instanceof ProcessModel) {
                ProcessModel processModel = (ProcessModel)designPart;
                for (ObjectDescr objectDescr : list) {
                    try {
                        DataFlowDesign dataFlowDesign = objectDescr.dfd;
                        processModel.setDataFlowDesign(dataFlowDesign);
                        this.readDesignPartObjects(dataFlowDesign, objectDescr.oid, objectDescr.ovid);
                        AbstractXMLReader abstractXMLReader2 = this.getRepositoryManager().getDesign().getAppView().getPersistenceManager().getDesignPartReader(dataFlowDesign);
                        if (abstractXMLReader2 != null) {
                            Document document2 = OracleRepositoryManager.getDocument(objectDescr.xmldata);
                            abstractXMLReader2.recreateDesign(document2, (DesignPart)dataFlowDesign, false);
                        }
                        dataFlowDesign.checkAndSetIDGenerator();
                        dataFlowDesign.createRepositoryMap();
                        dataFlowDesign.setLoaded(true);
                        dataFlowDesign.setDirty(false);
                    }
                    catch (Exception exception) {}
                }
            }
        }
        return designPart;
    }

    private void createDataFlowDesigns(Design design, List list) {
        for (ObjectDescr objectDescr : list) {
            Document document = OracleRepositoryManager.getDocument(objectDescr.xmldata);
            String string = objectDescr.name;
            String string2 = this.getAttributeForDesign(document, "top_level_dfd_design");
            DataFlowDesign dataFlowDesign = "true".equalsIgnoreCase(string2) ? design.getProcessModel().addDataFlowDesign(string) : design.getProcessModel().addDataFlowDesign(string, false);
            objectDescr.dfd = dataFlowDesign;
            design.getProcessModel().setDataFlowDesign(dataFlowDesign);
            String string3 = this.getAttributeForDesign(document, "id");
            dataFlowDesign.setObjectID(string3);
            design.getProcessModel().setHasOpenedDFDesigns(true);
            dataFlowDesign.setRepositoryOID(objectDescr.oid);
            dataFlowDesign.setRepositoryOVID(objectDescr.ovid);
            dataFlowDesign.setDirty(false);
            if (dataFlowDesign.getMainView() == null) continue;
            dataFlowDesign.getMainView().setDirty(false);
        }
    }

    private boolean createLogicalDatatypes(Design design, String string, String string2, String string3, String string4) {
        Document document;
        AbstractXMLReader abstractXMLReader;
        if (string4 != null && (abstractXMLReader = this.getRepositoryManager().getXMReader(string)) != null && (document = OracleRepositoryManager.getDocument(string4)) != null) {
            abstractXMLReader.recreateObject(document, design, false);
            return true;
        }
        return false;
    }

    private boolean createRDBMSSites(Design design, String string, String string2, String string3, String string4) {
        Document document;
        AbstractXMLReader abstractXMLReader;
        if (string4 != null && (abstractXMLReader = this.getRepositoryManager().getXMReader(string)) != null && (document = OracleRepositoryManager.getDocument(string4)) != null) {
            abstractXMLReader.recreateObject(document, design, false);
            return true;
        }
        return false;
    }

    private Domain createDomain(Design design, AbstractLevelDomains abstractLevelDomains, String string, String string2, String string3, String string4) {
        Domain domain;
        Document document;
        AbstractXMLReader abstractXMLReader;
        if (string4 != null && (abstractXMLReader = this.getRepositoryManager().getXMReader(string)) != null && (document = OracleRepositoryManager.getDocument(string4)) != null && (domain = (Domain)abstractXMLReader.recreateObject(document, design, false)) != null) {
            domain.setRepositoryOID(string2);
            domain.setRepositoryOVID(string3);
            abstractLevelDomains.createRepositoryMap();
            return domain;
        }
        return null;
    }

    private DesignPart createDesignPart(String string, String string2, Design design, Document document, List list) {
        if ("RelationalModel".equalsIgnoreCase(string)) {
            RelationalDesign relationalDesign = design.addRelationalDesign(string2);
            design.setRelationalDesign(relationalDesign);
            return relationalDesign;
        }
        if ("LogicalDesign".equalsIgnoreCase(string)) {
            return design.getLogicalDesign();
        }
        if ("Data Types".equalsIgnoreCase(string)) {
            return design.getDataTypesDesign();
        }
        if ("Dimensional Model".equalsIgnoreCase(string)) {
            MultidimensionalDesign multidimensionalDesign = design.addMultidimensionalDesign(string2);
            design.setMultidimensionalDesign(multidimensionalDesign);
            return multidimensionalDesign;
        }
        if ("Process Model".equalsIgnoreCase(string)) {
            return design.getProcessModel();
        }
        if ("Data Flow Diagram".equalsIgnoreCase(string)) {
            String string3 = this.getAttributeForDesign(document, "top_level_dfd_design");
            DataFlowDesign dataFlowDesign = "true".equalsIgnoreCase(string3) ? design.getProcessModel().addDataFlowDesign(string2) : design.getProcessModel().addDataFlowDesign(string2, false);
            design.getProcessModel().setDataFlowDesign(dataFlowDesign);
            String string4 = this.getAttributeForDesign(document, "id");
            dataFlowDesign.setObjectID(string4);
            design.getProcessModel().setHasOpenedDFDesigns(true);
            return dataFlowDesign;
        }
        if ("Business Information".equalsIgnoreCase(string)) {
            return design.getBusinessInfoDesign();
        }
        return null;
    }

    private String getAttributeForDesign(Document document, String string) {
        Element element = document.getDocumentElement();
        String string2 = element.getAttribute(string);
        return string2;
    }

    private String getAttributeForObject(Document document, String string) {
        Element element = document.getDocumentElement();
        Element element2 = AbstractXMLHandler.getFirstChildByTagName(element, "object");
        String string2 = element2.getAttribute(string);
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getDesigns(boolean bl) {
        ArrayList<AbstractRepositoryManager.DesignDescriptor> arrayList = new ArrayList<AbstractRepositoryManager.DesignDescriptor>();
        Connection connection = this.getRepositoryManager().getConnection();
        Statement statement = null;
        ResultSet resultSet = null;
        String string = "";
        String string2 = OracleRepositoryManager.T_PACKAGES;
        String string3 = OracleRepositoryManager.T_OBJECT_REGISTER;
        if (bl) {
            // empty if block
        }
        string = "select name,p.oid,ovid,to_char(date_created, 'DD.MM.YYYY HH24:MI') cdate_created,created_by,to_char(date_changed, 'DD.MM.YYYY HH24:MI'),changed_by, short_description, v_sequence, r.check_out_version, r.checkout_by,date_created  from " + string2 + " p, " + string3 + " r " + " where type = 'Design' and p.oid = r.oid " + " and r.last_version = p.ovid and (r.check_out_version is null or  r.check_out_version is not null and r.checkout_by <> user) " + " union all " + "select name,p.oid,ovid,to_char(date_created, 'DD.MM.YYYY HH24:MI') cdate_created,created_by,to_char(date_changed, 'DD.MM.YYYY HH24:MI') date_changed,changed_by, short_description, v_sequence, r.check_out_version, r.checkout_by,date_created " + " from " + string2 + " p, " + string3 + " r " + " where type = 'Design' and p.oid = r.oid " + " and r.check_out_version = p.ovid and r.check_out_version is not null and r.checkout_by = user " + " order by name asc, date_created desc ";
        try {
            statement = connection.createStatement();
            resultSet = statement.executeQuery(string);
            while (resultSet.next()) {
                AbstractRepositoryManager.DesignDescriptor designDescriptor = this.getRepositoryManager().new AbstractRepositoryManager.DesignDescriptor();
                arrayList.add(designDescriptor);
                designDescriptor.name = resultSet.getString(1);
                designDescriptor.oid = resultSet.getString(2);
                designDescriptor.ovid = resultSet.getString(3);
                designDescriptor.date_created = resultSet.getString(4);
                designDescriptor.created_by = resultSet.getString(5);
                designDescriptor.date_changed = resultSet.getString(6);
                designDescriptor.changed_by = resultSet.getString(7);
                String string4 = resultSet.getString(8);
                if (string4 == null) {
                    string4 = "";
                }
                designDescriptor.short_description = string4;
                designDescriptor.v_sequence = resultSet.getInt(9);
                designDescriptor.checkout_version = resultSet.getString(10);
                designDescriptor.checkout_by = resultSet.getString(11);
            }
        }
        catch (SQLException sQLException) {
        }
        finally {
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException sQLException) {}
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readUserRights(Design design) {
        if (ApplicationView.IS_VIEWER) {
            design.setReadOnly(true);
            return;
        }
        Connection connection = this.getRepositoryManager().getConnection();
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            String string = "select Viewer_Mode,Logical_Only from " + OracleRepositoryManager.T_USERS + " where name = user";
            statement = connection.createStatement();
            resultSet = statement.executeQuery(string);
            if (resultSet.next()) {
                String string2 = resultSet.getString(1);
                String string3 = resultSet.getString(2);
                if (string2 != null && string2.equalsIgnoreCase("Y")) {
                    ApplicationView.LOGICAL_MODEL_ONLY = false;
                    ApplicationView.IS_VIEWER = true;
                    design.setReadOnly(true);
                    design.getAppView().getController().updateMenus();
                    design.getAppView().getController().updateToolbar();
                    design.getAppView().updateActions();
                } else if (string3 != null && string3.equalsIgnoreCase("Y")) {
                    ApplicationView.IS_VIEWER = false;
                    ApplicationView.LOGICAL_MODEL_ONLY = true;
                    design.getAppView().getController().updateMenus();
                    design.getAppView().getController().updateToolbar();
                    design.getAppView().updateActions();
                } else if (!ApplicationView.LOGICAL_MODEL_ONLY) {
                    ApplicationView.IS_VIEWER = false;
                    ApplicationView.LOGICAL_MODEL_ONLY = false;
                    design.setReadOnly(false);
                    design.getAppView().getController().updateMenus();
                    design.getAppView().getController().updateToolbar();
                    design.getAppView().updateActions();
                }
            }
        }
        catch (SQLException sQLException) {
        }
        finally {
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException sQLException) {}
        }
    }

    private List reorderDP_Descriptors(List list) {
        ArrayList<ObjectDescr> arrayList = new ArrayList<ObjectDescr>();
        ArrayList arrayList2 = new ArrayList(list);
        for (int i = 0; i < this.dpOrder.length; ++i) {
            String string = this.dpOrder[i];
            for (ObjectDescr objectDescr : list) {
                if (!string.equalsIgnoreCase(objectDescr.type)) continue;
                arrayList.add(objectDescr);
                arrayList2.remove(objectDescr);
            }
        }
        arrayList.addAll(arrayList2);
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readPhysicalModel(StorageDesign storageDesign) throws SQLException {
        block15: {
            RelationalDesign relationalDesign = storageDesign.getPhysicalDesign();
            String string = relationalDesign.getRepositoryOID();
            String string2 = relationalDesign.getRepositoryOVID();
            String string3 = storageDesign.getRDBMSSite().getObjectID();
            ArrayList<ObjectDescr> arrayList = new ArrayList<ObjectDescr>();
            String string4 = OracleRepositoryManager.T_PACKAGE_MEMBERS;
            Connection connection = this.getRepositoryManager().getConnection();
            Statement statement = null;
            ResultSet resultSet = null;
            try {
                TimeLog.log();
                System.out.println("Load from DB start " + System.currentTimeMillis());
                String string5 = this.getRepositoryManager().getUser();
                String string6 = "select m.type,p.name,m.oid,p.ovid,r.check_out_version,r.checkout_by,p.xml_content from " + string4 + " m, " + OracleRepositoryManager.T_PM_OBJECT_REGISTER + " r, " + OracleRepositoryManager.T_PHYSMODELS + " p where parent_OVID = '" + string2 + "' and DB_SITE = '" + string3 + "' and m.oid = r.oid and p.ovid = r.last_version and (r.check_out_version is null or  r.check_out_version is not null and r.checkout_by <> user)";
                string6 = string6 + " union all " + "select m.type,p.name,m.oid,p.ovid,r.check_out_version,r.checkout_by,p.xml_content from " + string4 + " m, " + OracleRepositoryManager.T_PM_OBJECT_REGISTER + " r, " + OracleRepositoryManager.T_PHYSMODELS + " p where parent_OVID = '" + string2 + "'  and DB_SITE = '" + string3 + "' and m.oid = r.oid and p.ovid = r.check_out_version and r.check_out_version is not null and r.checkout_by = user";
                statement = connection.createStatement();
                resultSet = statement.executeQuery(string6);
                ObjectDescr objectDescr = null;
                storageDesign.setLoading(true);
                if (!resultSet.next()) break block15;
                String string7 = resultSet.getString(1);
                objectDescr = new ObjectDescr();
                arrayList.add(objectDescr);
                objectDescr.type = string7;
                objectDescr.name = resultSet.getString(2);
                objectDescr.oid = resultSet.getString(3);
                objectDescr.ovid = resultSet.getString(4);
                String string8 = resultSet.getString(5);
                objectDescr.checkOutBy = resultSet.getString(6);
                if (objectDescr.checkOutBy == null) {
                    objectDescr.checkOutBy = "";
                }
                BLOB bLOB = (BLOB)resultSet.getBlob(7);
                if (string8 != null) {
                    objectDescr.checkedOut = true;
                }
                if (bLOB != null) {
                    try {
                        objectDescr.xmldata = ReadManager.getString(bLOB);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                Document document = OracleRepositoryManager.getDocument(objectDescr.xmldata);
                String string9 = this.getAttributeForDesign(document, "stdes_version");
                float f = 2.1f;
                if (string9 != null && !"".equals(string9)) {
                    try {
                        f = Float.valueOf(string9).floatValue();
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                storageDesign.setLoadedVersion(f);
                List<String> list = new ArrayList();
                resultSet.close();
                statement.close();
                statement = null;
                resultSet = null;
                string6 = "select distinct m.type from " + OracleRepositoryManager.T_PHYSMODELS_MEMBERS + " m where parent_OVID = '" + objectDescr.ovid + "'";
                statement = connection.createStatement();
                resultSet = statement.executeQuery(string6);
                while (resultSet.next()) {
                    String string10 = resultSet.getString(1);
                    list.add(string10);
                }
                list = storageDesign.getOrderedTypes(list);
                this.count = 0;
                for (String string11 : list) {
                    this.readStorageObjects(storageDesign, objectDescr.ovid, string11);
                }
                storageDesign.setRepositoryOID(objectDescr.oid);
                storageDesign.setRepositoryOVID(objectDescr.ovid);
                storageDesign.createRepositoryMap();
            }
            finally {
                System.out.println("Load from DB end " + System.currentTimeMillis());
                TimeLog.log();
                System.out.println("phys objects " + this.count);
                if (resultSet != null) {
                    resultSet.close();
                }
                if (statement != null) {
                    statement.close();
                }
                storageDesign.setLoading(false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Document getDesignDoc(String string) throws SQLException {
        Document document;
        block7: {
            String string2 = OracleRepositoryManager.T_PACKAGES;
            Connection connection = this.getRepositoryManager().getConnection();
            Statement statement = null;
            ResultSet resultSet = null;
            String string3 = null;
            document = null;
            try {
                BLOB bLOB;
                String string4 = "select xml_content from " + string2 + " where ovid = '" + string + "'";
                statement = connection.createStatement();
                resultSet = statement.executeQuery(string4);
                if (!resultSet.next() || (bLOB = (BLOB)resultSet.getBlob(1)) == null) break block7;
                try {
                    string3 = ReadManager.getString(bLOB);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                document = OracleRepositoryManager.getDocument(string3);
            }
            finally {
                if (resultSet != null) {
                    resultSet.close();
                }
                if (statement != null) {
                    statement.close();
                }
            }
        }
        return document;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean readDLSettings(Design design) throws SQLException {
        boolean bl = false;
        String string = design.getRepositoryOVID();
        if (string != null) {
            Connection connection = this.getRepositoryManager().getConnection();
            Statement statement = null;
            ResultSet resultSet = null;
            try {
                BLOB bLOB;
                String string2 = OracleRepositoryManager.T_DL_SETTINGS;
                String string3 = "select xml_content from " + string2 + " where Design_ovid = '" + string + "'";
                statement = connection.createStatement();
                resultSet = statement.executeQuery(string3);
                if (resultSet.next() && (bLOB = (BLOB)resultSet.getBlob(1)) != null) {
                    try {
                        String string4 = ReadManager.getString(bLOB);
                        design.getAppView().getSettings().loadDLSettings(string4);
                        bl = true;
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
            finally {
                if (resultSet != null) {
                    resultSet.close();
                }
                if (statement != null) {
                    statement.close();
                }
            }
        }
        return bl;
    }

    class ObjectDescr {
        String type;
        String name;
        String oid;
        String ovid;
        String xmldata;
        String checkOutBy;
        boolean checkedOut = false;
        DataFlowDesign dfd;
        BLOB blob;

        ObjectDescr() {
        }
    }
}

