/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.persistence.db.oracle;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import oracle.dbtools.crest.model.design.ConnectionInterface;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.LogicalDatatypeSet;
import oracle.dbtools.crest.model.design.storage.RDBMSSiteSet;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.persistence.db.RepositoryObject;
import oracle.dbtools.crest.model.persistence.db.oracle.OracleRepositoryManager;
import oracle.dbtools.crest.model.xtdmapping.XtdMapping;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.util.GUID;

public class CheckInOutManager {
    private OracleRepositoryManager repositoryManager;

    public CheckInOutManager(OracleRepositoryManager oracleRepositoryManager) {
        this.repositoryManager = oracleRepositoryManager;
    }

    public OracleRepositoryManager getRepositoryManager() {
        return this.repositoryManager;
    }

    public boolean checkOutObject(RepositoryObject repositoryObject) throws SQLException {
        boolean bl = false;
        if (repositoryObject instanceof Design || repositoryObject instanceof DesignPart || repositoryObject instanceof DesignPartView || repositoryObject instanceof LogicalDatatypeSet || repositoryObject instanceof RDBMSSiteSet) {
            bl = this.checkOutPackage(repositoryObject);
            if (bl && repositoryObject instanceof Design) {
                this.getRepositoryManager().getWriteManager().createDLSettingsRecord((Design)repositoryObject, ((Design)repositoryObject).getDesignLevelSettings());
            }
        } else {
            bl = repositoryObject instanceof StorageDesign ? this.checkOutPhysicalModel(repositoryObject) : (repositoryObject instanceof ConnectionInterface ? this.checkOutConnectorObject(repositoryObject) : (repositoryObject instanceof XtdMapping ? this.checkOutConnectorObject(repositoryObject) : this.checkOutModelObject(repositoryObject)));
        }
        return bl;
    }

    private boolean checkOutPackage(RepositoryObject repositoryObject) throws SQLException {
        String string = repositoryObject.getRepositoryOID();
        String string2 = repositoryObject.getRepositoryOVID();
        String string3 = new GUID().toString();
        String string4 = "insert into " + OracleRepositoryManager.T_PACKAGES + "  (name,type,oid,ovid,created_by,date_created," + "changed_by,date_changed,check_status,short_description,v_sequence,xml_content)" + " select name,type,oid,'" + string3 + "',created_by,date_created,changed_by,date_changed,'O',short_description,v_sequence+1,xml_content from " + OracleRepositoryManager.T_PACKAGES + " where ovid = '" + string2 + "'";
        Connection connection = this.getConnection();
        boolean bl = connection.getAutoCommit();
        Statement statement = null;
        boolean bl2 = false;
        try {
            connection.setAutoCommit(false);
            statement = connection.createStatement();
            int n = statement.executeUpdate(string4);
            if (n > 0) {
                if (!(repositoryObject instanceof DesignPartView)) {
                    string4 = "insert into " + OracleRepositoryManager.T_PACKAGE_MEMBERS + "  (type,oid,created_by,date_created," + "changed_by,date_changed,ownership_flag,parent_oid,parent_ovid)" + " select type,oid,created_by,date_created,changed_by,date_changed,ownership_flag,parent_oid,'" + string3 + "' " + " from " + OracleRepositoryManager.T_PACKAGE_MEMBERS + " where parent_ovid = '" + string2 + "'";
                    n = statement.executeUpdate(string4);
                }
                CheckInOutManager.registerCheckOutObject(repositoryObject, string, string3, connection);
                repositoryObject.setRepositoryOVID(string3);
                repositoryObject.setCheckedOut(true);
            } else {
                bl2 = true;
            }
        }
        catch (SQLException sQLException) {
            bl2 = true;
            throw sQLException;
        }
        finally {
            if (bl2) {
                connection.rollback();
            } else {
                connection.commit();
            }
            if (statement != null) {
                statement.close();
            }
            connection.setAutoCommit(bl);
        }
        return !bl2;
    }

    private boolean checkOutPhysicalModel(RepositoryObject repositoryObject) throws SQLException {
        String string = repositoryObject.getRepositoryOID();
        String string2 = repositoryObject.getRepositoryOVID();
        String string3 = new GUID().toString();
        String string4 = "insert into " + OracleRepositoryManager.T_PHYSMODELS + "  (name,oid,ovid,relational_model,db_site,created_by,date_created," + "changed_by,date_changed,check_status,short_description,v_sequence,xml_content)" + " select name,oid,'" + string3 + "',relational_model,db_site,created_by,date_created,changed_by,date_changed,'O',short_description,v_sequence+1,xml_content from " + OracleRepositoryManager.T_PACKAGES + " where ovid = '" + string2 + "'";
        Connection connection = this.getConnection();
        boolean bl = connection.getAutoCommit();
        Statement statement = null;
        boolean bl2 = false;
        try {
            connection.setAutoCommit(false);
            statement = connection.createStatement();
            int n = statement.executeUpdate(string4);
            if (n > 0) {
                if (!(repositoryObject instanceof DesignPartView)) {
                    string4 = "insert into " + OracleRepositoryManager.T_PHYSMODELS_MEMBERS + "  (type,oid,created_by,date_created," + "changed_by,date_changed,ownership_flag,parent_oid,parent_ovid)" + " select type,oid,created_by,date_created,changed_by,date_changed,ownership_flag,parent_oid,'" + string3 + "' " + " from " + OracleRepositoryManager.T_PHYSMODELS_MEMBERS + " where parent_ovid = '" + string2 + "'";
                    n = statement.executeUpdate(string4);
                }
                CheckInOutManager.registerCheckOutObject(repositoryObject, string, string3, connection);
                repositoryObject.setRepositoryOVID(string3);
                repositoryObject.setCheckedOut(true);
            } else {
                bl2 = true;
            }
        }
        catch (SQLException sQLException) {
            bl2 = true;
            throw sQLException;
        }
        finally {
            if (bl2) {
                connection.rollback();
            } else {
                connection.commit();
            }
            if (statement != null) {
                statement.close();
            }
            connection.setAutoCommit(bl);
        }
        return !bl2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkOutModelObject(RepositoryObject repositoryObject) throws SQLException {
        String string = repositoryObject.getRepositoryOID();
        String string2 = null;
        try {
            string2 = this.getCheckoutByUser(repositoryObject);
        }
        catch (SQLException sQLException) {
            string2 = "1";
        }
        if (string2 != null) {
            return false;
        }
        String string3 = repositoryObject.getRepositoryOVID();
        String string4 = new GUID().toString();
        String string5 = this.getRepositoryManager().getTableName(repositoryObject);
        String string6 = "insert into " + string5 + "  (name,oid,ovid,created_by,date_created," + "changed_by,date_changed,check_status,v_sequence,xml_content)" + " select name,oid,'" + string4 + "',created_by,date_created,changed_by,date_changed,'O',v_sequence+1,xml_content from " + string5 + " where ovid = '" + string3 + "'";
        if (repositoryObject instanceof StorageObject) {
            string6 = "insert into " + string5 + "  (name,type,oid,ovid,created_by,date_created," + "changed_by,date_changed,check_status,v_sequence,xml_content)" + " select name,type,oid,'" + string4 + "',created_by,date_created,changed_by,date_changed,'O',v_sequence+1,xml_content from " + string5 + " where ovid = '" + string3 + "'";
        }
        Connection connection = this.getConnection();
        boolean bl = connection.getAutoCommit();
        Statement statement = null;
        boolean bl2 = false;
        try {
            connection.setAutoCommit(false);
            statement = connection.createStatement();
            int n = statement.executeUpdate(string6);
            if (n > 0) {
                CheckInOutManager.registerCheckOutObject(repositoryObject, string, string4, connection);
                repositoryObject.setCheckedOut(true);
                repositoryObject.setRepositoryOVID(string4);
            } else {
                bl2 = true;
            }
        }
        catch (SQLException sQLException) {
            bl2 = true;
        }
        finally {
            if (bl2) {
                connection.rollback();
            } else {
                connection.commit();
            }
            if (statement != null) {
                statement.close();
            }
            connection.setAutoCommit(bl);
        }
        return !bl2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkOutConnectorObject(RepositoryObject repositoryObject) throws SQLException {
        if (!(repositoryObject instanceof ConnectionInterface)) {
            return false;
        }
        String string = repositoryObject.getRepositoryOID();
        String string2 = null;
        try {
            string2 = this.getCheckoutByUser(repositoryObject);
        }
        catch (SQLException sQLException) {
            string2 = "1";
        }
        if (string2 != null) {
            return false;
        }
        String string3 = repositoryObject.getRepositoryOVID();
        String string4 = new GUID().toString();
        String string5 = this.getRepositoryManager().getTableName(repositoryObject);
        String string6 = "insert into " + string5 + "  (name,oid,ovid,source,target,created_by,date_created," + "changed_by,date_changed,check_status,v_sequence,xml_content)" + " select name,oid,'" + string4 + "',source,target,created_by,date_created,changed_by,date_changed,'O',v_sequence+1,xml_content from " + string5 + " where ovid = '" + string3 + "'";
        Connection connection = this.getConnection();
        boolean bl = connection.getAutoCommit();
        Statement statement = null;
        boolean bl2 = false;
        try {
            connection.setAutoCommit(false);
            statement = connection.createStatement();
            int n = statement.executeUpdate(string6);
            if (n > 0) {
                CheckInOutManager.registerCheckOutObject(repositoryObject, string, string4, connection);
                repositoryObject.setCheckedOut(true);
                repositoryObject.setRepositoryOVID(string4);
            } else {
                bl2 = true;
            }
        }
        catch (SQLException sQLException) {
            bl2 = true;
        }
        finally {
            if (bl2) {
                connection.rollback();
            } else {
                connection.commit();
            }
            if (statement != null) {
                statement.close();
            }
            connection.setAutoCommit(bl);
        }
        return !bl2;
    }

    private Connection getConnection() {
        return this.getRepositoryManager().getConnection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerCheckOutObject(RepositoryObject repositoryObject, String string, String string2, Connection connection) throws SQLException {
        Statement statement = null;
        String string3 = OracleRepositoryManager.T_OBJECT_REGISTER;
        if (repositoryObject instanceof StorageObject || repositoryObject instanceof StorageDesign) {
            string3 = OracleRepositoryManager.T_PM_OBJECT_REGISTER;
        }
        try {
            String string4 = "update " + string3 + " set check_out_version = '" + string2 + "', checkout_by = user where oid = '" + string + "'";
            statement = connection.createStatement();
            statement.executeUpdate(string4);
        }
        finally {
            if (statement != null) {
                statement.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean registerCheckInObject(RepositoryObject repositoryObject) throws SQLException {
        String string = repositoryObject.getRepositoryOID();
        String string2 = repositoryObject.getRepositoryOVID();
        String string3 = this.getRepositoryManager().getTableName(repositoryObject);
        String string4 = OracleRepositoryManager.T_OBJECT_REGISTER;
        if (repositoryObject instanceof StorageObject || repositoryObject instanceof StorageDesign) {
            string4 = OracleRepositoryManager.T_PM_OBJECT_REGISTER;
        }
        String string5 = "update " + string4 + " set last_version = '" + string2 + "', check_out_version = null , checkout_by = null " + "where oid = '" + string + "' and check_out_version = '" + string2 + "'";
        Connection connection = this.getConnection();
        boolean bl = connection.getAutoCommit();
        Statement statement = null;
        boolean bl2 = false;
        try {
            connection.setAutoCommit(false);
            statement = connection.createStatement();
            int n = statement.executeUpdate(string5);
            if (n > 0) {
                string5 = "update " + string3 + " set check_status = 'I' where ovid = '" + string2 + "'";
                n = statement.executeUpdate(string5);
                if (n < 1) {
                    bl2 = true;
                } else {
                    repositoryObject.setCheckedOut(false);
                }
            } else {
                bl2 = true;
            }
        }
        catch (Exception exception) {
            bl2 = true;
        }
        finally {
            if (bl2) {
                connection.rollback();
            } else {
                connection.commit();
                repositoryObject.setCheckedOut(false);
            }
            if (statement != null) {
                statement.close();
            }
            connection.setAutoCommit(bl);
        }
        return !bl2;
    }

    public boolean checkInObject(RepositoryObject repositoryObject) throws SQLException {
        if (repositoryObject.isCheckedOut()) {
            return this.registerCheckInObject(repositoryObject);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getCheckoutByUser(RepositoryObject repositoryObject) throws SQLException {
        Connection connection = this.getRepositoryManager().getConnection();
        Statement statement = null;
        ResultSet resultSet = null;
        String string = null;
        String string2 = repositoryObject.getRepositoryOID();
        if (string2 != null) {
            String string3 = OracleRepositoryManager.T_OBJECT_REGISTER;
            if (repositoryObject instanceof StorageObject) {
                string3 = OracleRepositoryManager.T_PM_OBJECT_REGISTER;
            }
            try {
                String string4 = "select checkout_by from " + string3 + " where oid = '" + string2 + "'";
                statement = connection.createStatement();
                resultSet = statement.executeQuery(string4);
                if (resultSet.next()) {
                    string = resultSet.getString(1);
                }
            }
            finally {
                if (resultSet != null) {
                    resultSet.close();
                }
                if (statement != null) {
                    statement.close();
                }
            }
        }
        return string;
    }
}

