/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.persistence.db.oracle;

import java.io.OutputStream;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import java.util.zip.Deflater;
import oracle.dbtools.crest.model.persistence.db.RepositoryObject;
import oracle.dbtools.crest.model.persistence.db.oracle.OracleRepositoryManager;
import oracle.dbtools.crest.model.persistence.db.oracle.WriteManager;
import oracle.sql.BLOB;

public abstract class AbstractDBWriter {
    protected OracleRepositoryManager repositoryManager;

    public AbstractDBWriter(OracleRepositoryManager oracleRepositoryManager) {
        this.repositoryManager = oracleRepositoryManager;
    }

    public OracleRepositoryManager getRepositoryManager() {
        return this.repositoryManager;
    }

    public Connection getConnection() {
        if (this.repositoryManager.isConnected()) {
            if (this.repositoryManager.isRepositoryExists()) {
                return this.repositoryManager.getConnection();
            }
            throw new RuntimeException("Repository is not created");
        }
        throw new RuntimeException("Repository Manger is not connected to repository");
    }

    public void writeObject(Object object) {
        if (this.canHandle(object)) {
            try {
                this.writeObjectToDB(object);
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    public void writeObjects(List list) {
        Object e;
        if (list.size() > 0 && this.canHandle(e = list.get(0))) {
            try {
                this.writeObjectsToDB(list);
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    protected String getTableName(Object object) {
        return this.repositoryManager.getTableName(object);
    }

    protected abstract void writeObjectToDB(Object var1) throws SQLException;

    public abstract void writeObjectsToDB(List var1) throws SQLException;

    public abstract boolean canHandle(Object var1);

    public static BLOB getBLOB(String string, Connection connection) throws SQLException {
        BLOB bLOB;
        block4: {
            bLOB = null;
            try {
                byte[] byArray = null;
                byArray = string.getBytes("UTF-8");
                byte[] byArray2 = new byte[byArray.length];
                Deflater deflater = new Deflater();
                deflater.setInput(byArray);
                deflater.finish();
                int n = deflater.deflate(byArray2);
                bLOB = BLOB.createTemporary((Connection)connection, (boolean)true, (int)10);
                bLOB.open(1);
                OutputStream outputStream = bLOB.setBinaryStream(1L);
                outputStream.write(byArray2, 0, n);
                outputStream.flush();
                outputStream.close();
                bLOB.close();
            }
            catch (SQLException sQLException) {
                if (bLOB != null) {
                    bLOB.freeTemporary();
                }
            }
            catch (Exception exception) {
                if (bLOB == null) break block4;
                bLOB.freeTemporary();
            }
        }
        return bLOB;
    }

    public WriteManager getWriteManager() {
        return this.getRepositoryManager().getWriteManager();
    }

    public void assignRepositoryIDs(RepositoryObject repositoryObject, String string, String string2) {
        this.getWriteManager().assignRepositoryIDs(repositoryObject, string, string2);
    }

    public void clearDirtyFlag(RepositoryObject repositoryObject) {
        this.getWriteManager().clearDirtyFlag(repositoryObject);
    }
}

