/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.persistence;

import java.io.InputStream;
import java.io.StringWriter;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.StatusBarOwner;
import oracle.dbtools.crest.model.Task;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.persistence.AbstractFileManager;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.ProgressDialog;
import oracle.dbtools.crest.util.logging.Logger;

public abstract class PersistenceManager {
    public static final String[] PROTO = new String[0];
    private List errors = Collections.synchronizedList(new ArrayList());
    private List tasks = Collections.synchronizedList(new ArrayList());
    private StatusBarOwner status = StatusBarOwner.NULL_INSTANCE;
    private boolean isReading = false;
    private boolean checkDirty = true;
    private boolean saveFailed = false;
    public static int READ_MODE_DATABASE = 1;
    public static int READ_MODE_FILESYTEM = 2;
    private int readMode = READ_MODE_FILESYTEM;
    private static final Logger LOGGER = new Logger(PersistenceManager.class);

    public abstract boolean write(Object var1);

    public abstract boolean writeAll(Object var1);

    public abstract boolean writeDomains(Object var1);

    public abstract boolean writeTypes(Object var1);

    public abstract boolean writeRDBMSSites(Object var1);

    public abstract Object read(Object var1, Design var2, boolean var3);

    public abstract Object read(Object var1, DesignPart var2, boolean var3);

    public abstract boolean isWriteFinished();

    public abstract boolean deleteDesign(String var1, String var2, String var3);

    public abstract boolean deleteFiles(List var1);

    public abstract boolean unlockDesign(String var1, String var2, String var3);

    public abstract String getDataPath();

    public abstract String getDesignLocation();

    public abstract ApplicationView getAppView();

    public abstract void setAppView(ApplicationView var1);

    public Object read(Object object, Design design, ProgressDialog progressDialog) {
        return null;
    }

    public abstract Object readSystemInit(Design var1);

    public abstract AbstractFileManager getFileManager();

    public Object read(Object object, Design design) {
        ApplicationView.log(new StringBuffer().append(Messages.getString("PersistenceManager.Reading")).append(object).toString());
        return this.read(object, design, false);
    }

    public void setStatusBarOwner(Object object) {
        if (object instanceof StatusBarOwner) {
            this.setStatusBarOwner((StatusBarOwner)object);
        }
    }

    public void setStatusBarOwner(StatusBarOwner statusBarOwner) {
        this.status = statusBarOwner != null ? statusBarOwner : StatusBarOwner.NULL_INSTANCE;
    }

    public synchronized void showStatusMessage(String string) {
        this.status.setTempStatusMessage(string, 5000);
    }

    public String[] getErrors() {
        return this.errors.toArray(PROTO);
    }

    public String errorsToString() {
        String string = System.getProperty("line.separator");
        String[] stringArray = this.getErrors();
        StringBuffer stringBuffer = new StringBuffer(string);
        stringBuffer.append(Messages.getString("PersistenceManager.Errors")).append(" ----------");
        for (int i = 0; i < stringArray.length; ++i) {
            stringBuffer.append(string);
            stringBuffer.append(stringArray[i]);
        }
        stringBuffer.append(string);
        stringBuffer.append("------------------");
        stringBuffer.append(string);
        return stringBuffer.toString();
    }

    protected void addError(Throwable throwable, String string) {
        StringWriter stringWriter = new StringWriter();
        StringBuffer stringBuffer = stringWriter.getBuffer();
        stringBuffer.append(string);
        stringBuffer.append('\n');
        this.errors.add(stringBuffer.toString());
    }

    protected void addError(String string) {
        this.errors.add(string);
    }

    public boolean hasErrors() {
        return this.errors.size() > 0;
    }

    public void clearErrors() {
        this.errors.clear();
    }

    public abstract InputStream getInputStreamFor(String var1, String var2);

    public abstract boolean exists(String var1, String var2);

    public abstract Object[] getAvailableDesigns();

    public abstract Object[] getAvailableNames(String var1);

    public void addTask(Task task) {
        this.tasks.add(task);
    }

    public void runTasks() {
        ApplicationView.log(Messages.getString("PersistenceManager.RunningTasks"));
        for (int i = 0; !this.tasks.isEmpty() && i < 20; ++i) {
            Iterator iterator = this.tasks.iterator();
            while (iterator.hasNext()) {
                boolean bl = false;
                Task task = (Task)iterator.next();
                try {
                    bl = task.execute();
                }
                catch (Exception exception) {
                    LOGGER.error("can not execute task: ", exception);
                }
                if (!bl) continue;
                iterator.remove();
            }
        }
        ApplicationView.log(MessageFormat.format(Messages.getString("PersistenceManager.PersistenceManagerRunTasksFinished"), this.tasks.size()));
        this.tasks.clear();
    }

    public final void setIsReadingx(boolean bl) {
        this.isReading = bl;
    }

    public final boolean getIsReading() {
        return this.isReading;
    }

    public String[] getLocationAndNameFor(Object object) {
        return new String[0];
    }

    public boolean isCheckDirty() {
        return this.checkDirty;
    }

    public void setCheckDirty(boolean bl) {
        this.checkDirty = bl;
    }

    public boolean isSaveFailed() {
        return this.saveFailed;
    }

    public void setSaveFailed(boolean bl) {
        this.saveFailed = bl;
    }

    public int getReadMode() {
        return this.readMode;
    }

    public void setReadMode(int n) {
        this.readMode = n;
    }

    public boolean isXML_FromDataBase() {
        return this.getReadMode() == READ_MODE_DATABASE;
    }
}

