/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.persistence;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.InetAddress;
import java.net.URL;
import java.util.Map;
import java.util.Properties;
import oracle.dbtools.crest.model.design.WordMapper;
import oracle.dbtools.crest.model.persistence.PersistenceManager;
import oracle.dbtools.crest.model.persistence.XMLPersistenceManager;
import oracle.dbtools.crest.util.logging.Logger;

public abstract class ConfigurationFileLoader {
    public static final String MDCONFIGURATION_PATH = "/be/ikan/cwd/properties/modelconfig.properties";
    public static final String GUICONFIGURATION_PATH = "/be/ikan/cwd/properties/guiconfig.properties";
    public static final String GUIUSERPREFS_PATH = "/be/ikan/cwd/properties/guiprefs.properties";
    public static final String LOGTOPHYS_NAME_MAP_PATH = "/be/ikan/cwd/properties/logtophys.properties";
    public static final String GUIUSERPREFS_FILE = "guiprefs.properties";
    public static final String MDCONFIGURATION_FILE = "modelconfig.properties";
    public static final String GUICONFIGURATION_FILE = "guiconfig.properties";
    public static final String LOGTOPHYS_NAME_MAP_FILE = "logtophys.properties";
    public static final String LOGTOPHYS_SERVER_PATH = "logtophys";
    public static final String NEWLINE = System.getProperty("line.separator");
    private static String hostName = "<UNKNOWN HOST>";
    private static final Logger LOGGER = new Logger(ConfigurationFileLoader.class);

    protected void loadProps(Map map, Map map2) {
        map2.putAll(map);
    }

    protected void loadProps(String string, Map map) {
        map.putAll(this.loadProps(string));
    }

    protected void loadProps(PersistenceManager persistenceManager, String string, String string2, Map map) {
        InputStream inputStream = persistenceManager.getFileManager().getDataInputStream(persistenceManager, string, string2);
        map.putAll(this.loadProps(inputStream, new StringBuffer(LOGTOPHYS_NAME_MAP_FILE).append(" on server").toString()));
    }

    private Properties loadProps(String string) {
        InputStream inputStream = this.getClass().getResourceAsStream(string);
        return this.loadProps(inputStream, string);
    }

    private Properties loadProps(InputStream inputStream, String string) {
        Properties properties = new Properties();
        try {
            if (inputStream == null) {
                LOGGER.error("No properties found. Make sure a directory in the classpath of this JVM contains a file in a subdirectory as follows: " + string);
            } else {
                properties.load(inputStream);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return properties;
    }

    protected File getPropDirectory() {
        URL uRL = this.getClass().getResource("/be/ikan/cwd/model/Model.class");
        String string = uRL.getPath();
        if (string != null && uRL.getProtocol().indexOf("file") != -1) {
            try {
                File file = new File(string).getParentFile();
                File file2 = file.getParentFile();
                File file3 = new File(file2, "properties/");
                return file3;
            }
            catch (Exception exception) {
                LOGGER.error("Error in ConfigurationFileLoader.getPropDirectory", exception);
            }
        } else {
            LOGGER.error("Can not find Model.class");
        }
        return new File("", "be/ikan/cwd/properties/");
    }

    public final void writePropertyFile() {
        try {
            this.createDefaultFile(this.getPropDirectory());
        }
        catch (Exception exception) {
            LOGGER.error("Can not write to properties directory", exception);
        }
    }

    protected abstract void createDefaultFile(File var1);

    protected void storeMap(XMLPersistenceManager xMLPersistenceManager, WordMapper wordMapper) {
        xMLPersistenceManager.write(wordMapper);
    }

    protected void storeMap(Map map, File file) {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            this.storeMap(map, fileOutputStream);
            fileOutputStream.close();
        }
        catch (IOException iOException) {
            LOGGER.error("Error in storeMap: ", iOException);
        }
    }

    protected void storeMap(Map map, OutputStream outputStream) throws IOException {
        BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(outputStream));
        this.storeMap(map, bufferedWriter);
    }

    protected void storeMap(Map map, Writer writer) throws IOException {
        for (String string : map.keySet()) {
            writer.write(string);
            writer.write(61);
            writer.write((String)map.get(string));
            writer.write(NEWLINE);
        }
    }

    public static String getHostName() {
        return hostName;
    }

    public String getPropertyDirectory() {
        try {
            return this.getPropDirectory().getAbsolutePath();
        }
        catch (Throwable throwable) {
            LOGGER.error("Can not detect property directory");
            return "/";
        }
    }

    static {
        try {
            InetAddress inetAddress = InetAddress.getLocalHost();
            hostName = inetAddress.toString();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

