/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.persistence;

import java.io.File;
import java.io.InputStream;
import java.util.List;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.persistence.PersistenceManager;
import oracle.dbtools.crest.util.io.EmptyInputStream;

public abstract class AbstractFileManager {
    private boolean startSeparateWriterThread = false;
    private String userName = "unknown";
    private String fileExtension = "xml";

    public abstract boolean setBasePath(String var1);

    public abstract void setDesignPath(String var1);

    public abstract boolean store(PersistenceManager var1, String var2, String var3, String var4);

    public abstract boolean store(PersistenceManager var1, String var2, String var3, InputStream var4);

    public boolean getStartWriterThread() {
        return this.startSeparateWriterThread;
    }

    public void setStartWriterThread(boolean bl) {
        this.startSeparateWriterThread = bl;
    }

    public abstract String readData(PersistenceManager var1, String var2, String var3);

    public abstract boolean exists(PersistenceManager var1, String var2, String var3);

    public abstract boolean deleteDesign(PersistenceManager var1, String var2, String var3, String var4);

    public abstract boolean deleteFiles(List var1);

    public abstract boolean unlockDesign(String var1, String var2, String var3);

    public abstract String getDataPath();

    public abstract Object[] listNames(String var1);

    public abstract String[] listNamesNoFileExtension(String var1);

    public abstract InputStream getDataInputStreamWithoutExtension(PersistenceManager var1, String var2, String var3);

    public abstract InputStream getDataInputStream(PersistenceManager var1, String var2, Object var3);

    public abstract File getAbsolutePath(PersistenceManager var1, String var2, String var3, boolean var4);

    public InputStream getDataInputStreamWithoutExtension(PersistenceManager persistenceManager, String string, String string2, boolean bl) {
        if (bl && this.implementsLocking() && this.getLock(string, string2)) {
            return this.getDataInputStreamWithoutExtension(persistenceManager, string, string2);
        }
        return new EmptyInputStream();
    }

    public InputStream getDataInputStream(PersistenceManager persistenceManager, String string, Object object, boolean bl) {
        if (bl && this.implementsLocking() && this.getLock(string, (String)object)) {
            return this.getDataInputStream(persistenceManager, string, object);
        }
        return new EmptyInputStream();
    }

    public void setUserName(String string) {
        this.userName = string;
    }

    public String getUserName() {
        return this.userName;
    }

    public boolean getLock(String string, String string2) {
        return this.getLock(string, string2, this.getUserName());
    }

    public boolean getLock(String string, String string2, String string3) {
        return false;
    }

    public boolean releaseLock(String string, String string2) {
        return this.releaseLock(string, string2, this.getUserName());
    }

    public boolean releaseLock(String string, String string2, String string3) {
        return false;
    }

    public boolean implementsLocking() {
        return false;
    }

    public boolean checkConnectionStatus() {
        return true;
    }

    public String getLastConnectionStatusMessage() {
        return Messages.getString("AbstractFileManager.NoConnectioToVerify");
    }

    public String getFileExtension() {
        return this.fileExtension;
    }

    public void setFileExtension(String string) {
        this.fileExtension = string;
    }

    public String toFileName(String string) {
        if (string == null) {
            return null;
        }
        if (string.endsWith("." + this.getFileExtension())) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string);
        stringBuffer.append('.');
        stringBuffer.append(this.getFileExtension());
        return stringBuffer.toString();
    }

    public String removeExt(String string) {
        int n = string.indexOf(46);
        if (n == -1) {
            return string;
        }
        return string.substring(0, n);
    }

    public String fixFilePath(String string) {
        int n = string.indexOf(92);
        if (n == -1) {
            return string;
        }
        return string.replaceAll("[\\\\]", "/");
    }

    public String fixPath(String string) {
        int n = string.indexOf(92);
        if (n == -1) {
            return this.addLastSlash(string);
        }
        return this.addLastSlash(string.replaceAll("[\\\\]", "/"));
    }

    public String addLastSlash(String string) {
        if (!string.endsWith("/")) {
            return string.concat("/");
        }
        return string;
    }

    public boolean isWriteFinished() {
        return false;
    }
}

