/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.metadata;

import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.zip.Deflater;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import oracle.dbtools.crest.fcp.DataModelerAddin;
import oracle.dbtools.crest.fcp.vcs.svn.SVNClientHelper;
import oracle.dbtools.crest.model.ChangeRequest;
import oracle.dbtools.crest.model.MDConfiguration;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.ModelIDObjectSet;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.StorableObject;
import oracle.dbtools.crest.model.businessinfo.BusinessInfoDesign;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.Domain;
import oracle.dbtools.crest.model.design.DomainFileWrapper;
import oracle.dbtools.crest.model.design.datatypes.DataTypesDesign;
import oracle.dbtools.crest.model.design.logical.LogicalDesign;
import oracle.dbtools.crest.model.design.logical.Relation;
import oracle.dbtools.crest.model.design.multidimensional.MultidimensionalDesign;
import oracle.dbtools.crest.model.design.process.DataFlowDesign;
import oracle.dbtools.crest.model.design.process.ProcessModel;
import oracle.dbtools.crest.model.design.process.TransformationPackage;
import oracle.dbtools.crest.model.design.process.TransformationTask;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.RDBMSSiteSet;
import oracle.dbtools.crest.model.design.storage.RDBMSType;
import oracle.dbtools.crest.model.design.storage.RDBMSTypeSet;
import oracle.dbtools.crest.model.design.storage.RelationalObjectProxy;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.metadata.ClassDescription;
import oracle.dbtools.crest.model.metadata.MDTransformationManager;
import oracle.dbtools.crest.model.metadata.MDTransformer;
import oracle.dbtools.crest.model.metadata.MDXMLConstants;
import oracle.dbtools.crest.model.metadata.MetaDataManager;
import oracle.dbtools.crest.model.metadata.XMLFromMapTransformer;
import oracle.dbtools.crest.model.metadata.XMLFromObjTransformer;
import oracle.dbtools.crest.model.metadata.XMLObjToStreamTransformer;
import oracle.dbtools.crest.model.metadata.XMLObjToStringBuilderTransformer;
import oracle.dbtools.crest.model.metadata.XMLToMapTransformer;
import oracle.dbtools.crest.model.metadata.XMLToObjectTransformer;
import oracle.dbtools.crest.model.persistence.db.RepositoryObject;
import oracle.dbtools.crest.model.persistence.xml.XMLConstants;
import oracle.dbtools.crest.model.placeholder.DesignPartViewPlaceHolder;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.logical.DPVLogical;
import oracle.dbtools.crest.swingui.multidimensional.DPVCompactMultidimentional;
import oracle.dbtools.crest.swingui.relational.DPVRelational;
import oracle.dbtools.crest.util.Extension;
import oracle.dbtools.crest.util.FileUtils;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.TimeLog;
import oracle.dbtools.crest.util.io.FolderFilesListing;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.dbtools.crest.util.options.Settings;
import oracle.dbtools.crest.util.string.StringUtilities;
import oracle.ide.net.InflaterInputStream;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class XMLTransformationManager
implements MDXMLConstants {
    public static final String COMPRESSED_FILE_SUFIX = "z";
    public static final String EXTENSION_LOCAL_FILES = ".local";
    public static final String EXTENSION_LOCAL_FILES_COMPRESSED = ".localz";
    public static boolean JDOM_PARSING = false;
    public static final String OBJECT_LIST = "Objects.local";
    public static final String CHANGE_REQUEST_LIST = "ChangeRequests.local";
    public static final String DIAGRAM_LIST = "Diagrams.local";
    public static final String DDL_SELECTION_LIST = "DDLSelection.local";
    public static final String SITE_TYPE = "siteType";
    public static final String SITE_ID = "siteID";
    public static final String SITE_NAME = "siteName";
    public static final String MARKED_GENERATE = "markedGenerate";
    private MDTransformationManager mdtManager = null;
    private boolean checkDirty = true;
    private boolean saveFailed = false;
    private MDTransformationManager xmlMapManager = null;
    private MetaDataManager metaDataManager = new MetaDataManager();
    private static final Logger LOGGER = new Logger(XMLTransformationManager.class);
    FileFilter filter = new FileFilter(){

        @Override
        public boolean accept(File file) {
            String string = file.getName();
            return string.endsWith(".xml") || string.endsWith(".xmlz") || file.isDirectory();
        }
    };

    public boolean isCheckDirty() {
        return this.checkDirty;
    }

    public void setCheckDirty(boolean bl) {
        this.checkDirty = bl;
    }

    public String fixFilePath(String string) {
        int n = string.indexOf(92);
        if (n == -1) {
            return string;
        }
        return string.replaceAll("[\\\\]", "/");
    }

    public boolean designExists(String string, String string2) {
        for (int i = 0; i < XMLConstants.DESIGN_EXTENSIONS.length; ++i) {
            String string3 = XMLConstants.DESIGN_EXTENSIONS[i];
            File file = new File(string, string2 + string3);
            if (!file.exists()) continue;
            return true;
        }
        return false;
    }

    public boolean fileExists(String string) {
        return new File(string).exists();
    }

    public boolean deleteDesign(String string, String string2) {
        File file = null;
        boolean bl = true;
        if (string2 != null) {
            for (int i = 0; i < XMLConstants.DESIGN_EXTENSIONS.length; ++i) {
                String string3 = XMLConstants.DESIGN_EXTENSIONS[i];
                file = new File(string, string2 + string3);
                if (!file.exists()) continue;
                bl = file.delete();
            }
            file = new File(string, string2);
            if (file.exists() && file.isDirectory()) {
                bl = this.deleteDirectory(file);
            }
        }
        return bl;
    }

    public boolean deleteFiles(List list) {
        boolean bl = false;
        System.gc();
        for (int i = 0; i < list.size(); ++i) {
            File file;
            String string = (String)list.get(i);
            if (string == null || !(file = new File(this.fixFilePath(string))).exists()) continue;
            if (file.isDirectory()) {
                bl = this.deleteDirectory(file);
                continue;
            }
            bl = file.delete();
            if (bl) continue;
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            bl = file.delete();
        }
        return bl;
    }

    public boolean deleteDirectory(File file) {
        if (file.exists()) {
            File[] fileArray = file.listFiles();
            for (int i = 0; i < fileArray.length; ++i) {
                if (fileArray[i].isDirectory()) {
                    this.deleteDirectory(fileArray[i]);
                    continue;
                }
                fileArray[i].delete();
            }
            return file.delete();
        }
        return false;
    }

    public boolean saveDesign(Design design) {
        try {
            Object object;
            Object object22;
            Object object3;
            Object object4;
            Object object5;
            ModelIDObject modelIDObject;
            this.saveFailed = false;
            int n = design.getCurrentOperation();
            if (n == 4 || n == 5) {
                this.checkDirty = false;
            }
            this.saveRDBMSSites(design);
            this.saveDomains(design);
            this.saveChangeRequestList(design);
            ArrayList<Object> arrayList = new ArrayList<Object>();
            arrayList.add(design);
            if (this.isCheckDirty()) {
                if (design.getExtendedMap().isDirty()) {
                    arrayList.add(design.getExtendedMap());
                }
            } else {
                arrayList.add(design.getExtendedMap());
            }
            Iterator iterator = design.getChangeRequestSet().iterator();
            while (iterator.hasNext()) {
                modelIDObject = (ChangeRequest)iterator.next();
                arrayList.add(modelIDObject);
            }
            if (this.isCheckDirty()) {
                if (design.getBusinessInfoDesign().isLoaded() && (design.getBusinessInfoDesign().isDirty() || design.getBusinessInfoDesign().hasDirtyStorableObjects())) {
                    arrayList.add(design.getBusinessInfoDesign());
                    arrayList.addAll(design.getBusinessInfoDesign().getStorableDesignObjects());
                    this.saveObjectList(design.getBusinessInfoDesign());
                }
            } else if (design.getBusinessInfoDesign().isLoaded() && design.shouldExportFull(design.getBusinessInfoDesign())) {
                arrayList.add(design.getBusinessInfoDesign());
                arrayList.addAll(design.getBusinessInfoDesign().getStorableDesignObjects());
                this.saveObjectList(design.getBusinessInfoDesign());
            }
            if (((DesignPart)(modelIDObject = design.getDataTypesDesign())).isLoaded() && (design.shouldExportFull((DesignPart)modelIDObject) || design.shouldExportPartial((DesignPart)modelIDObject))) {
                arrayList.add(modelIDObject);
                arrayList.addAll(((DesignPart)modelIDObject).getStorableDesignObjects());
                this.saveObjectList((DesignPart)modelIDObject);
                this.saveDiagrams((DesignPart)modelIDObject);
                this.saveDDLSelection((DesignPart)modelIDObject, ((DataTypesDesign)modelIDObject).getNotMarkedGenerateObjects());
            }
            if (design.getLogicalDesign().isLoaded() && (design.shouldExportFull(design.getLogicalDesign()) || design.shouldExportPartial(design.getLogicalDesign()))) {
                arrayList.add(design.getLogicalDesign());
                if (design.shouldExportPartial(design.getLogicalDesign())) {
                    object5 = design.getLogicalDesign().getStorableDesignObjects();
                    object4 = object5.iterator();
                    while (object4.hasNext()) {
                        object3 = (DesignObject)object4.next();
                        if (!design.shouldExport((DesignObject)object3)) continue;
                        arrayList.add(object3);
                    }
                } else {
                    arrayList.addAll(design.getLogicalDesign().getStorableDesignObjects());
                }
                this.saveObjectList(design.getLogicalDesign());
                this.saveDiagrams(design.getLogicalDesign());
            }
            object5 = design.getRelationalDesigns().iterator();
            while (object5.hasNext()) {
                object4 = (DesignPart)object5.next();
                if (!((DesignPart)object4).isLoaded() || !design.shouldExportFull((DesignPart)object4) && !design.shouldExportPartial((DesignPart)object4)) continue;
                object3 = (RelationalDesign)object4;
                arrayList.add(object4);
                if (this.isCheckDirty()) {
                    if (((RelationalDesign)object3).getRMExtendedMap().isDirty()) {
                        arrayList.add(((RelationalDesign)object3).getRMExtendedMap());
                    }
                } else {
                    arrayList.add(((RelationalDesign)object3).getRMExtendedMap());
                }
                if (design.shouldExportPartial((DesignPart)object4)) {
                    object22 = ((DesignPart)object4).getStorableDesignObjects();
                    Iterator iterator2 = object22.iterator();
                    while (iterator2.hasNext()) {
                        object = (DesignObject)iterator2.next();
                        if (!design.shouldExport((DesignObject)object)) continue;
                        arrayList.add(object);
                    }
                } else {
                    arrayList.addAll(((DesignPart)object4).getStorableDesignObjects());
                }
                this.saveObjectList((DesignPart)object4);
                this.saveDiagrams((DesignPart)object4);
                this.saveDDLSelection((DesignPart)object3, ((RelationalDesign)object3).getNotMarkedGenerateObjects());
                object22 = ((RelationalDesign)object3).getStorageDesignFactory().getOpenStorageDesigns();
                for (int i = 0; i < ((StorageDesign[])object22).length; ++i) {
                    List list;
                    object = object22[i];
                    if (!((StorageDesign)object).isOpen()) continue;
                    DataModelerAddin.saveAllEditors((StorageDesign)object);
                    arrayList.add(object);
                    this.saveObjectList((StorageDesign)object);
                    this.saveDDLSelection((StorageDesign)object);
                    if (this.isCheckDirty()) {
                        if (!((ModelIDObject)object).isDirty() && !((StorageDesign)object).hasDirtyStorableObjects()) continue;
                        if (design.isOldRepositoryType()) {
                            this.clearPropertyMap(((StorageDesign)object).getStorableObjects());
                        }
                        if (design.shouldExportPartial((DesignPart)object4)) {
                            list = ((StorageDesign)object).getStorableObjects();
                            for (Object e : list) {
                                if (!(e instanceof RelationalObjectProxy) || !design.shouldExport((RelationalObjectProxy)e)) continue;
                                arrayList.add((StorableObject)e);
                            }
                            continue;
                        }
                        arrayList.addAll(((StorageDesign)object).getStorableObjects());
                        continue;
                    }
                    if (design.isOldRepositoryType()) {
                        this.clearPropertyMap(((StorageDesign)object).getStorableObjects());
                    }
                    if (design.shouldExportPartial((DesignPart)object4)) {
                        list = ((StorageDesign)object).getStorableObjects();
                        for (Object e : list) {
                            if (!(e instanceof RelationalObjectProxy) || !design.shouldExport((RelationalObjectProxy)e)) continue;
                            arrayList.add((StorableObject)e);
                        }
                        continue;
                    }
                    arrayList.addAll(((StorageDesign)object).getStorableObjects());
                }
            }
            object5 = design.getMultidimensionalDesigns().iterator();
            while (object5.hasNext()) {
                object4 = (MultidimensionalDesign)object5.next();
                this.saveObjectList((DesignPart)object4);
                this.saveDiagrams((DesignPart)object4);
                if (this.isCheckDirty()) {
                    if (!((DesignPart)object4).isLoaded() || !((ModelIDObject)object4).isDirty() && !((DesignPart)object4).hasDirtyStorableObjects()) continue;
                    arrayList.add(object4);
                    arrayList.addAll(((DesignPart)object4).getStorableDesignObjects());
                    continue;
                }
                if (!((DesignPart)object4).isLoaded() || !design.shouldExportFull((DesignPart)object4) && !design.shouldExportPartial((DesignPart)object4)) continue;
                arrayList.add(object4);
                arrayList.addAll(((DesignPart)object4).getStorableDesignObjects());
            }
            if (this.isCheckDirty()) {
                if (design.getProcessModel().isLoaded()) {
                    object4 = design.getProcessModel();
                    this.saveObjectList((DesignPart)object4);
                    arrayList.add(object4);
                    arrayList.addAll(((DesignPart)object4).getStorableDesignObjects());
                    object5 = ((ProcessModel)object4).getDataFlowDesigns().iterator();
                    while (object5.hasNext()) {
                        object3 = (DataFlowDesign)object5.next();
                        this.saveObjectList((DesignPart)object3);
                        this.saveDiagrams((DesignPart)object3);
                        if (!((DesignPart)object3).isLoaded() || !((ModelIDObject)object3).isDirty() && !((DesignPart)object3).hasDirtyStorableObjects()) continue;
                        arrayList.add(object3);
                        arrayList.addAll(((DesignPart)object3).getStorableDesignObjects());
                    }
                    object3 = design.getProcessModel().getTransformationPackageSet().iterator();
                    while (object3.hasNext()) {
                        object22 = (TransformationPackage)object3.next();
                        Iterator iterator3 = ((TransformationPackage)object22).getTransformationTaskSet().iterator();
                        while (iterator3.hasNext()) {
                            object = (TransformationTask)iterator3.next();
                            this.saveObjectList((DesignPart)object);
                            this.saveDiagrams((DesignPart)object);
                            if (!((DesignPart)object).isLoaded() || !((ModelIDObject)object).isDirty() && !((DesignPart)object).hasDirtyStorableObjects()) continue;
                            arrayList.add(object);
                            arrayList.addAll(((DesignPart)object).getStorableDesignObjects());
                        }
                    }
                }
            } else if (design.getProcessModel().isLoaded() && design.shouldExportFull(design.getProcessModel())) {
                object4 = design.getProcessModel();
                this.saveObjectList((DesignPart)object4);
                arrayList.add(object4);
                arrayList.addAll(((DesignPart)object4).getStorableDesignObjects());
                object5 = ((ProcessModel)object4).getDataFlowDesigns().iterator();
                while (object5.hasNext()) {
                    object3 = (DataFlowDesign)object5.next();
                    this.saveObjectList((DesignPart)object3);
                    this.saveDiagrams((DesignPart)object3);
                    if (!((DesignPart)object3).isLoaded()) continue;
                    arrayList.add(object3);
                    arrayList.addAll(((DesignPart)object3).getStorableDesignObjects());
                }
                object3 = design.getProcessModel().getTransformationPackageSet().iterator();
                while (object3.hasNext()) {
                    object22 = (TransformationPackage)object3.next();
                    Iterator iterator4 = ((TransformationPackage)object22).getTransformationTaskSet().iterator();
                    while (iterator4.hasNext()) {
                        object = (TransformationTask)iterator4.next();
                        this.saveObjectList((DesignPart)object);
                        this.saveDiagrams((DesignPart)object);
                        if (!((DesignPart)object).isLoaded()) continue;
                        arrayList.add(object);
                        arrayList.addAll(((DesignPart)object).getStorableDesignObjects());
                    }
                }
            }
            object4 = new ArrayList();
            for (Object object22 : arrayList) {
                if (object22 instanceof DesignPart || object22 instanceof StorageDesign) {
                    object4.add(object22);
                    continue;
                }
                this.saveObject((StorableObject)object22);
            }
            object22 = object4.iterator();
            while (object22.hasNext()) {
                ModelIDObject modelIDObject2 = (ModelIDObject)object22.next();
                this.saveObject(modelIDObject2);
                if (modelIDObject2 instanceof DesignPart) {
                    object = (DesignPart)modelIDObject2;
                    try {
                        ((DesignPart)object).synchronizeFilesMap(true);
                    }
                    catch (Exception exception) {
                        LOGGER.error("Error in cleaning files in model: " + ((ModelObject)object).getName(), exception);
                    }
                    continue;
                }
                if (!(modelIDObject2 instanceof StorageDesign)) continue;
                object = (StorageDesign)modelIDObject2;
                try {
                    ((StorageDesign)object).doAfterSave();
                }
                catch (Exception exception) {
                    LOGGER.error("Error in cleaning files in physical model: " + ((ModelObject)object).getName(), exception);
                }
            }
            design.saveDesignLevelSettings();
            if (this.saveFailed) {
                MessageDialogs.showErrorMessage(Messages.getString("XMLPersistenceManager.SomeObjectsAreNotSavedCorrectly"));
                return false;
            }
            return true;
        }
        catch (Exception exception) {
            LOGGER.error("Unable to save the design: " + design.getName(), exception);
            MessageDialogs.showErrorMessage("Unable to save the design: " + design.getName());
            return false;
        }
    }

    private void saveDDLSelection(DesignPart designPart, List<StorableObject> list) {
        this.saveDDLSelection(designPart.getClass().getName(), designPart.getStoragePath(), list.iterator(), DDL_SELECTION_LIST, designPart.getDesign().isCompressedDesign());
    }

    public void saveDDLSelection(StorageDesign storageDesign) {
        this.saveDDLSelection(storageDesign.getClass().getName(), storageDesign.getStoragePath(), storageDesign.getNotMarkedGenerateObjects().iterator(), DDL_SELECTION_LIST, storageDesign.getDesign().isCompressedDesign());
    }

    private void restoreDDLSelection(DesignPart designPart) {
        Design design = designPart.getDesign();
        List<ObjectHelper> list = this.getObjects(designPart.getStoragePath(), DDL_SELECTION_LIST, design.isCompressedDesign());
        for (ObjectHelper objectHelper : list) {
            DesignObject designObject = design.getDesignObject(objectHelper.id);
            if (designObject == null) continue;
            designObject.setMarkedGenerate(false);
        }
    }

    public void restoreDDLSelection(StorageDesign storageDesign) {
        List<ObjectHelper> list = this.getObjects(storageDesign.getStoragePath(), DDL_SELECTION_LIST, storageDesign.getDesign().isCompressedDesign());
        for (ObjectHelper objectHelper : list) {
            ModelIDObject modelIDObject = storageDesign.getModelIDObject(objectHelper.id);
            if (modelIDObject == null) continue;
            modelIDObject.setMarkedGenerate(false);
        }
    }

    public boolean saveDesignPart(DesignPart designPart) {
        try {
            Object object2;
            this.saveFailed = false;
            ArrayList<RepositoryObject> arrayList = new ArrayList<RepositoryObject>();
            arrayList.add(designPart);
            if (this.isCheckDirty()) {
                if (designPart.isLoaded() && (designPart.isDirty() || designPart.hasDirtyStorableObjects())) {
                    arrayList.addAll(designPart.getStorableDesignObjects());
                    if (!(designPart instanceof BusinessInfoDesign) && !(designPart instanceof ProcessModel)) {
                        this.saveDiagrams(designPart);
                    }
                    if (designPart instanceof RelationalDesign && ((RelationalDesign)(object2 = (RelationalDesign)designPart)).getRMExtendedMap().isDirty()) {
                        arrayList.add(((RelationalDesign)object2).getRMExtendedMap());
                    }
                }
            } else if (designPart.isLoaded()) {
                arrayList.addAll(designPart.getStorableDesignObjects());
                arrayList.add(((RelationalDesign)designPart).getRMExtendedMap());
                if (!(designPart instanceof BusinessInfoDesign) && !(designPart instanceof ProcessModel)) {
                    this.saveDiagrams(designPart);
                }
            }
            object2 = new ArrayList();
            for (StorableObject object3 : arrayList) {
                if (object3 instanceof DesignPart) {
                    object2.add(object3);
                    continue;
                }
                this.saveObject(object3);
            }
            if (this.isCheckDirty()) {
                if (designPart.isLoaded() && (designPart.isDirty() || designPart.hasDirtyStorableObjects())) {
                    this.saveObjectList(designPart);
                }
            } else if (designPart.isLoaded()) {
                this.saveObjectList(designPart);
            }
            Iterator iterator = object2.iterator();
            while (iterator.hasNext()) {
                DesignPart designPart2 = (DesignPart)iterator.next();
                try {
                    this.saveObject(designPart2);
                    designPart2.synchronizeFilesMap(true);
                }
                catch (Exception exception) {
                    LOGGER.error("Error in cleaning files in model: " + designPart2.getName(), exception);
                }
            }
            if (this.saveFailed) {
                MessageDialogs.showErrorMessage(Messages.getString("XMLPersistenceManager.SomeObjectsAreNotSavedCorrectly"));
                return false;
            }
            return true;
        }
        catch (Exception exception) {
            LOGGER.error("Unable to save the Design Part: " + designPart.getName(), exception);
            MessageDialogs.showErrorMessage("Unable to save the Design Part: " + designPart.getName());
            return false;
        }
    }

    private MDTransformationManager getMDTransformationManager() {
        if (this.mdtManager == null) {
            this.mdtManager = new MDTransformationManager(this.metaDataManager);
            this.mdtManager.registerTransformer(ModelIDObject.class, XMLFromObjTransformer.class, XMLToObjectTransformer.class, XMLObjToStreamTransformer.class);
            this.mdtManager.registerTransformer(Object.class, XMLFromObjTransformer.class, XMLToObjectTransformer.class, XMLObjToStreamTransformer.class);
            MDTransformer.SKP_DEFAULTS = true;
        }
        return this.mdtManager;
    }

    public Document getXMLContent(Object object) {
        MDTransformationManager.TrObjects trObjects = this.getMDTransformationManager().getTransformersFor(object.getClass());
        if (trObjects != null && trObjects.getFromObjectTransformer() != null) {
            return ((XMLFromObjTransformer)trObjects.getFromObjectTransformer()).transformFromObject(object);
        }
        return null;
    }

    public String getContentAsString(Object object) {
        MDTransformationManager.TrObjects trObjects = this.getMDTransformationManager().getTransformersFor(object.getClass());
        if (trObjects != null && trObjects.getFromObjectTransformer() != null) {
            return ((XMLObjToStringBuilderTransformer)trObjects.getFromObjectTransformer()).transformFromObjectToString(object);
        }
        return null;
    }

    private boolean saveObject(StorableObject storableObject) {
        if (storableObject instanceof StorageObject && ((StorageObject)storableObject).isNullInstance() && !((StorageObject)storableObject).isStorableNullInstance()) {
            return false;
        }
        Design design = storableObject.getDesign();
        if (!this.isCheckDirty() || this.isCheckDirty() && this.hasDirtyStatus(storableObject)) {
            String string = storableObject.getStorageName();
            if (storableObject instanceof ModelIDObject) {
                if (!this.isCheckDirty()) {
                    ((ModelIDObject)storableObject).setSegmentedStorageName(null);
                }
                string = ((ModelIDObject)storableObject).getSegmentedStorageName();
            }
            if (string != null) {
                try {
                    XMLTransformationManager.saveContent(string, storableObject, design.isCompressedDesign(), this.getMDTransformationManager());
                    this.clearDirtyStatus(storableObject);
                    if (storableObject instanceof DesignPart) {
                        ((DesignPart)storableObject).doAfterSave();
                    } else if (storableObject instanceof StorageDesign) {
                        ((StorageDesign)storableObject).doAfterSave();
                    }
                    if (Extension.isSVNExtensionLoaded() && design.isVersioned()) {
                        SVNClientHelper.getInstance().saveProperties(storableObject);
                    }
                    return true;
                }
                catch (Exception exception) {
                    LOGGER.error("Can not write data! Location: " + storableObject.getStorageName() + " - Name: " + storableObject.getName(), exception);
                    this.saveFailed = true;
                }
            }
        }
        return false;
    }

    public boolean transformFromXMLToObject(Object object, File file, boolean bl) {
        return this.transformFromXMLToObject(object, file, bl, true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean transformFromXMLToObject(Object object, File file, boolean bl, boolean bl2) {
        MDTransformationManager.TrObjects trObjects = this.getMDTransformationManager().getTransformersFor(object.getClass());
        if (trObjects == null) return false;
        if (trObjects.getToObjectTransformer() == null) return false;
        try {
            String string = file.getAbsolutePath();
            if (bl) {
                Document document;
                if (!string.endsWith(COMPRESSED_FILE_SUFIX)) {
                    string = string + COMPRESSED_FILE_SUFIX;
                    File file2 = new File(string);
                    document = XMLTransformationManager.getDocument(file2);
                } else {
                    document = XMLTransformationManager.getDocument(file);
                }
                if (document == null) return false;
                ((XMLToObjectTransformer)trObjects.getToObjectTransformer()).transformToObject(object, document);
            } else {
                MDTransformer mDTransformer = trObjects.getToObjectTransformer();
                if (mDTransformer instanceof XMLToObjectTransformer) {
                    ((XMLToObjectTransformer)trObjects.getToObjectTransformer()).transformToObject(object, file);
                }
            }
            if (!bl2) return true;
            this.clearDirtyStatus(object);
            return true;
        }
        catch (Exception exception) {
            boolean bl3 = true;
            if (exception instanceof FileNotFoundException && object instanceof ModelIDObject) {
                ModelIDObject modelIDObject = (ModelIDObject)object;
                String string = modelIDObject.getObjectID();
                if ("47E390DE-0671-C4B1-8428-0F45CBEE18F8".equals(string)) return false;
                if ("F72C39E0-D1CA-8821-2AD7-A1E95A37D3D1".equals(string)) {
                    return false;
                }
            }
            if (!bl3) return false;
            LOGGER.error("Unable to load object from XML: " + file.getAbsolutePath(), exception);
        }
        return false;
    }

    public void transformFromXMLToObject(Object object, Document document) {
        XMLToObjectTransformer xMLToObjectTransformer = (XMLToObjectTransformer)this.getMDTransformationManager().getToObjectTransformerFor(object.getClass());
        if (xMLToObjectTransformer != null && document != null) {
            xMLToObjectTransformer.transformToObject(object, document);
        }
    }

    public void openChangeRequestList(Design design) {
        this.createObjectList(design.getClass().getName(), design.getFolderToTypeMap(), design.getStoragePath(), CHANGE_REQUEST_LIST, design.isCompressedDesign());
        List<ObjectHelper> list = this.getObjects(design.getStoragePath(), CHANGE_REQUEST_LIST, design.isCompressedDesign());
        for (ObjectHelper objectHelper : list) {
            ChangeRequest changeRequest = design.getChangeRequestSet().createChangeRequest(objectHelper.id);
            changeRequest.setName(objectHelper.name);
            this.transformFromXMLToObject(changeRequest, new File(changeRequest.getStorageName()), design.isCompressedDesign());
        }
    }

    protected void saveChangeRequestList(Design design) {
        if ((!this.isCheckDirty() || this.isCheckDirty() && design.isChangeRequestListChanged()) && this.saveObjectList(design.getClass().getName(), design.getStoragePath(), design.getChangeRequestSet().iterator(), CHANGE_REQUEST_LIST, design.isCompressedDesign(), new String[0])) {
            design.setChangeRequestListChanged(false);
        }
    }

    protected void saveObjectList(DesignPart designPart) {
        if ((!this.isCheckDirty() || this.isCheckDirty() && designPart.isObjectListChanged()) && this.saveObjectList(designPart.getClass().getName(), designPart.getStoragePath(), designPart.getStorableDesignObjects().iterator(), OBJECT_LIST, designPart.getDesign().isCompressedDesign(), new String[0])) {
            designPart.setObjectListChanged(false);
        }
    }

    protected void saveDiagrams(DesignPart designPart) {
        ArrayList<DesignPartView> arrayList = new ArrayList<DesignPartView>();
        DesignPartViewPlaceHolder designPartViewPlaceHolder = designPart.getMainDPVPlaceHolder();
        arrayList.add(designPartViewPlaceHolder.getDesignPartView());
        Iterator iterator = designPart.getDesignSubviews().iterator();
        while (iterator.hasNext()) {
            designPartViewPlaceHolder = (DesignPartViewPlaceHolder)iterator.next();
            if (designPart.getDesign().shouldExportPartial(designPart)) {
                if (!designPart.getDesign().shouldExportDPV(designPartViewPlaceHolder.getDesignPartView()) || designPartViewPlaceHolder.getDesignPartView() instanceof DPVCompactMultidimentional) continue;
                arrayList.add(designPartViewPlaceHolder.getDesignPartView());
                continue;
            }
            if (designPartViewPlaceHolder.getDesignPartView() instanceof DPVCompactMultidimentional) continue;
            arrayList.add(designPartViewPlaceHolder.getDesignPartView());
        }
        this.saveObjectList(designPart.getClass().getName(), designPart.getStoragePath(), arrayList.iterator(), DIAGRAM_LIST, designPart.getDesign().isCompressedDesign(), new String[0]);
        for (DesignPartView designPartView : arrayList) {
            if (this.isCheckDirty() && (!this.isCheckDirty() || !designPartView.isDirty())) continue;
            this.saveObject(designPartView);
        }
    }

    public void saveObjectsAndDiagramsList(DesignPart designPart) {
        this.saveObjectList(designPart);
        ArrayList<DesignPartView> arrayList = new ArrayList<DesignPartView>();
        DesignPartViewPlaceHolder designPartViewPlaceHolder = designPart.getMainDPVPlaceHolder();
        arrayList.add(designPartViewPlaceHolder.getDesignPartView());
        Iterator iterator = designPart.getDesignSubviews().iterator();
        while (iterator.hasNext()) {
            designPartViewPlaceHolder = (DesignPartViewPlaceHolder)iterator.next();
            arrayList.add(designPartViewPlaceHolder.getDesignPartView());
        }
        this.saveObjectList(designPart.getClass().getName(), designPart.getStoragePath(), arrayList.iterator(), DIAGRAM_LIST, designPart.getDesign().isCompressedDesign(), new String[0]);
    }

    protected void saveObjectList(StorageDesign storageDesign) {
        if ((!this.isCheckDirty() || this.isCheckDirty() && storageDesign.isObjectListChanged()) && this.saveObjectList(storageDesign.getClass().getName(), storageDesign.getStoragePath(), storageDesign.getStorableObjects().iterator(), OBJECT_LIST, storageDesign.getDesign().isCompressedDesign(), new String[0])) {
            storageDesign.setObjectListChanged(false);
        }
    }

    protected boolean saveObjectList(String string, String string2, Iterator iterator, String string3, boolean bl, String ... stringArray) {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.newDocument();
            Element element = document.createElement(string);
            document.appendChild(element);
            while (iterator.hasNext()) {
                RepositoryObject repositoryObject;
                Object object;
                Object e = iterator.next();
                if (!(e instanceof DesignObject) ? e instanceof RelationalObjectProxy && !((ModelObject)(object = (RelationalObjectProxy)e)).getDesign().shouldExport((RelationalObjectProxy)object) : ((repositoryObject = ((DesignObject)(object = (DesignObject)e)).getDesignPart()) instanceof LogicalDesign || repositoryObject instanceof RelationalDesign) && ((ModelObject)((Object)repositoryObject)).getDesign().shouldExportPartial((DesignPart)repositoryObject) && !((ModelObject)((Object)repositoryObject)).getDesign().shouldExport((DesignObject)object)) continue;
                if (e instanceof StorageObject && ((StorageObject)e).isNullInstance() && !((StorageObject)e).isStorableNullInstance()) continue;
                object = document.createElement("object");
                element.appendChild((Node)object);
                if (e instanceof DesignObject) {
                    repositoryObject = (DesignObject)e;
                    object.setAttribute("objectType", ((DesignObject)repositoryObject).getObjectTypeName());
                    object.setAttribute("objectID", ((ModelIDObject)repositoryObject).getObjectID());
                    object.setAttribute("name", StringUtilities.encodeAttributeValue(((DesignObject)repositoryObject).getName()));
                    object.setAttribute("seqName", ((DesignObject)repositoryObject).getDirectorySegmentName());
                } else if (e instanceof StorageObject) {
                    repositoryObject = (StorageObject)e;
                    object.setAttribute("objectType", ((StorageObject)repositoryObject).getObjectTypeName());
                    object.setAttribute("objectID", ((ModelIDObject)repositoryObject).getObjectID());
                    object.setAttribute("name", ((StorageObject)repositoryObject).getName());
                    object.setAttribute("seqName", ((StorageObject)repositoryObject).getDirectorySegmentName());
                } else if (e instanceof DesignPartView) {
                    repositoryObject = (DesignPartView)e;
                    String string4 = "sub_view";
                    if (repositoryObject == ((DesignPartView)repositoryObject).getDesignPart().getMainView()) {
                        string4 = "main_view";
                    }
                    object.setAttribute("objectType", string4);
                    object.setAttribute("objectID", ((DesignPartView)repositoryObject).getDPVId());
                    object.setAttribute("name", StringUtilities.encodeAttributeValue(((DesignPartView)repositoryObject).getName()));
                    object.setAttribute("visible", ((DesignPartView)repositoryObject).isEditorVisible() ? "true" : "false");
                }
                if (stringArray == null) continue;
                for (int i = 0; i < stringArray.length; i += 2) {
                    object.setAttribute(stringArray[i], stringArray[i + 1]);
                }
            }
            XMLTransformationManager.saveDocument(new File(string2, string3).getCanonicalPath(), document, bl);
            return true;
        }
        catch (Exception exception) {
            LOGGER.error("Can not save Object List for: " + string, exception);
            return false;
        }
    }

    protected boolean saveDDLSelection(String string, String string2, Iterator iterator, String string3, boolean bl) {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.newDocument();
            Element element = document.createElement(string);
            document.appendChild(element);
            while (iterator.hasNext()) {
                Object e = iterator.next();
                Element element2 = document.createElement("object");
                if (e instanceof DesignObject) {
                    element2.setAttribute("objectID", ((DesignObject)e).getObjectID());
                    if (ApplicationView.debugMode) {
                        element2.setAttribute("objectType", ((DesignObject)e).getObjectTypeName());
                    }
                } else {
                    if (!(e instanceof StorageObject)) continue;
                    element2.setAttribute("objectID", ((StorageObject)e).getObjectID());
                    if (ApplicationView.debugMode) {
                        element2.setAttribute("objectType", ((StorageObject)e).getObjectTypeName());
                    }
                }
                element2.setAttribute(MARKED_GENERATE, Boolean.FALSE.toString());
                element.appendChild(element2);
            }
            XMLTransformationManager.saveDocument(new File(string2, string3).getCanonicalPath(), document, bl);
            return true;
        }
        catch (ParserConfigurationException parserConfigurationException) {
            LOGGER.error("Can not save DDL Selection list for: " + string, parserConfigurationException);
        }
        catch (IOException iOException) {
            LOGGER.error("Can not save DDL Selection list for: " + string, iOException);
        }
        return false;
    }

    private List<DesignPartHelper> getModels(Design design) {
        SVNClientHelper sVNClientHelper = null;
        if (Extension.isSVNExtensionLoaded()) {
            sVNClientHelper = SVNClientHelper.getInstance();
        }
        ArrayList<DesignPartHelper> arrayList = new ArrayList<DesignPartHelper>();
        try {
            DesignPartHelper designPartHelper;
            File[] fileArray;
            int n;
            Object object;
            File file = new File(design.getStoragePath(), "businessinfo");
            String string = design.getBusinessInfoDesign().getName() + ".xml";
            if (design.isCompressedDesign()) {
                string = string + COMPRESSED_FILE_SUFIX;
            }
            File file2 = new File(file, string);
            if (!(sVNClientHelper != null && sVNClientHelper.isDeleted(file2) || (object = XMLTransformationManager.getDesignPartHelperFor(file2, design.isCompressedDesign(), "Business Information")) == null)) {
                arrayList.add((DesignPartHelper)object);
            }
            file = new File(design.getStoragePath(), "datatypes");
            string = design.getDataTypesDesign().getName() + ".xml";
            if (design.isCompressedDesign()) {
                string = string + COMPRESSED_FILE_SUFIX;
            }
            file2 = new File(file, string);
            if (!(sVNClientHelper != null && sVNClientHelper.isDeleted(file2) || (object = XMLTransformationManager.getDesignPartHelperFor(file2, design.isCompressedDesign(), "Data Types")) == null)) {
                arrayList.add((DesignPartHelper)object);
            }
            file = new File(design.getStoragePath(), "logical");
            string = design.getLogicalDesign().getName() + ".xml";
            if (design.isCompressedDesign()) {
                string = string + COMPRESSED_FILE_SUFIX;
            }
            file2 = new File(file, string);
            if (!(sVNClientHelper != null && sVNClientHelper.isDeleted(file2) || (object = XMLTransformationManager.getDesignPartHelperFor(file2, design.isCompressedDesign(), "LogicalDesign")) == null)) {
                arrayList.add((DesignPartHelper)object);
            }
            if ((file = new File(design.getStoragePath(), "rel")).exists()) {
                object = file.listFiles(this.filter);
                for (n = 0; n < ((File[])object).length; ++n) {
                    fileArray = object[n];
                    if (sVNClientHelper != null && sVNClientHelper.isDeleted((File)fileArray) || (designPartHelper = XMLTransformationManager.getDesignPartHelperFor((File)fileArray, design.isCompressedDesign(), "RelationalModel")) == null) continue;
                    arrayList.add(designPartHelper);
                }
            }
            if ((file = new File(design.getStoragePath(), "multidimensional")).exists()) {
                object = file.listFiles(this.filter);
                for (n = 0; n < ((File[])object).length; ++n) {
                    fileArray = object[n];
                    if (sVNClientHelper != null && sVNClientHelper.isDeleted((File)fileArray) || (designPartHelper = XMLTransformationManager.getDesignPartHelperFor((File)fileArray, design.isCompressedDesign(), "Dimensional Model")) == null) continue;
                    arrayList.add(designPartHelper);
                }
            }
            file = new File(design.getStoragePath(), "pm");
            string = design.getProcessModel().getName() + ".xml";
            if (design.isCompressedDesign()) {
                string = string + COMPRESSED_FILE_SUFIX;
            }
            file2 = new File(file, string);
            if (!(sVNClientHelper != null && sVNClientHelper.isDeleted(file2) || (object = XMLTransformationManager.getDesignPartHelperFor(file2, design.isCompressedDesign(), "Process Model")) == null)) {
                arrayList.add((DesignPartHelper)object);
            }
            if ((file = new File(design.getStoragePath(), "pm/dflows")).exists()) {
                object = new ArrayList();
                ArrayList<DesignPartHelper> arrayList2 = new ArrayList<DesignPartHelper>();
                fileArray = file.listFiles(this.filter);
                for (int i = 0; i < fileArray.length; ++i) {
                    DesignPartHelper designPartHelper2;
                    File file3 = fileArray[i];
                    if (sVNClientHelper != null && sVNClientHelper.isDeleted(file3) || (designPartHelper2 = XMLTransformationManager.getDesignPartHelperFor(file3, design.isCompressedDesign(), "Data Flow Diagram")) == null) continue;
                    if (designPartHelper2.top_level_dfd_design) {
                        arrayList2.add(0, designPartHelper2);
                        continue;
                    }
                    object.add(designPartHelper2);
                }
                this.orderDFDs_byParent((List)object, arrayList2);
                arrayList.addAll(arrayList2);
            }
        }
        catch (Exception exception) {
            LOGGER.error("Can not load Models from Design: " + design.getStoragePath(), exception);
        }
        return arrayList;
    }

    private void orderDFDs_byParent(List list, List list2) {
        for (DesignPartHelper designPartHelper : list) {
            if (list2.contains(designPartHelper)) continue;
            this.addParent(designPartHelper, list, list2);
            list2.add(designPartHelper);
        }
    }

    private void addParent(DesignPartHelper designPartHelper, List list, List list2) {
        if (designPartHelper.parent_id != null) {
            for (int i = 0; i < list.size(); ++i) {
                DesignPartHelper designPartHelper2 = (DesignPartHelper)list.get(i);
                if (!designPartHelper2.id.equals(designPartHelper.parent_id)) continue;
                this.addParent(designPartHelper2, list, list2);
                if (list2.contains(designPartHelper2)) continue;
                list2.add(designPartHelper2);
            }
        }
    }

    private List<DesignPartHelper> getTransformationTasks(TransformationPackage transformationPackage) {
        SVNClientHelper sVNClientHelper = null;
        if (Extension.isSVNExtensionLoaded()) {
            sVNClientHelper = SVNClientHelper.getInstance();
        }
        ArrayList<DesignPartHelper> arrayList = new ArrayList<DesignPartHelper>();
        try {
            File file = new File(transformationPackage.getStoragePath(), "tt");
            if (file.exists()) {
                File[] fileArray = file.listFiles(this.filter);
                for (int i = 0; i < fileArray.length; ++i) {
                    DesignPartHelper designPartHelper;
                    File file2 = fileArray[i];
                    if (sVNClientHelper != null && sVNClientHelper.isDeleted(file2) || (designPartHelper = XMLTransformationManager.getDesignPartHelperFor(file2, transformationPackage.getDesign().isCompressedDesign(), "TransformationTask")) == null) continue;
                    arrayList.add(designPartHelper);
                }
            }
        }
        catch (Exception exception) {
            LOGGER.error("Can not load Transformation Tasks: " + transformationPackage.getStoragePath(), exception);
        }
        return arrayList;
    }

    public static DesignPartHelper getDesignPartHelperFor(File file, boolean bl, String string) {
        if (file.exists() && file.isFile()) {
            try {
                Object object;
                Object object2;
                Object object3;
                Document document = null;
                if (bl) {
                    document = XMLTransformationManager.getDocument(file);
                } else {
                    object3 = DocumentBuilderFactory.newInstance();
                    object2 = ((DocumentBuilderFactory)object3).newDocumentBuilder();
                    object = new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8");
                    document = ((DocumentBuilder)object2).parse(new InputSource((Reader)object));
                    ((InputStreamReader)object).close();
                }
                if (document != null) {
                    object3 = new DesignPartHelper();
                    object2 = document.getDocumentElement();
                    ((DesignPartHelper)object3).type = string;
                    ((DesignPartHelper)object3).name = object2.getAttribute("name");
                    ((DesignPartHelper)object3).id = object2.getAttribute("id");
                    object = object2.getAttribute("parentDFD_ID");
                    if (object != null && !"".equals(object)) {
                        ((DesignPartHelper)object3).parent_id = object;
                    }
                    ((DesignPartHelper)object3).main_view_id = object2.getAttribute("mainViewID");
                    String string2 = object2.getAttribute("topLevel");
                    ((DesignPartHelper)object3).top_level_dfd_design = "true".equalsIgnoreCase(string2);
                    return object3;
                }
            }
            catch (Exception exception) {
                LOGGER.error("Can not parse file: " + file.getAbsolutePath(), exception);
            }
        }
        return null;
    }

    private static DesignPartHelper getDesignPartInfo(File file, boolean bl) {
        if (file.exists()) {
            try {
                Object object;
                Object object2;
                Object object3;
                Document document = null;
                if (bl) {
                    document = XMLTransformationManager.getDocument(file);
                } else {
                    object3 = DocumentBuilderFactory.newInstance();
                    object2 = ((DocumentBuilderFactory)object3).newDocumentBuilder();
                    object = new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8");
                    document = ((DocumentBuilder)object2).parse(new InputSource((Reader)object));
                    ((InputStreamReader)object).close();
                }
                if (document != null) {
                    object3 = new DesignPartHelper();
                    object2 = document.getDocumentElement();
                    object = object2.getAttribute("class");
                    if (((String)object).endsWith("SubView")) {
                        ((DesignPartHelper)object3).type = "sub_view";
                        ((DesignPartHelper)object3).visible = false;
                    } else {
                        ((DesignPartHelper)object3).type = "main_view";
                        ((DesignPartHelper)object3).visible = ((String)object).equalsIgnoreCase(DPVLogical.class.getName()) || ((String)object).equalsIgnoreCase(DPVRelational.class.getName());
                    }
                    ((DesignPartHelper)object3).name = object2.getAttribute("name");
                    ((DesignPartHelper)object3).id = object2.getAttribute("id");
                    return object3;
                }
            }
            catch (Exception exception) {
                LOGGER.error("Can not parse file: " + file.getAbsolutePath(), exception);
            }
        }
        return null;
    }

    public void createObjectList(String string, Map map, String string2, String string3, boolean bl) {
        File file = bl ? new File(string2, string3 + COMPRESSED_FILE_SUFIX) : new File(string2, string3);
        if (!file.exists() || ApplicationView.REBUILD_OBJECT_LIST) {
            try {
                if (file.exists()) {
                    file.delete();
                }
                DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
                Document document = documentBuilder.newDocument();
                Element element = document.createElement(string);
                document.appendChild(element);
                for (String string4 : map.keySet()) {
                    String string5 = (String)map.get(string4);
                    File file2 = new File(string2, string4);
                    if (!file2.exists() || !file2.isDirectory()) continue;
                    File[] fileArray = file2.listFiles(this.filter);
                    for (int i = 0; i < fileArray.length; ++i) {
                        File[] fileArray2;
                        File file3 = fileArray[i];
                        if (file3.isDirectory()) {
                            fileArray2 = file3.listFiles(this.filter);
                            for (int j = 0; j < fileArray2.length; ++j) {
                                File file4 = fileArray2[j];
                                if (file4.isDirectory()) continue;
                                Element element2 = document.createElement("object");
                                element.appendChild(element2);
                                element2.setAttribute("objectType", string5);
                                element2.setAttribute("objectID", FileUtils.removeExt(file4.getName()));
                                element2.setAttribute("name", "");
                                element2.setAttribute("seqName", file3.getName());
                            }
                            continue;
                        }
                        fileArray2 = document.createElement("object");
                        element.appendChild((Node)fileArray2);
                        if (DIAGRAM_LIST.equalsIgnoreCase(string3)) {
                            DesignPartHelper designPartHelper = XMLTransformationManager.getDesignPartInfo(file3, bl);
                            fileArray2.setAttribute("objectType", designPartHelper.type);
                            fileArray2.setAttribute("objectID", designPartHelper.id);
                            fileArray2.setAttribute("name", designPartHelper.name);
                            fileArray2.setAttribute("visible", designPartHelper.visible ? "true" : "false");
                            continue;
                        }
                        fileArray2.setAttribute("objectType", string5);
                        fileArray2.setAttribute("objectID", FileUtils.removeExt(file3.getName()));
                        fileArray2.setAttribute("name", "");
                        fileArray2.setAttribute("seqName", "");
                    }
                }
                XMLTransformationManager.saveDocument(new File(string2, string3).getCanonicalPath(), document, bl);
            }
            catch (Exception exception) {
                LOGGER.error("Can not create ObjectList: " + string2 + "/" + string3, exception);
            }
        }
    }

    private List<ObjectHelper> getObjects(String string, String string2, boolean bl) {
        ArrayList<ObjectHelper> arrayList = new ArrayList<ObjectHelper>();
        try {
            Object object;
            Object object2;
            Object object3;
            Document document = null;
            if (bl) {
                document = XMLTransformationManager.getDocument(new File(string, string2 + COMPRESSED_FILE_SUFIX));
            } else {
                object3 = DocumentBuilderFactory.newInstance();
                DocumentBuilder documentBuilder = ((DocumentBuilderFactory)object3).newDocumentBuilder();
                object2 = new File(string, string2);
                if (((File)object2).exists()) {
                    object = new InputStreamReader((InputStream)new FileInputStream((File)object2), "UTF-8");
                    document = documentBuilder.parse(new InputSource((Reader)object));
                    ((InputStreamReader)object).close();
                }
            }
            if (document != null) {
                object3 = document.getElementsByTagName("object");
                for (int i = 0; i < object3.getLength(); ++i) {
                    object2 = (Element)object3.item(i);
                    object = new ObjectHelper();
                    ((ObjectHelper)object).type = object2.getAttribute("objectType");
                    ((ObjectHelper)object).id = object2.getAttribute("objectID");
                    ((ObjectHelper)object).name = StringUtilities.decodeAttributeValue(object2.getAttribute("name"));
                    ((ObjectHelper)object).seq_name = object2.getAttribute("seqName");
                    if (DIAGRAM_LIST.equalsIgnoreCase(string2)) {
                        String string3 = object2.getAttribute("visible");
                        ((ObjectHelper)object).visible = "true".equalsIgnoreCase(string3);
                    }
                    arrayList.add((ObjectHelper)object);
                }
            }
        }
        catch (Exception exception) {
            LOGGER.error("Can not parse Object List: " + string + "/" + string2, exception);
        }
        return arrayList;
    }

    public boolean openDesign(Design design, File file) {
        if (file.exists() && this.transformFromXMLToObject(design, file, design.isCompressedDesign())) {
            this.loadRDBMSSites(design);
            this.openChangeRequestList(design);
            List<DesignPartHelper> list = this.getModels(design);
            design.getRelationalDesigns().removeAll();
            for (DesignPartHelper designPartHelper : list) {
                DesignPart designPart;
                String string = designPartHelper.main_view_id;
                if (designPartHelper.type.equalsIgnoreCase("Business Information")) {
                    designPart = design.getBusinessInfoDesign();
                    ((BusinessInfoDesign)designPart).setName(designPartHelper.name);
                    designPart.setObjectID(designPartHelper.id);
                    this.transformFromXMLToObject(designPart, new File(((BusinessInfoDesign)designPart).getStorageName()), design.isCompressedDesign());
                    designPart.setLoaded(false);
                    continue;
                }
                if (designPartHelper.type.equalsIgnoreCase("Data Types")) {
                    designPart = design.getDataTypesDesign();
                    designPart.setNewModel(false);
                    ((DataTypesDesign)designPart).setName(designPartHelper.name);
                    designPart.setObjectID(designPartHelper.id);
                    if (string != null && !"".equalsIgnoreCase(string) && !"null".equalsIgnoreCase(string)) {
                        ((DataTypesDesign)designPart).getMainView().setDPVId(string);
                    }
                    this.transformFromXMLToObject(designPart, new File(((DataTypesDesign)designPart).getStorageName()), design.isCompressedDesign());
                    designPart.setLoaded(false);
                    continue;
                }
                if (designPartHelper.type.equalsIgnoreCase("LogicalDesign")) {
                    designPart = design.getLogicalDesign();
                    designPart.setNewModel(false);
                    ((LogicalDesign)designPart).setName(designPartHelper.name);
                    designPart.setObjectID(designPartHelper.id);
                    if (string != null && !"".equalsIgnoreCase(string) && !"null".equalsIgnoreCase(string)) {
                        ((LogicalDesign)designPart).getMainView().setDPVId(string);
                    }
                    this.transformFromXMLToObject(designPart, new File(((LogicalDesign)designPart).getStorageName()), design.isCompressedDesign());
                    designPart.setLoaded(false);
                    continue;
                }
                if (designPartHelper.type.equalsIgnoreCase("RelationalModel")) {
                    designPart = design.addRelationalDesign(designPartHelper.name);
                    designPart.setObjectID(designPartHelper.id);
                    designPart.setNewModel(false);
                    if (string != null && !"".equalsIgnoreCase(string) && !"null".equalsIgnoreCase(string)) {
                        ((RelationalDesign)designPart).getMainView().setDPVId(string);
                    }
                    this.transformFromXMLToObject(designPart, new File(((RelationalDesign)designPart).getStorageName()), design.isCompressedDesign());
                    designPart.setShouldBeOpen(true);
                    ((RelationalDesign)designPart).setLoaded(false);
                    designPart.setMainViewVisible(false);
                    continue;
                }
                if (designPartHelper.type.equalsIgnoreCase("Dimensional Model")) {
                    designPart = design.addMultidimensionalDesign(designPartHelper.name);
                    design.setMultidimensionalDesign((MultidimensionalDesign)designPart);
                    designPart.setNewModel(false);
                    designPart.setObjectID(designPartHelper.id);
                    if (string != null && !"".equalsIgnoreCase(string) && !"null".equalsIgnoreCase(string)) {
                        ((MultidimensionalDesign)designPart).getMainView().setDPVId(string);
                    }
                    this.transformFromXMLToObject(designPart, new File(((MultidimensionalDesign)designPart).getStorageName()), design.isCompressedDesign());
                    designPart.setLoaded(false);
                    designPart.setShouldBeOpen(true);
                    continue;
                }
                if (designPartHelper.type.equalsIgnoreCase("Process Model")) {
                    designPart = design.getProcessModel();
                    designPart.setObjectID(designPartHelper.id);
                    this.transformFromXMLToObject(designPart, new File(((ProcessModel)designPart).getStorageName()), design.isCompressedDesign());
                    designPart.setLoaded(false);
                    continue;
                }
                if (!designPartHelper.type.equalsIgnoreCase("Data Flow Diagram")) continue;
                designPart = designPartHelper.top_level_dfd_design ? design.getProcessModel().addDataFlowDesign(designPartHelper.name) : design.getProcessModel().addDataFlowDesign(designPartHelper.name, false);
                designPart.setNewModel(false);
                design.getProcessModel().setDataFlowDesign((DataFlowDesign)designPart);
                designPart.setObjectID(designPartHelper.id);
                design.getProcessModel().setHasOpenedDFDesigns(true);
                if (string != null && !"".equalsIgnoreCase(string) && !"null".equalsIgnoreCase(string)) {
                    ((DataFlowDesign)designPart).getMainView().setDPVId(string);
                }
                this.transformFromXMLToObject(designPart, new File(((DataFlowDesign)designPart).getStorageName()), design.isCompressedDesign());
                designPart.setLoaded(false);
                designPart.setShouldBeOpen(true);
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void openDesignPart(DesignPart designPart) {
        block31: {
            boolean bl = ApplicationView.canLogging;
            ApplicationView.canLogging = false;
            designPart.getDesign().setPropagatePKChahges(false);
            try {
                StorableObject storableObject;
                designPart.doBeforeLoad();
                this.createObjectList(designPart.getClass().getName(), designPart.getFolderToTypeMap(), designPart.getStoragePath(), OBJECT_LIST, designPart.getDesign().isCompressedDesign());
                List<ObjectHelper> list = this.getObjects(designPart.getStoragePath(), OBJECT_LIST, designPart.getDesign().isCompressedDesign());
                Iterator<ObjectHelper> iterator = list.iterator();
                try {
                    while (iterator.hasNext()) {
                        ObjectHelper object2 = iterator.next();
                        storableObject = designPart.getDesign().getDesignObject(object2.id);
                        if (storableObject == null) {
                            storableObject = designPart.createObject(object2.type, object2.id, object2.name);
                        }
                        if (storableObject != null) {
                            DesignObject designObject;
                            String string = storableObject.getStorageName();
                            if (storableObject instanceof ModelIDObject) {
                                ((ModelIDObject)storableObject).setDirectorySegmentName(object2.seq_name, true);
                                string = ((ModelIDObject)storableObject).getSegmentedStorageName();
                            }
                            try {
                                this.transformFromXMLToObject(storableObject, new File(string), designPart.getDesign().isCompressedDesign());
                            }
                            catch (Exception exception) {
                                Design.openFailed();
                                LOGGER.error("Error in loading of " + string, exception);
                            }
                            if (storableObject instanceof FKIndexAssociation) {
                                designObject = (FKIndexAssociation)storableObject;
                                try {
                                    designObject.setDirectorySegmentName(object2.seq_name, true);
                                }
                                catch (Exception exception) {
                                    System.out.println("fk - " + designObject.getName() + "   - table " + ((FKIndexAssociation)designObject).getTable().getName());
                                    Design.openFailed();
                                    LOGGER.error("Error in adding foreign key " + designObject.getName() + "  for table " + ((FKIndexAssociation)designObject).getTable().getName(), exception);
                                }
                            } else if (storableObject instanceof TransformationPackage) {
                                designObject = (TransformationPackage)storableObject;
                                this.loadTransformationPackage((TransformationPackage)designObject);
                            } else if (storableObject instanceof Relation && (((Relation)(designObject = (Relation)storableObject)).getSourceEntity() == null || ((Relation)designObject).getTargetEntity() == null)) {
                                ((Relation)designObject).remove();
                            }
                            this.clearDirtyStatus(storableObject);
                            continue;
                        }
                        LOGGER.error("Can not create Object : " + object2.type + " - " + object2.id);
                    }
                }
                catch (Exception exception) {
                    LOGGER.error(exception);
                }
                if (designPart instanceof RelationalDesign) {
                    this.restoreDDLSelection(designPart);
                    this.loadExistingPhysicalModels((RelationalDesign)designPart);
                } else if (designPart instanceof DataTypesDesign) {
                    this.restoreDDLSelection(designPart);
                }
                designPart.executeTasks();
                if (!(designPart instanceof BusinessInfoDesign) && !(designPart instanceof ProcessModel)) {
                    this.createObjectList(designPart.getClass().getName(), designPart.getDiagramFolderMap(), designPart.getStoragePath(), DIAGRAM_LIST, designPart.getDesign().isCompressedDesign());
                    list = this.getObjects(designPart.getStoragePath(), DIAGRAM_LIST, designPart.getDesign().isCompressedDesign());
                    for (ObjectHelper objectHelper : list) {
                        storableObject = "main_view".equalsIgnoreCase(objectHelper.type) || designPart.getMainView().getDPVId().equalsIgnoreCase(objectHelper.id) ? designPart.getMainView() : designPart.createDesignPartSubView();
                        if (storableObject == null) continue;
                        boolean bl2 = ((DesignPartView)storableObject).getUndoManager().isLocked();
                        try {
                            ((DesignPartView)storableObject).getUndoManager().setLocked(true);
                            ((DesignPartView)storableObject).setDPVId(objectHelper.id);
                            ((DesignPartView)storableObject).setName(objectHelper.name);
                            this.transformFromXMLToObject(storableObject, new File(((DesignPartView)storableObject).getStorageName()), designPart.getDesign().isCompressedDesign());
                            if (((DesignPartView)storableObject).isMainDiagram()) {
                                designPart.setVisible(objectHelper.visible);
                            } else {
                                ((DesignPartView)storableObject).setMustBeVisible(objectHelper.visible);
                            }
                            ((DesignPartView)storableObject).setDirty(false);
                        }
                        finally {
                            ((DesignPartView)storableObject).getUndoManager().setLocked(bl2);
                        }
                    }
                }
                designPart.doAfterLoad();
                DesignPartView designPartView = designPart.getMainView();
                if (designPartView == null) break block31;
                boolean bl3 = designPartView.getUndoManager().isLocked();
                try {
                    designPartView.getUndoManager().setLocked(true);
                    designPart.getMainView().getWorkSpace().updateSettings();
                }
                finally {
                    designPartView.getUndoManager().setLocked(bl3);
                }
            }
            finally {
                designPart.getDesign().setPropagatePKChahges(true);
                ApplicationView.canLogging = bl;
            }
        }
    }

    public void loadTransformationPackage(TransformationPackage transformationPackage) {
        transformationPackage.getDesign().getProcessModel().setTransformationPackage(transformationPackage);
        List<DesignPartHelper> list = this.getTransformationTasks(transformationPackage);
        for (DesignPartHelper designPartHelper : list) {
            String string = designPartHelper.main_view_id;
            TransformationTask transformationTask = transformationPackage.createTransformationTask(designPartHelper.id);
            transformationTask.setName(designPartHelper.name);
            if (string != null && !"".equalsIgnoreCase(string) && !"null".equalsIgnoreCase(string)) {
                transformationTask.getMainView().setDPVId(string);
            }
            this.transformFromXMLToObject(transformationTask, new File(transformationTask.getStorageName()), transformationPackage.getDesign().isCompressedDesign());
            this.loadTransformationTask(transformationTask);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadTransformationTask(TransformationTask transformationTask) {
        Object object2;
        transformationTask.setLoaded(false);
        transformationTask.doBeforeLoad();
        this.createObjectList(transformationTask.getClass().getName(), transformationTask.getFolderToTypeMap(), transformationTask.getStoragePath(), OBJECT_LIST, transformationTask.getDesign().isCompressedDesign());
        List<ObjectHelper> list = this.getObjects(transformationTask.getStoragePath(), OBJECT_LIST, transformationTask.getDesign().isCompressedDesign());
        for (ObjectHelper object32 : list) {
            StorableObject storableObject = transformationTask.createObject(object32.type, object32.id, object32.name);
            if (storableObject == null) continue;
            object2 = storableObject.getStorageName();
            if (storableObject instanceof ModelIDObject) {
                ((ModelIDObject)storableObject).setDirectorySegmentName(object32.seq_name, true);
                object2 = ((ModelIDObject)storableObject).getSegmentedStorageName();
            }
            this.transformFromXMLToObject(storableObject, new File((String)object2), transformationTask.getDesign().isCompressedDesign());
            this.clearDirtyStatus(storableObject);
        }
        this.createObjectList(transformationTask.getClass().getName(), transformationTask.getDiagramFolderMap(), transformationTask.getStoragePath(), DIAGRAM_LIST, transformationTask.getDesign().isCompressedDesign());
        List<ObjectHelper> list2 = this.getObjects(transformationTask.getStoragePath(), DIAGRAM_LIST, transformationTask.getDesign().isCompressedDesign());
        for (Object object2 : list2) {
            DesignPartView bl = "main_view".equalsIgnoreCase(((ObjectHelper)object2).type) || transformationTask.getMainView().getDPVId().equalsIgnoreCase(((ObjectHelper)object2).id) ? transformationTask.getMainView() : transformationTask.createDesignPartSubView();
            if (bl == null) continue;
            boolean bl2 = bl.getUndoManager().isLocked();
            try {
                bl.getUndoManager().setLocked(true);
                bl.setDPVId(((ObjectHelper)object2).id);
                bl.setName(((ObjectHelper)object2).name);
                this.transformFromXMLToObject(bl, new File(bl.getStorageName()), transformationTask.getDesign().isCompressedDesign());
                bl.setMustBeVisible(((ObjectHelper)object2).visible);
                bl.setDirty(false);
            }
            finally {
                bl.getUndoManager().setLocked(bl2);
            }
        }
        transformationTask.doAfterLoad();
        object2 = transformationTask.getMainView();
        if (object2 != null) {
            boolean bl = ((DesignPartView)object2).getUndoManager().isLocked();
            try {
                ((DesignPartView)object2).getUndoManager().setLocked(true);
                transformationTask.getMainView().getWorkSpace().updateSettings();
            }
            finally {
                ((DesignPartView)object2).getUndoManager().setLocked(bl);
            }
        }
    }

    private Element getFirstElementByTagName(String string, Element element) {
        NodeList nodeList = element.getElementsByTagName(string);
        if (nodeList.getLength() > 0) {
            Element element2 = (Element)nodeList.item(0);
            return element2;
        }
        return null;
    }

    public void loadExistingPhysicalModels(RelationalDesign relationalDesign) {
        String string = relationalDesign.getDesign().getLoadedVersion() < 3.2f ? "storage" : "phys";
        File file = new File(relationalDesign.getStoragePath(), string);
        if (file.exists()) {
            File[] fileArray = file.listFiles();
            for (int i = 0; i < fileArray.length; ++i) {
                Object object;
                File file2 = fileArray[i];
                if (!file2.isDirectory()) continue;
                String string2 = file2.getName();
                RDBMSSite rDBMSSite = relationalDesign.getDesign().getLoadedVersion() < 3.2f ? relationalDesign.getDesign().getRDBMSSiteSet().getByObjectID(string2) : relationalDesign.getDesign().getRDBMSSiteSet().getByShortObjectIDString(string2);
                if (rDBMSSite == null && relationalDesign.getDesign().getLoadedVersion() >= 3.2f) {
                    File file3;
                    object = file2.getName() + ".xml";
                    if (relationalDesign.getDesign().isCompressedDesign()) {
                        object = (String)object + COMPRESSED_FILE_SUFIX;
                    }
                    if ((file3 = new File(file2, (String)object)).exists()) {
                        Object object2;
                        Object object3;
                        Object object4;
                        Document document = null;
                        if (relationalDesign.getDesign().isCompressedDesign()) {
                            document = XMLTransformationManager.getDocument(file3);
                        } else {
                            try {
                                object4 = DocumentBuilderFactory.newInstance();
                                object3 = ((DocumentBuilderFactory)object4).newDocumentBuilder();
                                object2 = new InputStreamReader((InputStream)new FileInputStream(file3), "UTF-8");
                                document = ((DocumentBuilder)object3).parse(new InputSource((Reader)object2));
                                ((InputStreamReader)object2).close();
                            }
                            catch (Exception exception) {
                                LOGGER.warn(exception.getMessage(), exception);
                            }
                        }
                        if (document != null && (object4 = this.getFirstElementByTagName(SITE_TYPE, document.getDocumentElement())) != null) {
                            object3 = object4.getTextContent();
                            object2 = this.getFirstElementByTagName(SITE_ID, document.getDocumentElement());
                            String string3 = object2.getTextContent();
                            Element element = this.getFirstElementByTagName(SITE_NAME, document.getDocumentElement());
                            String string4 = element.getTextContent();
                            rDBMSSite = relationalDesign.getDesign().getRDBMSSiteSet().createSite(string4, relationalDesign.getDesign());
                            int n = 9;
                            try {
                                n = Integer.parseInt((String)object3);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            RDBMSType rDBMSType = relationalDesign.getDesign().getRDBMSTypeSet().get(n);
                            rDBMSSite.setType(rDBMSType);
                            rDBMSSite.setObjectID(string3);
                            rDBMSSite.setPathID(relationalDesign.getDesign().getRDBMSSiteSet().nextIndex());
                        }
                    }
                }
                if (rDBMSSite == null || (object = relationalDesign.getStorageDesign(rDBMSSite)) == null) continue;
                ((StorageDesign)object).setOpen(false);
                ((StorageDesign)object).setTempModel(false);
                this.clearDirtyStatus(object);
                ((StorageDesign)object).setAllStorableObjectsDirty(false);
            }
        }
    }

    public void openPhysicalModel(StorageDesign storageDesign) {
        this.openPhysicalModel(storageDesign, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void openPhysicalModel(StorageDesign storageDesign, boolean bl) {
        if (storageDesign.getStorageName() != null) {
            try {
                ArrayList<Object> arrayList = new ArrayList<Object>();
                storageDesign.setLoading(true);
                File file = storageDesign.getDesign().isCompressedDesign() ? new File(storageDesign.getStorageName() + COMPRESSED_FILE_SUFIX) : new File(storageDesign.getStorageName());
                if (file.exists()) {
                    void var7_14;
                    void var7_12;
                    Object object3;
                    Object object2;
                    this.transformFromXMLToObject(storageDesign, file, storageDesign.getDesign().isCompressedDesign(), bl);
                    this.createObjectList(storageDesign.getClass().getName(), storageDesign.getFolderToTypeMap(), storageDesign.getStoragePath(), OBJECT_LIST, storageDesign.getDesign().isCompressedDesign());
                    List<ObjectHelper> list = this.getObjects(storageDesign.getStoragePath(), OBJECT_LIST, storageDesign.getDesign().isCompressedDesign());
                    for (ObjectHelper arrayList22 : list) {
                        object2 = storageDesign.getStorageObjectSetForType(arrayList22.type);
                        if (object2 != null) {
                            object3 = storageDesign.getStorageObject(arrayList22.id);
                            if (object3 == null) {
                                arrayList22.object = ((ModelIDObjectSet)object2).createElement(arrayList22.id);
                                continue;
                            }
                            arrayList22.object = object3;
                            continue;
                        }
                        arrayList22.object = storageDesign.getStorageObject(arrayList22.id);
                        if (arrayList22.object != null) continue;
                        int n = 0;
                        ++n;
                    }
                    for (ObjectHelper objectHelper : list) {
                        object2 = (ModelIDObject)objectHelper.object;
                        if (object2 == null) continue;
                        object3 = ((ModelIDObject)object2).getStorageName();
                        String string = ((ModelIDObject)object2).getDirectorySegmentName();
                        if (storageDesign.isCloneOperation()) {
                            ((ModelIDObject)object2).setSegmentedStorageName(null);
                        }
                        ((ModelIDObject)object2).setDirectorySegmentName(objectHelper.seq_name, true);
                        object3 = ((ModelIDObject)object2).getSegmentedStorageName();
                        boolean bl2 = this.transformFromXMLToObject(object2, new File((String)object3), storageDesign.getDesign().isCompressedDesign(), bl);
                        boolean bl3 = false;
                        if (storageDesign.isCloneOperation()) {
                            ((ModelIDObject)object2).setDirectorySegmentName(string, true);
                            ((ModelIDObject)object2).setSegmentedStorageName(null);
                        } else {
                            String string2 = ((ModelIDObject)object2).getDirectorySegmentName();
                            if (!string2.equals(objectHelper.seq_name) && bl2) {
                                bl3 = true;
                                ((ModelIDObject)object2).setDirectorySegmentName(objectHelper.seq_name, true);
                                arrayList.add(object2);
                            }
                        }
                        if (bl && !bl3) {
                            this.clearDirtyStatus(object2);
                            continue;
                        }
                        ((ModelIDObject)object2).setDirty(true);
                    }
                    Object var7_10 = null;
                    if (!bl) {
                        List list2 = storageDesign.getDirtyObjects();
                    } else {
                        storageDesign.doAfterLoad();
                    }
                    if (var7_12 == null) {
                        ArrayList<Object> arrayList2 = arrayList;
                    }
                    if (var7_14 != null) {
                        for (Object object3 : var7_14) {
                            ((ModelIDObject)object3).setDirty(true);
                        }
                    }
                }
                if (!bl) {
                    storageDesign.setDirty(true);
                }
            }
            finally {
                storageDesign.setLoading(false);
            }
        }
    }

    private void clearPropertyMap(List list) {
        for (Object e : list) {
            if (!(e instanceof ModelIDObject)) continue;
            ((ModelIDObject)e).clearProperties();
        }
    }

    public boolean savePhysicalModel(StorageDesign storageDesign) {
        try {
            this.saveFailed = false;
            ArrayList<StorageDesign> arrayList = new ArrayList<StorageDesign>();
            if (storageDesign.isOpen()) {
                if (this.isCheckDirty()) {
                    if (storageDesign.isDirty() || storageDesign.hasDirtyStorableObjects()) {
                        arrayList.addAll(storageDesign.getStorableObjects());
                    }
                } else {
                    arrayList.addAll(storageDesign.getStorableObjects());
                }
                arrayList.add(storageDesign);
                for (StorableObject storableObject : arrayList) {
                    this.saveObject(storableObject);
                }
                this.saveObjectList(storageDesign);
                storageDesign.doAfterSave();
                if (this.saveFailed) {
                    MessageDialogs.showErrorMessage(Messages.getString("XMLPersistenceManager.SomeObjectsAreNotSavedCorrectly"));
                    return false;
                }
                return true;
            }
        }
        catch (Exception exception) {
            LOGGER.error("Unable to save the Physical Model: " + storageDesign.getName(), exception);
            MessageDialogs.showErrorMessage("Unable to save the Physical Model: " + storageDesign.getName());
        }
        return false;
    }

    private static Document getDocument(File file) {
        try {
            int n;
            FileInputStream fileInputStream = new FileInputStream(file);
            InflaterInputStream inflaterInputStream = new InflaterInputStream((InputStream)fileInputStream);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            int n2 = 1024;
            byte[] byArray = new byte[n2];
            while ((n = inflaterInputStream.read(byArray)) != -1) {
                byteArrayOutputStream.write(byArray, 0, n);
            }
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(byteArrayInputStream);
            inflaterInputStream.close();
            byteArrayOutputStream.close();
            ((InputStream)byteArrayInputStream).close();
            return document;
        }
        catch (Exception exception) {
            Design.openFailed();
            LOGGER.error("Can not parse file:" + file.getAbsolutePath(), exception);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean saveDocument(String string, Document document, boolean bl) {
        if (string != null && document != null) {
            try {
                TransformerFactory transformerFactory = TransformerFactory.newInstance();
                Transformer transformer = transformerFactory.newTransformer();
                transformer.setOutputProperty("indent", "yes");
                transformer.setOutputProperty("encoding", "UTF-8");
                DOMSource dOMSource = new DOMSource(document);
                File file = new File(string).getParentFile();
                if (!file.exists()) {
                    file.mkdirs();
                }
                String string2 = System.getProperty("line.separator");
                try {
                    System.setProperty("line.separator", "\n");
                    if (bl) {
                        StringWriter stringWriter = new StringWriter();
                        StreamResult streamResult = new StreamResult(stringWriter);
                        transformer.transform(dOMSource, streamResult);
                        String string3 = stringWriter.getBuffer().toString();
                        stringWriter.close();
                        byte[] byArray = string3.getBytes("UTF-8");
                        byte[] byArray2 = new byte[byArray.length];
                        Deflater deflater = new Deflater();
                        deflater.setInput(byArray);
                        deflater.finish();
                        int n = deflater.deflate(byArray2);
                        FileOutputStream fileOutputStream = new FileOutputStream(string + COMPRESSED_FILE_SUFIX);
                        ((OutputStream)fileOutputStream).write(byArray2, 0, n);
                        fileOutputStream.flush();
                        ((OutputStream)fileOutputStream).close();
                    } else {
                        FileOutputStream fileOutputStream = new FileOutputStream(new File(string));
                        StreamResult streamResult = new StreamResult(fileOutputStream);
                        transformer.transform(dOMSource, streamResult);
                        fileOutputStream.flush();
                        fileOutputStream.close();
                    }
                }
                finally {
                    System.setProperty("line.separator", string2);
                }
                return true;
            }
            catch (Exception exception) {
                String string4 = Messages.getString("XMLPersistenceManager.SaveError") + " " + string;
                LOGGER.error(string4, exception);
                MessageDialogs.showErrorMessage(string4);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean saveContent(String string, String string2, boolean bl) {
        if (string != null && string2 != null) {
            try {
                File file = new File(string).getParentFile();
                if (!file.exists()) {
                    file.mkdirs();
                }
                String string3 = System.getProperty("line.separator");
                try {
                    System.setProperty("line.separator", "\n");
                    if (bl) {
                        String string4 = string2;
                        byte[] byArray = string4.getBytes("UTF-8");
                        byte[] byArray2 = new byte[byArray.length];
                        Deflater deflater = new Deflater();
                        deflater.setInput(byArray);
                        deflater.finish();
                        int n = deflater.deflate(byArray2);
                        FileOutputStream fileOutputStream = new FileOutputStream(string + COMPRESSED_FILE_SUFIX);
                        ((OutputStream)fileOutputStream).write(byArray2, 0, n);
                        fileOutputStream.flush();
                        ((OutputStream)fileOutputStream).close();
                    } else {
                        FileOutputStream fileOutputStream = new FileOutputStream(new File(string));
                        OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)fileOutputStream, "UTF-8");
                        outputStreamWriter.write(string2);
                        outputStreamWriter.flush();
                        outputStreamWriter.close();
                    }
                }
                finally {
                    System.setProperty("line.separator", string3);
                }
                return true;
            }
            catch (Exception exception) {
                String string5 = Messages.getString("XMLPersistenceManager.SaveError") + " " + string;
                LOGGER.error(string5, exception);
                MessageDialogs.showErrorMessage(string5);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean saveContent(String string, StorableObject storableObject, boolean bl, MDTransformationManager mDTransformationManager) {
        if (string != null) {
            try {
                File file = new File(string).getParentFile();
                if (!file.exists()) {
                    file.mkdirs();
                }
                String string2 = System.getProperty("line.separator");
                try {
                    System.setProperty("line.separator", "\n");
                    if (bl) {
                        StringWriter stringWriter = new StringWriter(8192);
                        XMLTransformationManager.writeContentAsStream(storableObject, stringWriter, mDTransformationManager);
                        String string3 = stringWriter.getBuffer().toString();
                        stringWriter.close();
                        byte[] byArray = string3.getBytes("UTF-8");
                        byte[] byArray2 = new byte[byArray.length];
                        Deflater deflater = new Deflater();
                        deflater.setInput(byArray);
                        deflater.finish();
                        int n = deflater.deflate(byArray2);
                        FileOutputStream fileOutputStream = new FileOutputStream(string + COMPRESSED_FILE_SUFIX);
                        ((OutputStream)fileOutputStream).write(byArray2, 0, n);
                        fileOutputStream.flush();
                        ((OutputStream)fileOutputStream).close();
                    } else {
                        FileOutputStream fileOutputStream = new FileOutputStream(new File(string));
                        OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)fileOutputStream, "UTF-8");
                        BufferedWriter bufferedWriter = new BufferedWriter(outputStreamWriter, 8192);
                        XMLTransformationManager.writeContentAsStream(storableObject, bufferedWriter, mDTransformationManager);
                        bufferedWriter.flush();
                        bufferedWriter.close();
                    }
                }
                finally {
                    System.setProperty("line.separator", string2);
                }
                return true;
            }
            catch (Exception exception) {
                String string4 = Messages.getString("XMLPersistenceManager.SaveError") + " " + string;
                LOGGER.error(string4, exception);
                MessageDialogs.showErrorMessage(string4);
            }
        }
        return false;
    }

    public static void writeContentAsStream(Object object, Writer writer, MDTransformationManager mDTransformationManager) {
        MDTransformationManager.TrObjects trObjects = mDTransformationManager.getTransformersFor(object.getClass());
        if (trObjects != null && trObjects.getFromObjectToStreamTransformer() != null && trObjects.getFromObjectToStreamTransformer() instanceof XMLObjToStreamTransformer) {
            ((XMLObjToStreamTransformer)trObjects.getFromObjectToStreamTransformer()).transformFromObject(object, writer);
        }
    }

    private static void writeContentAsStream(Object object, Writer writer, MDTransformationManager mDTransformationManager, boolean bl) {
        MDTransformationManager.TrObjects trObjects = mDTransformationManager.getTransformersFor(object.getClass());
        if (trObjects != null && trObjects.getFromObjectToStreamTransformer() != null && trObjects.getFromObjectToStreamTransformer() instanceof XMLObjToStreamTransformer) {
            ((XMLObjToStreamTransformer)trObjects.getFromObjectToStreamTransformer()).transformFromObject(object, writer, bl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean saveObjectWithExternals(String string, Object object) {
        TimeLog.log("start save operation");
        if (string != null) {
            try {
                MDTransformationManager mDTransformationManager = this.getMDTransformationManager();
                File file = new File(string).getParentFile();
                if (!file.exists()) {
                    file.mkdirs();
                }
                String string2 = System.getProperty("line.separator");
                try {
                    System.setProperty("line.separator", "\n");
                    FileOutputStream fileOutputStream = new FileOutputStream(new File(string));
                    OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)fileOutputStream, "UTF-8");
                    BufferedWriter bufferedWriter = new BufferedWriter(outputStreamWriter, 8192);
                    XMLTransformationManager.writeContentAsStream(object, bufferedWriter, mDTransformationManager, true);
                    bufferedWriter.flush();
                    bufferedWriter.close();
                    TimeLog.log("end save operation");
                }
                finally {
                    System.setProperty("line.separator", string2);
                }
                return true;
            }
            catch (Exception exception) {
                String string3 = Messages.getString("XMLPersistenceManager.SaveError") + " " + string;
                LOGGER.error(string3, exception);
                MessageDialogs.showErrorMessage(string3);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean loadObjectWithExternals(String string, Object object) {
        TimeLog.log("start load operation");
        int n = 0x100000;
        Runtime runtime = Runtime.getRuntime();
        System.out.println("start load operation memory  total  " + runtime.totalMemory() / (long)n + "  /memory  fre  " + runtime.freeMemory() / (long)n + "  /used memory  " + (runtime.totalMemory() - runtime.freeMemory()) / (long)n);
        if (string != null) {
            try {
                File file;
                if (object instanceof ModelIDObject) {
                    ((ModelIDObject)object).getDesign().setPropagatePKChahges(false);
                }
                ApplicationView.canLogging = false;
                ApplicationView.loading = true;
                MDTransformationManager mDTransformationManager = this.getMDTransformationManager();
                MDTransformationManager.TrObjects trObjects = mDTransformationManager.getTransformersFor(object.getClass());
                if (trObjects != null && trObjects.getToObjectTransformer() != null && (file = new File(string)).exists()) {
                    MDTransformer mDTransformer = trObjects.getToObjectTransformer();
                    if (mDTransformer instanceof XMLToObjectTransformer) {
                        ((XMLToObjectTransformer)trObjects.getToObjectTransformer()).transformToObject(object, file, true);
                    }
                    boolean bl = true;
                    return bl;
                }
            }
            catch (Exception exception) {
                String string2 = Messages.getString("XMLPersistenceManager.SaveError") + " " + string;
                LOGGER.error(string2, exception);
                MessageDialogs.showErrorMessage(string2);
            }
            finally {
                if (object instanceof ModelIDObject) {
                    ((ModelIDObject)object).getDesign().setPropagatePKChahges(true);
                }
                ApplicationView.canLogging = true;
                ApplicationView.loading = false;
                TimeLog.log("end load operation");
                System.out.println("end load operation memory  total  " + runtime.totalMemory() / (long)n + "  /memory  fre  " + runtime.freeMemory() / (long)n + "  /used memory  " + (runtime.totalMemory() - runtime.freeMemory()) / (long)n);
            }
        }
        return false;
    }

    public void saveDomains(Design design) {
        Object object;
        Object object2;
        Object object3;
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        Iterator iterator = design.getDomainSet().iterator();
        while (iterator.hasNext()) {
            object3 = (Domain)iterator.next();
            object2 = ((Domain)object3).getFileName();
            if (hashMap.containsKey(object2)) continue;
            hashMap.put((String)object2, object3);
        }
        iterator = hashMap.keySet().iterator();
        object3 = new FilenameFilter(){

            @Override
            public boolean accept(File file, String string) {
                return string.endsWith(".xml");
            }
        };
        object2 = new FolderFilesListing(design.getDomainSet().getStoragePath(), (FilenameFilter)object3);
        ArrayList<String> arrayList = ((FolderFilesListing)object2).getFilesLis();
        while (iterator.hasNext()) {
            object = (String)iterator.next();
            if ("".equals(object)) continue;
            if (!"defaultdomains".equalsIgnoreCase((String)object)) {
                this.saveDomain(design, (String)object);
                arrayList.remove((String)object + ".xml");
                if (!Extension.isSVNExtensionLoaded() || !design.isVersioned()) continue;
                SVNClientHelper.getInstance().saveProperties((ModelIDObject)hashMap.get(object), design.getDomainSet().getStorageName((String)object));
                continue;
            }
            this.saveDefaultDomain(this.getDefaultDomainsFileName(), design);
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            object = new File(design.getDomainSet().getStoragePath(), (String)arrayList.get(i));
            ((File)object).delete();
        }
    }

    public void saveDomain(Design design, String string) {
        DomainFileWrapper domainFileWrapper = new DomainFileWrapper(design, string);
        Document document = this.getXMLContent(domainFileWrapper);
        XMLTransformationManager.saveDocument(design.getDomainSet().getStorageName(string), document, false);
    }

    public boolean saveDefaultDomain(String string, Design design) {
        DomainFileWrapper domainFileWrapper = new DomainFileWrapper(design, "defaultdomains");
        Document document = this.getXMLContent(domainFileWrapper);
        return XMLTransformationManager.saveDocument(string, document, false);
    }

    public String getDefaultDomainsFileName() {
        try {
            return new File(XMLTransformationManager.getDefaultSystemTypesPath(), "defaultdomains.xml").getCanonicalPath();
        }
        catch (IOException iOException) {
            LOGGER.error(iOException);
            return null;
        }
    }

    public static File getDefaultRDBMSFile() {
        return new File(XMLTransformationManager.getDefaultSystemTypesPath(), "defaultRDBMSSites.xml");
    }

    public static File getDefaultTypesFile() {
        return new File(XMLTransformationManager.getDefaultSystemTypesPath(), "types.xml");
    }

    public static String getDefaultSystemTypesPath() {
        return XMLTransformationManager.getDefaultSystemTypesPath(ApplicationView.getInstance().getSettings());
    }

    public static String getDefaultSystemTypesPath(Settings settings) {
        String string = settings.getDefaultSystemTypesPath();
        if (!"".equals(string)) {
            return string;
        }
        File file = new File(ApplicationView.basePath);
        return file.getAbsolutePath() + "/" + MDConfiguration.getDefaultInstance().get("typesPath");
    }

    public void loadDomains(Design design) {
        File file = new File(design.getDomainSet().getStoragePath());
        if (file.exists()) {
            File[] fileArray = file.listFiles();
            for (int i = 0; i < fileArray.length; ++i) {
                File file2 = fileArray[i];
                if (file2.isDirectory()) continue;
                this.loadDomainFile(file2, design);
            }
        }
    }

    public void loadDomainFile(File file, Design design) {
        try {
            Document document = null;
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            InputStreamReader inputStreamReader = new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8");
            document = documentBuilder.parse(new InputSource(inputStreamReader));
            inputStreamReader.close();
            if (document != null) {
                String string = file.getName();
                int n = string.lastIndexOf(46);
                if (n > 0) {
                    string = string.substring(0, n);
                }
                this.loadDomains(design, string, document);
            }
        }
        catch (Exception exception) {
            LOGGER.error("Can not load Domain file: " + file.getAbsolutePath(), exception);
        }
    }

    public void loadDomains(Design design, String string, Document document) {
        DomainFileWrapper domainFileWrapper = new DomainFileWrapper(design, string);
        MDTransformer mDTransformer = this.getMDTransformationManager().getToObjectTransformerFor(DomainFileWrapper.class);
        if (mDTransformer != null && mDTransformer instanceof XMLToObjectTransformer) {
            ((XMLToObjectTransformer)mDTransformer).transformToObject((Object)domainFileWrapper, document);
        }
    }

    public MDTransformationManager getXMLMapTransformationManager() {
        if (this.xmlMapManager == null) {
            this.xmlMapManager = new MDTransformationManager(this.metaDataManager);
            this.xmlMapManager.registerTransformer(ModelIDObject.class, XMLFromMapTransformer.class, XMLToMapTransformer.class, XMLObjToStreamTransformer.class);
            this.xmlMapManager.registerTransformer(Object.class, XMLFromMapTransformer.class, XMLToMapTransformer.class, XMLObjToStreamTransformer.class);
            MDTransformer.SKP_DEFAULTS = true;
        }
        return this.xmlMapManager;
    }

    public MetaDataManager getMetaDataManager() {
        return this.metaDataManager;
    }

    public boolean hasDirtyStatus(Object object) {
        boolean bl;
        if (object instanceof RepositoryObject) {
            if (((RepositoryObject)object).isDirty()) {
                return true;
            }
            if (object instanceof DesignPartView) {
                return false;
            }
        }
        if (bl = this.hasDirtyProperty(object)) {
            return true;
        }
        bl = this.hasDirtyStructure(object);
        return bl;
    }

    private boolean hasDirtyProperty(Object object) {
        ClassDescription classDescription = this.getMetaDataManager().getClassDescription(object.getClass().getName());
        if (classDescription != null) {
            List<ClassDescription.PropertyDescription> list = classDescription.getPropertiesList();
            for (ClassDescription.PropertyDescription propertyDescription : list) {
                boolean bl;
                Object object2;
                if (propertyDescription.isReferred() || propertyDescription.isSimpleClass() || propertyDescription.isStringClass() || propertyDescription.isPropertyMap || propertyDescription.isMap || (object2 = MDTransformer.getObjectForProperty(object, propertyDescription)) == null || !(bl = this.hasDirtyStatus(object2))) continue;
                return true;
            }
        }
        return false;
    }

    private boolean hasDirtyStructure(Object object) {
        ClassDescription classDescription = this.getMetaDataManager().getClassDescription(object.getClass().getName());
        if (classDescription != null) {
            List<ClassDescription.CollectionDescription> list = classDescription.getCollectionsList();
            for (ClassDescription.CollectionDescription collectionDescription : list) {
                if (collectionDescription.isExternalCollection || collectionDescription.itemIsRef || collectionDescription.isMapItem || collectionDescription.isProxyitem || collectionDescription.isObjectViewItem || collectionDescription.isTVDiagramItem || collectionDescription.isTVConnectorItem) continue;
                Iterator iterator = MDTransformer.getObjectsIterator(object, collectionDescription);
                while (iterator.hasNext()) {
                    Object e = iterator.next();
                    boolean bl = this.hasDirtyStatus(e);
                    if (!bl) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public void clearDirtyStatus(Object object) {
        if (object instanceof RepositoryObject) {
            ((RepositoryObject)object).setDirty(false);
            if (object instanceof DesignPartView) {
                return;
            }
        }
        this.clearDirtyProperties(object);
        this.clearDirtyStructure(object);
    }

    private void clearDirtyProperties(Object object) {
        MDTransformer mDTransformer;
        ClassDescription classDescription;
        if (object != null && (classDescription = this.getMetaDataManager().getClassDescription(object.getClass().getName())) != null && (mDTransformer = this.getMDTransformationManager().getFromObjectTransformerFor(object.getClass())) != null) {
            List<ClassDescription.PropertyDescription> list = classDescription.getPropertiesList();
            for (ClassDescription.PropertyDescription propertyDescription : list) {
                Object object2;
                if (propertyDescription.isReferred() || propertyDescription.isSimpleClass() || propertyDescription.isStringClass() || propertyDescription.isPropertyMap || propertyDescription.isMap || propertyDescription.isExternalProperty || (object2 = MDTransformer.getObjectForProperty(object, propertyDescription)) == null) continue;
                this.clearDirtyStatus(object2);
            }
        }
    }

    private boolean clearDirtyStructure(Object object) {
        ClassDescription classDescription = this.getMetaDataManager().getClassDescription(object.getClass().getName());
        if (object != null && classDescription != null) {
            List<ClassDescription.CollectionDescription> list = classDescription.getCollectionsList();
            for (ClassDescription.CollectionDescription collectionDescription : list) {
                if (collectionDescription.isExternalCollection || collectionDescription.itemIsRef || collectionDescription.isMapItem || collectionDescription.isProxyitem || collectionDescription.isObjectViewItem || collectionDescription.isTVDiagramItem || collectionDescription.isTVConnectorItem) continue;
                Iterator iterator = MDTransformer.getObjectsIterator(object, collectionDescription);
                while (iterator.hasNext()) {
                    Object e = iterator.next();
                    this.clearDirtyStatus(e);
                }
            }
        }
        return false;
    }

    public void loadRDBMSSites(Design design) {
        File file;
        File file2 = new File(design.getStoragePath(), "rdbms");
        if (file2.exists() && (file = new File(file2, design.getName() + "_RDBMSSites" + ".xml")).exists()) {
            try {
                Document document = null;
                DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
                InputStreamReader inputStreamReader = new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8");
                document = documentBuilder.parse(new InputSource(inputStreamReader));
                inputStreamReader.close();
                if (document != null) {
                    RDBMSTypeSet rDBMSTypeSet = design.getDefaultRDBMSTypeSet();
                    RDBMSSiteSet rDBMSSiteSet = design.getRDBMSSiteSet();
                    NodeList nodeList = document.getDocumentElement().getElementsByTagName("site");
                    int n = nodeList.getLength();
                    for (int i = 0; i < n; ++i) {
                        this.recreateSite((Element)nodeList.item(i), rDBMSSiteSet, rDBMSTypeSet);
                    }
                }
            }
            catch (Exception exception) {
                LOGGER.error("Can not load RDBMS Sites: " + file.getAbsolutePath(), exception);
            }
        }
    }

    private void recreateSite(Element element, RDBMSSiteSet rDBMSSiteSet, RDBMSTypeSet rDBMSTypeSet) {
        String string = StringUtilities.decodeAttributeValue(element.getAttribute("name"));
        String string2 = element.getAttribute("oid");
        boolean bl = false;
        if (string2 != null && string2.length() > 0) {
            boolean bl2 = bl = rDBMSSiteSet.getByObjectID(string2) != null;
        }
        if (!bl && !rDBMSSiteSet.exists(string)) {
            String string3 = element.getAttribute("type");
            String string4 = element.getAttribute("pathid");
            RDBMSSite rDBMSSite = rDBMSSiteSet.createSite(string, rDBMSSiteSet.getDesign());
            rDBMSSite.setIsDefault(false);
            rDBMSSite.setDesignLevel(true);
            int n = 9;
            try {
                n = Integer.parseInt(string3);
            }
            catch (Exception exception) {
                // empty catch block
            }
            RDBMSType rDBMSType = rDBMSTypeSet.get(n);
            rDBMSSite.setType(rDBMSType);
            rDBMSSite.setObjectID(string2);
            int n2 = 0;
            try {
                n2 = Integer.parseInt(string4);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                n = Integer.parseInt(string3);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (n2 > 0) {
                rDBMSSite.setPathID(n2);
                rDBMSSiteSet.updateMaxIndex(n2);
            } else {
                rDBMSSite.setPathID(rDBMSSiteSet.nextIndex());
            }
            if (rDBMSType == null) {
                LOGGER.error("Unknown RDBMS type: " + n);
            }
        }
    }

    public void saveRDBMSSites(Design design) {
        try {
            RDBMSSiteSet rDBMSSiteSet = design.getRDBMSSiteSet();
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.newDocument();
            Element element = document.getDocumentElement();
            element = document.createElement("metadatadoc");
            element.setAttribute("version", "2.0");
            document.appendChild(element);
            RDBMSSite[] rDBMSSiteArray = (RDBMSSite[])rDBMSSiteSet.toArray();
            for (int i = 0; i < rDBMSSiteArray.length; ++i) {
                if (rDBMSSiteSet.canSaveDefaults()) {
                    this.appendSiteNode(element, rDBMSSiteArray[i]);
                    continue;
                }
                if (rDBMSSiteArray[i].getIsDefault() && rDBMSSiteArray[i].getPathID() <= 9) continue;
                this.appendSiteNode(element, rDBMSSiteArray[i]);
            }
            XMLTransformationManager.saveDocument(new File(design.getStoragePath(), "rdbms/" + design.getName() + "_RDBMSSites" + ".xml").getCanonicalPath(), document, false);
        }
        catch (Exception exception) {
            LOGGER.error("Can not save RDBMS Sites for Design: " + design.getName());
        }
    }

    public void appendSiteNode(Element element, RDBMSSite rDBMSSite) {
        Document document = element.getOwnerDocument();
        Element element2 = document.createElement("site");
        element2.setAttribute("name", StringUtilities.encodeAttributeValue(rDBMSSite.getLongName()));
        if (rDBMSSite.getType() != null) {
            element2.setAttribute("type", String.valueOf(rDBMSSite.getType().getType()));
        }
        element2.setAttribute("oid", rDBMSSite.getObjectID());
        element2.setAttribute("pathid", rDBMSSite.getPathIDString());
        element.appendChild(element2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean equal(Object object, Object object2, boolean bl) {
        MDTransformer mDTransformer;
        if (object.getClass().equals(object2.getClass()) && (mDTransformer = this.getMDTransformationManager().getFromObjectTransformerFor(object.getClass())) != null) {
            try {
                MDTransformer.includeLoggingProps = bl;
                MDTransformer.includeID = false;
                String string = mDTransformer.transformFromObjectToString(object);
                String string2 = mDTransformer.transformFromObjectToString(object2);
                if (string.equals(string2)) {
                    boolean bl2 = true;
                    return bl2;
                }
            }
            finally {
                MDTransformer.includeLoggingProps = true;
                MDTransformer.includeID = true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getFilteredXMLString(Object object) {
        String string = null;
        MDTransformer mDTransformer = this.getMDTransformationManager().getFromObjectTransformerFor(object.getClass());
        if (mDTransformer != null) {
            try {
                MDTransformer.includeLoggingProps = false;
                MDTransformer.includeID = false;
                string = mDTransformer.transformFromObjectToString(object);
            }
            finally {
                MDTransformer.includeLoggingProps = true;
                MDTransformer.includeID = true;
            }
        }
        return string;
    }

    private class ObjectHelper {
        public String type;
        public String id;
        public String name;
        public Object object;
        public boolean visible = false;
        public String seq_name;

        private ObjectHelper() {
        }
    }

    public static class DesignPartHelper {
        public String type;
        public String id;
        public String parent_id;
        public String name;
        public String main_view_id;
        public boolean top_level_dfd_design;
        public boolean visible = false;
    }
}

