/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.metadata;

import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.design.ConnectionInterface;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DiagramView;
import oracle.dbtools.crest.model.design.engineering.EngPropertyHolder;
import oracle.dbtools.crest.model.metadata.ClassDescription;
import oracle.dbtools.crest.model.metadata.ID_ObjectPropertyTranslator;
import oracle.dbtools.crest.model.metadata.MDTransformationManager;
import oracle.dbtools.crest.model.metadata.MDTransformer;
import oracle.dbtools.crest.model.metadata.MDXMLConstants;
import oracle.dbtools.crest.swingui.ContainerView;
import oracle.dbtools.crest.swingui.TVConnector;
import oracle.dbtools.crest.swingui.TopView;
import oracle.dbtools.crest.util.propertymap.PropertyMap;
import oracle.dbtools.crest.util.string.StringUtilities;
import org.w3c.dom.Element;

public class XMLObjToStringBuilderTransformer
extends MDTransformer
implements MDXMLConstants {
    private static final String OPEN_CHAR_SLASH = "</";
    private static final String NEWLINE_OPENCHAR_SLASH = "\n</";
    private static final String NEWLINE_OPENCHAR = "\n<";
    private static final String EQUAL_SLASH = "=\"";
    private static final String INNER_CLASS = "innerClass";
    private static final String XML_VERSION_1_0_ENCODING_UTF_8 = "<?xml version = '1.0' encoding = 'UTF-8'?>";
    public static boolean includeLoggingProps = true;
    public static boolean includeID = true;
    private static StringBuilder sb = new StringBuilder(4096);

    public StringBuilder transformFromObject(Object object) {
        return this.transformFromObject(object, false);
    }

    public StringBuilder transformFromObject(Object object, boolean bl) {
        sb.delete(0, sb.length());
        sb.append(XML_VERSION_1_0_ENCODING_UTF_8);
        this.transformFromObject(object, null, sb, bl);
        return sb;
    }

    public void transformFromObject(Object object, String string, StringBuilder stringBuilder) {
        this.transformFromObject(object, string, stringBuilder, false);
    }

    public void transformFromObject(Object object, String string, StringBuilder stringBuilder, boolean bl) {
        String string2 = this.transformFromObject(object, string, stringBuilder, bl, false);
        this.addCloseTag(string2, stringBuilder);
    }

    public String transformFromObject(Object object, String string, StringBuilder stringBuilder, boolean bl, boolean bl2) {
        String string2 = "";
        try {
            ClassDescription classDescription = this.getClassDescription();
            String string3 = "";
            if (string != null) {
                this.addOpenTag(string, stringBuilder);
            } else {
                boolean bl3 = false;
                string3 = classDescription.getXmlName();
                while (string3.indexOf(36) > -1) {
                    string3 = string3.replace('$', '.');
                    bl3 = true;
                }
                this.addOpenTag(string3, stringBuilder);
                if (bl3) {
                    this.addAttribute(INNER_CLASS, "true", stringBuilder);
                }
            }
            if (!SKP_CLASS_NAME && !bl2) {
                this.addAttribute("class", classDescription.getClassName(), stringBuilder);
            }
            this.invokeMethod(object, classDescription.beforeTransform);
            if (bl) {
                this.invokeMethod(object, classDescription.beforeTransformExt);
            }
            this.processProperties(object, stringBuilder, classDescription, bl);
            this.processClassPropertyMap(object, stringBuilder, classDescription);
            this.processCollections(object, stringBuilder, classDescription, bl);
            string2 = string != null ? string : string3;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string2;
    }

    private void addAttribute(String string, String string2, StringBuilder stringBuilder) {
        stringBuilder.append(' ').append(string).append(EQUAL_SLASH).append(string2).append('\"');
    }

    private void addOpenTag(String string, StringBuilder stringBuilder) {
        stringBuilder.append(NEWLINE_OPENCHAR).append(string);
    }

    private void addCloseTag(String string, StringBuilder stringBuilder) {
        stringBuilder.append(NEWLINE_OPENCHAR_SLASH).append(string).append('>');
    }

    private void addElement(String string, String string2, StringBuilder stringBuilder) {
        stringBuilder.append(NEWLINE_OPENCHAR).append(string).append('>').append(string2).append(OPEN_CHAR_SLASH).append(string).append('>');
    }

    private void addCloseChar(StringBuilder stringBuilder) {
        stringBuilder.append('>');
    }

    private void processProperties(Object object, StringBuilder stringBuilder, ClassDescription classDescription) {
        this.processProperties(object, stringBuilder, classDescription, false);
    }

    private void processProperties(Object object, StringBuilder stringBuilder, ClassDescription classDescription, boolean bl) {
        Object object2;
        for (ClassDescription.PropertyDescription propertyDescription : classDescription.getPropertiesList()) {
            if (!propertyDescription.isAttribute() || propertyDescription.isLoggingProp && !includeLoggingProps || !includeID && "id".equalsIgnoreCase(propertyDescription.xmlName) || propertyDescription.isExternalProperty && !bl || (object2 = this.getProperty(object, propertyDescription)) == null || SKP_DEFAULTS && ((String)object2).equalsIgnoreCase(propertyDescription.defaultValue)) continue;
            object2 = StringUtilities.encodeAttributeValue((String)object2);
            this.addAttribute(propertyDescription.xmlName, (String)object2, stringBuilder);
        }
        this.addTopViewAttributes(stringBuilder, object);
        stringBuilder.append('>');
        for (ClassDescription.PropertyDescription propertyDescription : classDescription.getPropertiesList()) {
            MDTransformationManager.TrObjects trObjects;
            if (propertyDescription.isLoggingProp && !includeLoggingProps || !includeID && "id".equalsIgnoreCase(propertyDescription.xmlName) || propertyDescription.isExternalProperty && !bl) continue;
            if (propertyDescription.isRectangle) {
                object2 = XMLObjToStringBuilderTransformer.getObjectForProperty(object, propertyDescription);
                if (object2 == null || !(object2 instanceof Rectangle)) continue;
                this.appendBounds(stringBuilder, propertyDescription.xmlName, (Rectangle)object2);
                continue;
            }
            if (propertyDescription.isPropertyMap) {
                this.processPropertyAsPropertyMap(object, stringBuilder, propertyDescription);
                continue;
            }
            if (propertyDescription.isMap) {
                this.processMapProperty(object, stringBuilder, propertyDescription);
                continue;
            }
            if (propertyDescription.isSimpleClass() || propertyDescription.isStringClass() || propertyDescription.isReferred()) {
                object2 = this.getProperty(object, propertyDescription);
                if (object2 == null || SKP_DEFAULTS && ((String)object2).equalsIgnoreCase(propertyDescription.defaultValue)) continue;
                object2 = StringUtilities.encodeAttributeValue((String)object2);
                if (propertyDescription.isAttribute()) continue;
                this.addElement(propertyDescription.xmlName, (String)object2, stringBuilder);
                continue;
            }
            object2 = XMLObjToStringBuilderTransformer.getObjectForProperty(object, propertyDescription);
            if (object2 == null || (trObjects = this.getTransformationManager().getTransformersFor(object2.getClass())) == null || trObjects.getFromObjectTransformer() == null || !(trObjects.getFromObjectTransformer() instanceof XMLObjToStringBuilderTransformer)) continue;
            XMLObjToStringBuilderTransformer xMLObjToStringBuilderTransformer = (XMLObjToStringBuilderTransformer)trObjects.getFromObjectTransformer();
            xMLObjToStringBuilderTransformer.transformFromObject(object2, propertyDescription.xmlName, stringBuilder, bl);
        }
    }

    private void processPropertyAsPropertyMap(Object object, StringBuilder stringBuilder, ClassDescription.PropertyDescription propertyDescription) {
        Object object2;
        if (propertyDescription.isPropertyMap && (object2 = XMLObjToStringBuilderTransformer.getObjectForProperty(object, propertyDescription)) != null && object2 instanceof PropertyMap) {
            PropertyMap propertyMap = (PropertyMap)object2;
            boolean bl = false;
            Iterator iterator = propertyMap.getPropertyNames();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                String string2 = propertyMap.getProperty(string);
                if (string2 == null) continue;
                if (!bl) {
                    this.addOpenTag(propertyDescription.xmlName, stringBuilder);
                    stringBuilder.append('>');
                    bl = true;
                }
                this.addOpenTag(propertyDescription.pmItemName, stringBuilder);
                this.addAttribute(propertyDescription.pmKeyName, StringUtilities.encodeAttributeValue(string), stringBuilder);
                this.addAttribute(propertyDescription.pmValueName, StringUtilities.encodeAttributeValue(string2), stringBuilder);
                stringBuilder.append("/>");
            }
            if (bl) {
                this.addCloseTag(propertyDescription.xmlName, stringBuilder);
            }
        }
    }

    private void processMapProperty(Object object, StringBuilder stringBuilder, ClassDescription.PropertyDescription propertyDescription) {
        Object object2;
        if (propertyDescription.isMap && (object2 = XMLObjToStringBuilderTransformer.getObjectForProperty(object, propertyDescription)) != null && object2 instanceof Map) {
            Map map = (Map)object2;
            boolean bl = false;
            for (String string : map.keySet()) {
                Object v = map.get(string);
                if (v == null) continue;
                if (!bl) {
                    this.addOpenTag(propertyDescription.xmlName, stringBuilder);
                    stringBuilder.append('>');
                    bl = true;
                }
                this.addOpenTag(propertyDescription.pmItemName, stringBuilder);
                this.addAttribute("key", StringUtilities.encodeAttributeValue(string), stringBuilder);
                this.addAttribute("value", StringUtilities.encodeAttributeValue(v.toString()), stringBuilder);
                stringBuilder.append("/>");
            }
            if (bl) {
                this.addCloseTag(propertyDescription.xmlName, stringBuilder);
            }
        }
    }

    private void processClassPropertyMap(Object object, StringBuilder stringBuilder, ClassDescription classDescription) {
        if (classDescription.isPropertyMap && object instanceof PropertyMap) {
            PropertyMap propertyMap = (PropertyMap)object;
            Iterator iterator = propertyMap.getPropertyNames();
            boolean bl = false;
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                if (this.skipProperty(string)) continue;
                String string2 = propertyMap.getProperty(string);
                if (!bl) {
                    this.addOpenTag("propertyMap", stringBuilder);
                    stringBuilder.append('>');
                    bl = true;
                }
                this.addOpenTag("property", stringBuilder);
                this.addAttribute("name", StringUtilities.encodeAttributeValue(string), stringBuilder);
                this.addAttribute("value", StringUtilities.encodeAttributeValue(string2), stringBuilder);
                stringBuilder.append("/>");
            }
            if (bl) {
                this.addCloseTag("propertyMap", stringBuilder);
            }
        }
    }

    private boolean skipProperty(String string) {
        return false;
    }

    private void processCollections(Object object, StringBuilder stringBuilder, ClassDescription classDescription) {
        this.processCollections(object, stringBuilder, classDescription, false);
    }

    private void processCollections(Object object, StringBuilder stringBuilder, ClassDescription classDescription, boolean bl) {
        for (ClassDescription.CollectionDescription collectionDescription : classDescription.getCollectionsList()) {
            Object object2;
            Collection collection;
            if (collectionDescription.isExternalCollection && !bl || (collection = this.getObjectList(object2 = XMLObjToStringBuilderTransformer.getCollection(object, collectionDescription), collectionDescription)) == null || !(collection instanceof Collection) || SKP_DEFAULTS && collection.size() <= 0) continue;
            if (collectionDescription.itemIsRef) {
                this.processCollectionWithRefs(object, collection, stringBuilder, collectionDescription, bl);
                continue;
            }
            this.processCollectionWithContained(collection, stringBuilder, collectionDescription, bl);
        }
    }

    private void processCollectionWithRefs(Object object, Collection collection, StringBuilder stringBuilder, ClassDescription.CollectionDescription collectionDescription) {
        this.processCollectionWithRefs(object, collection, stringBuilder, collectionDescription, false);
    }

    private void processCollectionWithRefs(Object object, Collection collection, StringBuilder stringBuilder, ClassDescription.CollectionDescription collectionDescription, boolean bl) {
        if (collectionDescription.isExternalCollection && !bl) {
            return;
        }
        this.addOpenTag(collectionDescription.xmlName, stringBuilder);
        if (!collectionDescription.listOfRefs) {
            stringBuilder.append('>');
            for (Object e : collection) {
                if (e == null) continue;
                String string = null;
                if (e instanceof ModelIDObject) {
                    string = ((ModelIDObject)e).getObjectID();
                } else if (object instanceof ID_ObjectPropertyTranslator) {
                    string = ((ID_ObjectPropertyTranslator)object).translateObjectToID(null, e);
                } else {
                    int n = 0;
                    ++n;
                }
                this.addElement(collectionDescription.itemXmlName, string, stringBuilder);
            }
            this.addCloseTag(collectionDescription.xmlName, stringBuilder);
        } else {
            Object object22;
            StringBuffer stringBuffer = new StringBuffer();
            boolean bl2 = true;
            for (Object object22 : collection) {
                String string = null;
                if (object22 instanceof ModelIDObject) {
                    string = ((ModelIDObject)object22).getObjectID();
                } else if (object instanceof ID_ObjectPropertyTranslator) {
                    string = ((ID_ObjectPropertyTranslator)object).translateObjectToID(null, object22);
                } else {
                    int n = 0;
                    ++n;
                }
                if (string == null) continue;
                if (bl2) {
                    stringBuffer.append(string);
                    bl2 = false;
                    continue;
                }
                stringBuffer.append(' ').append(string);
            }
            object22 = stringBuffer.toString();
            this.addAttribute(collectionDescription.refsXMLName, (String)object22, stringBuilder);
            stringBuilder.append("/>");
        }
    }

    private void processCollectionWithContained(Collection collection, StringBuilder stringBuilder, ClassDescription.CollectionDescription collectionDescription) {
        this.processCollectionWithContained(collection, stringBuilder, collectionDescription, false);
    }

    private void processCollectionWithContained(Collection collection, StringBuilder stringBuilder, ClassDescription.CollectionDescription collectionDescription, boolean bl) {
        Object object;
        Object object2;
        if (collectionDescription.isExternalCollection && !bl) {
            return;
        }
        this.addOpenTag(collectionDescription.xmlName, stringBuilder);
        boolean bl2 = false;
        if (collectionDescription.itemClassName != null && !"".equals(collectionDescription.itemClassName)) {
            bl2 = true;
            this.addAttribute("itemClass", collectionDescription.itemClassName, stringBuilder);
        }
        stringBuilder.append('>');
        if (collectionDescription.isEngPropertyHolderItem) {
            for (Object e : collection) {
                if (!(e instanceof EngPropertyHolder)) continue;
                object2 = (EngPropertyHolder)e;
                this.addOpenTag(collectionDescription.itemXmlName, stringBuilder);
                this.addAttribute("name", ((EngPropertyHolder)object2).getName(), stringBuilder);
                this.addAttribute("selected", String.valueOf(((EngPropertyHolder)object2).isSelected()), stringBuilder);
                stringBuilder.append("/>");
            }
        }
        boolean bl3 = true;
        boolean bl4 = collectionDescription.isMapItem;
        object2 = null;
        Class<?> clazz = null;
        if (!bl4) {
            for (Object e : collection) {
                if (e instanceof Map) {
                    bl4 = true;
                    continue;
                }
                if (bl3 || clazz != null && !e.getClass().equals(clazz)) {
                    object2 = this.getTransformationManager().getTransformersFor(e.getClass());
                    bl3 = false;
                    clazz = e.getClass();
                }
                object = null;
                if (object2 != null && ((MDTransformationManager.TrObjects)object2).getFromObjectTransformer() != null && ((MDTransformationManager.TrObjects)object2).getFromObjectTransformer() instanceof XMLObjToStringBuilderTransformer) {
                    XMLObjToStringBuilderTransformer xMLObjToStringBuilderTransformer = (XMLObjToStringBuilderTransformer)((MDTransformationManager.TrObjects)object2).getFromObjectTransformer();
                    object = xMLObjToStringBuilderTransformer.transformFromObject(e, collectionDescription.itemXmlName, stringBuilder, bl, bl2);
                }
                if (object == null) continue;
                this.addConnectorPoints(stringBuilder, e);
                this.addCloseTag((String)object, stringBuilder);
            }
        }
        if (bl4) {
            for (Object e : collection) {
                if (!(e instanceof Map)) continue;
                bl4 = true;
                object = (Map)e;
                if (object.entrySet().size() <= 0) continue;
                this.addOpenTag(collectionDescription.itemXmlName, stringBuilder);
                for (Map.Entry entry : object.entrySet()) {
                    Object v = entry.getValue();
                    Object k = entry.getKey();
                    if (v == null || k == null || !(v instanceof String) || !(k instanceof String)) continue;
                    this.addAttribute(StringUtilities.encodeAttributeValue((String)k), StringUtilities.encodeAttributeValue((String)v), stringBuilder);
                }
                stringBuilder.append("/>");
            }
        }
        this.addCloseTag(collectionDescription.xmlName, stringBuilder);
    }

    private void processTopView(Element element, Object object) {
        TopView topView;
        DesignObject designObject;
        if (object instanceof TopView && (designObject = (topView = (TopView)object).getModel()) != null) {
            ConnectionInterface connectionInterface;
            Object object2;
            element.setAttribute("oid", StringUtilities.encodeAttributeValue(designObject.getObjectID()));
            if (designObject instanceof DiagramView) {
                object2 = (DiagramView)designObject;
                element.setAttribute("dpv_id", StringUtilities.encodeAttributeValue(((DiagramView)object2).getDpvID()));
            } else {
                element.setAttribute("otype", StringUtilities.encodeAttributeValue(designObject.getObjectTypeName()));
            }
            if (topView instanceof ContainerView) {
                element.setAttribute("vid", StringUtilities.encodeAttributeValue(topView.getViewID()));
                if (topView.getViewNumber() != 0) {
                    element.setAttribute("vnum", String.valueOf(topView.getViewNumber()));
                }
            } else if (topView instanceof TVConnector && (connectionInterface = (ConnectionInterface)((Object)((TopView)(object2 = (TVConnector)topView)).getModel())).getSourceObject() != null && connectionInterface.getTargetObject() != null && ((TVConnector)object2).getSourceTopView() != null && ((TVConnector)object2).getTargetTopView() != null) {
                element.setAttribute("vid_source", StringUtilities.encodeAttributeValue(((TVConnector)object2).getSourceTopView().getViewID()));
                element.setAttribute("vid_target", StringUtilities.encodeAttributeValue(((TVConnector)object2).getTargetTopView().getViewID()));
            }
        }
    }

    private void addConnectorPoints(StringBuilder stringBuilder, Object object) {
        if (object instanceof TVConnector) {
            TVConnector tVConnector = (TVConnector)object;
            this.addCollectionOfPoints(stringBuilder, "points", tVConnector.getActualPoints());
        }
    }

    private void addTopViewAttributes(StringBuilder stringBuilder, Object object) {
        TopView topView;
        DesignObject designObject;
        if (object instanceof TopView && (designObject = (topView = (TopView)object).getModel()) != null) {
            ConnectionInterface connectionInterface;
            Object object2;
            this.addAttribute("oid", StringUtilities.encodeAttributeValue(designObject.getObjectID()), stringBuilder);
            if (designObject instanceof DiagramView) {
                object2 = (DiagramView)designObject;
                this.addAttribute("dpv_id", StringUtilities.encodeAttributeValue(((DiagramView)object2).getDpvID()), stringBuilder);
            } else {
                this.addAttribute("otype", StringUtilities.encodeAttributeValue(designObject.getObjectTypeName()), stringBuilder);
            }
            if (topView instanceof ContainerView) {
                this.addAttribute("vid", StringUtilities.encodeAttributeValue(topView.getViewID()), stringBuilder);
                if (topView.getViewNumber() != 0) {
                    this.addAttribute("vnum", String.valueOf(topView.getViewNumber()), stringBuilder);
                }
            } else if (topView instanceof TVConnector && (connectionInterface = (ConnectionInterface)((Object)((TopView)(object2 = (TVConnector)topView)).getModel())).getSourceObject() != null && connectionInterface.getTargetObject() != null && ((TVConnector)object2).getSourceTopView() != null && ((TVConnector)object2).getTargetTopView() != null) {
                this.addAttribute("vid_source", StringUtilities.encodeAttributeValue(((TVConnector)object2).getSourceTopView().getViewID()), stringBuilder);
                this.addAttribute("vid_target", StringUtilities.encodeAttributeValue(((TVConnector)object2).getTargetTopView().getViewID()), stringBuilder);
            }
        }
    }

    private void appendBounds(StringBuilder stringBuilder, String string, Rectangle rectangle) {
        this.addOpenTag(string, stringBuilder);
        this.addAttribute("x", String.valueOf(rectangle.x), stringBuilder);
        this.addAttribute("y", String.valueOf(rectangle.y), stringBuilder);
        this.addAttribute("width", String.valueOf(rectangle.width), stringBuilder);
        this.addAttribute("height", String.valueOf(rectangle.height), stringBuilder);
        stringBuilder.append("/>");
    }

    private void addCollectionOfPoints(StringBuilder stringBuilder, String string, Collection collection) {
        if (collection.size() > 0) {
            this.addOpenTag(string, stringBuilder);
            stringBuilder.append('>');
            for (Object e : collection) {
                if (!(e instanceof Point2D)) continue;
                this.addOpenTag("point", stringBuilder);
                Point2D point2D = (Point2D)e;
                this.addAttribute("x", String.valueOf((int)point2D.getX()), stringBuilder);
                this.addAttribute("y", String.valueOf((int)point2D.getY()), stringBuilder);
                stringBuilder.append("/>");
            }
            this.addCloseTag(string, stringBuilder);
        }
    }

    @Override
    public String transformFromObjectToString(Object object) {
        return this.transformFromObjectToString(object, false);
    }

    public String transformFromObjectToString(Object object, boolean bl) {
        StringBuilder stringBuilder = this.transformFromObject(object, bl);
        return stringBuilder.toString();
    }
}

