/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.metadata;

import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.io.IOException;
import java.io.Writer;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.design.ConnectionInterface;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DiagramView;
import oracle.dbtools.crest.model.design.engineering.EngPropertyHolder;
import oracle.dbtools.crest.model.metadata.ClassDescription;
import oracle.dbtools.crest.model.metadata.ID_ObjectPropertyTranslator;
import oracle.dbtools.crest.model.metadata.MDTransformationManager;
import oracle.dbtools.crest.model.metadata.MDTransformer;
import oracle.dbtools.crest.model.metadata.MDXMLConstants;
import oracle.dbtools.crest.swingui.ContainerView;
import oracle.dbtools.crest.swingui.TVConnector;
import oracle.dbtools.crest.swingui.TopView;
import oracle.dbtools.crest.util.propertymap.PropertyMap;
import oracle.dbtools.crest.util.string.StringUtilities;
import org.w3c.dom.Element;

public class XMLObjToStreamTransformer
extends MDTransformer
implements MDXMLConstants {
    private static final String SLASH_CLOSE_CHAR = "/>";
    private static final String OPEN_CHAR_SLASH = "</";
    private static final String CLOSE_CHAR = ">";
    private static final String NEWLINE_OPEN_SLASH = "\n</";
    private static final String NEWLINE_OPEN = "\n<";
    private static final String SLASHED_QUOTE = "\"";
    private static final String EQUAL_SLASH = "=\"";
    private static final String SPACE = " ";
    private static final String INNER_CLASS = "innerClass";
    public static boolean includeLoggingProps = true;
    public static boolean includeID = true;
    private static String header = "<?xml version = '1.0' encoding = 'UTF-8'?>";

    public void transformFromObject(Object object, Writer writer) {
        this.transformFromObject(object, writer, false);
    }

    public void transformFromObject(Object object, Writer writer, boolean bl) {
        try {
            writer.write(header);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.transformFromObject(object, null, writer, bl);
    }

    public void transformFromObject(Object object, String string, Writer writer) {
        this.transformFromObject(object, string, writer, false);
    }

    public void transformFromObject(Object object, String string, Writer writer, boolean bl) {
        String string2 = this.transformFromObject(object, string, writer, bl, false);
        this.addCloseTag(string2, writer);
    }

    public String transformFromObject(Object object, String string, Writer writer, boolean bl, boolean bl2) {
        String string2 = "";
        try {
            ClassDescription classDescription = this.getClassDescription();
            String string3 = "";
            if (string != null) {
                this.addOpenTag(string, writer);
            } else {
                boolean bl3 = false;
                string3 = classDescription.getXmlName();
                while (string3.indexOf(36) > -1) {
                    string3 = string3.replace('$', '.');
                    bl3 = true;
                }
                this.addOpenTag(string3, writer);
                if (bl3) {
                    this.addAttribute(INNER_CLASS, "true", writer);
                }
            }
            if (!SKP_CLASS_NAME && !bl2) {
                this.addAttribute("class", classDescription.getClassName(), writer);
            }
            this.invokeMethod(object, classDescription.beforeTransform);
            if (bl) {
                this.invokeMethod(object, classDescription.beforeTransformExt);
            }
            this.processProperties(object, writer, classDescription, bl);
            this.processClassPropertyMap(object, writer, classDescription);
            this.processCollections(object, writer, classDescription, bl);
            string2 = string != null ? string : string3;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string2;
    }

    public void transformFromObjectAttributesOnly(Object object, String string, Writer writer, boolean bl, boolean bl2) {
        String string2 = "";
        try {
            ClassDescription classDescription = this.getClassDescription();
            String string3 = "";
            if (string != null) {
                this.addOpenTag(string, writer);
            } else {
                boolean bl3 = false;
                string3 = classDescription.getXmlName();
                while (string3.indexOf(36) > -1) {
                    string3 = string3.replace('$', '.');
                    bl3 = true;
                }
                this.addOpenTag(string3, writer);
                if (bl3) {
                    this.addAttribute(INNER_CLASS, "true", writer);
                }
            }
            if (!SKP_CLASS_NAME && !bl2) {
                this.addAttribute("class", classDescription.getClassName(), writer);
            }
            this.invokeMethod(object, classDescription.beforeTransform);
            if (bl) {
                this.invokeMethod(object, classDescription.beforeTransformExt);
            }
            for (ClassDescription.PropertyDescription propertyDescription : classDescription.getPropertiesList()) {
                String string4;
                if (!propertyDescription.isAttribute() || propertyDescription.isLoggingProp && !includeLoggingProps || !includeID && "id".equalsIgnoreCase(propertyDescription.xmlName) || propertyDescription.isExternalProperty && !bl || (string4 = this.getProperty(object, propertyDescription)) == null || SKP_DEFAULTS && string4.equalsIgnoreCase(propertyDescription.defaultValue)) continue;
                string4 = StringUtilities.encodeAttributeValue(string4);
                this.addAttribute(propertyDescription.xmlName, string4, writer);
            }
            string2 = string != null ? string : string3;
            this.addCloseSlashChar(writer);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void addAttribute(String string, String string2, Writer writer) {
        try {
            writer.write(SPACE);
            writer.write(string);
            writer.write(EQUAL_SLASH);
            writer.write(string2);
            writer.write(SLASHED_QUOTE);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void addOpenTag(String string, Writer writer) {
        try {
            writer.write(NEWLINE_OPEN);
            writer.write(string);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void addCloseTag(String string, Writer writer) {
        try {
            writer.write(NEWLINE_OPEN_SLASH);
            writer.write(string);
            writer.write(CLOSE_CHAR);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void addElement(String string, String string2, Writer writer) {
        try {
            writer.write(NEWLINE_OPEN);
            writer.write(string);
            writer.write(CLOSE_CHAR);
            writer.write(string2);
            writer.write(OPEN_CHAR_SLASH);
            writer.write(string);
            writer.write(CLOSE_CHAR);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void addCloseChar(Writer writer) {
        try {
            writer.write(CLOSE_CHAR);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void addCloseSlashChar(Writer writer) {
        try {
            writer.write(SLASH_CLOSE_CHAR);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void processProperties(Object object, Writer writer, ClassDescription classDescription) {
        this.processProperties(object, writer, classDescription, false);
    }

    private void processProperties(Object object, Writer writer, ClassDescription classDescription, boolean bl) {
        Object object2;
        for (ClassDescription.PropertyDescription propertyDescription : classDescription.getPropertiesList()) {
            if (!propertyDescription.isAttribute() || propertyDescription.isLoggingProp && !includeLoggingProps || !includeID && "id".equalsIgnoreCase(propertyDescription.xmlName) || propertyDescription.isExternalProperty && !bl || (object2 = this.getProperty(object, propertyDescription)) == null || SKP_DEFAULTS && ((String)object2).equalsIgnoreCase(propertyDescription.defaultValue)) continue;
            object2 = StringUtilities.encodeAttributeValue((String)object2);
            this.addAttribute(propertyDescription.xmlName, (String)object2, writer);
        }
        this.addTopViewAttributes(writer, object);
        this.addCloseChar(writer);
        for (ClassDescription.PropertyDescription propertyDescription : classDescription.getPropertiesList()) {
            MDTransformationManager.TrObjects trObjects;
            if (propertyDescription.isAttribute() || propertyDescription.isLoggingProp && !includeLoggingProps || !includeID && "id".equalsIgnoreCase(propertyDescription.xmlName) || propertyDescription.isExternalProperty && !bl) continue;
            if (propertyDescription.isRectangle) {
                object2 = XMLObjToStreamTransformer.getObjectForProperty(object, propertyDescription);
                if (object2 == null || !(object2 instanceof Rectangle)) continue;
                this.appendBounds(writer, propertyDescription.xmlName, (Rectangle)object2);
                continue;
            }
            if (propertyDescription.isPropertyMap) {
                this.processPropertyAsPropertyMap(object, writer, propertyDescription);
                continue;
            }
            if (propertyDescription.isMap) {
                this.processMapProperty(object, writer, propertyDescription);
                continue;
            }
            if (propertyDescription.isSimpleClass() || propertyDescription.isStringClass() || propertyDescription.isReferred()) {
                object2 = this.getProperty(object, propertyDescription);
                if (object2 == null || SKP_DEFAULTS && ((String)object2).equalsIgnoreCase(propertyDescription.defaultValue)) continue;
                object2 = StringUtilities.encodeAttributeValue((String)object2);
                if (propertyDescription.isAttribute()) continue;
                this.addElement(propertyDescription.xmlName, (String)object2, writer);
                continue;
            }
            object2 = XMLObjToStreamTransformer.getObjectForProperty(object, propertyDescription);
            if (object2 == null || (trObjects = this.getTransformationManager().getTransformersFor(object2.getClass())) == null || trObjects.getFromObjectToStreamTransformer() == null || !(trObjects.getFromObjectToStreamTransformer() instanceof XMLObjToStreamTransformer)) continue;
            XMLObjToStreamTransformer xMLObjToStreamTransformer = (XMLObjToStreamTransformer)trObjects.getFromObjectToStreamTransformer();
            xMLObjToStreamTransformer.transformFromObject(object2, propertyDescription.xmlName, writer, bl);
        }
    }

    private void processPropertyAsPropertyMap(Object object, Writer writer, ClassDescription.PropertyDescription propertyDescription) {
        Object object2;
        if (propertyDescription.isPropertyMap && (object2 = XMLObjToStreamTransformer.getObjectForProperty(object, propertyDescription)) != null && object2 instanceof PropertyMap) {
            PropertyMap propertyMap = (PropertyMap)object2;
            boolean bl = false;
            Iterator iterator = propertyMap.getPropertyNames();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                String string2 = propertyMap.getProperty(string);
                if (string2 == null) continue;
                if (!bl) {
                    this.addOpenTag(propertyDescription.xmlName, writer);
                    this.addCloseChar(writer);
                    bl = true;
                }
                this.addOpenTag(propertyDescription.pmItemName, writer);
                this.addAttribute(propertyDescription.pmKeyName, StringUtilities.encodeAttributeValue(string), writer);
                this.addAttribute(propertyDescription.pmValueName, StringUtilities.encodeAttributeValue(string2), writer);
                this.addCloseSlashChar(writer);
            }
            if (bl) {
                this.addCloseTag(propertyDescription.xmlName, writer);
            }
        }
    }

    private void processMapProperty(Object object, Writer writer, ClassDescription.PropertyDescription propertyDescription) {
        Object object2;
        if (propertyDescription.isMap && (object2 = XMLObjToStreamTransformer.getObjectForProperty(object, propertyDescription)) != null && object2 instanceof Map) {
            Map map = (Map)object2;
            boolean bl = false;
            for (String string : map.keySet()) {
                Object v = map.get(string);
                if (v == null) continue;
                if (!bl) {
                    this.addOpenTag(propertyDescription.xmlName, writer);
                    this.addCloseChar(writer);
                    bl = true;
                }
                this.addOpenTag(propertyDescription.pmItemName, writer);
                this.addAttribute("key", StringUtilities.encodeAttributeValue(string), writer);
                this.addAttribute("value", StringUtilities.encodeAttributeValue(v.toString()), writer);
                this.addCloseSlashChar(writer);
            }
            if (bl) {
                this.addCloseTag(propertyDescription.xmlName, writer);
            }
        }
    }

    private void processClassPropertyMap(Object object, Writer writer, ClassDescription classDescription) {
        if (classDescription.isPropertyMap && object instanceof PropertyMap) {
            PropertyMap propertyMap = (PropertyMap)object;
            Iterator iterator = propertyMap.getPropertyNames();
            boolean bl = false;
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                if (this.skipProperty(string)) continue;
                String string2 = propertyMap.getProperty(string);
                if (!bl) {
                    this.addOpenTag("propertyMap", writer);
                    this.addCloseChar(writer);
                    bl = true;
                }
                this.addOpenTag("property", writer);
                this.addAttribute("name", StringUtilities.encodeAttributeValue(string), writer);
                this.addAttribute("value", StringUtilities.encodeAttributeValue(string2), writer);
                this.addCloseSlashChar(writer);
            }
            if (bl) {
                this.addCloseTag("propertyMap", writer);
            }
        }
    }

    private boolean skipProperty(String string) {
        return false;
    }

    private void processCollections(Object object, Writer writer, ClassDescription classDescription) {
        this.processCollections(object, writer, classDescription, false);
    }

    private void processCollections(Object object, Writer writer, ClassDescription classDescription, boolean bl) {
        for (ClassDescription.CollectionDescription collectionDescription : classDescription.getCollectionsList()) {
            Object object2;
            Collection collection;
            if (collectionDescription.isExternalCollection && !bl || (collection = this.getObjectList(object2 = XMLObjToStreamTransformer.getCollection(object, collectionDescription), collectionDescription)) == null || !(collection instanceof Collection) || SKP_DEFAULTS && collection.size() <= 0) continue;
            if (collectionDescription.itemIsRef) {
                this.processCollectionWithRefs(object, collection, writer, collectionDescription, bl);
                continue;
            }
            this.processCollectionWithContained(collection, writer, collectionDescription, bl);
        }
    }

    private void processCollectionWithRefs(Object object, Collection collection, Writer writer, ClassDescription.CollectionDescription collectionDescription) {
        this.processCollectionWithRefs(object, collection, writer, collectionDescription, false);
    }

    private void processCollectionWithRefs(Object object, Collection collection, Writer writer, ClassDescription.CollectionDescription collectionDescription, boolean bl) {
        if (collectionDescription.isExternalCollection && !bl) {
            return;
        }
        this.addOpenTag(collectionDescription.xmlName, writer);
        if (!collectionDescription.listOfRefs) {
            this.addCloseChar(writer);
            for (Object e : collection) {
                if (e == null) continue;
                String string = null;
                if (e instanceof ModelIDObject) {
                    string = ((ModelIDObject)e).getObjectID();
                } else if (object instanceof ID_ObjectPropertyTranslator) {
                    string = ((ID_ObjectPropertyTranslator)object).translateObjectToID(null, e);
                } else {
                    int n = 0;
                    ++n;
                }
                this.addElement(collectionDescription.itemXmlName, string, writer);
            }
            this.addCloseTag(collectionDescription.xmlName, writer);
        } else {
            Object object22;
            StringBuffer stringBuffer = new StringBuffer();
            boolean bl2 = true;
            for (Object object22 : collection) {
                String string = null;
                if (object22 instanceof ModelIDObject) {
                    string = ((ModelIDObject)object22).getObjectID();
                } else if (object instanceof ID_ObjectPropertyTranslator) {
                    string = ((ID_ObjectPropertyTranslator)object).translateObjectToID(null, object22);
                } else {
                    int n = 0;
                    ++n;
                }
                if (string == null) continue;
                if (bl2) {
                    stringBuffer.append(string);
                    bl2 = false;
                    continue;
                }
                stringBuffer.append(' ').append(string);
            }
            object22 = stringBuffer.toString();
            this.addAttribute(collectionDescription.refsXMLName, (String)object22, writer);
            this.addCloseSlashChar(writer);
        }
    }

    private void processCollectionWithContained(Collection collection, Writer writer, ClassDescription.CollectionDescription collectionDescription) {
        this.processCollectionWithContained(collection, writer, collectionDescription, false);
    }

    private void processCollectionWithContained(Collection collection, Writer writer, ClassDescription.CollectionDescription collectionDescription, boolean bl) {
        Object object;
        Object object2;
        if (collectionDescription.isExternalCollection && !bl) {
            return;
        }
        this.addOpenTag(collectionDescription.xmlName, writer);
        boolean bl2 = false;
        if (collectionDescription.itemClassName != null && !"".equals(collectionDescription.itemClassName)) {
            bl2 = true;
            this.addAttribute("itemClass", collectionDescription.itemClassName, writer);
        }
        this.addCloseChar(writer);
        if (collectionDescription.isEngPropertyHolderItem) {
            for (Object e : collection) {
                if (!(e instanceof EngPropertyHolder)) continue;
                object2 = (EngPropertyHolder)e;
                this.addOpenTag(collectionDescription.itemXmlName, writer);
                this.addAttribute("name", ((EngPropertyHolder)object2).getName(), writer);
                this.addAttribute("selected", String.valueOf(((EngPropertyHolder)object2).isSelected()), writer);
                this.addCloseSlashChar(writer);
            }
        }
        boolean bl3 = true;
        boolean bl4 = collectionDescription.isMapItem;
        object2 = null;
        Class<?> clazz = null;
        if (!bl4) {
            for (Object e : collection) {
                if (e instanceof Map) {
                    bl4 = true;
                    continue;
                }
                if (bl3 || clazz != null && !e.getClass().equals(clazz)) {
                    object2 = this.getTransformationManager().getTransformersFor(e.getClass());
                    bl3 = false;
                    clazz = e.getClass();
                }
                object = null;
                if (object2 != null && ((MDTransformationManager.TrObjects)object2).getFromObjectToStreamTransformer() != null && ((MDTransformationManager.TrObjects)object2).getFromObjectToStreamTransformer() instanceof XMLObjToStreamTransformer) {
                    XMLObjToStreamTransformer xMLObjToStreamTransformer = (XMLObjToStreamTransformer)((MDTransformationManager.TrObjects)object2).getFromObjectToStreamTransformer();
                    ClassDescription object3 = xMLObjToStreamTransformer.getClassDescription();
                    if (!(e instanceof TopView) && object3 != null && !object3.isHasElementsOrCollections()) {
                        xMLObjToStreamTransformer.transformFromObjectAttributesOnly(e, collectionDescription.itemXmlName, writer, bl, bl2);
                    } else {
                        object = xMLObjToStreamTransformer.transformFromObject(e, collectionDescription.itemXmlName, writer, bl, bl2);
                    }
                }
                if (object == null) continue;
                this.addConnectorPoints(writer, e);
                this.addCloseTag((String)object, writer);
            }
        }
        if (bl4) {
            for (Object e : collection) {
                if (!(e instanceof Map)) continue;
                bl4 = true;
                object = (Map)e;
                if (object.entrySet().size() <= 0) continue;
                this.addOpenTag(collectionDescription.itemXmlName, writer);
                for (Map.Entry entry : object.entrySet()) {
                    Object v = entry.getValue();
                    Object k = entry.getKey();
                    if (v == null || k == null || !(v instanceof String) || !(k instanceof String)) continue;
                    this.addAttribute(StringUtilities.encodeAttributeValue((String)k), StringUtilities.encodeAttributeValue((String)v), writer);
                }
                this.addCloseSlashChar(writer);
            }
        }
        this.addCloseTag(collectionDescription.xmlName, writer);
    }

    private void processTopView(Element element, Object object) {
        TopView topView;
        DesignObject designObject;
        if (object instanceof TopView && (designObject = (topView = (TopView)object).getModel()) != null) {
            ConnectionInterface connectionInterface;
            Object object2;
            element.setAttribute("oid", StringUtilities.encodeAttributeValue(designObject.getObjectID()));
            if (designObject instanceof DiagramView) {
                object2 = (DiagramView)designObject;
                element.setAttribute("dpv_id", StringUtilities.encodeAttributeValue(((DiagramView)object2).getDpvID()));
            } else {
                element.setAttribute("otype", StringUtilities.encodeAttributeValue(designObject.getObjectTypeName()));
            }
            if (topView instanceof ContainerView) {
                element.setAttribute("vid", StringUtilities.encodeAttributeValue(topView.getViewID()));
                if (topView.getViewNumber() != 0) {
                    element.setAttribute("vnum", String.valueOf(topView.getViewNumber()));
                }
            } else if (topView instanceof TVConnector && (connectionInterface = (ConnectionInterface)((Object)((TopView)(object2 = (TVConnector)topView)).getModel())).getSourceObject() != null && connectionInterface.getTargetObject() != null && ((TVConnector)object2).getSourceTopView() != null && ((TVConnector)object2).getTargetTopView() != null) {
                element.setAttribute("vid_source", StringUtilities.encodeAttributeValue(((TVConnector)object2).getSourceTopView().getViewID()));
                element.setAttribute("vid_target", StringUtilities.encodeAttributeValue(((TVConnector)object2).getTargetTopView().getViewID()));
            }
        }
    }

    private void addConnectorPoints(Writer writer, Object object) {
        if (object instanceof TVConnector) {
            TVConnector tVConnector = (TVConnector)object;
            this.addCollectionOfPoints(writer, "points", tVConnector.getActualPoints());
        }
    }

    private void addTopViewAttributes(Writer writer, Object object) {
        TopView topView;
        DesignObject designObject;
        if (object instanceof TopView && (designObject = (topView = (TopView)object).getModel()) != null) {
            ConnectionInterface connectionInterface;
            Object object2;
            this.addAttribute("oid", StringUtilities.encodeAttributeValue(designObject.getObjectID()), writer);
            if (designObject instanceof DiagramView) {
                object2 = (DiagramView)designObject;
                this.addAttribute("dpv_id", StringUtilities.encodeAttributeValue(((DiagramView)object2).getDpvID()), writer);
            } else {
                this.addAttribute("otype", StringUtilities.encodeAttributeValue(designObject.getObjectTypeName()), writer);
            }
            if (topView instanceof ContainerView) {
                this.addAttribute("vid", StringUtilities.encodeAttributeValue(topView.getViewID()), writer);
                if (topView.getViewNumber() != 0) {
                    this.addAttribute("vnum", String.valueOf(topView.getViewNumber()), writer);
                }
            } else if (topView instanceof TVConnector && (connectionInterface = (ConnectionInterface)((Object)((TopView)(object2 = (TVConnector)topView)).getModel())).getSourceObject() != null && connectionInterface.getTargetObject() != null && ((TVConnector)object2).getSourceTopView() != null && ((TVConnector)object2).getTargetTopView() != null) {
                this.addAttribute("vid_source", StringUtilities.encodeAttributeValue(((TVConnector)object2).getSourceTopView().getViewID()), writer);
                this.addAttribute("vid_target", StringUtilities.encodeAttributeValue(((TVConnector)object2).getTargetTopView().getViewID()), writer);
            }
        }
    }

    private void appendBounds(Writer writer, String string, Rectangle rectangle) {
        this.addOpenTag(string, writer);
        this.addAttribute("x", String.valueOf(rectangle.x), writer);
        this.addAttribute("y", String.valueOf(rectangle.y), writer);
        this.addAttribute("width", String.valueOf(rectangle.width), writer);
        this.addAttribute("height", String.valueOf(rectangle.height), writer);
        this.addCloseSlashChar(writer);
    }

    private void addCollectionOfPoints(Writer writer, String string, Collection collection) {
        if (collection.size() > 0) {
            this.addOpenTag(string, writer);
            this.addCloseChar(writer);
            for (Object e : collection) {
                if (!(e instanceof Point2D)) continue;
                this.addOpenTag("point", writer);
                Point2D point2D = (Point2D)e;
                this.addAttribute("x", String.valueOf((int)point2D.getX()), writer);
                this.addAttribute("y", String.valueOf((int)point2D.getY()), writer);
                this.addCloseSlashChar(writer);
            }
            this.addCloseTag(string, writer);
        }
    }

    @Override
    public String transformFromObjectToString(Object object) {
        return "";
    }
}

