/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.metadata;

import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.io.StringWriter;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.design.ConnectionInterface;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DiagramView;
import oracle.dbtools.crest.model.design.engineering.EngPropertyHolder;
import oracle.dbtools.crest.model.metadata.ClassDescription;
import oracle.dbtools.crest.model.metadata.ID_ObjectPropertyTranslator;
import oracle.dbtools.crest.model.metadata.MDTransformationManager;
import oracle.dbtools.crest.model.metadata.MDTransformer;
import oracle.dbtools.crest.model.metadata.MDXMLConstants;
import oracle.dbtools.crest.swingui.ContainerView;
import oracle.dbtools.crest.swingui.TVConnector;
import oracle.dbtools.crest.swingui.TopView;
import oracle.dbtools.crest.util.propertymap.PropertyMap;
import oracle.dbtools.crest.util.string.StringUtilities;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class XMLFromObjTransformer
extends MDTransformer
implements MDXMLConstants {
    public Document transformFromObject(Object object) {
        return this.transformFromObject(object, false);
    }

    public Document transformFromObject(Object object, boolean bl) {
        Document document = null;
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            document = documentBuilder.newDocument();
            Element element = this.transformFromObject(object, null, document, bl);
            if (element != null) {
                document.appendChild(element);
            }
        }
        catch (ParserConfigurationException parserConfigurationException) {
            // empty catch block
        }
        return document;
    }

    public Element transformFromObject(Object object, String string, Document document) {
        return this.transformFromObject(object, string, document, false);
    }

    public Element transformFromObject(Object object, String string, Document document, boolean bl) {
        return this.transformFromObject(object, string, document, bl, false);
    }

    public Element transformFromObject(Object object, String string, Document document, boolean bl, boolean bl2) {
        Element element = null;
        try {
            ClassDescription classDescription = this.getClassDescription();
            if (string != null) {
                element = document.createElement(string);
            } else {
                boolean bl3 = false;
                String string2 = classDescription.getXmlName();
                while (string2.indexOf(36) > -1) {
                    string2 = string2.replace('$', '.');
                    bl3 = true;
                }
                element = document.createElement(string2);
                if (bl3) {
                    element.setAttribute("innerClass", "true");
                }
            }
            if (!SKP_CLASS_NAME && !bl2) {
                element.setAttribute("class", classDescription.getClassName());
            }
            this.invokeMethod(object, classDescription.beforeTransform);
            if (bl) {
                this.invokeMethod(object, classDescription.beforeTransformExt);
            }
            this.processProperties(object, element, classDescription, bl);
            this.processClassPropertyMap(object, element, classDescription);
            this.processCollections(object, element, classDescription, bl);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return element;
    }

    private void processProperties(Object object, Element element, ClassDescription classDescription) {
        this.processProperties(object, element, classDescription, false);
    }

    private void processProperties(Object object, Element element, ClassDescription classDescription, boolean bl) {
        Document document = element.getOwnerDocument();
        for (ClassDescription.PropertyDescription propertyDescription : classDescription.getPropertiesList()) {
            Element element2;
            Object object2;
            Object object3;
            Object object4;
            if (propertyDescription.isLoggingProp && !MDTransformer.includeLoggingProps || !MDTransformer.includeID && "id".equalsIgnoreCase(propertyDescription.xmlName) || propertyDescription.isExternalProperty && !bl) continue;
            if (propertyDescription.isRectangle) {
                object4 = XMLFromObjTransformer.getObjectForProperty(object, propertyDescription);
                if (object4 == null || !(object4 instanceof Rectangle)) continue;
                this.appendBounds(element, propertyDescription.xmlName, (Rectangle)object4);
                continue;
            }
            if (propertyDescription.isPropertyMap) {
                this.processPropertyAsPropertyMap(object, element, propertyDescription);
                continue;
            }
            if (propertyDescription.isMap) {
                this.processMapProperty(object, element, propertyDescription);
                continue;
            }
            if (propertyDescription.isSimpleClass() || propertyDescription.isStringClass() || propertyDescription.isReferred()) {
                object4 = this.getProperty(object, propertyDescription);
                if (object4 == null || SKP_DEFAULTS && ((String)object4).equalsIgnoreCase(propertyDescription.defaultValue)) continue;
                object4 = StringUtilities.encodeAttributeValue((String)object4);
                if (propertyDescription.isAttribute()) {
                    element.setAttribute(propertyDescription.xmlName, (String)object4);
                    continue;
                }
                object3 = document.createElement(propertyDescription.xmlName);
                object2 = document.createTextNode((String)object4);
                object3.appendChild((Node)object2);
                element.appendChild((Node)object3);
                continue;
            }
            object4 = XMLFromObjTransformer.getObjectForProperty(object, propertyDescription);
            if (object4 == null || (object3 = this.getTransformationManager().getTransformersFor(object4.getClass())) == null || ((MDTransformationManager.TrObjects)object3).getFromObjectTransformer() == null || !(((MDTransformationManager.TrObjects)object3).getFromObjectTransformer() instanceof XMLFromObjTransformer) || (element2 = ((XMLFromObjTransformer)(object2 = (XMLFromObjTransformer)((MDTransformationManager.TrObjects)object3).getFromObjectTransformer())).transformFromObject(object4, propertyDescription.xmlName, document, bl)) == null) continue;
            element.appendChild(element2);
        }
    }

    private void processPropertyAsPropertyMap(Object object, Element element, ClassDescription.PropertyDescription propertyDescription) {
        Object object2;
        if (propertyDescription.isPropertyMap && (object2 = XMLFromObjTransformer.getObjectForProperty(object, propertyDescription)) != null && object2 instanceof PropertyMap) {
            Document document = element.getOwnerDocument();
            PropertyMap propertyMap = (PropertyMap)object2;
            Iterator iterator = propertyMap.getPropertyNames();
            Element element2 = null;
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                String string2 = propertyMap.getProperty(string);
                if (string2 == null) continue;
                if (element2 == null) {
                    element2 = document.createElement(propertyDescription.xmlName);
                    element.appendChild(element2);
                }
                Element element3 = document.createElement(propertyDescription.pmItemName);
                element3.setAttribute(propertyDescription.pmKeyName, StringUtilities.encodeAttributeValue(string));
                element3.setAttribute(propertyDescription.pmValueName, StringUtilities.encodeAttributeValue(string2));
                element2.appendChild(element3);
            }
        }
    }

    private void processMapProperty(Object object, Element element, ClassDescription.PropertyDescription propertyDescription) {
        Object object2;
        if (propertyDescription.isMap && (object2 = XMLFromObjTransformer.getObjectForProperty(object, propertyDescription)) != null && object2 instanceof Map) {
            Document document = element.getOwnerDocument();
            Map map = (Map)object2;
            Iterator iterator = map.keySet().iterator();
            Element element2 = null;
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                Object v = map.get(string);
                if (v == null) continue;
                if (element2 == null) {
                    element2 = document.createElement(propertyDescription.xmlName);
                    element.appendChild(element2);
                }
                Element element3 = document.createElement(propertyDescription.pmItemName);
                element3.setAttribute("key", StringUtilities.encodeAttributeValue(string));
                element3.setAttribute("value", StringUtilities.encodeAttributeValue(v.toString()));
                element2.appendChild(element3);
            }
        }
    }

    private void processClassPropertyMap(Object object, Element element, ClassDescription classDescription) {
        if (classDescription.isPropertyMap && object instanceof PropertyMap) {
            Document document = element.getOwnerDocument();
            PropertyMap propertyMap = (PropertyMap)object;
            Iterator iterator = propertyMap.getPropertyNames();
            Element element2 = null;
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                if (this.skipProperty(string)) continue;
                String string2 = propertyMap.getProperty(string);
                if (element2 == null) {
                    element2 = document.createElement("propertyMap");
                    element.appendChild(element2);
                }
                Element element3 = document.createElement("property");
                element3.setAttribute("name", StringUtilities.encodeAttributeValue(string));
                element3.setAttribute("value", StringUtilities.encodeAttributeValue(string2));
                element2.appendChild(element3);
            }
        }
    }

    private boolean skipProperty(String string) {
        return false;
    }

    private void processCollections(Object object, Element element, ClassDescription classDescription) {
        this.processCollections(object, element, classDescription, false);
    }

    private void processCollections(Object object, Element element, ClassDescription classDescription, boolean bl) {
        for (ClassDescription.CollectionDescription collectionDescription : classDescription.getCollectionsList()) {
            Object object2;
            Collection collection;
            if (collectionDescription.isExternalCollection && !bl || (collection = this.getObjectList(object2 = XMLFromObjTransformer.getCollection(object, collectionDescription), collectionDescription)) == null || !(collection instanceof Collection) || SKP_DEFAULTS && collection.size() <= 0) continue;
            if (collectionDescription.itemIsRef) {
                this.processCollectionWithRefs(object, collection, element, collectionDescription, bl);
                continue;
            }
            this.processCollectionWithContained(collection, element, collectionDescription, bl);
        }
    }

    private void processCollectionWithRefs(Object object, Collection collection, Element element, ClassDescription.CollectionDescription collectionDescription) {
        this.processCollectionWithRefs(object, collection, element, collectionDescription, false);
    }

    private void processCollectionWithRefs(Object object, Collection collection, Element element, ClassDescription.CollectionDescription collectionDescription, boolean bl) {
        if (collectionDescription.isExternalCollection && !bl) {
            return;
        }
        Document document = element.getOwnerDocument();
        Element element2 = document.createElement(collectionDescription.xmlName);
        element.appendChild(element2);
        if (!collectionDescription.listOfRefs) {
            for (Object e : collection) {
                if (e == null) continue;
                String string = null;
                if (e instanceof ModelIDObject) {
                    string = ((ModelIDObject)e).getObjectID();
                } else if (object instanceof ID_ObjectPropertyTranslator) {
                    string = ((ID_ObjectPropertyTranslator)object).translateObjectToID(null, e);
                } else {
                    int n = 0;
                    ++n;
                }
                Element element3 = document.createElement(collectionDescription.itemXmlName);
                Text text = document.createTextNode(string);
                element3.appendChild(text);
                element2.appendChild(element3);
            }
        } else {
            String string;
            Object object22;
            StringBuffer stringBuffer = new StringBuffer();
            boolean bl2 = true;
            for (Object object22 : collection) {
                string = null;
                if (object22 instanceof ModelIDObject) {
                    string = ((ModelIDObject)object22).getObjectID();
                } else if (object instanceof ID_ObjectPropertyTranslator) {
                    string = ((ID_ObjectPropertyTranslator)object).translateObjectToID(null, object22);
                } else {
                    int n = 0;
                    ++n;
                }
                if (string == null) continue;
                if (bl2) {
                    stringBuffer.append(string);
                    bl2 = false;
                    continue;
                }
                stringBuffer.append(' ').append(string);
            }
            object22 = collectionDescription.refsXMLName;
            string = stringBuffer.toString();
            element2.setAttribute((String)object22, string);
        }
    }

    private void processCollectionWithContained(Collection collection, Element element, ClassDescription.CollectionDescription collectionDescription) {
        this.processCollectionWithContained(collection, element, collectionDescription, false);
    }

    private void processCollectionWithContained(Collection collection, Element element, ClassDescription.CollectionDescription collectionDescription, boolean bl) {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        if (collectionDescription.isExternalCollection && !bl) {
            return;
        }
        Document document = element.getOwnerDocument();
        Element element2 = document.createElement(collectionDescription.xmlName);
        boolean bl2 = false;
        if (collectionDescription.itemClassName != null && !"".equals(collectionDescription.itemClassName)) {
            bl2 = true;
            element2.setAttribute("itemClass", collectionDescription.itemClassName);
        }
        element.appendChild(element2);
        if (collectionDescription.isEngPropertyHolderItem) {
            for (Object e : collection) {
                if (!(e instanceof EngPropertyHolder)) continue;
                object4 = (EngPropertyHolder)e;
                object3 = document.createElement(collectionDescription.itemXmlName);
                object3.setAttribute("name", ((EngPropertyHolder)object4).getName());
                object3.setAttribute("selected", String.valueOf(((EngPropertyHolder)object4).isSelected()));
                element2.appendChild((Node)object3);
            }
        }
        boolean bl3 = true;
        boolean bl4 = collectionDescription.isMapItem;
        object4 = null;
        object3 = null;
        if (!bl4) {
            for (Object e : collection) {
                if (e instanceof Map) {
                    bl4 = true;
                    continue;
                }
                if (bl3 || object3 != null && !e.getClass().equals(object3)) {
                    object4 = this.getTransformationManager().getTransformersFor(e.getClass());
                    bl3 = false;
                    object3 = e.getClass();
                }
                object2 = null;
                if (object4 != null && ((MDTransformationManager.TrObjects)object4).getFromObjectTransformer() != null && ((MDTransformationManager.TrObjects)object4).getFromObjectTransformer() instanceof XMLFromObjTransformer) {
                    object = (XMLFromObjTransformer)((MDTransformationManager.TrObjects)object4).getFromObjectTransformer();
                    object2 = ((XMLFromObjTransformer)object).transformFromObject(e, collectionDescription.itemXmlName, document, bl, bl2);
                }
                if (object2 == null) continue;
                element2.appendChild((Node)object2);
                this.processTopView((Element)object2, e);
            }
        }
        if (bl4) {
            for (Object e : collection) {
                if (!(e instanceof Map)) continue;
                bl4 = true;
                object2 = (Map)e;
                object = document.createElement(collectionDescription.itemXmlName);
                for (Map.Entry entry : object2.entrySet()) {
                    Object v = entry.getValue();
                    Object k = entry.getKey();
                    if (v == null || k == null || !(v instanceof String) || !(k instanceof String)) continue;
                    object.setAttribute(StringUtilities.encodeAttributeValue((String)k), StringUtilities.encodeAttributeValue((String)v));
                    element2.appendChild((Node)object);
                }
            }
        }
    }

    private void processTopView(Element element, Object object) {
        TopView topView;
        DesignObject designObject;
        if (object instanceof TopView && (designObject = (topView = (TopView)object).getModel()) != null) {
            ConnectionInterface connectionInterface;
            Object object2;
            element.setAttribute("oid", StringUtilities.encodeAttributeValue(designObject.getObjectID()));
            if (designObject instanceof DiagramView) {
                object2 = (DiagramView)designObject;
                element.setAttribute("dpv_id", StringUtilities.encodeAttributeValue(((DiagramView)object2).getDpvID()));
            } else {
                element.setAttribute("otype", StringUtilities.encodeAttributeValue(designObject.getObjectTypeName()));
            }
            if (topView instanceof ContainerView) {
                element.setAttribute("vid", StringUtilities.encodeAttributeValue(topView.getViewID()));
                if (topView.getViewNumber() != 0) {
                    element.setAttribute("vnum", String.valueOf(topView.getViewNumber()));
                }
            } else if (topView instanceof TVConnector && (connectionInterface = (ConnectionInterface)((Object)((TopView)(object2 = (TVConnector)topView)).getModel())).getSourceObject() != null && connectionInterface.getTargetObject() != null && ((TVConnector)object2).getSourceTopView() != null && ((TVConnector)object2).getTargetTopView() != null) {
                element.setAttribute("vid_source", StringUtilities.encodeAttributeValue(((TVConnector)object2).getSourceTopView().getViewID()));
                element.setAttribute("vid_target", StringUtilities.encodeAttributeValue(((TVConnector)object2).getTargetTopView().getViewID()));
                this.addCollectionOfPoints(element, "points", ((TVConnector)object2).getActualPoints());
            }
        }
    }

    private void appendBounds(Element element, String string, Rectangle rectangle) {
        Element element2 = element.getOwnerDocument().createElement(string);
        element2.setAttribute("x", String.valueOf(rectangle.x));
        element2.setAttribute("y", String.valueOf(rectangle.y));
        element2.setAttribute("width", String.valueOf(rectangle.width));
        element2.setAttribute("height", String.valueOf(rectangle.height));
        element.appendChild(element2);
    }

    private void addCollectionOfPoints(Element element, String string, Collection collection) {
        if (collection.size() > 0) {
            Document document = element.getOwnerDocument();
            Element element2 = document.createElement(string);
            for (Object e : collection) {
                if (!(e instanceof Point2D)) continue;
                Element element3 = document.createElement("point");
                Point2D point2D = (Point2D)e;
                element3.setAttribute("x", String.valueOf((int)point2D.getX()));
                element3.setAttribute("y", String.valueOf((int)point2D.getY()));
                element2.appendChild(element3);
            }
            element.appendChild(element2);
        }
    }

    @Override
    public String transformFromObjectToString(Object object) {
        return this.transformFromObjectToString(object, false);
    }

    public String transformFromObjectToString(Object object, boolean bl) {
        try {
            Document document = this.transformFromObject(object, bl);
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            DOMSource dOMSource = new DOMSource(document);
            StringWriter stringWriter = new StringWriter();
            StreamResult streamResult = new StreamResult(stringWriter);
            transformer.transform(dOMSource, streamResult);
            return stringWriter.getBuffer().toString();
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
        }
        catch (TransformerException transformerException) {
            // empty catch block
        }
        return null;
    }

    public Document transformListOfObject(List list, String string) {
        return this.transformListOfObject(list, string, false);
    }

    public Document transformListOfObject(List list, String string, boolean bl) {
        Document document = null;
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            document = documentBuilder.newDocument();
            Element element = string != null && !"".equals(string) ? document.createElement(string) : document.createElement("objects");
            if (element != null) {
                document.appendChild(element);
                for (Object e : list) {
                    Element element2 = this.transformFromObject(e, null, document, bl);
                    if (element2 == null) continue;
                    element.appendChild(element2);
                }
            }
        }
        catch (ParserConfigurationException parserConfigurationException) {
            // empty catch block
        }
        return document;
    }
}

