/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.metadata;

import java.awt.geom.Point2D;
import java.io.StringWriter;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import oracle.dbtools.crest.model.design.engineering.EngPropertyHolder;
import oracle.dbtools.crest.model.metadata.ClassDescription;
import oracle.dbtools.crest.model.metadata.MDTransformationManager;
import oracle.dbtools.crest.model.metadata.MDTransformer;
import oracle.dbtools.crest.model.metadata.MDXMLConstants;
import oracle.dbtools.crest.model.metadata.XMLTransformationManager;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.util.string.StringUtilities;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class XMLFromMapTransformer
extends MDTransformer
implements MDXMLConstants {
    public static Document transformFromMap(Map map) {
        Document document = null;
        try {
            DocumentBuilderFactory documentBuilderFactory;
            DocumentBuilder documentBuilder;
            Element element;
            XMLFromMapTransformer xMLFromMapTransformer;
            ClassDescription classDescription;
            String string = XMLFromMapTransformer.getObjectClassName(map);
            if (string != null && !"".equals(string) && (classDescription = XMLFromMapTransformer.getClassDecription(map)) != null && (xMLFromMapTransformer = XMLFromMapTransformer.getXMLFromMapTransformer(string)) != null && (element = xMLFromMapTransformer.transformFromMap(map, null, document = (documentBuilder = (documentBuilderFactory = DocumentBuilderFactory.newInstance()).newDocumentBuilder()).newDocument())) != null) {
                document.appendChild(element);
            }
        }
        catch (ParserConfigurationException parserConfigurationException) {
            // empty catch block
        }
        return document;
    }

    public static XMLFromMapTransformer getXMLFromMapTransformer(String string) {
        MDTransformationManager mDTransformationManager = ApplicationView.getInstance().getXMLTransformationManager().getXMLMapTransformationManager();
        XMLFromMapTransformer xMLFromMapTransformer = (XMLFromMapTransformer)mDTransformationManager.getFromObjectTransformerFor(string);
        return xMLFromMapTransformer;
    }

    public Element transformFromMap(Map map, String string, Document document) {
        return this.transformFromMap(map, string, document, false);
    }

    public Element transformFromMap(Map map, String string, Document document, boolean bl) {
        Element element = null;
        try {
            ClassDescription classDescription = XMLFromMapTransformer.getClassDecription(map);
            if (classDescription != null) {
                element = string != null ? document.createElement(string) : document.createElement(classDescription.getXmlName());
                if (!SKP_CLASS_NAME && !bl) {
                    element.setAttribute("class", classDescription.getClassName());
                }
                this.processProperties(map, element, classDescription);
                this.processClassPropertyMap(map, element, classDescription);
                this.processCollections(map, element, classDescription);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return element;
    }

    private void processProperties(Map map, Element element, ClassDescription classDescription) {
        Document document = element.getOwnerDocument();
        for (ClassDescription.PropertyDescription propertyDescription : classDescription.getPropertiesList()) {
            Element element2;
            Object object;
            Object object2;
            Object object3;
            if (propertyDescription.isRectangle) {
                object3 = map.get(propertyDescription.xmlName);
                if (object3 == null || !(object3 instanceof Map)) continue;
                this.appendBounds(element, propertyDescription.xmlName, (Map)object3);
                continue;
            }
            if (propertyDescription.isPropertyMap) {
                this.processPropertyAsPropertyMap(map, element, propertyDescription);
                continue;
            }
            if (propertyDescription.isMap) {
                this.processMapProperty(map, element, propertyDescription);
                continue;
            }
            if (propertyDescription.isSimpleClass() || propertyDescription.isStringClass() || propertyDescription.isReferred()) {
                object3 = (String)map.get(propertyDescription.xmlName);
                if (object3 == null || SKP_DEFAULTS && ((String)object3).equalsIgnoreCase(propertyDescription.defaultValue)) continue;
                object3 = StringUtilities.encodeAttributeValue(object3);
                if (propertyDescription.isAttribute()) {
                    element.setAttribute(propertyDescription.xmlName, (String)object3);
                    continue;
                }
                object2 = document.createElement(propertyDescription.xmlName);
                object = document.createTextNode((String)object3);
                object2.appendChild((Node)object);
                element.appendChild((Node)object2);
                continue;
            }
            object3 = (Map)map.get(propertyDescription.xmlName);
            if (object3 == null || (object = XMLFromMapTransformer.getXMLFromMapTransformer((String)(object2 = XMLFromMapTransformer.getObjectClassName(object3)))) == null || (element2 = ((XMLFromMapTransformer)object).transformFromMap((Map)object3, propertyDescription.xmlName, document)) == null) continue;
            element.appendChild(element2);
        }
    }

    private void processPropertyAsPropertyMap(Map map, Element element, ClassDescription.PropertyDescription propertyDescription) {
        Object v;
        if (propertyDescription.isPropertyMap && (v = map.get(propertyDescription.xmlName)) != null && v instanceof Map) {
            Document document = element.getOwnerDocument();
            Map map2 = (Map)v;
            Iterator iterator = map2.keySet().iterator();
            Element element2 = null;
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                String string2 = (String)map2.get(string);
                if (string2 == null) continue;
                if (element2 == null) {
                    element2 = document.createElement(propertyDescription.xmlName);
                    element.appendChild(element2);
                }
                Element element3 = document.createElement(propertyDescription.pmItemName);
                element3.setAttribute(propertyDescription.pmKeyName, StringUtilities.encodeAttributeValue(string));
                element3.setAttribute(propertyDescription.pmValueName, StringUtilities.encodeAttributeValue(string2));
                element2.appendChild(element3);
            }
        }
    }

    private void processMapProperty(Map map, Element element, ClassDescription.PropertyDescription propertyDescription) {
        Object v;
        if (propertyDescription.isMap && (v = map.get(propertyDescription.xmlName)) != null && v instanceof Map) {
            Document document = element.getOwnerDocument();
            Map map2 = (Map)v;
            Iterator iterator = map2.keySet().iterator();
            Element element2 = null;
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                String string2 = (String)map2.get(string);
                if (string2 == null) continue;
                if (element2 == null) {
                    element2 = document.createElement(propertyDescription.xmlName);
                    element.appendChild(element2);
                }
                Element element3 = document.createElement(propertyDescription.pmItemName);
                element3.setAttribute("key", StringUtilities.encodeAttributeValue(string));
                element3.setAttribute("value", StringUtilities.encodeAttributeValue(string2));
                element2.appendChild(element3);
            }
        }
    }

    private void processClassPropertyMap(Map map, Element element, ClassDescription classDescription) {
        if (classDescription.isPropertyMap) {
            Document document = element.getOwnerDocument();
            Map map2 = (Map)map.get("propertyMap");
            if (map2 != null) {
                Iterator iterator = map2.keySet().iterator();
                Element element2 = null;
                while (iterator.hasNext()) {
                    String string = (String)iterator.next();
                    if (this.skipProperty(string)) continue;
                    String string2 = (String)map2.get(string);
                    if (element2 == null) {
                        element2 = document.createElement("propertyMap");
                        element.appendChild(element2);
                    }
                    Element element3 = document.createElement("property");
                    element3.setAttribute("name", StringUtilities.encodeAttributeValue(string));
                    element3.setAttribute("value", StringUtilities.encodeAttributeValue(string2));
                    element2.appendChild(element3);
                }
            }
        }
    }

    private boolean skipProperty(String string) {
        return false;
    }

    private void processCollections(Map map, Element element, ClassDescription classDescription) {
        for (ClassDescription.CollectionDescription collectionDescription : classDescription.getCollectionsList()) {
            Object v = map.get(collectionDescription.xmlName);
            if (v == null || !(v instanceof Collection) || SKP_DEFAULTS && ((Collection)v).size() <= 0) continue;
            if (collectionDescription.itemIsRef) {
                this.processCollectionWithRefs(map, (Collection)v, element, collectionDescription);
                continue;
            }
            this.processCollectionWithContained((Collection)v, element, collectionDescription);
        }
    }

    private void processCollectionWithRefs(Object object, Collection collection, Element element, ClassDescription.CollectionDescription collectionDescription) {
        Document document = element.getOwnerDocument();
        Element element2 = document.createElement(collectionDescription.xmlName);
        element.appendChild(element2);
        if (!collectionDescription.listOfRefs) {
            for (Object e : collection) {
                if (e != null && e instanceof String) {
                    String string = (String)e;
                    Element element3 = document.createElement(collectionDescription.itemXmlName);
                    Text text = document.createTextNode(string);
                    element3.appendChild(text);
                    element2.appendChild(element3);
                    continue;
                }
                int n = 0;
                ++n;
            }
        } else {
            String string;
            Object object22;
            StringBuffer stringBuffer = new StringBuffer();
            boolean bl = true;
            for (Object object22 : collection) {
                if (object22 == null || !(object22 instanceof String) || (string = (String)object22) == null) continue;
                if (bl) {
                    stringBuffer.append(string);
                    bl = false;
                    continue;
                }
                stringBuffer.append(' ').append(string);
            }
            object22 = collectionDescription.refsXMLName;
            string = stringBuffer.toString();
            element2.setAttribute((String)object22, string);
        }
    }

    private void processCollectionWithContained(Collection collection, Element element, ClassDescription.CollectionDescription collectionDescription) {
        Element element2;
        Object object;
        Object object2;
        Document document = element.getOwnerDocument();
        Element element3 = document.createElement(collectionDescription.xmlName);
        element.appendChild(element3);
        if (collectionDescription.isEngPropertyHolderItem) {
            for (Object e : collection) {
                if (!(e instanceof EngPropertyHolder)) continue;
                EngPropertyHolder engPropertyHolder = (EngPropertyHolder)e;
                object2 = document.createElement(collectionDescription.itemXmlName);
                object2.setAttribute("name", engPropertyHolder.getName());
                object2.setAttribute("selected", String.valueOf(engPropertyHolder.isSelected()));
                element3.appendChild((Node)object2);
            }
        }
        boolean bl = true;
        boolean bl2 = false;
        boolean bl3 = collectionDescription.isMapItem;
        object2 = null;
        String string = collectionDescription.itemClassName;
        if (string != null && !"".equals(string)) {
            element3.setAttribute("class", string);
        }
        XMLFromMapTransformer xMLFromMapTransformer = null;
        if (!bl3) {
            for (Object e : collection) {
                if (!(e instanceof Map)) continue;
                object = null;
                if (string != null && !"".equals(string)) {
                    object = string;
                    ((Map)e).put("class", object);
                    bl2 = true;
                } else {
                    object = XMLFromMapTransformer.getObjectClassName((Map)e);
                }
                if (bl || object2 != null && object != null && !((String)object).equals(object2)) {
                    object2 = object;
                    xMLFromMapTransformer = XMLFromMapTransformer.getXMLFromMapTransformer((String)object2);
                    bl = false;
                }
                element2 = null;
                if (xMLFromMapTransformer != null) {
                    element2 = xMLFromMapTransformer.transformFromMap((Map)e, collectionDescription.itemXmlName, document, bl2);
                }
                if (element2 == null) continue;
                element3.appendChild(element2);
                this.processTopView(element2, (Map)e, collectionDescription);
            }
        }
        if (bl3) {
            for (Object e : collection) {
                if (!(e instanceof Map)) continue;
                bl3 = true;
                object = (Map)e;
                element2 = document.createElement(collectionDescription.itemXmlName);
                for (Map.Entry entry : object.entrySet()) {
                    Object v = entry.getValue();
                    Object k = entry.getKey();
                    if (v == null || k == null || !(v instanceof String) || !(k instanceof String)) continue;
                    element2.setAttribute(StringUtilities.encodeAttributeValue((String)k), StringUtilities.encodeAttributeValue((String)v));
                    element3.appendChild(element2);
                }
            }
        }
    }

    private void processTopView(Element element, Map map, ClassDescription.CollectionDescription collectionDescription) {
        if (collectionDescription.isObjectViewItem || collectionDescription.isTVDiagramItem || collectionDescription.isTVConnectorItem) {
            List list;
            String string = (String)map.get("oid");
            String string2 = (String)map.get("otype");
            String string3 = (String)map.get("vid");
            String string4 = (String)map.get("dpv_id");
            String string5 = (String)map.get("vnum");
            String string6 = (String)map.get("vid_source");
            String string7 = (String)map.get("vid_target");
            boolean bl = false;
            if (string != null && !"".equals(string)) {
                element.setAttribute("oid", StringUtilities.encodeAttributeValue(string));
            }
            if (string2 != null && !"".equals(string2)) {
                element.setAttribute("otype", StringUtilities.encodeAttributeValue(string2));
            }
            if (string3 != null && !"".equals(string3)) {
                element.setAttribute("vid", StringUtilities.encodeAttributeValue(string3));
            }
            if (string4 != null && !"".equals(string4)) {
                element.setAttribute("vid", StringUtilities.encodeAttributeValue(string4));
            }
            if (string5 != null && !"".equals(string5)) {
                element.setAttribute("vnum", StringUtilities.encodeAttributeValue(string5));
            }
            if (string6 != null && !"".equals(string6)) {
                element.setAttribute("vid_source", StringUtilities.encodeAttributeValue(string6));
                bl = true;
            }
            if (string7 != null && !"".equals(string7)) {
                element.setAttribute("vid_target", StringUtilities.encodeAttributeValue(string7));
                bl = true;
            }
            if ((collectionDescription.isTVConnectorItem || bl) && (list = (List)map.get("points")) != null) {
                this.addCollectionOfPoints(element, "points", list);
            }
        }
    }

    private void appendBounds(Element element, String string, Map map) {
        if (map != null) {
            Integer n = (Integer)map.get("x");
            Integer n2 = (Integer)map.get("y");
            Integer n3 = (Integer)map.get("width");
            Integer n4 = (Integer)map.get("height");
            if (n != null) {
                Element element2 = element.getOwnerDocument().createElement(string);
                element2.setAttribute("x", String.valueOf(n));
                element2.setAttribute("y", String.valueOf(n2));
                element2.setAttribute("width", String.valueOf(n3));
                element2.setAttribute("height", String.valueOf(n4));
                element.appendChild(element2);
            }
        }
    }

    private void addCollectionOfPoints(Element element, String string, Collection collection) {
        if (collection.size() > 0) {
            Document document = element.getOwnerDocument();
            Element element2 = document.createElement(string);
            for (Object e : collection) {
                if (!(e instanceof Point2D)) continue;
                Element element3 = document.createElement("point");
                Point2D point2D = (Point2D)e;
                element3.setAttribute("x", String.valueOf((int)point2D.getX()));
                element3.setAttribute("y", String.valueOf((int)point2D.getY()));
                element2.appendChild(element3);
            }
            element.appendChild(element2);
        }
    }

    public static String transformFromObjectToString(Map map) {
        try {
            Document document = XMLFromMapTransformer.transformFromMap(map);
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            DOMSource dOMSource = new DOMSource(document);
            StringWriter stringWriter = new StringWriter();
            StreamResult streamResult = new StreamResult(stringWriter);
            transformer.transform(dOMSource, streamResult);
            return stringWriter.getBuffer().toString();
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
        }
        catch (TransformerException transformerException) {
            // empty catch block
        }
        return null;
    }

    public static String getObjectClassName(Map map) {
        if (map == null) {
            return null;
        }
        return (String)map.get("class");
    }

    public static ClassDescription getClassDecription(Map map) {
        String string = XMLFromMapTransformer.getObjectClassName(map);
        if (string != null && !"".equals(string)) {
            return ApplicationView.getInstance().getXMLTransformationManager().getMetaDataManager().getClassDescription(string);
        }
        return null;
    }

    public Class getObjectClass(Map map) {
        String string = XMLFromMapTransformer.getObjectClassName(map);
        Class<?> clazz = null;
        if (string != null && !"".equals(string)) {
            try {
                clazz = Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return clazz;
    }

    @Override
    public String transformFromObjectToString(Object object) {
        if (object instanceof Map) {
            return XMLFromMapTransformer.transformFromObjectToString((Map)object);
        }
        return null;
    }

    public static void transformMapToXMLFile(Map map, String string, boolean bl) {
        Document document = XMLFromMapTransformer.transformFromMap(map);
        XMLTransformationManager.saveDocument(string, document, bl);
    }
}

