/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.metadata;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.util.Extension;
import oracle.dbtools.crest.util.logging.Logger;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class MetaFileLoader {
    private static final Logger LOGGER = new Logger(MetaFileLoader.class);
    public static DocumentBuilder DOCUMENT_BUILDER = null;

    public static void main(String[] stringArray) {
    }

    public static Document loadFile(String string) {
        Document document = null;
        if (DOCUMENT_BUILDER != null) {
            FileInputStream fileInputStream = null;
            try {
                fileInputStream = new FileInputStream(MetaFileLoader.getFileName(string));
            }
            catch (FileNotFoundException fileNotFoundException) {
                if (ApplicationView.debugMode) {
                    // empty if block
                }
            }
            if (fileInputStream != null) {
                InputStreamReader inputStreamReader = null;
                try {
                    inputStreamReader = new InputStreamReader((InputStream)fileInputStream, "UTF-8");
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    LOGGER.error("MetaFileLoader: InputStreamReader(is, XMLConstants.ENCODING_UTF8)", unsupportedEncodingException);
                }
                if (inputStreamReader != null) {
                    InputSource inputSource = new InputSource(inputStreamReader);
                    try {
                        document = DOCUMENT_BUILDER.parse(inputSource);
                    }
                    catch (SAXException sAXException) {
                        LOGGER.error("MetaFileLoader: DOCUMENT_BUILDER.parse(inputSource)", sAXException);
                    }
                    catch (IOException iOException) {
                        LOGGER.error("MetaFileLoader: InputSource(reader)", iOException);
                    }
                    try {
                        inputStreamReader.close();
                    }
                    catch (IOException iOException) {
                        LOGGER.error("MetaFileLoader: reader.close()", iOException);
                    }
                }
            }
        }
        return document;
    }

    private static String getFileName(String string) {
        int n = string.lastIndexOf(46) + 1;
        String string2 = string.substring(n);
        if ((n = string2.indexOf(36)) > -1) {
            string2 = string2.replace('$', '.');
        }
        String string3 = Extension.getBaseDir();
        File file = new File(string3);
        file = new File(file, "xmlmetadata");
        return new File(file, string2 + ".xml").getAbsolutePath();
    }

    static {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        try {
            DOCUMENT_BUILDER = documentBuilderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            // empty catch block
        }
    }
}

