/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.metadata;

import java.awt.Color;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.dbtools.crest.model.ModelIDObjectSet;
import oracle.dbtools.crest.model.metadata.ClassDescription;
import oracle.dbtools.crest.model.metadata.MDXMLConstants;
import oracle.dbtools.crest.model.metadata.MetaFileLoader;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.util.propertymap.PropertyMap;
import oracle.dbtools.crest.util.propertymap.PropertyMapWrapper;
import oracle.dbtools.crest.util.propertymap.PropertyTranslator;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class MetaDataManager
implements MDXMLConstants {
    HashMap<String, ClassDescription> classesMap = new HashMap();
    public static final String MODEL_ID_OBJECT = "oracle.dbtools.crest.model.ModelObject";
    public static final String TV_DIAGRAM = "oracle.dbtools.crest.swingui.TVDiagramView";
    public static final String RECTANGLE = "java.awt.Rectangle";
    public static final String STRING = "java.lang.String";
    static final String SHORT = "short";
    static final String INT = "int";
    static final String BOOLEAN = "boolean";
    static final String LONG = "long";
    static final String DOUBLE = "double";
    static final String FLOAT = "float";
    private static PropertyTranslator[] sharedTranslators = new PropertyTranslator[]{new PropertyMapWrapper.StringPropertyTranslator(), new PropertyMapWrapper.ShortPropertyTranslator(), new PropertyMapWrapper.IntegerPropertyTranslator(), new PropertyMapWrapper.LongPropertyTranslator(), new PropertyMapWrapper.FloatPropertyTranslator(), new PropertyMapWrapper.DoublePropertyTranslator(), new PropertyMapWrapper.BooleanPropertyTranslator(), new PropertyMapWrapper.ColorPropertyTranslator()};
    private List sortedObjects = new ArrayList();
    private List tracedObjects = new ArrayList();
    boolean cyclicRef = false;
    boolean error = false;
    boolean valid = false;

    public static void main(String[] stringArray) {
        MetaDataManager metaDataManager = new MetaDataManager();
        ClassDescription classDescription2 = metaDataManager.getClassDescription("oracle.dbtools.crest.model.design.relational.Table");
        for (ClassDescription classDescription2 : metaDataManager.classesMap.values()) {
            System.out.println(classDescription2.toString() + "  " + classDescription2.getPropertiesList().size());
            for (ClassDescription.PropertyDescription propertyDescription : classDescription2.getPropertiesList()) {
                System.out.println("-- " + propertyDescription.toString());
            }
        }
    }

    public ClassDescription getClassDescription(String string) {
        ClassDescription classDescription = this.classesMap.get(string);
        if (classDescription == null) {
            return this.addClassDescription(string);
        }
        return classDescription;
    }

    private ClassDescription addClassDescription(String string) {
        Object object;
        ClassDescription classDescription = null;
        Document document = MetaFileLoader.loadFile(string);
        if (document == null) {
            object = null;
            try {
                object = Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            if (object != null && !object.equals(Object.class)) {
                while (document == null && !(object = ((Class)object).getSuperclass()).equals(Object.class)) {
                    document = MetaFileLoader.loadFile(((Class)object).getName());
                }
            }
        }
        if (document != null) {
            Object object2;
            int n;
            Class<?> clazz;
            Method[] methodArray;
            int n2;
            NodeList nodeList;
            block40: {
                Cloneable cloneable;
                Object object3;
                String string2;
                object = document.getDocumentElement();
                String string3 = object.getTagName();
                if (!string3.equalsIgnoreCase(string)) {
                    // empty if block
                }
                if ((string2 = object.getAttribute("parentClass")) != null && !"".equals(string2)) {
                    object3 = null;
                    try {
                        object3 = Class.forName(string);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        // empty catch block
                    }
                    cloneable = this.getClassDescription(string2);
                    if (cloneable != null) {
                        try {
                            classDescription = (ClassDescription)((ClassDescription)cloneable).clone();
                        }
                        catch (CloneNotSupportedException cloneNotSupportedException) {
                            // empty catch block
                        }
                    }
                }
                if ((object3 = object.getAttribute("isPropertyMap")) != null && "true".equals(object3)) {
                    classDescription.isPropertyMap = true;
                }
                cloneable = new ArrayList();
                if (classDescription == null) {
                    classDescription = new ClassDescription();
                }
                classDescription.setClassName(string);
                String string4 = object.getAttribute("xmlName");
                if (string4 != null && !"".equals(string4)) {
                    classDescription.setXmlName(string4);
                }
                String string5 = null;
                String string6 = null;
                String string7 = null;
                String string8 = null;
                nodeList = object.getElementsByTagName("processing");
                n2 = nodeList.getLength();
                if (n2 > 0) {
                    Element element = (Element)nodeList.item(0);
                    string5 = element.getAttribute("beforeTransform");
                    if (string5 != null && !"".equals(string5)) {
                        classDescription.beforeTransformName = string5;
                    }
                    if ((string6 = element.getAttribute("beforeTransformExt")) != null && !"".equals(string6)) {
                        classDescription.beforeTransformExtName = string6;
                    }
                    if ((string7 = element.getAttribute("afterInit")) != null && !"".equals(string7)) {
                        classDescription.afterInitName = string7;
                    }
                    if ((string8 = element.getAttribute("afterInitExt")) != null && !"".equals(string8)) {
                        classDescription.afterInitExtName = string8;
                    }
                    if ((object3 = element.getAttribute("createAllExtItemsFirst")) != null && "true".equals(object3)) {
                        classDescription.isCreateAllExtItemsFirst = true;
                    }
                }
                nodeList = object.getElementsByTagName("property");
                n2 = nodeList.getLength();
                for (int i = 0; i < n2; ++i) {
                    methodArray = (Method[])nodeList.item(i);
                    this.processProperty((Element)methodArray, classDescription, (List<ClassDescription.PropertyDescription>)((Object)cloneable));
                }
                clazz = null;
                try {
                    clazz = Class.forName(string);
                    methodArray = clazz.getMethods();
                    if (cloneable.size() > 0) {
                        this.processMethods(classDescription, (List<ClassDescription.PropertyDescription>)((Object)cloneable), methodArray);
                    }
                    if (string5 != null && !"".equals(string5)) {
                        for (n = 0; n < methodArray.length; ++n) {
                            object2 = methodArray[n];
                            if (!string5.equals(((Method)object2).getName()) || !this.hasNoArgument((Method)object2)) continue;
                            classDescription.beforeTransform = object2;
                            break;
                        }
                    }
                    if (string6 != null && !"".equals(string6)) {
                        for (n = 0; n < methodArray.length; ++n) {
                            object2 = methodArray[n];
                            if (!string6.equals(((Method)object2).getName()) || !this.hasNoArgument((Method)object2)) continue;
                            classDescription.beforeTransformExt = object2;
                            break;
                        }
                    }
                    if (string7 != null && !"".equals(string7)) {
                        for (n = 0; n < methodArray.length; ++n) {
                            object2 = methodArray[n];
                            if (!string7.equals(((Method)object2).getName()) || !this.hasNoArgument((Method)object2)) continue;
                            classDescription.afterInit = object2;
                            break;
                        }
                    }
                    if (string8 == null || "".equals(string8)) break block40;
                    for (n = 0; n < methodArray.length; ++n) {
                        object2 = methodArray[n];
                        if (!string8.equals(((Method)object2).getName()) || !this.hasNoArgument((Method)object2)) continue;
                        classDescription.afterInitExt = object2;
                        break;
                    }
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
            methodArray = new ArrayList();
            nodeList = object.getElementsByTagName("collection");
            n2 = nodeList.getLength();
            for (n = 0; n < n2; ++n) {
                object2 = (Element)nodeList.item(n);
                this.processCollection((Element)object2, classDescription, (List<ClassDescription.CollectionDescription>)methodArray);
            }
            this.processCollectionsOrder((Element)object, classDescription);
            this.orderCollections(classDescription);
            if (methodArray.size() > 0) {
                clazz = null;
                try {
                    clazz = Class.forName(string);
                    Method[] methodArray2 = clazz.getMethods();
                    this.processMethodsForCollections((List<ClassDescription.CollectionDescription>)methodArray, methodArray2);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
            nodeList = object.getElementsByTagName("propertyDependency");
            n2 = nodeList.getLength();
            for (int i = 0; i < n2; ++i) {
                object2 = (Element)nodeList.item(i);
                this.processPropertyDependency((Element)object2, classDescription);
            }
            if (classDescription.propertiesDependency.size() > 0) {
                this.sortObjects(classDescription.getPropertiesList(), classDescription.propertiesDependency);
            }
            classDescription.resetElementsAndCollectionsFlag();
        }
        if (classDescription != null) {
            this.classesMap.put(string, classDescription);
        }
        return classDescription;
    }

    private void processPropertyDependency(Element element, ClassDescription classDescription) {
        String string;
        ClassDescription.PropertyDescription propertyDescription;
        String string2 = element.getAttribute("propDef");
        ClassDescription.PropertyDescription propertyDescription2 = classDescription.getPropertyDescriptionByName(string2);
        if (propertyDescription2 != null && (propertyDescription = classDescription.getPropertyDescriptionByName(string = element.getAttribute("dependOnProperty"))) != null) {
            ObjectDependence objectDependence = this.getObjectDependence(propertyDescription2, classDescription.propertiesDependency);
            if (objectDependence == null) {
                objectDependence = new ObjectDependence(propertyDescription2);
                classDescription.propertiesDependency.add(objectDependence);
            }
            objectDependence.dependOn.add(propertyDescription);
        }
    }

    private void processProperty(Element element, ClassDescription classDescription, List<ClassDescription.PropertyDescription> list) {
        String string;
        String string2;
        int n;
        String string3;
        String string4 = element.getAttribute("name");
        ClassDescription.PropertyDescription propertyDescription = classDescription.getPropertyDescriptionByName(string4);
        if (propertyDescription != null) {
            classDescription.removePropertyDescription(propertyDescription);
        }
        propertyDescription = new ClassDescription.PropertyDescription();
        propertyDescription.name = string4;
        propertyDescription.className = element.getAttribute("dataType");
        Class<?> clazz = null;
        try {
            clazz = Class.forName(propertyDescription.className);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        if (clazz != null && Map.class.isAssignableFrom(clazz)) {
            propertyDescription.isMap = true;
        }
        if (RECTANGLE.equals(propertyDescription.className)) {
            propertyDescription.isRectangle = true;
        }
        if (!STRING.equals(propertyDescription.className)) {
            propertyDescription.stringClass = false;
        }
        if ((string3 = element.getAttribute("isPropertyMap")) != null && "true".equals(string3)) {
            propertyDescription.isPropertyMap = true;
        }
        if ((string3 = element.getAttribute("colorProperty")) != null && "true".equals(string3)) {
            propertyDescription.isColorProperty = true;
        }
        if ((string3 = element.getAttribute("processing")) != null && "afterColletions".equals(string3)) {
            propertyDescription.isAfterCollectionProcessing = true;
        }
        if ((string3 = element.getAttribute("external")) != null && "true".equals(string3)) {
            propertyDescription.isExternalProperty = true;
        }
        if ((string3 = element.getAttribute("loggingProp")) != null && "true".equals(string3)) {
            propertyDescription.isLoggingProp = true;
        }
        if ((string3 = element.getAttribute("createdTimeProp")) != null && "true".equals(string3)) {
            propertyDescription.isCreatedTimeProp = true;
        }
        if ((string3 = element.getAttribute("mergeCompare")) != null && "true".equals(string3)) {
            propertyDescription.isMergeCompare = true;
        }
        if ((string3 = element.getAttribute("listOfRefs")) != null && "true".equals(string3)) {
            propertyDescription.isListOfRefs = true;
        }
        if ((string3 = element.getAttribute("itemXmlName")) != null && !"".equals(string3)) {
            propertyDescription.pmItemName = string3;
        }
        if ((string3 = element.getAttribute("keyXmlName")) != null && !"".equals(string3)) {
            propertyDescription.pmKeyName = string3;
        }
        if ((string3 = element.getAttribute("valueXmlName")) != null && !"".equals(string3)) {
            propertyDescription.pmValueName = string3;
        }
        if ((string3 = element.getAttribute("createItem")) != null && !"".equals(string3)) {
            propertyDescription.createPropertyName = string3;
        }
        if ((string3 = element.getAttribute("removeItem")) != null && !"".equals(string3)) {
            propertyDescription.removePropertyName = string3;
        }
        if ((string3 = element.getAttribute("createPMap")) != null && !"".equals(string3)) {
            propertyDescription.createPMapName = string3;
        }
        if ((string3 = element.getAttribute("beforeCollection")) != null && !"".equals(string3)) {
            propertyDescription.beforeCollection = string3;
        }
        if ((string3 = element.getAttribute("afterCollection")) != null && !"".equals(string3)) {
            propertyDescription.afterCollection = string3;
        }
        if ((n = propertyDescription.className.lastIndexOf(32)) > -1) {
            propertyDescription.className = propertyDescription.className.substring(n + 1);
        }
        propertyDescription.xmlName = element.getAttribute("xmlName");
        if ("id".equalsIgnoreCase(propertyDescription.xmlName)) {
            propertyDescription.isID = true;
        }
        propertyDescription.oldXmlName = element.getAttribute("oldXmlName");
        if ("".equals(propertyDescription.oldXmlName)) {
            propertyDescription.oldXmlName = null;
        }
        propertyDescription.presentationName = (string3 = element.getAttribute("presentationName")) != null && !"".equals(string3) ? string3 : propertyDescription.xmlName;
        String string5 = element.getAttribute("xmlType");
        if (!string5.equals("element")) {
            propertyDescription.propType = 1;
        }
        if ("true".equals(string2 = element.getAttribute("reffered"))) {
            propertyDescription.referred = true;
        }
        propertyDescription.getterName = element.getAttribute("getter");
        propertyDescription.setterName = element.getAttribute("setter");
        String string6 = element.getAttribute("defaultValue");
        if (string6 != null) {
            propertyDescription.defaultValue = string6;
        }
        if ((string = element.getAttribute("ddlRelated")) != null && "true".equals(string)) {
            propertyDescription.ddlRelated = true;
        }
        this.processCodedEnum(element, propertyDescription);
        classDescription.getPropertiesList().add(propertyDescription);
        list.add(propertyDescription);
    }

    private void checkpropertyClass(ClassDescription classDescription, ClassDescription.PropertyDescription propertyDescription) {
        if (propertyDescription.className.indexOf("java.util.List") > -1 || propertyDescription.className.indexOf("java.util.Collection") > -1) {
            System.out.println(classDescription.getClassName() + " ||  pname=" + propertyDescription.name + "  --  " + propertyDescription.className);
        }
        if (propertyDescription.isContainedClass()) {
            if (propertyDescription.isPropertyMap) {
                if (propertyDescription.createPMapName != null && propertyDescription.removePropertyName == null || propertyDescription.createPMapName == null) {
                    System.out.println("no removeProperty for PropMap -- " + classDescription.getClassName() + " ||  pname=" + propertyDescription.name + "  --  " + propertyDescription.className);
                } else if (propertyDescription.createPMapName != null && propertyDescription.removePropertyName != null) {
                    // empty if block
                }
            } else if (propertyDescription.createPropertyName != null && propertyDescription.removePropertyName == null || propertyDescription.createPropertyName == null) {
                if (!propertyDescription.className.equals(RECTANGLE)) {
                    System.out.println("no removeProperty -- " + classDescription.getClassName() + " ||  pname=" + propertyDescription.name + "  --  " + propertyDescription.className);
                }
            } else if (propertyDescription.createPropertyName == null || propertyDescription.removePropertyName != null) {
                // empty if block
            }
        }
    }

    private void processCodedEnum(Element element, ClassDescription.PropertyDescription propertyDescription) {
        NodeList nodeList = element.getElementsByTagName("codedEnum");
        int n = nodeList.getLength();
        n = Math.min(1, n);
        for (int i = 0; i < n; ++i) {
            Element element2 = (Element)nodeList.item(i);
            NodeList nodeList2 = element2.getElementsByTagName("item");
            int n2 = nodeList2.getLength();
            for (int j = 0; j < n2; ++j) {
                Element element3 = (Element)nodeList2.item(j);
                String string = element3.getAttribute("code");
                if (string == null || "".equals(string)) continue;
                String string2 = element3.getAttribute("value");
                propertyDescription.getCoddedEnumMap().put(string, string2);
            }
        }
    }

    private void processMethods(ClassDescription classDescription, List<ClassDescription.PropertyDescription> list, Method[] methodArray) {
        Class<?> clazz = null;
        try {
            clazz = Class.forName(MODEL_ID_OBJECT);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        for (ClassDescription.PropertyDescription propertyDescription : list) {
            Class<?> clazz2;
            Object object;
            String string = propertyDescription.createPMapName;
            if (propertyDescription.isPropertyMap) {
                for (int i = 0; i < methodArray.length; ++i) {
                    object = methodArray[i];
                    if (!string.equals(((Method)object).getName()) || !this.hasNoArgument((Method)object) || !PropertyMap.class.isAssignableFrom(clazz2 = ((Method)object).getReturnType())) continue;
                    propertyDescription.createPMap = object;
                    break;
                }
            }
            if (propertyDescription.isMap) {
                // empty if block
            }
            String string2 = propertyDescription.setterName;
            object = propertyDescription.getterName;
            clazz2 = this.getClass(propertyDescription.className);
            Method method = null;
            Method method2 = null;
            if (!(clazz2 == null || object == null || string2 == null && propertyDescription.isReferred())) {
                Class<?> clazz3;
                Method method3;
                int n;
                for (n = 0; n < methodArray.length; ++n) {
                    method3 = methodArray[n];
                    if (!((String)object).equals(method3.getName()) || !this.hasNoArgument(method3) || !(clazz3 = method3.getReturnType()).equals(clazz2)) continue;
                    method = method3;
                    break;
                }
                if (!propertyDescription.isReferred() && propertyDescription.createPropertyName != null && !"".equals(propertyDescription.createPropertyName)) {
                    for (n = 0; n < methodArray.length; ++n) {
                        method3 = methodArray[n];
                        if (!propertyDescription.createPropertyName.equals(method3.getName()) || !this.hasNoArgument(method3) || !clazz2.isAssignableFrom(clazz3 = method3.getReturnType())) continue;
                        propertyDescription.createProperty = method3;
                        propertyDescription.stringClass = false;
                        propertyDescription.getter = method;
                        break;
                    }
                }
                if (!propertyDescription.isReferred() && propertyDescription.removePropertyName != null && !"".equals(propertyDescription.removePropertyName)) {
                    for (n = 0; n < methodArray.length; ++n) {
                        method3 = methodArray[n];
                        if (!propertyDescription.removePropertyName.equals(method3.getName()) || !this.hasNoArgument(method3) || !clazz2.isAssignableFrom(clazz3 = method3.getReturnType())) continue;
                        propertyDescription.removeProperty = method3;
                        propertyDescription.stringClass = false;
                        propertyDescription.getter = method;
                        break;
                    }
                }
                if (propertyDescription.isPropertyMap || propertyDescription.isMap) {
                    propertyDescription.getter = method;
                }
                if (method != null) {
                    for (n = 0; n < methodArray.length; ++n) {
                        method3 = methodArray[n];
                        if (!string2.equals(method3.getName()) || !this.hasSingleArgument(method3) || !this.hasVoidOrBooleanReturn(method3) || !(clazz3 = method3.getParameterTypes()[0]).equals(clazz2)) continue;
                        method2 = method3;
                        break;
                    }
                } else {
                    n = 0;
                    ++n;
                }
                if (method != null && method2 != null) {
                    propertyDescription.setter = method2;
                    propertyDescription.getter = method;
                    propertyDescription.simpleClass = this.isSimpleClas(clazz2);
                    propertyDescription.stringClass = this.isStringClas(clazz2);
                    PropertyTranslator propertyTranslator = this.getPropertyTranslatorFor(clazz2);
                    if (propertyTranslator == null) {
                        if (clazz != null && clazz.isAssignableFrom(clazz2)) {
                            propertyDescription.idObjecttranslator = true;
                        }
                    } else {
                        propertyDescription.propertyTranslator = propertyTranslator;
                    }
                } else {
                    n = 0;
                    ++n;
                }
            } else {
                int n = 0;
                ++n;
            }
            if (!ApplicationView.debugMode) continue;
            this.checkpropertyClass(classDescription, propertyDescription);
        }
    }

    private void processCollection(Element element, ClassDescription classDescription, List<ClassDescription.CollectionDescription> list) {
        String string = element.getAttribute("name");
        ClassDescription.CollectionDescription collectionDescription = classDescription.getCollectionDescriptionByName(string);
        if (collectionDescription != null) {
            classDescription.removeCollectionDescription(collectionDescription);
        }
        collectionDescription = new ClassDescription.CollectionDescription();
        collectionDescription.name = string;
        collectionDescription.className = element.getAttribute("dataType");
        int n = collectionDescription.className.lastIndexOf(32);
        if (n > -1) {
            collectionDescription.className = collectionDescription.className.substring(n + 1);
        }
        collectionDescription.xmlName = element.getAttribute("xmlName");
        collectionDescription.itemXmlName = element.getAttribute("itemXmlName");
        collectionDescription.itemClassName = element.getAttribute("itemClass");
        String string2 = element.getAttribute("xmlType");
        String string3 = element.getAttribute("reffered");
        String string4 = element.getAttribute("external");
        if (string4 != null && "true".equals(string4)) {
            collectionDescription.isExternalCollection = true;
        }
        if ((string4 = element.getAttribute("itemIsRef")) != null && "true".equals(string4)) {
            collectionDescription.itemIsRef = true;
        }
        if ((string4 = element.getAttribute("createAllItemsFirst")) != null && "true".equals(string4)) {
            collectionDescription.createAllItemsFirst = true;
        }
        if ((string4 = element.getAttribute("objectViewItem")) != null && "true".equals(string4)) {
            collectionDescription.isObjectViewItem = true;
        }
        if ((string4 = element.getAttribute("physicalModelItem")) != null && "true".equals(string4)) {
            collectionDescription.isPhysicalModelItem = true;
        }
        if ((string4 = element.getAttribute("diagramViewItem")) != null && "true".equals(string4)) {
            collectionDescription.isTVDiagramItem = true;
        }
        if ((string4 = element.getAttribute("orderImportant")) != null && "false".equals(string4)) {
            collectionDescription.isOrderImportant = false;
        }
        if ((string4 = element.getAttribute("tvConnectorItem")) != null && "true".equals(string4)) {
            collectionDescription.isTVConnectorItem = true;
        }
        if ((string4 = element.getAttribute("proxyItem")) != null && "true".equals(string4)) {
            collectionDescription.isProxyitem = true;
        }
        if ((string4 = element.getAttribute("listOfRefs")) != null && "true".equals(string4)) {
            collectionDescription.listOfRefs = true;
        }
        if ((string4 = element.getAttribute("nativeList")) != null && "true".equals(string4)) {
            collectionDescription.nativeList = true;
        }
        if ((string4 = element.getAttribute("orderTheList")) != null && "true".equals(string4)) {
            collectionDescription.orderTheList = true;
        }
        if ((string4 = element.getAttribute("refsXMLName")) != null && !"".equals(string4)) {
            collectionDescription.refsXMLName = string4;
        }
        collectionDescription.getterName = element.getAttribute("getter");
        collectionDescription.setterName = element.getAttribute("setter");
        String string5 = element.getAttribute("isMapItem");
        if (string5 != null && "true".equalsIgnoreCase(string5)) {
            collectionDescription.isMapItem = true;
        }
        if ((string5 = element.getAttribute("isEngPropertyHolderItem")) != null && "true".equalsIgnoreCase(string5)) {
            collectionDescription.isEngPropertyHolderItem = true;
        }
        collectionDescription.createItemName = element.getAttribute("createItem");
        collectionDescription.addItemName = element.getAttribute("addItem");
        collectionDescription.removeItemName = element.getAttribute("removeItem");
        collectionDescription.applyListName = element.getAttribute("applyList");
        collectionDescription.getItemByIDName = element.getAttribute("getItemByID");
        collectionDescription.moveMethodName = element.getAttribute("moveMethod");
        collectionDescription.preProcessName = element.getAttribute("preProcessMethod");
        classDescription.getCollectionsList().add(collectionDescription);
        list.add(collectionDescription);
    }

    private void processMethodsForCollections(List<ClassDescription.CollectionDescription> list, Method[] methodArray) {
        Class<?> clazz = null;
        try {
            clazz = Class.forName(MODEL_ID_OBJECT);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        block2: for (ClassDescription.CollectionDescription collectionDescription : list) {
            Method method;
            int n;
            String string = collectionDescription.setterName;
            String string2 = collectionDescription.getterName;
            Class clazz2 = this.getClass(collectionDescription.className);
            if (ModelIDObjectSet.class.isAssignableFrom(clazz2)) {
                collectionDescription.isIDObjectSet = true;
            }
            Method method2 = null;
            Object var10_11 = null;
            if (clazz2 != null && string2 != null) {
                Class<?> clazz3;
                for (n = 0; n < methodArray.length; ++n) {
                    method = methodArray[n];
                    if (!string2.equals(method.getName()) || !this.hasNoArgument(method) || !(clazz3 = method.getReturnType()).equals(clazz2)) continue;
                    method2 = method;
                    break;
                }
                if (method2 == null) {
                    for (n = 0; n < methodArray.length; ++n) {
                        method = methodArray[n];
                        if (!string2.equals(method.getName()) || !this.hasNoArgument(method) || !(clazz3 = method.getReturnType()).isAssignableFrom(clazz2)) continue;
                        method2 = method;
                        break;
                    }
                }
                collectionDescription.getter = method2;
            } else {
                n = 0;
                ++n;
            }
            if (collectionDescription.createItemName != null && !"".equals(collectionDescription.createItemName)) {
                for (n = 0; n < methodArray.length; ++n) {
                    method = methodArray[n];
                    if (!collectionDescription.createItemName.equals(method.getName()) || !this.hasNoArgument(method) || this.hasVoidReturn(method)) continue;
                    collectionDescription.createItem = method;
                    break;
                }
            }
            if (collectionDescription.removeItemName != null && !"".equals(collectionDescription.removeItemName)) {
                for (n = 0; n < methodArray.length; ++n) {
                    method = methodArray[n];
                    if (!collectionDescription.removeItemName.equals(method.getName()) || !this.hasSingleArgument(method)) continue;
                    collectionDescription.removeItem = method;
                    break;
                }
            }
            if (collectionDescription.addItemName != null && !"".equals(collectionDescription.addItemName)) {
                for (n = 0; n < methodArray.length; ++n) {
                    method = methodArray[n];
                    if (!collectionDescription.addItemName.equals(method.getName()) || !this.hasSingleArgument(method)) continue;
                    collectionDescription.addItem = method;
                    break;
                }
            }
            if (collectionDescription.applyListName != null && !"".equals(collectionDescription.applyListName)) {
                for (n = 0; n < methodArray.length; ++n) {
                    method = methodArray[n];
                    if (!collectionDescription.applyListName.equals(method.getName()) || !this.hasSingleArgument(method) || !this.hasVoidReturn(method)) continue;
                    collectionDescription.applyList = method;
                    break;
                }
            }
            if (collectionDescription.getItemByIDName != null && !"".equals(collectionDescription.getItemByIDName)) {
                for (n = 0; n < methodArray.length; ++n) {
                    method = methodArray[n];
                    if (!collectionDescription.getItemByIDName.equals(method.getName()) || !this.hasSingleArgument(method)) continue;
                    collectionDescription.getItemByID = method;
                    break;
                }
            }
            if (collectionDescription.moveMethodName != null && !"".equals(collectionDescription.moveMethodName)) {
                for (n = 0; n < methodArray.length; ++n) {
                    method = methodArray[n];
                    if (!collectionDescription.moveMethodName.equals(method.getName()) || !this.hasTwoArguments(method)) continue;
                    collectionDescription.moveMethod = method;
                    break;
                }
            }
            if (collectionDescription.preProcessName == null || "".equals(collectionDescription.preProcessName)) continue;
            for (n = 0; n < methodArray.length; ++n) {
                method = methodArray[n];
                if (!collectionDescription.preProcessName.equals(method.getName()) || !this.hasNoArgument(method)) continue;
                collectionDescription.preProcess = method;
                continue block2;
            }
        }
    }

    private boolean hasSingleArgument(Method method) {
        return method.getParameterTypes().length == 1;
    }

    private boolean hasTwoArguments(Method method) {
        return method.getParameterTypes().length == 2;
    }

    private boolean hasVoidOrBooleanReturn(Method method) {
        return Void.TYPE.equals(method.getReturnType()) || Boolean.TYPE.equals(method.getReturnType());
    }

    private boolean hasVoidReturn(Method method) {
        return Void.TYPE.equals(method.getReturnType());
    }

    private boolean hasNoArgument(Method method) {
        return method.getParameterTypes().length == 0;
    }

    private PropertyTranslator getPropertyTranslatorFor(Class clazz) {
        for (int i = 0; i < sharedTranslators.length; ++i) {
            if (!sharedTranslators[i].canHandleClass(clazz)) continue;
            return sharedTranslators[i];
        }
        return null;
    }

    private Class getClass(String string) {
        if (SHORT.equals(string)) {
            return Short.TYPE;
        }
        if (INT.equals(string)) {
            return Integer.TYPE;
        }
        if (BOOLEAN.equals(string)) {
            return Boolean.TYPE;
        }
        if (DOUBLE.equals(string)) {
            return Double.TYPE;
        }
        if (FLOAT.equals(string)) {
            return Float.TYPE;
        }
        if (LONG.equals(string)) {
            return Long.TYPE;
        }
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    private boolean isSimpleClas(Class clazz) {
        return clazz.equals(Integer.TYPE) || clazz.equals(Integer.class) || clazz.equals(Short.TYPE) || clazz.equals(Short.class) || clazz.equals(Double.TYPE) || clazz.equals(Double.class) || clazz.equals(Float.TYPE) || clazz.equals(Float.class) || clazz.equals(Long.TYPE) || clazz.equals(Long.class) || clazz.equals(Boolean.TYPE) || clazz.equals(Boolean.class) || clazz.equals(Color.class);
    }

    private boolean isStringClas(Class clazz) {
        return clazz.equals(String.class);
    }

    private void sortObjects(List list, List list2) {
        this.sortedObjects.clear();
        this.tracedObjects.clear();
        this.cyclicRef = false;
        ArrayList arrayList = new ArrayList();
        for (Object e : list) {
            ObjectDependence objectDependence = this.getObjectDependence(e, list2);
            if (objectDependence == null || objectDependence.dependOn.size() == 0) {
                this.sortedObjects.add(e);
                this.tracedObjects.add(e);
                continue;
            }
            arrayList.add(e);
        }
        for (Object e : arrayList) {
            this.addToSorted(e, list2);
            if (!this.cyclicRef) continue;
            return;
        }
        if (this.sortedObjects.size() == list.size()) {
            list.clear();
            list.addAll(this.sortedObjects);
        } else {
            int n = 0;
            ++n;
        }
    }

    private void addToSorted(Object object, List list) {
        if (this.sortedObjects.contains(object)) {
            return;
        }
        ObjectDependence objectDependence = this.getObjectDependence(object, list);
        if (objectDependence == null) {
            this.sortedObjects.add(object);
            this.tracedObjects.add(object);
            return;
        }
        if (objectDependence.dependOn.size() == 0) {
            this.sortedObjects.add(object);
            this.tracedObjects.add(object);
            return;
        }
        this.tracedObjects.add(object);
        for (Object e : objectDependence.dependOn) {
            if (this.tracedObjects.contains(e) && !this.sortedObjects.contains(e)) {
                this.cyclicRef = true;
                this.error = true;
                this.valid = false;
                return;
            }
            if (this.sortedObjects.contains(e)) continue;
            this.addToSorted(e, list);
            if (!this.cyclicRef) continue;
            return;
        }
        this.sortedObjects.add(object);
    }

    private ObjectDependence getObjectDependence(Object object, List list) {
        for (ObjectDependence objectDependence : list) {
            if (objectDependence.object != object) continue;
            return objectDependence;
        }
        return null;
    }

    private void processCollectionsOrder(Element element, ClassDescription classDescription) {
        NodeList nodeList = element.getElementsByTagName("collectionOrder");
        int n = nodeList.getLength();
        if (n > 0) {
            for (int i = 0; i < n; ++i) {
                NodeList nodeList2;
                int n2;
                Element element2 = (Element)nodeList.item(i);
                String string = element2.getAttribute("context");
                if (!classDescription.getContexts().contains(string)) {
                    classDescription.getContexts().add(string);
                }
                if ((n2 = (nodeList2 = element2.getElementsByTagName("collectionOrd")).getLength()) > 0) {
                    ArrayList<String> arrayList = new ArrayList<String>();
                    for (int j = 0; j < n2; ++j) {
                        Element element3 = (Element)nodeList2.item(j);
                        String string2 = element3.getAttribute("name");
                        if (string2 == null || "".equals(string2)) continue;
                        arrayList.add(string2);
                    }
                    if (arrayList.size() > 0) {
                        classDescription.getContextMap().put(string + "collectionOrderNames", arrayList);
                        continue;
                    }
                    classDescription.getContextMap().remove(string + "collectionOrderNames");
                    continue;
                }
                classDescription.getContextMap().remove(string + "collectionOrderNames");
            }
        }
    }

    private void orderCollections(ClassDescription classDescription) {
        for (String string : classDescription.getContexts()) {
            List list = (List)classDescription.getContextMap().get(string + "collectionOrderNames");
            ArrayList<ClassDescription.CollectionDescription> arrayList = new ArrayList<ClassDescription.CollectionDescription>();
            if (list != null) {
                for (String string2 : list) {
                    ClassDescription.CollectionDescription collectionDescription = classDescription.getCollectionDescriptionByName(string2);
                    if (collectionDescription == null) continue;
                    arrayList.add(collectionDescription);
                }
            }
            for (ClassDescription.CollectionDescription collectionDescription : classDescription.getCollectionsList()) {
                if (arrayList.contains(collectionDescription)) continue;
                arrayList.add(collectionDescription);
            }
            classDescription.getContextMap().put(string + "collectionOrder", arrayList);
        }
    }

    class ObjectDependence {
        Object object;
        List dependOn = new ArrayList();

        ObjectDependence(Object object) {
            this.object = object;
        }
    }
}

