/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.metadata;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import oracle.dbtools.crest.model.ElementSet;
import oracle.dbtools.crest.model.ModelIDObjectSet;
import oracle.dbtools.crest.model.metadata.ClassDescription;
import oracle.dbtools.crest.model.metadata.ID_ObjectPropertyTranslator;
import oracle.dbtools.crest.model.metadata.MDTransformationManager;
import oracle.dbtools.crest.model.metadata.MetaDataManager;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.dbtools.crest.util.propertymap.PropertyMap;
import oracle.dbtools.crest.util.propertymap.PropertyMapWrapper;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public abstract class MDTransformer {
    protected ClassDescription classDescription;
    protected Class objectClass;
    protected MetaDataManager metaDataManager;
    protected MDTransformationManager transformationManager;
    public static boolean includeID = true;
    public static boolean includeLoggingProps = true;
    public static boolean SKP_DEFAULTS = true;
    public static boolean SKP_CLASS_NAME = false;
    private static final Logger LOGGER = new Logger(PropertyMapWrapper.class);

    public static void main(String[] stringArray) {
    }

    void init(Class clazz, ClassDescription classDescription, MetaDataManager metaDataManager, MDTransformationManager mDTransformationManager) {
        this.classDescription = classDescription;
        this.objectClass = clazz;
        this.metaDataManager = metaDataManager;
        this.transformationManager = mDTransformationManager;
    }

    public void setProperty(Object object, String string, ClassDescription.PropertyDescription propertyDescription) {
        Method method = propertyDescription.setter;
        if (method != null) {
            try {
                Object object2 = null;
                if (propertyDescription.propertyTranslator != null) {
                    object2 = propertyDescription.propertyTranslator.translateFromString(string);
                } else if (object instanceof ID_ObjectPropertyTranslator) {
                    object2 = ((ID_ObjectPropertyTranslator)object).translateIdToObject(propertyDescription.name, string);
                }
                method.invoke(object, object2);
            }
            catch (IllegalAccessException illegalAccessException) {
                LOGGER.error("No access rights for getter method", illegalAccessException);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                LOGGER.error("Illegal argument for getter", illegalArgumentException);
            }
            catch (InvocationTargetException invocationTargetException) {
                LOGGER.error("Invocation error for getter", invocationTargetException);
            }
        } else if (object instanceof PropertyMap) {
            ((PropertyMap)object).setProperty(propertyDescription.name, string);
        }
    }

    public String getProperty(Object object, ClassDescription.PropertyDescription propertyDescription) {
        Method method = propertyDescription.getter;
        if (method != null) {
            try {
                Object object2 = method.invoke(object, new Object[0]);
                if (propertyDescription.propertyTranslator != null) {
                    return propertyDescription.propertyTranslator.translateToString(object2);
                }
                if (object instanceof ID_ObjectPropertyTranslator) {
                    String string = ((ID_ObjectPropertyTranslator)object).translateObjectToID(propertyDescription.name, object2);
                    return string;
                }
            }
            catch (IllegalAccessException illegalAccessException) {
                LOGGER.error("No access rights for getter method", illegalAccessException);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                LOGGER.error("Illegal argument for getter", illegalArgumentException);
            }
            catch (InvocationTargetException invocationTargetException) {
                LOGGER.error("Invocation error for getter", invocationTargetException);
            }
            catch (Exception exception) {}
        } else if (object instanceof PropertyMap) {
            return ((PropertyMap)object).getProperty(propertyDescription.name);
        }
        return null;
    }

    public static Object getObjectForProperty(Object object, ClassDescription.PropertyDescription propertyDescription) {
        Method method = propertyDescription.getter;
        if (method != null) {
            try {
                Object object2 = method.invoke(object, new Object[0]);
                return object2;
            }
            catch (IllegalAccessException illegalAccessException) {
                LOGGER.error("No access rights for getter method", illegalAccessException);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                LOGGER.error("Illegal argument for getter", illegalArgumentException);
            }
            catch (InvocationTargetException invocationTargetException) {
                LOGGER.error("Invocation error for getter", invocationTargetException);
            }
        }
        return null;
    }

    public void setObjectForProperty(Object object, ClassDescription.PropertyDescription propertyDescription, Object object2) {
        Method method = propertyDescription.setter;
        if (method != null) {
            try {
                method.invoke(object, object2);
            }
            catch (IllegalAccessException illegalAccessException) {
                LOGGER.error("No access rights for getter method", illegalAccessException);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                LOGGER.error("Illegal argument for getter", illegalArgumentException);
            }
            catch (InvocationTargetException invocationTargetException) {
                LOGGER.error("Invocation error for getter", invocationTargetException);
            }
        }
    }

    public static Object getCollection(Object object, ClassDescription.CollectionDescription collectionDescription) {
        Method method = collectionDescription.getter;
        if (method != null) {
            try {
                Object object2 = method.invoke(object, new Object[0]);
                return object2;
            }
            catch (IllegalAccessException illegalAccessException) {
                LOGGER.error("No access rights for getter method", illegalAccessException);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                LOGGER.error("Illegal argument for getter", illegalArgumentException);
            }
            catch (InvocationTargetException invocationTargetException) {
                LOGGER.error("Invocation error for getter", invocationTargetException);
            }
        }
        return null;
    }

    Object createObject(Object object, Method method) {
        if (object != null && method != null) {
            try {
                return method.invoke(object, (Object[])null);
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
        }
        return null;
    }

    Object createItem(Object object, Method method) {
        if (object != null && method != null) {
            try {
                return method.invoke(object, (Object[])null);
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
        }
        return null;
    }

    void applyList(Object object, Method method, List list) {
        if (object != null && method != null) {
            try {
                method.invoke(object, list);
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
        }
    }

    void moveContained(Object object, Method method, Object object2, Integer n) {
        if (object != null && method != null && object2 != null) {
            try {
                method.invoke(object, object2, n);
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
        }
    }

    Object getItemByID(Object object, Method method, String string) {
        if (object != null && method != null) {
            try {
                return method.invoke(object, string);
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
        }
        return null;
    }

    void removeItem(Object object, Method method, Object object2) {
        if (object != null && method != null) {
            try {
                method.invoke(object, object2);
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
        }
    }

    void addItem(Object object, Method method, Object object2) {
        if (object != null && method != null) {
            try {
                method.invoke(object, object2);
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
        }
    }

    void removeProperty(Object object, Method method) {
        if (object != null && method != null) {
            try {
                method.invoke(object, (Object[])null);
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
        }
    }

    public ClassDescription getClassDescription() {
        return this.classDescription;
    }

    public Class getObjectClass() {
        return this.objectClass;
    }

    public MetaDataManager getMetaDataManager() {
        return this.metaDataManager;
    }

    public MDTransformationManager getTransformationManager() {
        return this.transformationManager;
    }

    public abstract String transformFromObjectToString(Object var1);

    public void setDefaultProperty(Object object, ClassDescription.PropertyDescription propertyDescription) {
        if (propertyDescription.isContainedClass()) {
            this.removeProperty(object, propertyDescription.removeProperty);
        } else if (propertyDescription.isPropertyMap) {
            if (object instanceof PropertyMap) {
                PropertyMap propertyMap = (PropertyMap)object;
                propertyMap.clearProperties();
            } else {
                this.removeProperty(object, propertyDescription.removeProperty);
            }
        } else if (propertyDescription.isMap) {
            if (object instanceof Map) {
                Map map = (Map)object;
                map.clear();
            } else {
                this.removeProperty(object, propertyDescription.removeProperty);
            }
        } else if (!"".equals(propertyDescription.defaultValue)) {
            this.setProperty(object, propertyDescription.defaultValue, propertyDescription);
        } else if (propertyDescription.isStringClass()) {
            String string = null;
            try {
                string = this.getProperty(object, propertyDescription);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (string != null && !"".equals(string)) {
                this.setProperty(object, "", propertyDescription);
            }
        }
    }

    public Collection getObjectList(Object object, ClassDescription.CollectionDescription collectionDescription) {
        if (object instanceof Collection) {
            return (Collection)object;
        }
        if (object instanceof ElementSet) {
            ArrayList arrayList = new ArrayList();
            ((ElementSet)object).addAllElementsTo(arrayList);
            if (collectionDescription.isProxyitem) {
                Collections.sort(arrayList, ModelIDObjectSet.OBJECT_ID_COMPARATOR);
            }
            return arrayList;
        }
        return null;
    }

    public void invokeMethod(Object object, Method method) {
        if (method != null) {
            try {
                method.invoke(object, new Object[0]);
            }
            catch (IllegalAccessException illegalAccessException) {
                LOGGER.error("No access rights for getter method", illegalAccessException);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                LOGGER.error("Illegal argument for getter", illegalArgumentException);
            }
            catch (InvocationTargetException invocationTargetException) {
                LOGGER.error("Invocation error for getter", invocationTargetException);
            }
        }
    }

    public boolean canProcessCollectionItem(ClassDescription.CollectionDescription collectionDescription) {
        return (collectionDescription.createItem != null || collectionDescription.itemIsRef || collectionDescription.isProxyitem || collectionDescription.isObjectViewItem || collectionDescription.isTVDiagramItem || collectionDescription.isTVConnectorItem || collectionDescription.isPhysicalModelItem) && !collectionDescription.isMapItem;
    }

    public static Iterator getObjectsIterator(Object object, ClassDescription.CollectionDescription collectionDescription) {
        Object object2 = MDTransformer.getCollection(object, collectionDescription);
        if (object2 instanceof Collection) {
            return ((Collection)object2).iterator();
        }
        if (object2 instanceof ModelIDObjectSet) {
            return ((ModelIDObjectSet)object2).iterator();
        }
        return Collections.EMPTY_LIST.iterator();
    }

    protected Element getFirstElementByTagName(String string, Element element) {
        NodeList nodeList = element.getElementsByTagName(string);
        if (nodeList.getLength() > 0) {
            Element element2 = (Element)nodeList.item(0);
            return element2;
        }
        return null;
    }
}

