/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.designrules.storage.udb;

import java.text.MessageFormat;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.udb.TableSpaceUDB;
import oracle.dbtools.crest.model.designrules.CheckResult;
import oracle.dbtools.crest.model.designrules.storage.AbstractDRStorageDesign;

public class DRTableSpaceContainer
extends AbstractDRStorageDesign {
    private final String RULE_ID = "B45A54DF-80CB-F4C8-8869-57A3687111B0";

    public DRTableSpaceContainer(StorageDesign storageDesign) {
        super(storageDesign);
        this.setName(Messages.getString("DRTableSpaceContainer.CheckContainersCountForDatabaseTablespaces"));
        this.setDescription(Messages.getString("DRTableSpaceContainer.DatabaseTablespacesShouldHaveMaximumOneContainer"));
    }

    @Override
    public CheckResult doCheck(Object object) {
        TableSpaceUDB tableSpaceUDB = (TableSpaceUDB)object;
        if (tableSpaceUDB.getManagedBy().equalsIgnoreCase("DATABASE")) {
            if (tableSpaceUDB.getContainers().length > 1) {
                return CheckResult.createFailed(tableSpaceUDB, this, Messages.getString("DRTableSpaceContainer.TablespaceCouldHaveMaximumOneContainer"));
            }
            return CheckResult.createOk(tableSpaceUDB, this, Messages.getString("DRTableSpaceContainer.ContainersAreNoMoreThanOne"));
        }
        return CheckResult.createOk(tableSpaceUDB, this, MessageFormat.format(Messages.getString("DRTableSpaceContainer.IsSystemTablespace"), tableSpaceUDB.getName()));
    }

    @Override
    public int getType() {
        return 0;
    }

    @Override
    public String getRuleId() {
        return "B45A54DF-80CB-F4C8-8869-57A3687111B0";
    }
}

