/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.designrules.storage.sqlserver;

import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.sqlserver.TableViewProxySqlServer;
import oracle.dbtools.crest.model.designrules.CheckResult;
import oracle.dbtools.crest.model.designrules.storage.AbstractDRStorageDesign;

public class DRViewProxyUserSet
extends AbstractDRStorageDesign {
    private final String RULE_ID = "FCFC02A8-0730-14C0-C202-3EC92DB16A37";

    public DRViewProxyUserSet(StorageDesign storageDesign) {
        super(storageDesign);
        this.setName(Messages.getString("DRViewProxyUserSet.CheckWhetherUserIsSet"));
        this.setDescription(Messages.getString("DRViewProxyUserSet.ViewProxySshouldHaveUserSet"));
    }

    @Override
    public CheckResult doCheck(Object object) {
        TableViewProxySqlServer tableViewProxySqlServer = (TableViewProxySqlServer)object;
        if (tableViewProxySqlServer.getUser() == null) {
            return CheckResult.createWarning(object, this, Messages.getString("DRViewProxyUserSet.UserNotSettoTheView"));
        }
        return CheckResult.createOk(object, this, Messages.getString("DRViewProxyUserSet.UserSetToTheView"));
    }

    @Override
    public int getType() {
        return 1;
    }

    @Override
    public String getRuleId() {
        return "FCFC02A8-0730-14C0-C202-3EC92DB16A37";
    }
}

