/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.designrules.storage.sqlserver;

import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.sqlserver.DataFileSqlServer;
import oracle.dbtools.crest.model.designrules.CheckResult;
import oracle.dbtools.crest.model.designrules.storage.AbstractDRStorageDesign;

public class DRDatafileEmptyFilename
extends AbstractDRStorageDesign {
    private final String RULE_ID = "69303308-8DC2-47A2-CC0B-501503A90093";

    public DRDatafileEmptyFilename(StorageDesign storageDesign) {
        super(storageDesign);
        this.setName(Messages.getString("DRDatafileEmptyFilename.CheckFilenameOfDatafile"));
        this.setDescription(Messages.getString("DRDatafileEmptyFilename.FilenameShouldNotBeEmpty"));
    }

    @Override
    public CheckResult doCheck(Object object) {
        DataFileSqlServer dataFileSqlServer = (DataFileSqlServer)object;
        if ("".equalsIgnoreCase(dataFileSqlServer.getFileName())) {
            return CheckResult.createFailed(object, this, Messages.getString("DRDatafileEmptyFilename.FilenameIsEmpty"));
        }
        return CheckResult.createOk(object, this, Messages.getString("DRDatafileEmptyFilename.FilenameIsNotEmpty"));
    }

    @Override
    public int getType() {
        return 0;
    }

    @Override
    public String getRuleId() {
        return "69303308-8DC2-47A2-CC0B-501503A90093";
    }
}

