/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.designrules.storage.oracle;

import java.text.MessageFormat;
import java.util.Iterator;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.design.storage.RelationalObjectProxy;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.oracle.CollectionTypeProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.ReservedWordsOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StructuredTypeProxyOracle;
import oracle.dbtools.crest.model.designrules.CheckResult;
import oracle.dbtools.crest.model.designrules.storage.AbstractDRStorageDesign;

public class DRReservedWordNameOracle
extends AbstractDRStorageDesign {
    private final String RULE_ID = "FD841029-76BF-0569-8ECE-D3190D9C137D";
    private ReservedWordsOracle reserved = new ReservedWordsOracle();
    private StorageDesignOracle stoDesign = null;

    public DRReservedWordNameOracle(StorageDesign storageDesign) {
        super(storageDesign);
        this.stoDesign = (StorageDesignOracle)storageDesign;
        this.setName(Messages.getString("DRReservedWordNameOracle.IdentifyObjectsUsingReservedWords"));
        this.setDescription(Messages.getString("DRReservedWordNameOracle.ObjectMayNotHaveIdentifierReservedWord"));
    }

    @Override
    public CheckResult doCheck(Object object) {
        RelationalObjectProxy relationalObjectProxy;
        this.stoDesign.updateGeneralRule();
        ModelIDObject modelIDObject = (ModelIDObject)object;
        String string = modelIDObject.getName();
        if (this.reserved.isReservedWord(string)) {
            return CheckResult.createWarning(modelIDObject, this, MessageFormat.format(Messages.getString("DRReservedWordNameOracle.NameIsReservedWord"), string));
        }
        Iterator iterator = this.stoDesign.getStructuredTypeProxySet().iterator();
        while (iterator.hasNext()) {
            relationalObjectProxy = (StructuredTypeProxyOracle)iterator.next();
            if (!relationalObjectProxy.getName().equalsIgnoreCase(string)) continue;
            return CheckResult.createWarning(modelIDObject, this, Messages.getString("DRReservedWordNameOracle.ThereIsStructuredTypeWithSameName"));
        }
        iterator = this.stoDesign.getCollectionTypeProxySet().iterator();
        while (iterator.hasNext()) {
            relationalObjectProxy = (CollectionTypeProxyOracle)iterator.next();
            if (!relationalObjectProxy.getName().equalsIgnoreCase(string)) continue;
            return CheckResult.createWarning(modelIDObject, this, Messages.getString("DRReservedWordNameOracle.ThereIsCollectionTypeWithSameName"));
        }
        return CheckResult.createOk(modelIDObject, this, Messages.getString("DRReservedWordNameOracle.NameIsNotReservedWord"));
    }

    @Override
    public int getType() {
        return 1;
    }

    @Override
    public String getRuleId() {
        return "FD841029-76BF-0569-8ECE-D3190D9C137D";
    }
}

