/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.designrules.storage.oracle;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.design.storage.ColumnProxy;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.oracle.ColumnProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.PartitionListOracle;
import oracle.dbtools.crest.model.designrules.CheckResult;
import oracle.dbtools.crest.model.designrules.storage.AbstractDRStorageDesign;

public class DRPartitionListColumnsTypeOracle
extends AbstractDRStorageDesign {
    private final String RULE_ID = "D641DC9A-8E7D-1E68-2D0F-366BA58C139E";
    private static final String[] DATA_TYPE = new String[]{"ROWID", "UROWID", "LONG", "BLOB", "CLOB", "NCLOB", "BFILES"};
    private static Set dataTypeSet = null;

    public DRPartitionListColumnsTypeOracle(StorageDesign storageDesign) {
        super(storageDesign);
        this.setName(Messages.getString("DRPartitionListColumnsTypeOracle.CheckPartitionListColumnsType"));
        this.setDescription(Messages.getString("DRPartitionListColumnsTypeOracle.DataTypeCanNotBe"));
    }

    public static String[] getDataTypes() {
        return DATA_TYPE;
    }

    private boolean checkDataType(String string) {
        if (dataTypeSet == null) {
            dataTypeSet = new HashSet();
            dataTypeSet.addAll(Arrays.asList(DRPartitionListColumnsTypeOracle.getDataTypes()));
        }
        return dataTypeSet.contains(string);
    }

    private ColumnProxyOracle getColumn(String string, PartitionListOracle partitionListOracle) {
        ColumnProxy[] columnProxyArray = partitionListOracle.getTable().getColumnProxies();
        String string2 = partitionListOracle.getTable().getName();
        String string3 = new StringBuffer(string2).append('.').append(string).toString();
        for (int i = 0; i < columnProxyArray.length; ++i) {
            ColumnProxy columnProxy = columnProxyArray[i];
            if (!string3.equalsIgnoreCase(columnProxy.getLongName())) continue;
            return (ColumnProxyOracle)columnProxy;
        }
        return null;
    }

    @Override
    public CheckResult doCheck(Object object) {
        PartitionListOracle partitionListOracle = (PartitionListOracle)object;
        StringTokenizer stringTokenizer = new StringTokenizer(partitionListOracle.getColumnList(), ",");
        StringBuffer stringBuffer = new StringBuffer();
        if (stringTokenizer.hasMoreTokens()) {
            while (stringTokenizer.hasMoreTokens()) {
                String string = stringTokenizer.nextToken().trim();
                ColumnProxyOracle columnProxyOracle = this.getColumn(string, partitionListOracle);
                if (columnProxyOracle == null || !this.checkDataType(columnProxyOracle.getDataType().getName())) continue;
                stringBuffer.append(string).append(':').append(columnProxyOracle.getDataType()).append(' ');
            }
            if (!"".equalsIgnoreCase(stringBuffer.toString())) {
                return CheckResult.createFailed(object, this, new StringBuffer(Messages.getString("DRPartitionListColumnsTypeOracle.PartitionListContainsColumnsWithWrongDataType")).append("(").append(stringBuffer).append(").").toString());
            }
            return CheckResult.createOk(object, this, this.getDescription());
        }
        return CheckResult.createOk(object, this, Messages.getString("DRPartitionListColumnsTypeOracle.PartitionListDoesNotContainsAnyColumns"));
    }

    @Override
    public int getType() {
        return 0;
    }

    @Override
    public String getRuleId() {
        return "D641DC9A-8E7D-1E68-2D0F-366BA58C139E";
    }
}

