/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.designrules.storage.oracle;

import java.util.Iterator;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.oracle.ClusterIndexOracle;
import oracle.dbtools.crest.model.design.storage.oracle.ClusterIndexSetOracle;
import oracle.dbtools.crest.model.design.storage.oracle.ClusterOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.model.designrules.CheckResult;
import oracle.dbtools.crest.model.designrules.storage.AbstractDRStorageDesign;

public class DRClusterIndexOracle
extends AbstractDRStorageDesign {
    private final String RULE_ID = "C996DE42-B809-6D74-3610-6CBAC481359C";

    public DRClusterIndexOracle(StorageDesign storageDesign) {
        super(storageDesign);
        this.setName(Messages.getString("DRClusterIndexOracle.SetClusterIndex"));
        this.setDescription(Messages.getString("DRClusterIndexOracle.ThereMustBeOneCorrespondingIndex"));
    }

    private int getClusterIndex(ClusterOracle clusterOracle) {
        ClusterIndexSetOracle clusterIndexSetOracle = ((StorageDesignOracle)clusterOracle.getStorageDesign()).getClusterIndexSet();
        Iterator iterator = clusterIndexSetOracle.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            ClusterIndexOracle clusterIndexOracle = (ClusterIndexOracle)iterator.next();
            if (clusterIndexOracle.getCluster() != clusterOracle) continue;
            ++n;
        }
        return n;
    }

    @Override
    public CheckResult doCheck(Object object) {
        ClusterOracle clusterOracle = (ClusterOracle)object;
        if ("Yes".equalsIgnoreCase(clusterOracle.getIndexed())) {
            int n = this.getClusterIndex(clusterOracle);
            if (n == 0) {
                return CheckResult.createFailed(object, this, Messages.getString("DRClusterIndexOracle.ThereIsNoIndexForTheCluster"));
            }
            if (n == 1) {
                return CheckResult.createOk(object, this, this.getDescription());
            }
            return CheckResult.createFailed(object, this, Messages.getString("DRClusterIndexOracle.ClusterMustHave1CorrespondingIndexDefined"));
        }
        return CheckResult.createOk(object, this, Messages.getString("DRClusterIndexOracle.ClusterNotIndexed"));
    }

    @Override
    public int getType() {
        return 0;
    }

    @Override
    public String getRuleId() {
        return "C996DE42-B809-6D74-3610-6CBAC481359C";
    }
}

