/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.designrules.storage.db2;

import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.db2.DataBaseDB2;
import oracle.dbtools.crest.model.design.storage.db2.TableProxyDB2;
import oracle.dbtools.crest.model.designrules.CheckResult;
import oracle.dbtools.crest.model.designrules.storage.AbstractDRStorageDesign;

public class DRTableProxyWrongDatabase
extends AbstractDRStorageDesign {
    private final String RULE_ID = "28B44133-00CD-086A-93D8-E44294BEF9A1";

    public DRTableProxyWrongDatabase(StorageDesign storageDesign) {
        super(storageDesign);
        this.setName(Messages.getString("DRTableProxyWrongDatabase.CheckDBForTables"));
        this.setDescription(Messages.getString("DRTableProxyWrongDatabase.DBForTableShouldNotBeWorkFileTempDB"));
    }

    @Override
    public CheckResult doCheck(Object object) {
        TableProxyDB2 tableProxyDB2 = (TableProxyDB2)object;
        DataBaseDB2 dataBaseDB2 = tableProxyDB2.getDataBase();
        if (dataBaseDB2 != null) {
            if (!"USUAL".equalsIgnoreCase(dataBaseDB2.getType())) {
                return CheckResult.createFailed(dataBaseDB2, this, Messages.getString("DRTableProxyWrongDatabase.DatabaseForTheTableShouldBeUSUAL"));
            }
            if ("DSNDB06".equalsIgnoreCase(dataBaseDB2.getName())) {
                return CheckResult.createFailed(dataBaseDB2, this, Messages.getString("DRTableProxyWrongDatabase.DatabaseNameForThetableShouldNotBeDSNDB06"));
            }
        }
        return CheckResult.createOk(dataBaseDB2, this, Messages.getString("DRTableProxyWrongDatabase.TableHasNoDB"));
    }

    @Override
    public int getType() {
        return 0;
    }

    @Override
    public String getRuleId() {
        return "28B44133-00CD-086A-93D8-E44294BEF9A1";
    }
}

