/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.designrules.storage.db2;

import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.design.KeyObject;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.storage.IndexProxy;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.TableProxy;
import oracle.dbtools.crest.model.designrules.CheckResult;
import oracle.dbtools.crest.model.designrules.storage.AbstractDRStorageDesign;

public class DRTableProxyIdentifyPK
extends AbstractDRStorageDesign {
    private final String RULE_ID = "1A6EB6D0-0129-76DF-7943-C852EF99DF01";

    public DRTableProxyIdentifyPK(StorageDesign storageDesign) {
        super(storageDesign);
        this.setName(Messages.getString("DRTableProxyIdentifyPK.IdentifyPK"));
        this.setDescription(Messages.getString("DRTableProxyIdentifyPK.RuleIdentifiesPKCandidates"));
    }

    @Override
    public CheckResult doCheck(Object object) {
        TableProxy tableProxy = (TableProxy)object;
        Table table = (Table)tableProxy.getObject();
        StringBuffer stringBuffer = new StringBuffer(Messages.getString("DRTableProxyIdentifyPK.TableHasNoPK"));
        KeyObject keyObject = table.getPK();
        if (keyObject == null) {
            boolean bl = false;
            KeyObject[] keyObjectArray = table.getKeys();
            for (int i = 0; i < keyObjectArray.length; ++i) {
                IndexProxy indexProxy = (IndexProxy)this.getProxyFor(keyObjectArray[i]);
                if (indexProxy == null || !indexProxy.isClustered()) continue;
                stringBuffer.append(keyObjectArray[i].getName());
                if (keyObjectArray[i].isUnique()) {
                    stringBuffer.append(Messages.getString("DRTableProxyIdentifyPK.ClusteredUnique"));
                } else {
                    stringBuffer.append(Messages.getString("DRTableProxyIdentifyPK.ClusteredNonunique"));
                }
                stringBuffer.append("; ");
                bl = true;
            }
            if (bl) {
                return CheckResult.createWarning(object, this, stringBuffer.toString());
            }
            return CheckResult.createOk(object, this, Messages.getString("DRTableProxyIdentifyPK.TableHasNoPKNoClustIndex"));
        }
        return CheckResult.createOk(object, this, Messages.getString("DRTableProxyIdentifyPK.TableHasPKNoPKCandidatesPresented"));
    }

    @Override
    public int getType() {
        return 1;
    }

    @Override
    public String getRuleId() {
        return "1A6EB6D0-0129-76DF-7943-C852EF99DF01";
    }
}

