/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.designrules.storage.db2;

import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.design.storage.IndexProxy;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.db2.IndexProxyDB2;
import oracle.dbtools.crest.model.design.storage.db2.TableProxyDB2;
import oracle.dbtools.crest.model.designrules.CheckResult;
import oracle.dbtools.crest.model.designrules.storage.AbstractDRStorageDesign;

public class DRTableProxyClusteredIndex
extends AbstractDRStorageDesign {
    private final String RULE_ID = "5C1BFBE5-D389-9118-9CC7-7D074B0FE483";

    public DRTableProxyClusteredIndex(StorageDesign storageDesign) {
        super(storageDesign);
        this.setName(Messages.getString("DRTableProxyClusteredIndex.CreateClusteringIndex"));
        this.setDescription(Messages.getString("DRTableProxyClusteredIndex.TablesWhichContainsNoClusteringIndex"));
    }

    @Override
    public CheckResult doCheck(Object object) {
        TableProxyDB2 tableProxyDB2 = (TableProxyDB2)object;
        IndexProxy[] indexProxyArray = tableProxyDB2.getIndexProxies();
        StringBuffer stringBuffer = new StringBuffer(Messages.getString("DRTableProxyClusteredIndex.AvailableIndexes"));
        for (int i = 0; i < indexProxyArray.length; ++i) {
            IndexProxyDB2 indexProxyDB2 = (IndexProxyDB2)indexProxyArray[i];
            if (indexProxyDB2 == null) continue;
            stringBuffer.append(indexProxyDB2.getObject().getLongName()).append("; ");
            if (!indexProxyDB2.isClustered()) continue;
            return CheckResult.createOk(object, this, Messages.getString("DRTableProxyClusteredIndex.TableContainsClusteringIndex"));
        }
        if (indexProxyArray.length > 0) {
            return CheckResult.createWarning(object, this, new StringBuffer(Messages.getString("DRTableProxyClusteredIndex.TableContainsNoClusteringIndex")).append(stringBuffer).append('.').toString());
        }
        return CheckResult.createWarning(object, this, Messages.getString("DRTableProxyClusteredIndex.TableContainsNoClusteringIndexOrAnyIndex"));
    }

    @Override
    public int getType() {
        return 1;
    }

    @Override
    public String getRuleId() {
        return "5C1BFBE5-D389-9118-9CC7-7D074B0FE483";
    }
}

