/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.designrules.storage.db2;

import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.db2.IndexProxyDB2;
import oracle.dbtools.crest.model.designrules.CheckResult;
import oracle.dbtools.crest.model.designrules.storage.AbstractDRStorageDesign;

public class DRIndexProxyPKNullsAllowed
extends AbstractDRStorageDesign {
    private final String RULE_ID = "B3F91DA6-3A73-76BD-DD94-F5AFBF2E02B7";

    public DRIndexProxyPKNullsAllowed(StorageDesign storageDesign) {
        super(storageDesign);
        this.setName(Messages.getString("DRIndexProxyPKNullsAllowed.IdentifyPKWithNullAllowedColumns"));
        this.setDescription(Messages.getString("DRIndexProxyPKNullsAllowed.AtLeast1ColumnOfPKMustBeNotNullsAllowed"));
    }

    @Override
    public CheckResult doCheck(Object object) {
        IndexProxyDB2 indexProxyDB2 = (IndexProxyDB2)object;
        Index index = (Index)indexProxyDB2.getObject();
        if (index.isPK()) {
            Column[] columnArray = (Column[])index.getElements();
            for (int i = 0; i < columnArray.length; ++i) {
                if (!columnArray[i].getNullsAllowed()) continue;
                return CheckResult.createFailed(object, this, this.getDescription());
            }
            return CheckResult.createOk(object, this, Messages.getString("DRIndexProxyPKNullsAllowed.PKContainsOnlyNotNullAllowedColumns"));
        }
        return CheckResult.createOk(object, this, Messages.getString("DRIndexProxyPKNullsAllowed.IndexNotPKMustNotContainNotNullsAllowedColumns"));
    }

    @Override
    public int getType() {
        return 0;
    }

    @Override
    public String getRuleId() {
        return "B3F91DA6-3A73-76BD-DD94-F5AFBF2E02B7";
    }
}

