/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.designrules.storage.db2;

import java.text.MessageFormat;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.datatype.MDDataType;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.db2.IndexProxyDB2;
import oracle.dbtools.crest.model.designrules.CheckResult;
import oracle.dbtools.crest.model.designrules.storage.AbstractDRStorageDesign;

public class DRIndexProxyMaxBytes
extends AbstractDRStorageDesign {
    private final String RULE_ID = "7B4D69B0-4CE5-90FD-7090-BEE8C3DBA34E";
    private int maxBytes = 0;

    public DRIndexProxyMaxBytes(StorageDesign storageDesign) {
        super(storageDesign);
        this.setMaxBytes(254);
        this.setName(Messages.getString("DRIndexProxyMaxBytes.IdentifyClusteringIndexesWithTooManyBytes"));
        this.setDescription(new StringBuffer(MessageFormat.format(Messages.getString("DRIndexProxyMaxBytes.IndexesCanNotCompriseMoreThan"), this.getMaxBytes())));
    }

    public DRIndexProxyMaxBytes(StorageDesign storageDesign, int n) {
        this(storageDesign);
        this.setMaxBytes(n);
    }

    public void setMaxBytes(int n) {
        this.maxBytes = n;
    }

    public int getMaxBytes() {
        return this.maxBytes;
    }

    @Override
    public CheckResult doCheck(Object object) {
        IndexProxyDB2 indexProxyDB2 = (IndexProxyDB2)object;
        int n = 0;
        if (indexProxyDB2.isClustered()) {
            Index index = (Index)indexProxyDB2.getObject();
            Column[] columnArray = (Column[])index.getElements();
            for (int i = 0; i < columnArray.length; ++i) {
                MDDataType mDDataType = columnArray[i].getDomain().getDataType(this.getRDBMSType().toString());
                n += mDDataType.getByteSize();
            }
            if (n > this.getMaxBytes()) {
                return CheckResult.createFailed(object, this, new StringBuffer(MessageFormat.format(Messages.getString("DRIndexProxyMaxBytes.BytesAllowed"), this.getMaxBytes(), n)).toString());
            }
            return CheckResult.createOk(object, this, new StringBuffer(MessageFormat.format(Messages.getString("DRIndexProxyMaxBytes.MaxBytesNotReached"), this.getMaxBytes(), n)).toString());
        }
        return CheckResult.createOk(object, this, new StringBuffer(MessageFormat.format(Messages.getString("DRIndexProxyMaxBytes.MaxBytesNotReachedIndexNotClustered"), this.getMaxBytes())).toString());
    }

    @Override
    public int getType() {
        return 0;
    }

    @Override
    public String getRuleId() {
        return "7B4D69B0-4CE5-90FD-7090-BEE8C3DBA34E";
    }
}

