/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.designrules.storage;

import java.text.MessageFormat;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.design.storage.ColumnProxy;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.designrules.CheckResult;
import oracle.dbtools.crest.model.designrules.DRDesignObjectMaxNameLength;

public class DRColumnProxyMaxNameLength
extends DRDesignObjectMaxNameLength {
    private final String RULE_ID = "C79639F5-8DAE-B7B5-4271-71E52A8173FC";

    public DRColumnProxyMaxNameLength(StorageDesign storageDesign) {
        super(storageDesign);
        this.setName(Messages.getString("DRColumnProxyMaxNameLength.CheckForColumnMaximumNameLength"));
        this.setDescription(Messages.getString("DRColumnProxyMaxNameLength.ColumnNameHasTooManyCharacters"));
    }

    @Override
    public CheckResult doCheck(Object object) {
        int n;
        ModelIDObject modelIDObject = (ModelIDObject)object;
        String string = modelIDObject.getName();
        if (modelIDObject instanceof ColumnProxy && ((ColumnProxy)modelIDObject).getColumn().isNested() && (n = string.lastIndexOf(46)) > -1) {
            string = string.substring(n + 1);
        }
        if (string.length() > 0) {
            if (modelIDObject.getMaxNameLength() > 0 && string.length() > modelIDObject.getMaxNameLength()) {
                return CheckResult.createFailed(modelIDObject, this, new StringBuffer(MessageFormat.format(Messages.getString("DRColumnProxyMaxNameLength.NameHasMoreThan"), modelIDObject.getMaxNameLength())).toString());
            }
            if (!Character.isLetter(string.charAt(0))) {
                return CheckResult.createFailed(modelIDObject, this, Messages.getString("DRColumnProxyMaxNameLength.FirstCharacterMustBeLetter"));
            }
        } else {
            return CheckResult.createFailed(modelIDObject, this, Messages.getString("DRColumnProxyMaxNameLength.ThereIsNoNameSpecified"));
        }
        return CheckResult.createOk(modelIDObject, this, Messages.getString("DRColumnProxyMaxNameLength.TheLengthFirstCharacterOfNameIsOk"));
    }

    @Override
    public String getRuleId() {
        return "C79639F5-8DAE-B7B5-4271-71E52A8173FC";
    }
}

