/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.designrules.relational;

import java.util.ArrayList;
import java.util.Iterator;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.design.KeyObject;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.designrules.CheckResult;
import oracle.dbtools.crest.model.designrules.DesignRule;
import oracle.dbtools.crest.util.options.namingstandards.NamingStandardRule;

public class DRUniqueConstraintNamingStandard
extends DesignRule {
    private final String RULE_ID = "F63CE5A0-B871-1F00-5BC3-E55586F4467D";
    private NamingStandardRule namingRule;
    private String tableName = "";
    private String tableAbbr = "";
    private String modelName = "";

    public DRUniqueConstraintNamingStandard() {
        this.setName(Messages.getString("DRUniqueConstraintNamingStandard.IdentifyUCWithWrongNamingStandards"));
        this.setDescription(Messages.getString("DRUniqueConstraintNamingStandard.UniqueConstraintsWithWrongNamingStandardsAreNotRecommended"));
    }

    private Object[] getUniqueKeys(Table table) {
        ArrayList<KeyObject> arrayList = new ArrayList<KeyObject>();
        Iterator iterator = table.getKeySet().iterator();
        while (iterator.hasNext()) {
            KeyObject keyObject = (KeyObject)iterator.next();
            if (!keyObject.isUnique()) continue;
            arrayList.add(keyObject);
        }
        return arrayList.toArray();
    }

    private int getPosition(Index index) {
        Object[] objectArray = this.getUniqueKeys(index.getTable());
        for (int i = 0; i < objectArray.length; ++i) {
            Object object = objectArray[i];
            if (!index.equals(object)) continue;
            return i + 1;
        }
        return 0;
    }

    @Override
    public CheckResult doCheck(Object object) {
        Index index = (Index)object;
        this.namingRule = index.getDesign().getDLSettings().getNamingStandardRule();
        String string = this.namingRule.getUnConstr();
        if (index.isUnique()) {
            int n = this.getPosition(index);
            this.tableName = index.getTable().getName();
            this.tableName = this.tableName.replaceAll("\\$", "\\\\\\$");
            string = string.replaceAll("\\{table\\}", this.tableName);
            string = string.replaceAll("\\{seq nr\\}", String.valueOf(n));
            this.tableAbbr = index.getTable().getAbbreviation();
            this.tableAbbr = this.tableAbbr.replaceAll("\\$", "\\\\\\$");
            string = string.replaceAll("\\{table abbr\\}", this.tableAbbr);
            this.modelName = index.getDesignPart().getName();
            this.modelName = this.modelName.replaceAll("\\$", "\\\\\\$");
            string = string.replaceAll("\\{model\\}", this.modelName);
            if (index.getElements().length > 0) {
                String string2 = index.getElement(0).getName();
                string2 = string2.replaceAll("\\$", "\\\\\\$");
                string = string.replaceAll("\\{column\\}", string2);
                String string3 = ((Column)index.getElement(0)).getAbbreviation();
                string3 = string3.replaceAll("\\$", "\\\\\\$");
                string = string.replaceAll("\\{column abbr\\}", string2);
            }
            if (index.getName().equalsIgnoreCase(string)) {
                return CheckResult.createOk(index, this, Messages.getString("DRUniqueConstraintNamingStandard.UKNameIsInValidformat"));
            }
            return CheckResult.createWarning(index, this, this.getDescription());
        }
        return CheckResult.createOk(index, this, Messages.getString("DRUniqueConstraintNamingStandard.UKNameIsInValidformat"));
    }

    @Override
    public int getType() {
        return 1;
    }

    @Override
    public String getRuleId() {
        return "F63CE5A0-B871-1F00-5BC3-E55586F4467D";
    }
}

