/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.designrules.relational;

import java.util.Iterator;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.NamingOptionsHolder;
import oracle.dbtools.crest.model.design.glossary.Glossary;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.designrules.CheckResult;
import oracle.dbtools.crest.model.designrules.DesignRule;
import oracle.dbtools.crest.util.options.namingstandards.NamingConstants;
import oracle.dbtools.crest.util.options.namingstandards.NamingStandardRule;

public class DRTableNamingStandard
extends DesignRule
implements NamingConstants {
    private final String RULE_ID = "92E06D4A-0D91-B313-3652-8C983D517988";
    private NamingStandardRule namingRule;

    public DRTableNamingStandard() {
        this.setName(Messages.getString("DRTableNamingStandard.IdentifyTablesWithWrongNamingStandards"));
        this.setDescription(Messages.getString("DRTableNamingStandard.TablesWithWrongNamingStandardsAreNotRecommended"));
    }

    @Override
    public CheckResult doCheck(Object object) {
        char c;
        Table table = (Table)object;
        this.namingRule = table.getDesign().getDLSettings().getNamingStandardRule();
        Iterator iterator = this.namingRule.getGlossaries().iterator();
        String string = "";
        NamingOptionsHolder namingOptionsHolder = table.getDesignPart().getNamingOptionsHolderFor(Table.class);
        if (namingOptionsHolder == null) {
            namingOptionsHolder = table.getDesignPart().getNamingOptionsHolderFor(Table.class);
        }
        boolean bl = false;
        if (namingOptionsHolder != null && (c = namingOptionsHolder.getCaseType()) == '\u0000') {
            bl = true;
        }
        c = this.namingRule.getRelationalSeparatorChar();
        boolean bl2 = this.namingRule.isAbbreviatedOnly();
        while (iterator.hasNext()) {
            Glossary glossary = (Glossary)iterator.next();
            String string2 = glossary.checkValidName(table.getName(), this.namingRule.getTablesList(), c, false, bl, true, bl2);
            if (string2 == null) {
                return CheckResult.createOk(table, this, Messages.getString("DRTableNamingStandard.TableNameIsInValidFormat"));
            }
            if (string.length() == 0) {
                string = string2;
                continue;
            }
            string = string + ". " + string2;
        }
        if ("".equals(string)) {
            return CheckResult.createOk(table, this, Messages.getString("DRTableNamingStandard.TableNameIsInValidFormat"));
        }
        return CheckResult.createWarning(table, this, string);
    }

    @Override
    public int getType() {
        return 1;
    }

    @Override
    public String getRuleId() {
        return "92E06D4A-0D91-B313-3652-8C983D517988";
    }
}

